public class ITDmodnn extends Id {

static final int MAXK = 10;    // Maximum number of members.
static final int MAXHID = 10;  // Maximum number of hidden nodes.
static final int MAXP = 10;    // Maximum number of input variables.
static final int NMPAR = 100;   // Maximum number of parameters.

static boolean missdat[] = new boolean[DATSZE];

static int k, nmhid, nmnetp, samplesize;

static int rspns[] = new int[DATSZE];

static double cmpn[] = new double[MAXK];
static double optx[] = new double[NMPAR];
static double errs[] = new double[MAXK];
static double rawerrs[] = new double[MAXK];
static double y[][] = new double[MAXK][MAXHID + 1];
static double z[] = new double[MAXK];
static double nu[][] = new double[MAXK][MAXHID + 1];
static double omega[][][] = new double[MAXK][MAXHID][MAXP + 1];
static double znorm[] = new double[MAXK];

// ------------------------------------------------------------------

public static int predict_member_(double x[]) {

/* Predicts a category (returned in "choice") at the input vector x.
   ***Note: This routine assumes that the input vector values are always
            between 0 and 1. *** */

int i, j, i1, choice = 0;

double sum, max, zsum;

// Add the dummy node to the input layer.

x[nmnetp] = 1.;

// Compute hidden layer output values.

for (i = 0; i < k; ++i) {
   for (j = 0; j < nmhid; ++j) {
      sum = 0.;
      for (i1 = 0; i1 <= nmnetp; ++i1) {
	 sum += x[i1] * omega[i][j][i1];
      }
      if (sum > 50.) {
	 sum = 50.;
      }

      // Compute the sigmoidal function value.

      y[i][j] = Math.exp(sum);
      y[i][j] = y[i][j] / (1. + y[i][j]);
   }
   y[i][nmhid] = 1.;
}

// Compute output layer values.

zsum = 0.;
for (i = 0; i < k; ++i) {
   sum = 0.;
   for (j = 0; j <= nmhid; ++j) {
      sum += y[i][j] * nu[i][j];
   }
   if (sum > 50.) {
      sum = 50.;
   }

   // Compute the sigmoidal function value.

   z[i] = Math.exp(sum);
   z[i] = z[i] / (1. + z[i]);
   zsum += z[i];
}

/* Regard the output node with the largest value as the choice, and
   normalize the outputs. */

max = 0.;
choice = 0;
for (i = 0; i < k; ++i) {
   if (z[i] > max) {
      max = z[i];
      choice = i + 1;
   }
   znorm[i] = z[i] / zsum;
}

return choice;
}

// --------------------------------------------------------------------

public static boolean netfit_(boolean first, double prds[][],
   int rspns[], int nin) {

// Estimates a modular neural network.

int i, j, nmpars, ier = 0, m;

// Transfer input value to global location.

samplesize = nin;

/* Test function for dfpmin (turn on test function in Dfpmin.func_()).
nmpars = 2;
optx[0] = 1.;
optx[1] = .5;
ier = Dfpmin.dfpmin_(prds, rspns, nmpars, optx, 1, 1);
iderr_("netfit: ier= " + ier);
*/

if (first) {

   // Compute count per response category.

   for (i = 0; i < samplesize; ++i) {
      cmpn[rspns[i] - 1] += 1.;
   }

   printf_("netfit: nmnetp= " + nmnetp + " nmhid= " + nmhid);
}

/* Upon the first call to netfit, perform m optimizations each time
   with a randomly chosen data point temporarily held out of the
   data set. */

if (first) {
   m = 2;

} else {
   m = 1;
}

for (i = 2; i <= m; ++i) { // was i = 1

   for (j = 0; j < samplesize; ++j) {
      missdat[j] = false;
   }

   if (i < m) {

      // For i < m, Randomly set one observation to missing.

      printf_("netfit: Random start= " + i);
      j = (int) (((double) samplesize) * Rndm.rndm1_(0, 0));
      missdat[j] = true;

   } else {
      printf_("netfit: full-sample start");
   }

   // Define initial values of all link weights and load parameter vector.

   nmpars = xwghtx_(optx, 0, first);

   // Call BFGS optimzation routine.

   ier = Dfpmin.dfpmin_(prds, rspns, nmpars, optx, 1, 1);

   if (ier == 1) {
      printf_("netfit: dfpmin_ failed.");
   }
   if (first) {
      first = false;
   }
}

return first;
}

// --------------------------------------------------------------------

public static int xwghtx_(double x[], int flag, boolean first) {

/* Transfers between the optimization algorithm's parameter vector and
   the neural network's link weights. */

int i, j, i1, i2, nmpars = 0;

double strtval, limit = 1.e5;

if (flag == 0) {

   // Initialization.

   nmpars = 0;
   for (i = 0; i < k; ++i) {
      for (j = 0; j < nmhid; ++j) {
	 for (i1 = 0; i1 <= nmnetp; ++i1) {
            if (first) {
               strtval = .1 * Rndm.rndm1_(0, 0);
               omega[i][j][i1] = strtval;
            }
            x[nmpars] = omega[i][j][i1];
            ++nmpars;
	 }
      }
   }
   for (i = 0; i < k; ++i) {
      for (j = 0; j <= nmhid; ++j) {
	 if (first) {
	    strtval = Rndm.rndm1_(0, 0);
	    nu[i][j] = strtval;
	 }
         x[nmpars] = nu[i][j];
	 ++nmpars;
      }
   }

   printf_("xwghtx: nmnetp= " + nmnetp + " nmhid= " + nmhid +
      " nmpars= " + nmpars + " NMPAR= " + NMPAR);

} else if (flag == 1) {

   // Load link weights with the parameter vector values that are in "x."

   i2 = 0;
   for (i = 0; i < k; ++i) {
      for (j = 0; j < nmhid; ++j) {
	 for (i1 = 0; i1 <= nmnetp; ++i1) {
            x[i2] = Math.max(x[i2], -limit);
            x[i2] = Math.min(x[i2], limit);

            omega[i][j][i1] = x[i2];
            ++i2;
	 }
      }
   }
   for (i = 0; i < k; ++i) {
      for (j = 0; j <= nmhid; ++j) {
         x[i2] = Math.max(x[i2], -limit);
         x[i2] = Math.min(x[i2], limit);

         nu[i][j] = x[i2];
         ++i2;
      }
   }
}

return nmpars;
}

// -----------------------------------------------------------------------

public static int neterr_(int rspns[], double prds[][], double errs[],
   double rawerrs[]) {

// Computes the classification error rate vector.

int i, j, choice;

double err, dum;

double x[] = new double[MAXP + 1];

for (i = 0; i < k; ++i) {
   errs[i] = 0.;
   rawerrs[i] = 0.;
}

for (i = 0; i < samplesize; ++i) {
   if (missdat[i]) {
      continue;
   }

   for (j = 0; j < nmnetp; ++j) {
      x[j] = prds[i][j];
   }

   choice = predict_member_(x);

   // Compute raw error rate.

   if (choice != rspns[i]) {
      rawerrs[rspns[i] - 1] += 1.;
   }

   // Compute smooth error measure.

   err = 0.;
   for (j = 1; j <= k; ++j) {
      if (j == rspns[i]) {
	 dum = 1. - znorm[j - 1];

      } else {
	 dum = znorm[j - 1];
      }
      err += dum * dum;
   }
   errs[rspns[i] - 1] += err;
}

for (i = 0; i < k; ++i) {
   errs[i] /= cmpn[i];
   rawerrs[i] /= cmpn[i];
}

return 0;
}
}
