import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class Helpwindow extends Dialog implements ActionListener {

/* Creates a new window and displays the "help" text for the method
   from which it was called. */

final int NMTEXTROWS = 30;

String helptext[][] = new String[10][NMTEXTROWS];

int topicindex = 0;
int nmlines[] = new int[10];

int width = 500, height = 300;

// --------------------------------------------------------------------

public Helpwindow (Dialog parent, String title) {
super(parent, title);
setLayout(new FlowLayout());
setSize(width, height);
setModal(false);

// Create an object to handle window events.

HelpWindowAdapter helpadapter = new HelpWindowAdapter(this);

// Register it to receive those events.

addWindowListener(helpadapter);

// Set font, background and foreground colors.

Font f = new Font("SansSerif", Font.PLAIN, 14);
setFont(f);
setBackground(Color.white);
setForeground(Color.black);

// Load help text into "helptext" array.

loadtext_();

// Find help topic to be displayed.

if (title.equals("FVS-to-Network Association")) {
   topicindex = 1;

} else if (title.equals("Weighted-Sum Weights Entry")) {
   topicindex = 2;

} else if (title.equals("Stratum Aggregation Method")) {
   topicindex = 3;

} else if (title.equals("Node Probabilities Plot")) {
   topicindex = 4;

} else if (title.equals("General decnet Help Message")) {
   topicindex = 5;

} else if (title.equals("About decnet")) {
   topicindex = 6;

} else if (title.equals("Replication group assignment")) {
   topicindex = 7;
}

}

// ----------------------------------------------------------------------

public void actionPerformed(ActionEvent ae) {
String str;

str = ae.getActionCommand();

if (str.equals("Finish")) {
   dispose();
}

}

// ----------------------------------------------------------------------

public void itemStateChanged(ItemEvent ie) {
repaint();
}

// ----------------------------------------------------------------------

public void paint (Graphics g) {

int i, yinc = 20, ypos = 50, fontheight;

// Get font height.

FontMetrics fm = g.getFontMetrics();
fontheight = fm.getHeight();

// Write help topic's text.

for (i = 0; i < nmlines[topicindex - 1]; ++i){
   g.drawString(helptext[topicindex - 1][i], 6, ypos);
   ypos += yinc;
}

}

// ----------------------------------------------------------------------

public void loadtext_() {

/* Loads all help texts into "helptext" array.  First, load text for
   the node-to-FVS variable association. */

helptext[0][0] = "The FVS-to-Network node associator allows the user";
helptext[0][1] = "to define network nodes as weighted sums of quantities";
helptext[0][2] = "in the FVS Structural Statistics Table.";
nmlines[0] = 3;

// Weighted-sum weights entry window.

helptext[1][0] = "Node based on multiple continuous FVS variables:";
helptext[1][1] = "   Enter weight values to form the weighted sum of the";
helptext[1][2] = "   selected FVS variables to be associated with a node.";
helptext[1][3] = "   Use negative values to create negative associations.";
helptext[1][4] = "Node based on a single qualitative FVS variable:";
helptext[1][5] = "   Field 1: # of FVS variable values for a node value";
helptext[1][6] = "   Field 2: FVS variable values separated by spaces";
nmlines[1] = 7;

// Stratum aggregation window.

helptext[2][0] = "FVS creates from one to three strata of a stand.";
helptext[2][1] = "Because the number of strata cannot be fixed by";
helptext[2][2] = "by the user, a stratum-combination algorithm needs";
helptext[2][3] = "to be chosen.";
nmlines[2] = 4;

// Node probability distribution graphical displays window.

helptext[3][0] = "Plots the conditional distribution of the selected";
helptext[3][1] = "node.";
nmlines[3] = 2;

// General decnet Help message.

helptext[4][0] = "Most of decnet's Dialog and List windows have Help";
helptext[4][1] = "buttons that display brief Help messages.";
nmlines[4] = 2;

// About decnet

helptext[5][0] = "id Version 1.0 as a Java Application by";
helptext[5][1] = "Associate Professor Timothy C. Haas";
helptext[5][2] = "School of Business Administration";
helptext[5][3] = "University of Wisconsin-Milwaukee";
helptext[5][4] = "P. O. Box 742";
helptext[5][5] = "Milwaukee, WI 53201";
helptext[5][6] = "haas@uwm.edu";
nmlines[5] = 7;

// Replication group assignment.

helptext[6][0] = "Each stand needs to be assigned to a group";
helptext[6][1] = "within which only random variation exists.";
nmlines[6] = 2;
}

}

// ******************************************************************

class HelpWindowAdapter extends WindowAdapter {
Helpwindow helpwindow;

// ------------------------------------------------------------------

public HelpWindowAdapter (Helpwindow helpwindow) {
this.helpwindow = helpwindow;
}

// ------------------------------------------------------------------

public void windowClosing(WindowEvent we) {
helpwindow.setVisible(false);
}

}
