import java.util.*;

// -------------------------------------------------------------------

class Grouputils extends Groupdata {

// Groupdata utilities.

// -------------------------------------------------------------------

static void getobsactnshist_(String obsactnshistfle) {

/* Reads an observed actions history file, i.e., one composed of
   only "action" records.
   BCOW: Behavioral Correlates of War
   EMAT: Ecosystem Management Actions Taxonomy.  EMAT is a modified
   version of BCOW. */

boolean test = false, foundaction;

String rawstrng, ematcode, recordtype, restofline = "none";

int i, j, idnm = 0, tindex = 1, nmtrgts = 0, ematcodeindex;

double action_time = 0.;

fleopen_(2, obsactnshistfle, 'r');

// Initialize number of action times and number of actions variables.

nmobsactntimes = 0;
nmobsactns = 0;

do {
   recordtype = fgetstrng_(2);
   if (!recordtype.equals("action")) {
      iderr_("getobsactnshist: record type= " + recordtype);
   }

   /* First, get the action's time and increment the
      number-of-actions-time variable as necessary. */

   action_time = fgetdble_(2);

   // When running CA, skip if outside the requested temporal window.

   if (cacalc && (action_time < Intridslve.t0 ||
                  Intridslve.tfinal < action_time)) {
      restofline = fgetline_(2);
      continue;
   }

   if (nmobsactntimes == 0 ||
      actnshstry_obsactntime[tindex - 1] < action_time) {
      ++nmobsactntimes;

      if (nmobsactntimes > MAXTIMES) {
         iderr_("getobsactnshist: nmobsactntimes > MAXTIMES");
      }

      actnshstry_obsactntime[nmobsactntimes - 1] = action_time;
   }

   // Find tindex for this observation.

   for (i = 1; i <= nmobsactntimes; ++i) {
      if (Math.abs(action_time - actnshstry_obsactntime[i - 1]) < 1.e-6) {
         tindex = i;
	 break;
      }
   }
   
   // Read actor name.  Convert ecosystem actor if necessary.

   strng = fgetstrng_(2);
   if (strng.equals("ecosys")) {
      strng = idname[nmids - 1];
   }

   /* Look up the ID number of this actor.  Skip if not found.  Note
      that IDs are numbered starting at "1" -- not "0." */

   idnm = 0;
   for (i = 1; i <= nmids; ++i) {
      if (strng.equals(idname[i - 1])) {
         idnm = i;
	 idnmbrm1 = idnm - 1;
	 break;
      }
   }
   if (idnm == 0) {
      /*
      printf_("getobsactnshist: actor " + strng +
         " not recognized, skipping.");
      */
      restofline = fgetline_(2);

      continue;
   }

   /*
   printf_("getobsactnhist: tindex= " + tindex + " obstime= " +
      actnshstry_obsactntime[tindex - 1] + " obsactn= " +
      actnshstry_obsactn[idnm - 1][tindex - 1][0] + " obstrgt= " +
      actnshstry_obstrgts[idnm - 1][tindex - 1][0]);
   */

   // Read the action.

   rawstrng = fgetstrng_(2);

   /* For traders only, replace any action that contains the word
      "kill" with "poach_some_rhinos." */

   if (idname[idnmbrm1].equals("traders")) {
      if (rawstrng.indexOf("kill", 0) >= 0) {
         rawstrng = "poach_some_rhinos";
      }
   }

   /* Convert the action to the corresponding first-occurring EMAT action.
      Then, look up its index. */

   ematcodeindex = getematcodeindex_(rawstrng, ematthrshld);
   if (ematcodeindex == 0) {
      iderr_("getobsactnshist: no EMAT code for: " + rawstrng);
   }
   ematcode = Intridslve.ematcode[ematcodeindex - 1];
   strng = getemataction_(ematcode);

   // Get EMAT index of the archetypal version of this action.
   
   ematcodeindex = getematcodeindex_(strng, ematthrshld);

   foundaction = false;
   for (i = 1; i <= Intridslve.nmoutacts[idnmbrm1]; ++i) {
      if (strng.equals(Intridslve.action_labels[idnmbrm1][i - 1])) {
         actnshstry_obsactn[idnmbrm1][tindex - 1][0] = i;
         foundaction = true;
         break;
      }
   }

   if (!foundaction) {
      /*
      printf_("getobsactnshist: ID " + idname[idnmbrm1] +
         " has no action for raw string:" + "\n   " + rawstrng +
         "\n   EMAT action= " + strng + " code= " + ematcode);
      */
      restofline = fgetline_(2);

      continue;
   }

   ++nmobsactns;
   actnshstry_obsactnnmraw[idnmbrm1][tindex - 1] = nmobsactns;
   actnshstry_obsactnnmtime[nmobsactns - 1] = action_time;
   actnshstry_obsactnraw[nmobsactns - 1] =
      actnshstry_obsactn[idnmbrm1][tindex - 1][0];
   actnshstry_obsactntext[idnmbrm1][tindex - 1][0] =
	    Intridslve.action_labels[idnmbrm1][i - 1];
   actnshstry_obsactornm[tindex - 1] = idnm;

   if (maxreadtime < action_time) {
      maxreadtime = action_time;
   }

   /* Store in the raw observations arrays, the string form of
      the actor, and action. */

   actnshstry_obsactor[nmobsactns - 1] = idname[idnmbrm1];
   actnshstry_obsactnstrng[nmobsactns - 1] =
	    Intridslve.action_labels[idnmbrm1][i - 1];

   /* Get the target(s) and store their string-form also.  First,
      get the targets string and find the Target node's integer value
      for this set of targets. */

   strng1 = fgetstrng_(2);

   if (strng1.equals("none")) {

      // Find archtypal target if none is recorded.

      strng1 = Intridslve.archetypal_subject[ematcodeindex - 1][0];
      strng1 = Storyutils.ctryspec_(strng1, idcountry[idnmbrm1]);
      strng1 = "one," + strng1.toLowerCase();
      strng1 = strng1.toLowerCase();
   }

   // Replace any generic "ecosys" with this model's ecosystem ID name.

   strng1 = strngsub_(strng1, "ecosys", idname[nmids - 1]);
 
   // Find target name.

   actnshstry_obstrgts[idnmbrm1][tindex - 1][0] = 0;
   for (j = 1; j <= Intridslve.nmtrgtlbls[idnmbrm1]; ++j) {
      //if (levenshtein_(strng1, Intridslve.target_labels[idnmbrm1][j - 1])
       //   > .2) {
      if (Intridslve.target_labels[idnmbrm1][j - 1].indexOf(strng1, 0) >= 0) {
         actnshstry_obstrgts[idnmbrm1][tindex - 1][0] = j;

         actnshstry_obstrgtsstrng[nmobsactns - 1] =
	    Intridslve.target_labels[idnmbrm1][j - 1];
	 
	 strng1 = Intridslve.target_labels[idnmbrm1][j - 1];

         break;
      }
   }

   // Get action location(s).

   actnshstry_nmobsactlocs[idnmbrm1][tindex - 1] = fgetint_(2);
   for (j = 0; j < actnshstry_nmobsactlocs[idnmbrm1][tindex - 1]; ++j) {
      actnshstry_obsactloc[idnmbrm1][tindex - 1][j] = fgetstrng_(2);
   }
	 
   /*
   printf_("getobsactnshist: tindex= " + tindex +
      " tindex= " + tindex + " obsactor= " + idname[idnmbrm1] +
      " nmlocs= " + actnshstry_nmobsactlocs[idnmbrm1][tindex - 1] +
      " region0= " + actnshstry_obsactloc[idnmbrm1][tindex - 1][0]);
   */

   // Skip this action if target is not recognized.

   if (actnshstry_obstrgts[idnmbrm1][tindex - 1][0] == 0) {
      printf_("getobsactnshist: ID= " + idname[idnmbrm1] + " action= " +
         actnshstry_obsactnstrng[nmobsactns - 1] +
	 "\n   the read-in target: " + strng1 + " is not recognized.");
      --nmobsactns;

      restofline = fgetline_(2);

      continue;
   }

   actnshstry_obstrgtnm[nmobsactns - 1] =
      actnshstry_obstrgts[idnmbrm1][tindex - 1][0];
   
   nmtrgts = Displayutils.gettargets_(strng1, alltargets);

   actnshstry_obsnmtrgts[idnmbrm1][tindex - 1][0] = nmtrgts;

   /*
   printf_("getobsactnshist: nmobsactns= " + nmobsactns + " actor= " +
      actnshstry_obsactor[nmobsactns - 1] + " action= " +
      actnshstry_obsactnstrng[nmobsactns - 1]);
   */
   
   // Find the absolute ID number of each individual target for plotting.

   for (i = 0; i < nmtrgts; ++i) {
      strng = alltargets[i];

      plttrgts[idnmbrm1][tindex - 1][0][i] = 0;
      for (j = 1; j <= nmids; ++j) {
         if (strng.equals(idname[j - 1])) {
            plttrgts[idnmbrm1][tindex - 1][0][i] = j;
	    break;
         }
      }

      if (plttrgts[idnmbrm1][tindex - 1][0][i] == 0) {
	 iderr_("getobsactnshist: plotting target for read-in target: " +
	    strng + " not found.");
      }

   }
} while (!checkeof_(2));

/*
printf_("\ngetobsactnshist: Final Printout, nmobsactntimes= " + nmobsactntimes);
for (j = 0; j < nmobsactntimes; ++j) {
   idnmbrm1 = actnshstry_obsactornm[j] - 1;
   if (idnmbrm1 < 0) {
      continue;
   }
   printf_("getobsactnshist: j+1= " + (j + 1) +
      " obsactor= " + actnshstry_obsactornm[j] +
      " region0= " + actnshstry_obsactloc[idnmbrm1][j][0]);
}
*/

fclose_(2, 'r');
}

// -------------------------------------------------------------------

static int getematcodeindex_(String action, double threshold) {

/* Finds the index of the archetypal EMAT corresponding to "action."
   Future improvement: do not allow an EMAT code starting with "Z" to
   match to an action taken by a group ID. */

String emataction = "none";

int i, ematactionindex = 0;

double score = 0., maxscore = 0.;

for (i = 0; i < Intridslve.nmematcodes; ++i) {
   score = Textutils.levenshtein_(action, Intridslve.emataction[i]);
   if (score > maxscore) {
      maxscore = score;
      ematactionindex = i + 1;
      emataction = Intridslve.emataction[i];
   }
}

if (maxscore > threshold) {
   if (checklevel.equals("highcheck")) {
   //if (true) {
      printf_("getematcodeindex: found emat action with score= " +
         maxscore +
         "\n   action= " + action +
         "\n   emataction= " + emataction);
   }
   return ematactionindex;

} else {

   if (checklevel.equals("highcheck")) {
      printf_("getematcodeindex: action= " + action +
         "\n   threshold= " + fdble_(threshold, 5, 2) +
	 " score= " + fdble_(maxscore, 5, 2) +
	 "\n   emataction= " + emataction);
   }

   // printf_("getematcodeindex: 0 action= " + action);
   return 0;
}
}

// ---------------------------------------------------------------------

static String getemataction_(String code) {

// Finds the EMAT action associated with the EMAT code, "code."

String origcode = "origcode", retval = "none";

int i;

origcode = code;

// Always return the archetypal action as opposed to one of its variants.

if ((code.indexOf("V", 0) >= 0) || (code.indexOf("v", 0) >= 0)) {
   code = code.substring(0, code.length() - 3);
}
for (i = 0; i < Intridslve.nmematcodes; ++i) {
   if (code.equals(Intridslve.ematcode[i])) {
      retval = Intridslve.emataction[i];
      break;
   }
}

if (retval.equals("none")) {
   printf_("getemataction: origcode= " + origcode +
      " found bad EMAT code= " + code);
   return "bad EMAT code= " + code;
}
return retval;
}
}
