public class Getmodl extends Id {

static boolean eosdata = false, test = true, readoneid = true,
   readnodefle = false, readecorlztnsfle = false, EMATfleread = false,
   econodesread = false, readintelreportfle = false, readoptimizationoptions,
   readonequalifier = false, grpsrgnsflesread = false;

static int nmpairs = 0;

static String strng2, idword;

static String pairnames[][] = new String[TNMNDS][2];

static double tempbeliefs[] = new double[TNMVALS];

// -------------------------------------------------------------------

public static void getmodl_(int flenm, String idflenme) {

// Gets id language file "idfle" and parameter values file.

boolean gmpflag = false, datafleread = false, outflesread = false,
   bdryfleread = false, regionread = false, initinacts = false,
   initacts = false;

String dumstrng, contextqualifier, ematpth = "none", ematflename = "none",
   storiespath;

int i, j, k, nmparms, chldnm, prntnm, nmprnts, nmextprnts = 0,
   nmidfles = 0, nminputs = 0, dumint1, dumint2;

double val = 0.;

// Initialize things.

readoneid = true;

dstfle[idnmbrm1][0] = "none";
dstfle[idnmbrm1][1] = "none";
dstfle[idnmbrm1][2] = "none";

for (i = 0; i < MAXNMLV; ++i) {
   Pltsurf.lgndlbl[i] = "none";
}

for (i = 0; i < TNMNDS; ++i) {
   varinfo_eval[idnmbrm1][i] = true;
   varinfo_memnde[idnmbrm1][i] = "none";
}
idinfo_nmsdes[idnmbrm1] = 0;

nmnds = 0;
parm_mvar = 0;
optimal_decision = false;
phenom_class = "not_assigned";
countrymap[0] = "allcountries";

// Open id language fle, and read 2-line title.

if (test) {
   printf_("getmodl: opening ID file " + idflenme);
}
fleopen_(flenm, idflenme, 'r');

gphtitl[0] = fgetline_(flenm);
gphtitl[1] = fgetline_(flenm);

if (gmpflag) {
   printf_(gphtitl[0]);
   printf_(gphtitl[1]);
}

// Read id "influence_diagram," "node," or "context" statements.

nextnde: for (;;) {
   strng = fgetstrng_(flenm);

   if (strng.equals("comment")) {

      /* Discard comments after detecting the Situaion subnetwork part
	 of the file. */

      fgetline_(flenm);
      continue;
   
   } else if (strng.equals("begincomment")) {
      do {
	 strng = fgetstrng_(flenm);
      } while (!strng.equals("endcomment"));
      continue;

   } else if (strng.equals("report")) {
      iderr_("report statement must follow ``influence_diagram,'' " +
         "``node,'' or ``context'' statements.");
   
   } else if (!strng.equals("influence_diagram") &&
       !strng.equals("node") && !strng.equals("context")) {
      iderr_("getmodl: strng= " + strng +
         " is not an ``influence_diagram,'' ``node,'' or " +
         "``context'' statement");
   }

   idword = strng;

   if (idword.equals("influence_diagram")) {
      Readnet.newdst = true;
      ++nmidfles;
      if (nmidfles > TNMIDS) {
	 iderr_("getmodl: nmidfles= " + nmidfles + " TNMIDS= " +
	    TNMIDS);
      }
      readoneid = false;

   } else if (idword.equals("node")) {

      /* Get "node" qualifier.  First, increment node counter and check
         for valid number. */

      ++nmnds;
      Intridslve.nmndes[idnmbrm1] = nmnds;
      if (nmnds > TNMNDS) {
         iderr_("getmodl: nmnds= " + nmnds + ", too many nodes.");
      }

      // Get node name.

      nodelbls[idnmbrm1][nmnds - 1][0] = fgetstrng_(flenm);

      // Detect if this is a spatial model.
  
      if (nodelbls[idnmbrm1][nmnds - 1][0].equals("Xcoord") ||
          nodelbls[idnmbrm1][nmnds - 1][0].equals("Ycoord")) {
         spatial = true;
      }

      // Detect if this ID has a Situation subnetwork.
      
      if (nodelbls[idnmbrm1][nmnds - 1][0].equals("TIME") ||
          nodelbls[idnmbrm1][nmnds - 1][0].equals("Input_Action") ||
          nodelbls[idnmbrm1][nmnds - 1][0].equals("Time")) {
         hassituation = true;
      }

      // Detect seasonality and get short name.

      if (nodelbls[idnmbrm1][nmnds - 1][0].equals("Season")) {
         seasclc = true;
      }
      grph_label[idnmbrm1][nmnds - 1] = fgetstrng_(flenm);

      // Detect a discrete region node.

      if (grph_label[idnmbrm1][nmnds - 1].equals("Region") ||
          grph_label[idnmbrm1][nmnds - 1].equals("Locale") ||
          grph_label[idnmbrm1][nmnds - 1].equals("Ranch")) {
         regionnode = grph_label[idnmbrm1][nmnds - 1];
      }

      // Get distribution family and check for a valid entry.

      strng = fgetstrng_(flenm);
      if (!strng.equals("Determ_Root") &&
          !strng.equals("Determ_Decision") &&
          !strng.equals("Determ_Thrshld") &&
          !strng.equals("Determ_Ratio") &&
          !strng.equals("Determ_Linear") &&
          !strng.equals("Determ_Frctn") &&
          !strng.equals("Determ_Discrete") &&
          !strng.equals("Determ_Contin") &&
          !strng.equals("Determ_Temporal") &&
          !strng.equals("Discrete") &&
          !strng.equals("Logit") &&
          !strng.equals("Additive_Error") &&
          !strng.equals("Beta") &&
          !strng.equals("Gamma") &&
          !strng.equals("Lognormal") &&
          !strng.equals("LOMAP") &&
          !strng.equals("GLOMAP") &&
          !strng.equals("HIBM") &&
          !strng.equals("PIBM") &&
          !strng.equals("SMS") &&
          !strng.equals("R_Horn_ABM") &&
          !strng.equals("M_Network_ABM") &&
          !strng.equals("SDE")) {
          iderr_("getmodl: type= " + strng + " is an unknown node type.");
      }
      varinfo_dist[idnmbrm1][nmnds - 1] = strng;

      if (varinfo_dist[idnmbrm1][nmnds - 1].equals("SDE")) {
         ++idinfo_nmsdes[idnmbrm1];
         //Beliefs.enmloops = SDESIMSZE;

      } else if (varinfo_dist[idnmbrm1][nmnds - 1].equals("HIBM")) {
         idinfo_hashibm[idnmbrm1] = true;
         Beliefs.enmloops = ISIMSZE;

      } else if (varinfo_dist[idnmbrm1][nmnds - 1].equals("PIBM")) {
         idinfo_haspibm[idnmbrm1] = true;
         Beliefs.enmloops = ISIMSZE;

      } else if (varinfo_dist[idnmbrm1][nmnds - 1].equals("R_Horn_ABM")) {
         idinfo_hasabm[idnmbrm1] = true;
         Beliefs.anmloops = ASIMSZE;

      } else if (varinfo_dist[idnmbrm1][nmnds - 1].equals("M_Network_ABM")) {
         idinfo_hasabm[idnmbrm1] = true;
         Beliefs.anmloops = ASIMSZE;
         Beliefs.isbusinessabm = true;

      } else if (varinfo_dist[idnmbrm1][nmnds - 1].equals("SMS")) {
         Beliefs.issms = true;
         Beliefs.enmloops = ISIMSZE;
      }

      // Initialize the number of node values.
   
      nodenghs[idnmbrm1][nmnds - 1][0] = 1;
      nodenghs[idnmbrm1][nmnds - 1][1] = 0;

      // Count number of LOMAP/GLOMAP nodes and store their numbers.

      if (varinfo_dist[idnmbrm1][nmnds - 1].equals("LOMAP") ||
          varinfo_dist[idnmbrm1][nmnds - 1].equals("GLOMAP")) {
         lomapnms[parm_mvar] = nmnds;
	 idtostnm[nmnds - 1] = parm_mvar + 1;
         ++parm_mvar;
      }

      // Set the number of parameters for a Determ_Discrete node.

      if (varinfo_dist[idnmbrm1][nmnds - 1].equals("Determ_Discrete")) {
         varinfo_nmparms[idnmbrm1][nmnds - 1] = 1;
      }
   }

   // Read n-array relations for this id word.

   for (;;) {
      if (checkeof_(flenm)) {
	 break nextnde;
      }

      strng = fgetstrng_(flenm);

      if (strng.equals("comment")) {

         /* Discard comments after detecting the Situaion subnetwork part
	    of the file. */

         fgetline_(flenm);
         continue;
   
      } else if (strng.equals("begincomment")) {
         do {
	    strng = fgetstrng_(flenm);
         } while (!strng.equals("endcomment"));
         continue;

      } else if (strng.equals("influence_diagram") ||
          strng.equals("node") || strng.equals("context")) {

         // Push back next id word unless it is the word "report."

	 streamTokenizer[flenm - 1].pushBack();
	 break;

      } else if (strng.equals("report")) {
	 break nextnde;
      }

      if (idword.equals("influence_diagram")) {
         if (strng.equals("idname")) {

	    /* Get ID name, plotting symbol, and country that the ID
	       belongs to. */

            idname[nmidfles - 1] = fgetstrng_(flenm);
            idsymb[nmidfles - 1] = fgetstrng_(flenm);
            idcountry[nmidfles - 1] = fgetstrng_(flenm);

         } else if (strng.equals("idfile")) {

	    // Get idfle name.

	    idfle[nmidfles - 1] = fgetstrng_(flenm);

	    if (idfle[nmidfles - 1].equals("thisfile")) {
               readoneid = true;
	    }
         }

      } else if (idword.equals("node")) {
         if (strng.equals("values")) {
            nodenghs[idnmbrm1][nmnds - 1][0] = fgetint_(flenm);
            
            /*
	    printf_("node= " + nodelbls[idnmbrm1][nmnds - 1][0] +
               " short name= " + grph_label[idnmbrm1][nmnds - 1] +
               " nmvals= " + nodenghs[idnmbrm1][nmnds - 1][0]);
            */

            if (nodenghs[idnmbrm1][nmnds - 1][0] > TNMVALS) {
	       iderr_("getmodl: variable= " +
                  nodelbls[idnmbrm1][nmnds - 1][0] +
	          " nmvals= " + nodenghs[idnmbrm1][nmnds - 1][0] +
	          " too many discrete values.");
	    }
            for (j = 1; j <= nodenghs[idnmbrm1][nmnds - 1][0]; ++j) {
	       dumstrng = fgetstrng_(flenm);
  
	       // Trim front and back whitespace and convert to lowercase.

               dumstrng = dumstrng.toLowerCase();
               dumstrng = dumstrng.trim();

	       // Check for duplicate values.

	       for (k = 1; k < j; ++k) {
	          if (nodelbls[idnmbrm1][nmnds - 1][k].equals(dumstrng)) {
                     iderr_("getmodl: value= " + dumstrng +
		        " is a duplicate");
		  }
	       }

               nodelbls[idnmbrm1][nmnds - 1][j] = dumstrng;
            }

	    // Set the number of parameters for a Determ_Temporal node.

            if (varinfo_dist[idnmbrm1][nmnds - 1].equals(
				    "Determ_Temporal")) {
               varinfo_nmparms[idnmbrm1][nmnds - 1] =
	          nodenghs[idnmbrm1][nmnds - 1][0];
            }

         } else if (strng.equals("parameters")) {

            // Read parameter names.

            varinfo_nmparms[idnmbrm1][nmnds - 1] = fgetint_(flenm);
            if (varinfo_nmparms[idnmbrm1][nmnds - 1] > TNMVALS) {
	       iderr_("getmodl: TNMVALS= " + TNMVALS +
		  ", too many parameters.");
	    }
            for (j = 0; j < varinfo_nmparms[idnmbrm1][nmnds - 1]; ++j) {
	       parmlbls[idnmbrm1][nmnds - 1][j] = fgetstrng_(flenm);
            }

         } else if (strng.equals("parents")) {

            // Read parent names and check limits.

            nodenghs[idnmbrm1][nmnds - 1][1] = fgetint_(flenm);
      
  	    // Error checking.

	    if (nodenghs[idnmbrm1][nmnds - 1][1] > TNMPRTS ||
	        (nodenghs[idnmbrm1][nmnds - 1][1] > NMPRBDIM &&
	         varinfo_dist[idnmbrm1][nmnds - 1].equals("Discrete"))) {
               iderr_("getmodl: number of parents= " +
		  nodenghs[idnmbrm1][nmnds - 1][1] + " TNMPRTS= " +
		     TNMPRTS + " NMPRBDIM= " + NMPRBDIM +
		     ", too many parents");

            } else if (varinfo_dist[idnmbrm1]
                                   [nmnds - 1].equals("Determ_Linear") &&
                       nodenghs[idnmbrm1][nmnds - 1][1] > 3) {
               iderr_("getmodl: ID= " + thisidname +
                      " invalid parents on node " + nmnds);
            }

	    // Get parents.

            for (j = 1; j <= nodenghs[idnmbrm1][nmnds - 1][1]; ++j) {
               strng = fgetstrng_(flenm);
               if (strng.equals("none")) {
	          nodenghs[idnmbrm1][nmnds - 1][1] = 0;
	          break;
	       }
            
	       // Find parent's number.

               for (k = 1; k <= nmnds; ++k) {
                  if (strng.equals(grph_label[idnmbrm1][k - 1])) {
                     nodenghs[idnmbrm1][nmnds - 1][j + 1] = k;
                     break;
                  }
               }

               if (k >= nmnds) {
	          if (strng.equals(grph_label[idnmbrm1][nmnds - 1])) {
	             iderr_("getmodl: ID= " + idflenme +
	                " parent is same as node " +
                        nodelbls[idnmbrm1][nmnds - 1][0]);
		     
		  } else {
		     iderr_("getmodl: ID= " + idflenme + ", Parent " +
		        strng + " for node " +
                        nodelbls[idnmbrm1][nmnds - 1][0] +
		        "\n **** not found. ****");
	          }
               }

               // Nodes inherit temporal dependence.
     
               if (strng.equals("Time") ||
		   nodelbls[idnmbrm1][k - 1][0].equals("Time") ||
		   nodelbls[idnmbrm1][k - 1][0].equals("TIME") ||
		   varinfo_temporal[idnmbrm1][k - 1]) {
                  varinfo_temporal[idnmbrm1][nmnds - 1] = true;
		  temporal = true;
               }
            }

         } else if (strng.equals("memory")) {

	    /* Read the name of the node that this memory node is to use
	       as a distribution after the initial time. */

	    varinfo_memnde[idnmbrm1][nmnds - 1] = fgetstrng_(flenm);
	 }
      
      } else if (idword.equals("context")) {

	 contextqualifier = strng;

	 // Read all of this qualifier's relations.

	 for (;;) {
	    strng = fgetstrng_(flenm);

	    // Break out of "context" section if "report" is read.

	    if (strng.equals("report") || strng.equals("context")) {
	       streamTokenizer[flenm - 1].pushBack();
	       break;
            }

	    if (contextqualifier.equals("settings")) {
		
               // Read "settings" qualifier relations.

	       if (strng.equals("real-world_phenomenon_type")) {
                  phenom_class = fgetstrng_(flenm);
                  if (!phenom_class.equals("president") &&
                      !phenom_class.equals("EPA") &&
                      !phenom_class.equals("RR") &&
                      !phenom_class.equals("pastoralists") &&
                      !phenom_class.equals("NGO") &&
                      !phenom_class.equals("ecosystem") &&
                      !phenom_class.equals("econsystem") &&
                      !phenom_class.equals("tutorial")) {
                     iderr_("phenomenon class " + phenom_class +
	                " not recognized.");
	          }

	       } else if (strng.equals("parameter_learning")) {
                  Idsolve.parameterlearning = fgetboolean_(flenm);

	       } else if (strng.equals("geographic_window")) {
                  spacetime_lngmn = fgetdble_(flenm);
                  spacetime_lngmx = fgetdble_(flenm);
                  spacetime_latmn = fgetdble_(flenm);
                  spacetime_latmx = fgetdble_(flenm);
        
	          // Check for valid entries.

                  if (spacetime_lngmn >= spacetime_lngmx ||
                      spacetime_latmn >= spacetime_latmx) {
                     iderr_("getmodl: invalid lngmn or latmn");
                  }

	          if (spacetime_lngmn <= -180. ||
                      spacetime_lngmx >= 180. ||
                      spacetime_latmn <= -90. ||
		      spacetime_latmx >= 90.) {
                     iderr_("getmodl: lng, lat out of bounds");
                  }

               } else if (strng.equals("inputs")) {

	          if (!readoneid) {
	             iderr_("getmodl: inputs relation not valid in an" +
                        " IntIDs model run");
	          }

                  /* Read conditioning values.  First, find out number of
	             nodes that will be conditioned-on for this run. */

                  nminputs = fgetint_(flenm);

                  for (i = 0; i < nminputs; ++i) {

                     // Get node's short name and conditioning value.

                     strng = fgetstrng_(flenm);
                     condnodes[idnmbrm1][i] = Getmodlutils.getndnm_(strng);

                     if (strng.equals("Time") || strng.equals("Tme") ||
                         strng.equals("t") || strng.equals("TIME")) {

                        /* For the conditioning variable of Time,
			   read t0, tmin, and tmax. */

                        val = fgetdble_(flenm);
	   	        if (nmids == 1) {
                           Ecosyscalcs.tbegin = val;
		           spacetime_begintime = Ecosyscalcs.tbegin;
                           Intridslve.t0 = spacetime_begintime;
                        }

                        val = fgetdble_(flenm);
		        if (nmids == 1) {
                           spacetime_tmin = val;
                           condvals[i] = spacetime_tmin;
                        }

                        val = fgetdble_(flenm);
		        if (nmids == 1) {
                           spacetime_tmax = val;
                           spacetime_endtime = spacetime_tmax;
                           Intridslve.tfinal = spacetime_tmax;
                        }

	             } else if (nodenghs[idnmbrm1][condnodes[idnmbrm1][i] - 1]
		  		        [0] == 1) {

                        // Get the conditioning value of a continuous node.

	                condvals[i] = fgetdble_(flenm);

	             } else {
	                strng2 = fgetstrng_(flenm);

                        /* Trim front and back whitespace and convert to
		           lowercase. */

	                dumstrng = strng2.toLowerCase();
                        strng2 = dumstrng.trim();

                        /* Use the special value "_all_" to signal all values
                           of the conditioning node are to be separately used.
                           Otherwise, find the value that corresponds to the
                           string, "strng" of this discrete conditioning node.
                        */

	                if (strng.equals(regionnode) &&
		            strng2.equals("_all_")) {
                           map = condnodes[idnmbrm1][i];
                           spacetime_option = 2;

	                } else {
                           condvals[i] =
                              Getmodlutils.getndval_(condnodes[idnmbrm1][i],
			   		             strng2, true);
                     
                           if (strng.equals("ManOp")) {
                              initial_ecosystem_action = strng2;
                           }

		           if (condvals[i] <= 0) {
                              iderr_("Conditioning node read failure");
		           }
	                }
	             }
                  }
   
               } else if (strng.equals("management_policy")) {
                  if (!initinacts) {
                     Intridslve.management_policy = fgetstrng_(flenm);
                     initinacts = true;

	          } else {
                     fgetstrng_(flenm);
                  }

               } else if (strng.equals("initial_actions")) {
                  if (!initacts) {
	             Intridslve.nminitialacts = fgetint_(flenm);
                     if (Intridslve.nminitialacts < 1) {
                        iderr_("getmodl: nminitialacts needs to be > 0");
                     }
	             for (i = 0; i < Intridslve.nminitialacts; ++i) {
                        Intridslve.initial_actor[i] = fgetstrng_(flenm);
                        Intridslve.initial_action[i] = fgetstrng_(flenm);
                        Intridslve.initial_nmsubj[i] = fgetint_(flenm);
                        for (j = 0; j < Intridslve.initial_nmsubj[i]; ++j) {
	                   Intridslve.initial_subj[i][j] = fgetstrng_(flenm);
		        }
                     }
                     initacts = true;

	          } else {
	             dumint1 = fgetint_(flenm);
	             for (i = 0; i < dumint1; ++i) {
                        fgetstrng_(flenm);
                        fgetstrng_(flenm);
                        dumint2 = fgetint_(flenm);
                        for (j = 0; j < dumint2; ++j) {
	                   fgetstrng_(flenm);
		        }
                     }
                  }
         
               } else if (strng.equals("this_id_name")) {
                  if (nmids == 1) {

	             /* Get this ID's name, plotting symbol, and country that
                        this ID belongs to. */

                     idname[0] = fgetstrng_(flenm);
                     thisidname = idname[0];
                     idsymb[0] = fgetstrng_(flenm);
                     idcountry[0] = fgetstrng_(flenm);
                     countrymap[1] = idcountry[0];
                     nmcountries = 2;

                  } else {
                     fgetstrng_(flenm);
                     fgetstrng_(flenm);
                     fgetstrng_(flenm);
                  }

               } else if (strng.equals("optimization_options")) {
		  if (!readoptimizationoptions) {
                     if (fgetstrng_(flenm).equals("true")) {
		        Optimiz.stochobjfcn = true;
             
	             } else {
		        Optimiz.stochobjfcn = false;
                     }
                     Optimiz.maxnmf = fgetint_(flenm);
                     Optimiz.epsilon = fgetdble_(flenm);
                     Optimiz.rhohooke = fgetdble_(flenm);
                     Optimiz.maxhookeiter = fgetint_(flenm);
		     SimAnnealContin.globalsearchthres = fgetdble_(flenm);
                     readoptimizationoptions = true;

		  } else {
                     fgetint_(flenm);
		     fgetdble_(flenm);
		     fgetdble_(flenm);
                     fgetint_(flenm);
		     fgetdble_(flenm);
		  }

	       } else if (strng.equals("region")) {
                  if (!regionread) {
                     nmcmprgns = fgetint_(flenm);
                     for (i = 0; i < nmcmprgns; ++i) {
	                strng2 = fgetstrng_(flenm);
	                dumstrng = strng2.toLowerCase();
                        regionname[i] = dumstrng.trim();
                     }
                     regionread = true;

	          } else {
                     j = fgetint_(flenm);
                     for (i = 0; i < j; ++i) {
	                fgetstrng_(flenm);
                     }
                  }

	       } else if (strng.equals("ecosystem_nodes")) {
                  dumint1 = fgetint_(flenm);
                  for (i = 0; i < dumint1; ++i) {
                     dumstrng = fgetstrng_(flenm);
                     if (!econodesread) {
	                Intridslve.econdelbls[i] = dumstrng;
                     }
                  }
                  if (!econodesread) {
                     Intridslve.nmecosysnds = dumint1;
                     econodesread = true;
		  }

               } else {
                  iderr_("getmodl: " + strng + " not a settings relation");
	       }

	    } else if (contextqualifier.equals("files")) {
	
               // Read "files" qualifier relations.

	       if (strng.equals("gis_layer_files")) {
                  nmgisfles = fgetint_(flenm);
                  for (i = 0; i < nmgisfles; ++i) {
	             SMScalcs.gisflename[i] = fgetstrng_(flenm);
                  }

               } else if (strng.equals("parameter_files")) {

                  // Find out if a parameter file exists.

                  if (fgetstrng_(flenm).equals("new")) {
	             Readnet.newdst = true;
             
	          } else {
	             Readnet.newdst = false;
                  }

                  /* Read the names of the hypothesis, initial values, and
	             estimate parameter files. */

                  dstfle[idnmbrm1][0] = fgetstrng_(flenm);
                  dstfle[idnmbrm1][1] = fgetstrng_(flenm);
                  dstfle[idnmbrm1][2] = fgetstrng_(flenm);
  
               } else if (strng.equals("EMAT_files")) {

                  /* Read the names of the EMAT definitions file, and the
	             file of parsed EMAT entries. */

	          if (!EMATfleread) {
                     ematpth = "c:/polbio/ematdbfiles/";
                     ematflename = fgetstrng_(flenm);
                     Storyutils.ematfle = ematpth + ematflename;

		     if (!fleexists_(Storyutils.ematfle)) {
                        ematpth =
                           "/tscc/nfs/home/haas/polbio/ematdbfiles/";
                        Storyutils.ematfle = ematpth + ematflename;

                        if (!fleexists_(Storyutils.ematfle)) {
                           iderr_("getmodl: no EMAT file");
                        }
                     }

	             Storyparse.parsedematactsfle = ematpth +
                                                       fgetstrng_(flenm);
	             printf_("getmodl: emat file= " + Storyutils.ematfle +
	                "\n   parsedemtacts file= " +
                                 Storyparse.parsedematactsfle);
                     EMATfleread = true;

	          } else {
	             fgetstrng_(flenm);
	             fgetstrng_(flenm);
	          }

               } else if (strng.equals("groups_and_regions_files")) {

                  /* Read the names of the groups file and the regions
                     file. */

	          if (!grpsrgnsflesread) {
                     Groupdata.grpsinfofle = fgetstrng_(flenm);
                     Groupdata.rgnsinfofle = fgetstrng_(flenm);
                     grpsrgnsflesread = true;

	          } else {
	             fgetstrng_(flenm);
	             fgetstrng_(flenm);
	          }

               } else if (strng.equals("social_network_links_file")) {

                  // Read a social network links file name.

	          SNA.linksfle = fgetstrng_(flenm);

               } else if (strng.equals("insider_threat_detection_files")) {

                  // Read insider threat detection system files.

                  ITD.queryresultsfle = fgetstrng_(flenm);
                  ITD.newqueryresultfle = fgetstrng_(flenm);

               } else if (strng.equals("dsens_file")) {

                  /* Read the name of the deterministic sensitivity analysis
		     conditions file. */

                  Dsens.dsensfle = fgetstrng_(flenm);
  
               } else if (strng.equals("MPEMP_constraints_file")) {

                  // Read the name of the MPEMP constraints file.

                  Mpemp.mpempfle = fgetstrng_(flenm);
  
               } else if (strng.equals("MPEMP_file")) {

                  // Read the name of the MPEMP parameter file.

                  dstfle[idnmbrm1][3] = fgetstrng_(flenm);
  
               } else if (strng.equals("sites_file")) {
                  Pltsleg.sitesfle = fgetstrng_(flenm);
	          if (!Pltsleg.sitesfle.equals("none")) {
                     Pltsleg.plotsites = true;
                  }

               } else if (strng.equals("initial_patches_file")) {

                  /* Read the name of the file that gives initial abundances
		     and characteristics of the IBM's patches. */

                  PIBMcalcs.patchdefflename = fgetstrng_(flenm);
  
	       } else if (strng.equals("ecosystem_data_file")) {

                  /* In an IntIDs model, only read the ecosystem data file
                     from the model-definition file, idnmbrm1 = 0. */

	          if (datafleread || (nmids > 1 && idnmbrm1 > 0)) {
	             fgetstrng_(flenm);
	    
	          } else {
                     datafle = fgetstrng_(flenm);
                     datafleread = true;
	          }

               } else if (strng.equals("observed_actions_history_file")) {

	          /* If an actions history file has been read, don't load another
	             one, major bug if you do.  Either way, consume the
	             file name. */

	          strng2 = fgetstrng_(flenm);
	          if (CA.actnshistfle.equals("dumactnshistfle.ahs")) {
	             CA.actnshistfle = strng2;
                  }

               } else if (strng.equals("boundaries_file")) {
	          if (!bdryfleread) {
                     spacetime_bdrysfle = fgetstrng_(flenm);
	             Surf.xislongitude = fgetboolean_(flenm);
                     bdryfleread = true;

	          } else {
	             fgetstrng_(flenm);
	             fgetstrng_(flenm);
	          }

               } else if (strng.equals("output_files")) {
	          if (!outflesread) {
                     Pltgrph.flename = fgetstrng_(flenm);
	             spacetime_psfle = Pltgrph.flename;
                     rptfle = fgetstrng_(flenm);
                     estfle = fgetstrng_(flenm);
                     outflesread = true;

	          } else {
	             fgetstrng_(flenm);
	             fgetstrng_(flenm);
	             fgetstrng_(flenm);
	          }

               } else if (strng.equals("node_output_file")) {
                  if (!readnodefle) {
                     spacetime_xyptsfle = fgetstrng_(flenm);
	             readnodefle = true;

	          } else {
                     strng = fgetstrng_(flenm);
	          }

               } else if (strng.equals("ecosystem_predictions_files")) {
                  if (!readecorlztnsfle) {
                     Ecosyscalcs.ecorlztnsfle = fgetstrng_(flenm);
	             Ecosyscalcs.riskfle = fgetstrng_(flenm);
	             readecorlztnsfle = true;

	          } else {
                     strng = fgetstrng_(flenm);
                     strng = fgetstrng_(flenm);
	          }

               } else if (strng.equals(
                  "actionable_intelligence_report_file")) {
                  if (!readintelreportfle) {
                      SNA.actionableIntelligenceReportFile = fgetstrng_(flenm);
	             readintelreportfle = true;

	          } else {
                     strng = fgetstrng_(flenm);
	          }

	       } else {
                  iderr_("getmodl: " + strng + " not a valid files relation.");
	       }
            }
         }
      }
   } // End of ``influence_diagram,'' ``node,'' or ``context'' relations
     // read statements.
}

// Deduce the number of conditioning nodes.

nmcondnds = 0;
for (i = 0; i < nmnds; ++i) {
   if (nodenghs[idnmbrm1][i][1] == 0 &&
       (varinfo_dist[idnmbrm1][i].equals("Determ_Root") ||
        varinfo_dist[idnmbrm1][i].equals("Determ_Decision") ||
        varinfo_dist[idnmbrm1][i].equals("Determ_Contin"))) {
      ++nmcondnds;
   }
}

// Set the spatio-temporal flag.

if (parm_mvar > 0) {
   spacetime_option = 6;
}

if (nmidfles > 0) {

   /* For an IntIDs .id file (the file that gives the names of each
      ID), set number of IDs and initialize distribution information.
      
      ***Note that this IntIDs .id file should be read only once because
      for an ID-type .id file, "nmidfles" will be 0.  Therefore, this
      single conditional statement should only execute once. */

   nmids = nmidfles;

   /* Figure out how many countries there are and assign an identifier
      number to each country.  Remember that countrynm = 1
      (countrymap[0]) is "allcountries."  Hence, nmcountries is always
      bigger than 1. */

   IDLOOP: for (i = 0; i < nmids; ++i) {
      for (j = 1; j <= nmcountries; ++j) {
         if (idcountry[i].equals(countrymap[j - 1])) {
            countrynm[i] = j;
            continue IDLOOP;
         }
      }
      countrymap[nmcountries] = idcountry[i];
      ++nmcountries;
   }

   if (!phenom_class.equals("not_assigned") && nmcountries < 2) {
      iderr_("getmodl: nmids= " + nmids + " nmcountries= " + nmcountries);
   }
}

/* If a report qualifier has been read already, close the .id file and
   process the ID's parameter file. */

if (reportqualifier != null) {
   fclose_(flenm, 'r');

   thisidname = idname[idnmbrm1];

   if (gmpflag) {
      printf_("getmodl: finished reading id language file.");
   }

   // Really important to have a phenomenon class assigned.

   if (nmidfles == 0 && phenom_class.equals("not_assigned")) {
      iderr_("getmodl: ID= " + thisidname + " no phenom_class");
   }

   if (nmidfles > 1) {
      iderr_("getmodl: nmidfles= " + nmidfles +
	 " trying to call readnet_" + " when reading an IntIDs .id file.");
   }

   /* If network calculations are to be performed, read the ID's
      parameter file.  Create a parameter file if none exists. */

   if (reportqualifier.equals("evaluate") ||
       reportqualifier.equals("sensitivity_analysis") ||
       reportqualifier.equals("mc_hypothesis_test") ||
       reportqualifier.equals("estimate") ||
       reportqualifier.equals("prepare_data") ||
       reportqualifier.equals("describe_data")) {

      if (Readnet.newdst) {
	 Readnet.readnet_(dstfle[idnmbrm1][0], flenm, nmnds, 1);
	 Writenet.writenet_(1, 1, true);
      
      } else {

	 // Read the hypothesis distribution.
         
	 Readnet.readnet_(dstfle[idnmbrm1][0], flenm, nmnds, 1);

	 /* Read the initial distribution.  Note that the initial
	    distribution is loaded into the 2nd distribution location
	    of "condprb." */

         Readnet.readnet_(dstfle[idnmbrm1][1], flenm, nmnds, 2);
      }
   }

   /* The "report" qualifier has already been read so there is nothing
      more to do here. */

   return;
}

/* Next, read "report" statements.  First read the report word
   qualifier. */

reportqualifier = fgetstrng_(flenm);

// Read n-array relations.

for (;;) {
   if (checkeof_(flenm)) break;
   strng = fgetstrng_(flenm);

   // Read any comments above a report qualifier.

   if (strng.equals("begincomment")) {
      readonequalifier = false;
      do {
	 strng = fgetstrng_(flenm);
      } while (!strng.equals("endcomment"));
      strng = fgetstrng_(flenm);
   }

   if (strng.equals("report") || readonequalifier) {
      
      // Process only 1 report command per run.

      break;
   }

   readonequalifier = true;
   if (reportqualifier.equals("prepare_data")) {
      if (strng.equals("read_NWS_data")) {
         spacetime_option = -1;

      } else if (strng.equals("gis_tools")) {
         GISwind.pointfle = fgetstrng_(flenm);
	 GISutils.nmflesperimage = fgetint_(flenm);
	 iderr_("getmodl: broken");
	 for (i = 0; i < 2; ++i) {
            for (j = 0; j < GISutils.nmflesperimage; ++j) {
               GISwind.animalfle[i][j] = fgetstrng_(flenm);
            }
	 }

      } else if (strng.equals("convert_data")) {
         spacetime_infle[0] = fgetstrng_(flenm);
	 Convrt.analysisfle = fgetstrng_(flenm);
	 Convrt.mintime = fgetdble_(flenm);
	 Convrt.maxtime = fgetdble_(flenm);
         spacetime_outfle = fgetstrng_(flenm);
	 spacetime_nminfles = 1;
         spacetime_option = 1;

      } else if (strng.equals("convert_eos_data")) {
         spacetime_infle[0] = fgetstrng_(flenm);
         spacetime_outfle = fgetstrng_(flenm);
         Eosdata.longmin = fgetdble_(flenm);
         Eosdata.longmax = fgetdble_(flenm);
         Eosdata.latmin = fgetdble_(flenm);
         Eosdata.latmax = fgetdble_(flenm);
	 spacetime_endtime = fgetdble_(flenm);
	 Eosdata.nmrows = fgetint_(flenm);
	 Eosdata.nmcols = fgetint_(flenm);
	 Eosdata.minval = fgetint_(flenm);
	 Eosdata.maxval = fgetint_(flenm);
	 Eosdata.background = (short) fgetint_(flenm);
	 Eosdata.varname = fgetstrng_(flenm);
	 eosdata = true;
         spacetime_option = 1;

      } else if (strng.equals("convert_boundary")) {
	 spacetime_nminfles = fgetint_(flenm);
	 for (i = 0; i < spacetime_nminfles; ++i) {
            spacetime_infle[i] = fgetstrng_(flenm);
	 }
	 Convrt.analysisfle = fgetstrng_(flenm);
	 Convrt.mintime = fgetdble_(flenm);
	 Convrt.maxtime = fgetdble_(flenm);
         spacetime_outfle = fgetstrng_(flenm);
         spacetime_nmrows = fgetint_(flenm);
         spacetime_nmcols = fgetint_(flenm);
         spacetime_option = 0;

      } else if (strng.equals("grid")) {
         spacetime_nmrows = fgetint_(flenm);
         spacetime_nmcols = fgetint_(flenm);
         spacetime_option = 3;

      } else if (strng.equals("convert_label-grid")) {
         spacetime_labelfle = fgetstrng_(flenm);
         spacetime_surffle[0] = fgetstrng_(flenm);
         spacetime_psfle = fgetstrng_(flenm);
         spacetime_nmrows = fgetint_(flenm);
         spacetime_nmcols = fgetint_(flenm);
         spacetime_option = 4;

      } else if (strng.equals("remove_html")) {
	 Storyparse.htmlfle = fgetstrng_(flenm);
	 Storyparse.outfle = fgetstrng_(flenm);
         
      } else if (strng.equals("parse_stories")) {
         strng = fgetstrng_(flenm);
	 if (strng.equals("true")) {
            Storyparse.accuracycheck = true;
	 }
         strng = fgetstrng_(flenm);
	 if (strng.equals("true")) {
            Storyparse.learnmode = true;
	 }

	 storiespath = fgetstrng_(flenm);
	 Storyparse.nmstoriesfiles = fgetint_(flenm);
	 for (i = 0; i < Storyparse.nmstoriesfiles; ++i) {
	    Storyparse.storiesfle[i] = fgetstrng_(flenm);
            dumstrng = Storyparse.storiesfle[i].replaceAll(".txt","");
	    Storyparse.storiesfle[i] = storiespath + Storyparse.storiesfle[i];

	    Groupdata.grpactnsfle[i] = dumstrng + "acts.dat";
	    Storyparse.parsedstoriesfle[i] = dumstrng + "parsed.dat";
            Storyparse.checkfle[i] = dumstrng + "check.dat";
         }

      } else if (strng.equals("rdbms")) {
	 PolEcolDB.dbname = fgetstrng_(flenm);
	 Storyparse.parsedstoriesfle[0] = fgetstrng_(flenm);

	 PolEcolDB.command1 = fgetline_(flenm);
         for (i = 0; i < 100; ++i) { // checkeof_() breaks with fgetline_()
            dumstrng = fgetline_(flenm);
            if (dumstrng.trim().equals("endcommand")) {
               break;
	    
	    } else {
	       PolEcolDB.command1 += "\n" + dumstrng;
	    }
	 }

	 PolEcolDB.command2 = fgetline_(flenm);
         for (i = 0; i < 100; ++i) { // checkeof_() breaks with fgetline_()
            dumstrng = fgetline_(flenm);
            if (dumstrng.trim().equals("endcommand")) {
               break;
	    
	    } else {
	       PolEcolDB.command2 += "\n" + dumstrng;
	    }
	 }

	 PolEcolDB.command3 = fgetline_(flenm);
         for (i = 0; i < 100; ++i) { // checkeof_() breaks with fgetline_()
            dumstrng = fgetline_(flenm);
            if (dumstrng.trim().equals("endcommand")) {
               break;
	    
	    } else {
	       PolEcolDB.command3 += "\n" + dumstrng;
	    }
	 }

	 PolEcolDB.command4 = fgetline_(flenm);
         for (i = 0; i < 100; ++i) { // checkeof_() breaks with fgetline_()
            dumstrng = fgetline_(flenm);
            if (dumstrng.trim().equals("endcommand")) {
               break;
	    
	    } else {
	       PolEcolDB.command4 += "\n" + dumstrng;
	    }
	 }

	 PolEcolDB.query = fgetline_(flenm);
         for (i = 0; i < 100; ++i) {
            dumstrng = fgetline_(flenm);
            if (dumstrng.trim().equals("endquery")) {
               break;
	    
	    } else {
	       PolEcolDB.query += "\n" + dumstrng;
	    }
	 }

         Storyparse.dboption = fgetstrng_(flenm);

      } else if (strng.equals("generate_an_actions_history_file")) {
	 Groupdata.grpactnsfle[0] = fgetstrng_(flenm);
	 Displayactions.actnshistfle = fgetstrng_(flenm);
         strng = fgetstrng_(flenm);
	 if (strng.equals("true")) {
            cacalc = true;
	 }
         Groupdata.checklevel = fgetstrng_(flenm);

      } else if (strng.equals("find_product_themes")) {
	 ProductThemes.socialmediaposts = fgetstrng_(flenm);

      } else {
         iderr_("getmodl: strng= " + strng +
            " is not a valid relation for the report qualifier \n     " +
	    reportqualifier);
      }

   } else if (reportqualifier.equals("describe_data")) {
      if (strng.equals("compare_samples")) {
         nmpairs = fgetint_(flenm);
         for (i = 0; i < nmpairs; ++i) {
            pairnames[i][0] = fgetstrng_(flenm);
            pairnames[i][1] = fgetstrng_(flenm);
         }

      } else {
         iderr_("getmodl: strng= " + strng +
            " is not a valid relation for the report qualifier \n     " +
	    reportqualifier);
      }

   } else if (reportqualifier.equals("estimate")) {
      Beliefs.loadconsdst = true;
      if (strng.equals("fit_logits")) {
         cacalc = true;
         Fitlogit.nmtofit = fgetint_(flenm);
         for (i = 0; i < Fitlogit.nmtofit; ++i) {
	    // printf_("getmodl: getndnm_ call 2, i= " + i);
	    Fitlogit.fitnodes[i] = Getmodlutils.getndnm_(fgetstrng_(flenm));
         }

      } else if (strng.equals("find_interdiction_patrol_route")) {
         interdict = true;
	 Interdict.bdryflenme = fgetstrng_(flenm);
	 Interdict.carcassflenme = fgetstrng_(flenm);
	 Interdict.obstargetflenme = fgetstrng_(flenm);
	 Interdict.attrtesflenme = fgetstrng_(flenm);
	 Interdict.intrrtesflenme = fgetstrng_(flenm);
	 Routegen.bdryflenme = fgetstrng_(flenm);
	 Routegen.genrtesflenme = fgetstrng_(flenm);
	 Interdict.generate_routes = fgetboolean_(flenm);
	 Interdict.update = fgetboolean_(flenm);

      } else if (strng.equals("pursuit_strategy")) {
         pursuit = true;
	 Interdict.obstargetflenme = fgetstrng_(flenm);
	 Interdict.attrtesflenme = fgetstrng_(flenm);
	 Pursuit.beginrte = fgetint_(flenm);
	 Pursuit.endrte = fgetint_(flenm);

      } else if (strng.equals("deduplicate_players")) {
         deduplicateplayers = true;
         SNA.linksfle = fgetstrng_(flenm);
         Deduplicate.thrshld = fgetdble_(flenm);

      } else if (strng.equals("reconstruct_social_network")) {
         cacalc = true;
	 estimatesocialnetwork = true;
	 SNA.linksfle = fgetstrng_(flenm);
	 SNA.nmlevels = fgetint_(flenm);
         Beliefs.nmloops = fgetint_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);

      } else if (strng.equals("estimate_nodes")) {
         Report.estimatenodes = true;
         cacalc = true;
         Intridslve.t0 = fgetdble_(flenm);
         Intridslve.tfinal = fgetdble_(flenm);

	 if (nmids == 1) {
            Psens.nmsensids = 1;
	    Psens.id[0] = idname[0];

	 } else {
            Psens.nmsensids = fgetint_(flenm);
	 }
         for (i = 0; i < Psens.nmsensids; ++i) {
         
	    // Get ID name.

            if (nmids > 1) {
               Psens.id[i] = fgetstrng_(flenm);
            }

	    // Get number of nodes to estimate within that ID.

	    Psens.nmndes[i] = fgetint_(flenm);

	    // Read node names.

	    for (j = 0; j < Psens.nmndes[i]; ++j) {
               Psens.ndenames[i][j] = fgetstrng_(flenm);
	    }
         }

         // Get Consistency Analysis directions.

	 CA.ch = fgetdble_(flenm);
         Beliefs.nmloops = fgetint_(flenm);
	 CA.initsubstep1 = fgetboolean_(flenm);
	 CA.initsubstep2 = fgetboolean_(flenm);
	 CA.camax = fgetboolean_(flenm);
         CA.runtype = fgetstrng_(flenm);

         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);

      } else if (strng.equals("confidence_intervals")) {
	 Report.confidenceintervals = true;
         cacalc = true;
         Intridslve.t0 = fgetdble_(flenm);
         Intridslve.tfinal = fgetdble_(flenm);

	 if (nmids == 1) {
            Psens.nmsensids = 1;
	    Psens.id[0] = idname[0];

	 } else {
            Psens.nmsensids = fgetint_(flenm);
	 }
         for (i = 0; i < Psens.nmsensids; ++i) {
         
	    // Get ID name.

            if (nmids > 1) {
               Psens.id[i] = fgetstrng_(flenm);
            }

	    // Get number of nodes to estimate within that ID.

	    Psens.nmndes[i] = fgetint_(flenm);

	    // Read node names.

	    for (j = 0; j < Psens.nmndes[i]; ++j) {
               Psens.ndenames[i][j] = fgetstrng_(flenm);
	    }
         }
	 CA.ch = fgetdble_(flenm);
         CAapps.cilevel = fgetdble_(flenm);
         Beliefs.nmloops = fgetint_(flenm);

         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);

      } else if (strng.equals("prediction_skill")) {
         cacalc = true;
         predskill = true;
         Intridslve.t0 = fgetdble_(flenm);
         CAapps.begintme = fgetdble_(flenm);
         Intridslve.tfinal = fgetdble_(flenm);

         Psens.nmsensids = fgetint_(flenm);
         for (i = 0; i < Psens.nmsensids; ++i) {
         
	    // Get ID name and number of nodes to assess within that ID.

            Psens.id[i] = fgetstrng_(flenm);
	    Psens.nmndes[i] = fgetint_(flenm);

	    // Read node names.

	    for (j = 0; j < Psens.nmndes[i]; ++j) {
               Psens.ndenames[i][j] = fgetstrng_(flenm);
	    }
         }

         // Get Consistency Analysis information.

	 CA.ch = fgetdble_(flenm);
         Beliefs.nmloops = fgetint_(flenm);
	 CA.initsubstep1 = fgetboolean_(flenm);
	 CA.initsubstep2 = fgetboolean_(flenm);
	 CA.camax = fgetboolean_(flenm);
         CA.runtype = fgetstrng_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);

      } else if (strng.equals("find_mpemp")) {
         cacalc = true;
	 findmpemp = true;
         Beliefs.loadconsdst = true;
         Intridslve.t0 = fgetdble_(flenm);
         Intridslve.tfinal = fgetdble_(flenm);

         CA.ch = .1;
         Psens.nmsensids = fgetint_(flenm);
         for (i = 0; i < Psens.nmsensids; ++i) {
         
	    // Get ID name and number of nodes to assess within that ID.

            Psens.id[i] = fgetstrng_(flenm);
	    Psens.nmndes[i] = fgetint_(flenm);

	    // Read node names.

	    for (j = 0; j < Psens.nmndes[i]; ++j) {
               Psens.ndenames[i][j] = fgetstrng_(flenm);
	    }
         }
         Beliefs.nmloops = fgetint_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);
         Psens.nmmc = Beliefs.nmloops;

      } else if (strng.equals("cross-validation")) {
         spacetime_begintime = fgetdble_(flenm);
         spacetime_endtime = fgetdble_(flenm);
         spacetime_predoption = fgetint_(flenm);

         if (!temporal) {
            spacetime_begintime = 0.;
            spacetime_endtime = 0.;
            spacetime_predoption = 2;
	 }
         spacetime_option = 7;

      } else if (strng.equals("detect_insider_threat")) {
         Report.detectinsiderthreat = true;
         strng = fgetstrng_(flenm);
         if (strng.equals("true")) {
            ITD.train = true;
         }
         strng = fgetstrng_(flenm);
         if (strng.equals("true")) {
            ITD.checkqueryresult = true;
         }

      } else {
         iderr_("getmodl: strng= " + strng +
            " is not a valid relation for the report qualifier \n     " +
	    reportqualifier);
      }

   } else if (reportqualifier.equals("evaluate")) {
      if (strng.equals("id_interactions")) {
         Intridslve.t0 = fgetdble_(flenm);
         Intridslve.tfinal = fgetdble_(flenm);
         Beliefs.nmloops = fgetint_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);

      } else if (strng.equals("evaluate_nodes")) {
         for (i = 0; i < nmnds; ++i) {
	    varinfo_eval[idnmbrm1][i] = false;
	 }
         nmevalndes = fgetint_(flenm);
         for (i = 0; i < nmevalndes; ++i) {
	    // printf_("getmodl: getndnm_ call 3, i= " + i);
            k = Getmodlutils.getndnm_(fgetstrng_(flenm));
            varinfo_eval[idnmbrm1][k - 1] = true;
         }
         Beliefs.nmloops = fgetint_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);

      } else if (strng.equals("optimal_decision")) {
         optimal_decision = true;
         Beliefs.nmloops = fgetint_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);
 
      } else if (strng.equals("surface")) {
         spacetime_surfvar = Getmodlutils.getndnm_(fgetstrng_(flenm));
         spacetime_surfvar = idtostnm[spacetime_surfvar - 1];

         spacetime_tmin = fgetdble_(flenm);
         spacetime_tmax = fgetdble_(flenm);
         spacetime_begintime = fgetdble_(flenm);
         spacetime_endtime = fgetdble_(flenm);

         spacetime_predoption = fgetint_(flenm);
         spacetime_nmrows = fgetint_(flenm);
         spacetime_nmcols = fgetint_(flenm);

         spacetime_grdtyp = fgetint_(flenm);
	 spatial = true;
         spacetime_option = 8;
	 map = 1;

      } else if (strng.equals("volume")) {
         spacetime_surfvar = Getmodlutils.getndnm_(fgetstrng_(flenm));
         spacetime_surfvar = idtostnm[spacetime_surfvar - 1];

         spacetime_tmin = fgetdble_(flenm);
         spacetime_tmax = fgetdble_(flenm);
         spacetime_begintime = fgetdble_(flenm);
         spacetime_endtime = fgetdble_(flenm);

         spacetime_predoption = fgetint_(flenm);

         spacetime_nmrows = fgetint_(flenm);
         spacetime_nmcols = spacetime_nmrows;

         spacetime_nmmc = fgetint_(flenm);

	 spatial = true;
         spacetime_option = 9;

      } else if (strng.equals("simulate_MOC")) {
         tutor = true;

      } else if (strng.equals("find_author_clusters")) {
         tutor = true;
         PlagDetect.docfle = fgetstrng_(flenm);

      } else if (strng.equals("evaluate_social_network")) {
         cacalc = false;
         evaluatesocialnetwork = true;

      } else {
         iderr_("getmodl: strng= " + strng +
            " is not a valid relation for the report qualifier \n     " +
	    reportqualifier);
      }

   } else if (reportqualifier.equals("display")) {
      if (strng.equals("plot_graph")) {

         // Set the graph drawing switch to "on."

         Pltgrph.draw = true;
	 
	 // Get number of node groups.

	 Pltgrph.nmndegrps = fgetint_(flenm);

	 // Read these groups.

	 for (i = 0; i < Pltgrph.nmndegrps; ++i) {
            Pltgrph.grpsze[i] = (short) fgetint_(flenm);
	    for (j = 0; j < Pltgrph.grpsze[i]; ++j) {
               Pltgrph.grpnde[i][j] = (short) Getmodlutils.getndnm_(
			                 fgetstrng_(flenm));
	    }
         }

      } else if (strng.equals("label_regions")) {
         spacetime_psfle = fgetstrng_(flenm);
	 spatial = true;
         spacetime_option = 11;

      } else if (strng.equals("overlay")) {
	 spacetime_nminfles = fgetint_(flenm);
	 for (i = 0; i < spacetime_nminfles; ++i) {
            spacetime_infle[i] = fgetstrng_(flenm);
            spacetime_surffle[i] = fgetstrng_(flenm);
	 }
         spacetime_psfle = fgetstrng_(flenm);
	 Pltsurf.legtitle = fgetstrng_(flenm);

	 spatial = true;
         spacetime_option = 5;

      } else if (strng.equals("display_intervals")) {
         Pltsurf.nmlevls = fgetint_(flenm);
         for (i = 0; i < Pltsurf.nmlevls; ++i) {
	    Pltsurf.level[i] = fgetdble_(flenm);
	    Pltsurf.level[i + 1] = fgetdble_(flenm);
         }

      } else if (strng.equals("interval_labels")) {
	 Pltsurf.legtitle = fgetstrng_(flenm);
         Pltsurf.nmlevls = fgetint_(flenm);
         for (i = 0; i < Pltsurf.nmlevls; ++i) {
	    Pltsurf.lgndlbl[i] = fgetstrng_(flenm);
         }

      } else if (strng.equals("map_levels")) {
         Pltsurf.nmmaplevels = fgetint_(flenm);
         for (i = 0; i < Pltsurf.nmmaplevels; ++i) {

	    // Throw away label of the map level.

	    fgetstrng_(flenm);

	    Pltsurf.levelsmap[i] = fgetint_(flenm);
         }

      } else if (strng.equals("plot_surface")) {
         spacetime_surffle[0] = fgetstrng_(flenm);
	 spacetime_nminfles = 1;
         spacetime_psfle = fgetstrng_(flenm);
	 spatial = true;
         spacetime_option = 10;

      } else if (strng.equals("plot_actions_history")) {
         Displayactions.plottype = fgetstrng_(flenm);
	 Displayactions.fleformat = fgetstrng_(flenm);
         Displayactions.actnshistfle = fgetstrng_(flenm);
	 Displayactions.flename = fgetstrng_(flenm);
	 Displayactions.minfreq = fgetint_(flenm);
         Displayactions.starttime[0] = fgetdble_(flenm);
         Displayactions.endtime = fgetdble_(flenm);
         Plotutils.use_endy = fgetboolean_(flenm);
         Plotutils.beginy = fgetdble_(flenm);
         Plotutils.endy = fgetdble_(flenm);

      } else if (strng.equals("xyplots")) {
	 Plotutils.beginy = fgetdble_(flenm);
	 Plotutils.endy = fgetdble_(flenm);
	 spatial = false;
         spacetime_option = 12;

      } else {
         iderr_("getmodl: strng= " + strng +
            " is not a valid relation for the report qualifier \n     " +
	    reportqualifier);
      }

   } else if (reportqualifier.equals("sensitivity_analysis")) {
      cacalc = true;
      Beliefs.loadconsdst = true;
      dsensanalysis = true;
      if (strng.equals("assess_nodes")) {
         Intridslve.t0 = fgetdble_(flenm);
         Intridslve.tfinal = fgetdble_(flenm);
         Psens.nmsensids = fgetint_(flenm);
         for (i = 0; i < Psens.nmsensids; ++i) {
         
	    /* Get ID name and number of nodes to assess the
	       sensitivity of within that ID. */

            Psens.id[i] = fgetstrng_(flenm);
	    Psens.nmndes[i] = fgetint_(flenm);

	    // Read node names.

	    for (j = 0; j < Psens.nmndes[i]; ++j) {
               Psens.ndenames[i][j] = fgetstrng_(flenm);
	    }
         }
         Beliefs.nmloops = fgetint_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);
         Psens.nmmc = Beliefs.nmloops;

      } else {
         iderr_("getmodl: strng= " + strng +
            " is not a valid relation for the report qualifier \n     " +
	    reportqualifier);
      }

   } else if (reportqualifier.equals("mc_hypothesis_test")) {
      
      // Monte Carlo hypothesis test.

      cacalc = true;
      Beliefs.loadconsdst = true;
      if (strng.equals("nodes_to_estimate")) {
         Intridslve.t0 = fgetdble_(flenm);
         Intridslve.tfinal = fgetdble_(flenm);

         Psens.nmsensids = fgetint_(flenm);
         for (i = 0; i < Psens.nmsensids; ++i) {
         
	    // Get ID name.

            Psens.id[i] = fgetstrng_(flenm);
            if (nmids == 1) {
	       idname[0] = Psens.id[i];
	    }

	    // Get number of nodes to estimate within that ID.

	    Psens.nmndes[i] = fgetint_(flenm);

	    // Read node names.

	    for (j = 0; j < Psens.nmndes[i]; ++j) {
               Psens.ndenames[i][j] = fgetstrng_(flenm);
	    }
         }
	 CA.ch = fgetdble_(flenm);
         Beliefs.nmloops = fgetint_(flenm);
         Beliefs.nmloops = nmthreads * (Beliefs.nmloops / nmthreads);
      }
   }
}
fclose_(flenm, 'r');

if (gmpflag) {
   printf_("getmodl: done reading id language file.");
}

/* For a single ID and an analysis-type report, either open and read an
   existing network distribution file, or open a new distribution file
   and write uniform conditional distributions for all nodes. */

if (nmids == 1 && (reportqualifier.equals("evaluate") ||
                   reportqualifier.equals("sensitivity_analysis") ||
                   reportqualifier.equals("mc_hypothesis_test") ||
                   reportqualifier.equals("estimate") ||
                   reportqualifier.equals("describe_data"))) {

   if (Readnet.newdst) {
      Readnet.readnet_(dstfle[idnmbrm1][0], flenm, nmnds, 1);
      Writenet.writenet_(1, 1, true);

   } else {

      // Read the hypothesis, and initial consistent distributions.

      Readnet.readnet_(dstfle[idnmbrm1][0], flenm, nmnds, 1);
      Readnet.readnet_(dstfle[idnmbrm1][1], flenm, nmnds, 2);
   }
}

// iderr_("in getmodl");
}
}
