class Getdata extends Surf {
static int quant1order = 0, quant2order = 0, qual1order = 0, qual2order = 0;

static int oorder[] = new int[TNMNDS];
static int ndnms[] = new int[TNMNDS];

// --------------------------------------------------------------------

static int getdata_(String datfile, String names[]) {

/* Reads the data file ("datfile") and eliminates colocated observations
   within a spatio-temporal analysis.  Current version allows only one
   dependent variable per record, 2 or less quantitative explanatory
   variables, and 2 or less qualitative explanatory variables.

   The first several records of the data file are comments as long as
   "comment" is the first word in the record.  The remainder of the data
   file's format consists of set of records as follows:

   independent-variable-name(s) dependent-variable-name
   begin
   record 1
   ...
   record n
   end

   independent-variable-name can be x, Xcoord, Long, y, Ycoord, Lat,
   Time, Quant1, Quant2, (quantitative predictors), Qual1, Qual2
   (qualtitative predictors).
   */

boolean test = true, unique, readstddev = false;

String dumstrng;

int i, j, nmvars = 0, xorder = 0, yorder = 0, zorder = 0, torder = 0,
   nmcols, ndnm, nmreadvar, vrble, regionnde = 0;

double dstmin, val;

fleopen_(5, datfile, 'r');

for (i = 0; i < TNMNDS; ++i) {
   nmobs[idnmbrm1][i] = 0;
}

/* Loop for reading sets of observations, one set for each observed
   stochastic variable.  Note that comments are only allowed at the
   very top of the data file. */

while (fle_ready_(5)) {
   strng = fgetstrng_(5);
   if (strng.equals("comment") || strng.indexOf("#", 0) >= 0) {

      // Read a comment line.

      strng = fgetline_(5);
   
   } else {
      streamTokenizer[4].pushBack();
      break;
   }
}

// Loop for reading per-variable data sets.

nmecoobsttl = 0;
varloop: for (;;) {
   i = 0;
   nmreadvar = 0;

   if (Beliefs.issms) {
      SMScalcs.nmobssteps[nmecoobsttl] = fgetint_(5);
      SMScalcs.subsnmsteps[nmecoobsttl] = SMScalcs.nmobssteps[nmecoobsttl];
      fgetstrng_(5);
      fgetint_(5);
      for (i = 0; i < SMScalcs.nmobssteps[nmecoobsttl]; ++i) {
         SMScalcs.obspath[nmecoobsttl][i][0] = fgetdble_(5);
         SMScalcs.subspath[nmecoobsttl][i][0] =
            SMScalcs.obspath[nmecoobsttl][i][0];

         SMScalcs.obspath[nmecoobsttl][i][1] = fgetdble_(5);
         SMScalcs.subspath[nmecoobsttl][i][1] =
            SMScalcs.obspath[nmecoobsttl][i][1];
      }
      ++nmecoobsttl;

      if (checkeof_(5)) {
         fclose_(5, 'r');
	 SMScalcs.nmanimals = nmecoobsttl;

	 return 1;
      }
      continue;
   }

   // Loop for reading variable names within a data set.

   for (;;) {
      strng = fgetstrng_(5);

      /* Old way of ending the reading of variable names:
      if (streamTokenizer[4].ttype != streamTokenizer[4].TT_WORD) {
	 streamTokenizer[4].pushBack();
         break;
      }
      */

      if (strng.equals("begin")) {

	 /* Break out of the node-name-read loop because the next
	    record will be data. */

	 break;
      }

      ++i;
      ndnm = Getmodlutils.getndnm_(strng);
      if (grph_label[idnmbrm1][ndnm - 1].equals("Xcoord") ||
          grph_label[idnmbrm1][ndnm - 1].equals("x") ||
          grph_label[idnmbrm1][ndnm - 1].equals("Long")) {
         xorder = i;
      
      } else if (grph_label[idnmbrm1][ndnm - 1].equals(regionnode)) {
         xorder = i;
         regionnde = ndnm;

      } else if (grph_label[idnmbrm1][ndnm - 1].equals("Ycoord") ||
                 grph_label[idnmbrm1][ndnm - 1].equals("y") ||
                 grph_label[idnmbrm1][ndnm - 1].equals("Lat")) {
         yorder = i;
      
      } else if (grph_label[idnmbrm1][ndnm - 1].equals("Zcoord") ||
                 grph_label[idnmbrm1][ndnm - 1].equals("z") ||
                 grph_label[idnmbrm1][ndnm - 1].equals("Hght")) {
         zorder = i;
      
      } else if (nodelbls[idnmbrm1][ndnm - 1][0].equals("Time") ||
	 grph_label[idnmbrm1][ndnm - 1].equals("Time") ||
	 grph_label[idnmbrm1][ndnm - 1].equals("t") ||
	 grph_label[idnmbrm1][ndnm - 1].equals("Tme")) {
         temporal = true;
         torder = i;

      } else if (grph_label[idnmbrm1][ndnm - 1].equals("Quant1")) {
         quant1order = i;
     
      } else if (grph_label[idnmbrm1][ndnm - 1].equals("Quant2")) {
         quant2order = i;
      
      } else if (grph_label[idnmbrm1][ndnm - 1].equals("Qual1")) {
         qual1order = i;
      
      } else if (grph_label[idnmbrm1][ndnm - 1].equals("Qual2")) {
         qual2order = i;
      
      } else {

         // Store this dependent node name.

         names[nmvars] = strng;
         oorder[nmreadvar] = i;

         if (parm_mvar > 0) {

            // LOMAP/GLOMAP model: use negative node numbers.

            for (j = 1; j <= parm_mvar; ++j) {
               if (lomapnms[j - 1] == ndnm) {
                  ndnms[nmreadvar] = -j;
                  break;
               }
            }

         } else {
            ndnms[nmreadvar] = ndnm;
         }

         ++nmreadvar;
         if (nmreadvar > 1) {
            iderr_("Current version of id: 1 dependent node per record.");
         }
      
	 // Check for a standard deviation variable to be read.

	 strng = fgetstrng_(5);
         if (strng.equals("STDDEV")) {
	   readstddev = true;

	 } else {
	    readstddev = false;
	    streamTokenizer[4].pushBack();
	 }
      }
   } 
   nmcols = i;
   ndnm = Getmodlutils.getndnm_(names[nmvars]);
   ++nmvars;
   if (nmvars > MAXNMECO) {
      iderr_("getdata: nmvars = MAXNMECO");
   }

   // Loop for reading observations. 

   readvar: for (;;) {
      strng = fgetstrng_(5);

      /* Old way of ending the reading of data on a list of variables:
         Try to read a variable name.  If so, push it back and break
         the readvar loop.  Either way, push back whatever was read.
      if (streamTokenizer[4].ttype == streamTokenizer[4].TT_WORD) {
	 streamTokenizer[4].pushBack();
         break;
      }
      */

      if (strng.equals("end")) {
         break;
      }

      streamTokenizer[4].pushBack();

      // Read values and assign variable number.

      for (i = 1; i <= nmcols; ++i) {
         if (i == xorder) {
            if (regionnde == 0) {
	       dat2_x[nmecoobsttl] = fgetdble_(5);
            
	    } else {
	       
	       /* Read a region label and trim its front and back of
		  whitespace and convert it to lowercase before looking
		  up its value. */

               dumstrng = fgetstrng_(5).toLowerCase();
	       dat2_x[nmecoobsttl] = (double)
		  Getmodlutils.getndval_(regionnde, dumstrng.trim(), true); 
               if (dat2_x[nmecoobsttl] <= 0.) {
                  iderr_("getdata: dat2_x read failure");
               }
            }

         } else if (i == yorder) {
            dat2_y[nmecoobsttl] = fgetdble_(5);
         
         } else if (i == zorder) {
            dat2_z[nmecoobsttl] = fgetdble_(5);
         
         } else if (i == torder) {
            dat2_t[nmecoobsttl] = fgetdble_(5);
         
         } else if (i == quant1order) {
            dat2_quantval[nmecoobsttl][0] = fgetdble_(5);
         
         } else if (i == quant2order) {
            dat2_quantval[nmecoobsttl][1] = fgetdble_(5);
         
         } else if (i == qual1order) {
            dat2_qualval[nmecoobsttl][0] = (int) fgetdble_(5);
         
         } else if (i == qual2order) {
            dat2_qualval[nmecoobsttl][1] = (int) fgetdble_(5);
         
         } else {
            for (j = 0; j < nmreadvar; ++j) {
               if (i == oorder[j]) {
                  
		  /* Why did I have the following line:
		  if (!client) dat2_dat[nmecoobsttl] = fgetdble_(5);
		  instead of the unconditional read, below?  I think
		  it was something to do with the MC-Hess problem. */
		  
		  dat2_dat[nmecoobsttl] = fgetdble_(5);

                  if (readstddev) {
		     dat2_stddev[nmecoobsttl] = fgetdble_(5);
		  }

		  /* Place non-LOMAP/GLOMAP numbers in the first
		     row of the "dat2_vrble" array.
		     NOTE: LOMAP/GLOMAP numbers are NOT ID node
			   numbers, they instead, sequentially
			   index just those variables are either
			   of type LOMAP or typ GLOMAP. */

		  if (ndnms[j] > 0) {
		     dat2_vrble[0][nmecoobsttl] = ndnms[j];

		  } else {
                     dat2_vrble[1][nmecoobsttl] = -ndnms[j];
		  }
               }
            }
         }
      }

      // Update number-of-observations counters.

      ++nmobs[idnmbrm1][ndnm - 1];
      ++nmecoobsttl;
      if (nmecoobsttl - 1 > DATSZE) {
         iderr_("getdata: current nmecoobsttl= " + nmecoobsttl +
            " > DATSZE= " + DATSZE);
      }

      if (spacetime_option > 0 && spatial) {

         /* For a spatio-temporal analysis, only accept observations that
            are within the boundary and within the box defined by xmin,
            xmax, ymin, ymax, tmin, tmax. */

         dstmin = Surf.bdry_(bdry_nmbdpts[0], bdry_xbdry[0], bdry_ybdry[0],
                             dat2_x[nmecoobsttl - 1], dat2_y[nmecoobsttl - 1]);

         if ((dstmin < 0. && (spacetime_option < 7 ||
              spacetime_option > 9))

             || (dat2_x[nmecoobsttl - 1] < spacetime_xmin ||
                 dat2_x[nmecoobsttl - 1] > spacetime_xmax)

             || (dat2_y[nmecoobsttl - 1] < spacetime_ymin ||
                 dat2_y[nmecoobsttl - 1] > spacetime_ymax)

             || (dat2_t[nmecoobsttl - 1] < spacetime_tmin ||
                 dat2_t[nmecoobsttl - 1] > spacetime_tmax)) {

            if (test) {
               printf_("getdata: tmin= " + spacetime_tmin + " t= " +
                  dat2_t[nmecoobsttl - 1] + " tmax= " + spacetime_tmax +
	          " dstmin= " + dstmin);
               printf_("getdata: xmin= " + spacetime_xmin + " x= " +
                  dat2_x[nmecoobsttl - 1] + " xmax= " + spacetime_xmax);
               printf_("getdata: ymin= " + spacetime_ymin + " y= " +
                  dat2_y[nmecoobsttl - 1] + " ymax= " + spacetime_ymax);
            }
            --nmobs[idnmbrm1][ndnm - 1];
            --nmecoobsttl;
            continue readvar;
         }

         // Also for a spatio-temporal analysis, eliminate co-located sites.

         for (i = 0; i < nmecoobsttl - 1; ++i) {
            if (Math.abs(dat2_x[i] - dat2_x[nmecoobsttl - 1]) < 1.e-6 &&
                Math.abs(dat2_y[i] - dat2_y[nmecoobsttl - 1]) < 1.e-6 &&
                Math.abs(dat2_t[i] - dat2_t[nmecoobsttl - 1]) < 1.e-6 &&
                dat2_vrble[1][i] == dat2_vrble[1][nmecoobsttl - 1]) {

               printf_("getdata: colocated points: "
		  + "\n   i= " + (i + 1) + ", x= " + dat2_x[nmecoobsttl - 1]
                  + " y= " + dat2_y[nmecoobsttl - 1]
                  + " LOMAP/GLOMAP variable= " + dat2_vrble[1][nmecoobsttl - 1]
		  + "\n   nmecoobsttl= " + nmecoobsttl + ", x= "
		  + dat2_x[nmecoobsttl - 1] + " y= " + dat2_y[nmecoobsttl - 1]
                  + " LOMAP/GLOMAP variable= " 
		  + dat2_vrble[1][nmecoobsttl - 1]);

               --nmobs[idnmbrm1][ndnm - 1];
               --nmecoobsttl;
               break;
            }
         }
      }

      if (temporal && nmids == 1) {

         // Only accept observations within the time window.

         if (dat2_t[nmecoobsttl - 1] < spacetime_tmin ||
            spacetime_tmax < dat2_t[nmecoobsttl - 1]) {
            --nmobs[idnmbrm1][ndnm - 1];
            --nmecoobsttl;
            continue readvar;
         }
      }

      // Store unique time values.

      unique = true;
      for (i = 0; i < nmdattimes; ++i) {
         if (Math.abs(dat2_t[nmecoobsttl - 1] - dattimes[i]) < 1.e-20) {
            unique = false;
         }
      }
      if (unique || nmecoobsttl == 1) {
         if (nmdattimes >= MAXTIMES) {
            iderr_("getdata: nmdattimes= " + nmdattimes +
               " > MAXTIMES= " + MAXTIMES);
         }
         dattimes[nmdattimes] = dat2_t[nmecoobsttl - 1];
         ++nmdattimes;
      }

      if (spatial) {

         // Store unique site locations for this variable.

         vrble = dat2_vrble[1][nmecoobsttl - 1];
         unique = true;
         for (i = 0; i < nmsites[vrble - 1]; ++i) {
            if (Math.abs(dat2_x[nmecoobsttl - 1] - xvals[vrble - 1][i])
                < 1.e-20 &&
                Math.abs(dat2_y[nmecoobsttl - 1] - yvals[vrble - 1][i])
                < 1.e-20) unique = false;
         }
         if (unique || nmecoobsttl == 1) {
            xvals[vrble - 1][nmsites[vrble - 1]] = dat2_x[nmecoobsttl - 1];
            yvals[vrble - 1][nmsites[vrble - 1]] = dat2_y[nmecoobsttl - 1];
            ++nmsites[vrble - 1];
         }
      }
   } // End of readvar loop.

   // Check for end of file if so, break varloop.

   if (checkeof_(5)) {
      if (nmobs[idnmbrm1][ndnm - 1] == 0) {
	 iderr_("getdata: ndnm= " + ndnm + " n=0");
      }
      break;
   } 
} // End of varloop loop.
fclose_(5, 'r');

if (spatial) {

   // Write a file of all unique site locations on LOMAP/GLOMAP variable 1.

   fleopen_(8, "sites.dat", 'w');
   for (i = 0; i < nmsites[0]; ++i) {
      fprintf_(8, xvals[0][i] + " " + yvals[0][i]);
   }
   fclose_(8, 'w');
}

return nmvars;
}
}
