class Gama3 extends Surf {
static double dx, dy, pt, realnd1, realnd2; 
static int lagstr_slagnm[][] = new int[WLSSZE2][WLSSZE2];
static int lagstr_tlagnm[][] = new int[WLSSZE2][WLSSZE2];
static int lagstr_cvstrct[][] = new int[WLSSZE2][WLSSZE2];

// ---------------------------------------------------------------------

static int gama3_(int ndi, double alp[], double da, int mode,
   double tolt, boolean test, boolean start) {

/* See pg.224, Journel (1978).  Semi-variogram in two dimensions, irregular
   grid.  There may be missing data, calculation is by angle and distance
   class.

   Parameters:
   dat(nd,i)        data array
   x(nd), y(nd)     x and y coordinates of points
   nd               number of points
   kmax             maximum number of computation lags
   parm_mvar           number of variables, if 2, find the cross-variogram.
   pas              length of basic lag
   tol              width of distance class.  if tol=0, tol=pas/2 is used. 
   ndi              number of directions
   alp(ndi)         angles defining directions (with respect to x axis
                    in degrees)
   da               width of angle class.  if da=0, da=45 is used 
   u                average (total) of data set
   smplvr[k-1]      sample variance of variable k, k=3 is cross-variogram
   n                number of data values (used in u, variance-covariances)
   Capacities:      LGDIM lags.

  Dimensions of g, nc, and d are [lag][direction][time][variable].  The
  parm_mvar+1 variable is the cross-covariance, parm_mvar+2 the even
  component of the cross-covariance, and parm_mvar+3 the odd component
  of the cross-covariance. */

boolean ddflag, direct;

int i, ii, iii, it, j, k, prtfreq, cvstrct, nd1, nd2, tlags, nmvals, vnmbr,
   stnmi, stnmk;

double h, tdst, lows, highs, lowt, hight, avecp, nmclass, rnmobs, lowestt;

// Initialize.

ddflag = false;

for (i = 0; i < ndi; ++i) {
   for (j = 0; j <= kmax; ++j) {
      for (k = 0; k <= 2 * kmaxt; ++k) {
	 for (ii = 0; ii < nmmdls; ++ii) {
            gama_g[j][i][k][ii] = 0.;
	    if (start) {
               gama_d[j][i][k][ii] = 0.;
               gama_nc[j][i][k][ii] = 0;
	    }
	 }
      }
   }
}
if (tol <= 0.) {
   tol = pas / 2.;
}

if (tolt <= 0.) {
   iderr_("gama3: tolt= " + tolt);
}

// Calculate means and variances for each variable.

for (i = 0; i < parm_mvar; ++i) {
   varmod_mean[i] = 0.;
   varmod_smplvr[i] = 0.;
}

if (nd == 0) iderr_("gama3: No data");

for (i = 0; i < nd; ++i) {
   vnmbr = idtostnm[vardat_vrble[i] - 1];
   varmod_mean[vnmbr - 1] += vardat_dat[i];
   varmod_smplvr[vnmbr - 1] += vardat_dat[i] * vardat_dat[i];
}

for (i = 0; i < parm_mvar; ++i) {
   rnmobs = nmcylobs[i];
   varmod_smplvr[i] = (varmod_smplvr[i]
      - (varmod_mean[i] * varmod_mean[i] / rnmobs)) /
                          (rnmobs - 1.);
   varmod_mean[i] /= rnmobs;
}

// Check for zero variance on each variable.

for (i = 0; i < parm_mvar; ++i) {
   if (varmod_smplvr[i] <  1.e-12) {
      printf_("gama3: sample variance(" + (i + 1) + ")= " +
         varmod_smplvr[i] + ", sample covariogram not computed.");
/*
      printf_("nd1=%d, nd2=%d, Variable 1 data:\n",nd1,nd2);
      for (i=0; i < nd; ++i) {
         if (vardat_vrble[i] == 1) printf_("%lf\n",vardat_dat[i]);
      }
*/
      return 1;
   }
}

/* If only an isotropic sample variogram is needed, do fast, minimal
   calculations. */

if (ndi == 1) {

   /* Compute each couple distance and squared difference. */

   prtfreq = 0;
   for (i = 1; i < nd; ++i) {
      ++prtfreq;
      if (prtfreq > 200) {
         // printf_("Starting data point " + i);
         prtfreq = 0;
      }

      next: for (k = 0; k < i; ++k) {

         stnmi = idtostnm[vardat_vrble[i] - 1];
         stnmk = idtostnm[vardat_vrble[k] - 1];

	 if (start) {

            lagstr_slagnm[i][k] = -1;
            lagstr_tlagnm[i][k] = -1;

	    // Find covariance structure.

	    if (vardat_vrble[i] == vardat_vrble[k]) {
               direct = true;
	       cvstrct = stnmi;
	    
	    } else {
               direct = false;
	       cvstrct = crossmap[stnmi - 1][stnmk - 1];
            }

	    // Sample semi-variogram or sample covariogram.

	    if (direct) {
	       pt = vardat_dat[i] - vardat_dat[k];
	       pt *= pt; 

	    } else {
	       pt = (vardat_dat[i] - varmod_mean[stnmi - 1]) *
		    (vardat_dat[k] - varmod_mean[stnmk - 1]);
	    }

	    // Compute distance and gamma.

            dx = vardat_x[i] - vardat_x[k];
	    dy = vardat_y[i] - vardat_y[k];
	    h = Math.sqrt(dx * dx + dy * dy);
	    tdst = vardat_t[i] - vardat_t[k];
            if (direct) tdst = Math.abs(tdst);

	    // Find lag that couple belongs to.

	    if (direct) {
	       tlags = kmaxt;
	       lowestt = 0.; 

	    } else {
	       tlags = 2 * kmaxt;
               if (!temporal) lowestt = 0.;
	       else lowestt = -1. * past * ((double) kmaxt);
	    }
            for (it = 0; it <= tlags; ++it) {
	       lowt = lowestt + (past * (double) it) - tolt;
	       hight = lowestt + (past * (double) it) + tolt;

               for (j = 0; j <= kmax; ++j) {
		  if (j == 0) {
		     lows = 0.;
		     highs = 0.5 * pas;
	          
		  } else {
		     lows = (pas * ((double) j)) - tol;
		     highs = (pas * ((double) j)) + tol;
		  }

	          if (lows <= h    && h < highs &&
	              lowt <= tdst && tdst < hight) {
	             ++gama_nc[j][0][it][cvstrct - 1];
	             gama_d[j][0][it][cvstrct - 1] += h;
	             gama_g[j][0][it][cvstrct - 1] += pt;

		     lagstr_slagnm[i][k] = j;
		     lagstr_tlagnm[i][k] = it;
		     lagstr_cvstrct[i][k] = cvstrct;

		     continue next;
	          }
               }
            }

	 } else if (!start) {
	    j = lagstr_slagnm[i][k];
	    it = lagstr_tlagnm[i][k];
	    if (j == -1 || it == -1) {
	       continue next;
            }

	    cvstrct = lagstr_cvstrct[i][k];
            if (vardat_vrble[i] == vardat_vrble[k]) {
	       direct = true;
            
	    } else {
	       direct = false;
            }

	    // Sample semi-variogram or sample covariogram.

	    if (direct) {
	       pt = vardat_dat[i] - vardat_dat[k];
	       pt *= pt; 

	    } else {
	       pt = (vardat_dat[i] - varmod_mean[stnmi - 1])
		    * (vardat_dat[k] - varmod_mean[stnmk - 1]);
	    }
	    gama_g[j][0][it][cvstrct - 1] += pt;
	 }
      }
   }
}

// Results.

if (ddflag) {
   iderr_("gama3: ddflag=true.");
}

// Find average gamma values and lags.
 
for (i = 0; i < ndi; ++i) {
   for (ii = 0; ii < nmmdls; ++ii) {
      nmvals = 0;
      varmod_avegam2[ii] = 0.;
      for (j = 0; j <= kmax; ++j) {

	 if (ii < parm_mvar) tlags = kmaxt;
	 else tlags = 2 * kmaxt;

         for (k = 0; k <= tlags; ++k) {

	    // Set missing value indicator if no couples.

            if (gama_nc[j][i][k][ii] == 0) {
               gama_d[j][i][k][ii] = -1.e30;
               gama_g[j][i][k][ii] = -1.e30;

	    } else {
               if (start) gama_d[j][i][k][ii]
				      /= (double) gama_nc[j][i][k][ii];
               if (ii < parm_mvar) {
		  gama_g[j][i][k][ii] /= (double) (2 * gama_nc[j][i][k][ii]);
	    
	       } else if (ii >= parm_mvar) {

	          /* Pseudo-cross-variogram of Clark et al.
	          meandif = mean[0] - mean[1];
	          gama_g[j][i][k][ii] -= .5 * (meandif * meandif);
                  */

	          // Sample cross-covariogram.

	          gama_g[j][i][k][ii] /= (double) gama_nc[j][i][k][ii];
	       }

	       // Compute average of all gama values for this model.

	       varmod_avegam2[ii] += gama_g[j][i][k][ii] *
				     gama_g[j][i][k][ii];
	       ++nmvals;
	    } // End of valid-data if-statement.
	 } // End of temporal lag loop.
      } // End of spatial lag loop.

      varmod_avegam2[ii] /= (double) nmvals;

   } // End of nmmdls loop.
} // End of anisotropy direction loop.

if (temporal) {

   // Compute even and odd terms of cross-covariograms.

   for (k = parm_mvar; k < nmmdls; ++k) {
      tlags = 2 * kmaxt;
      for (i = 0; i <= tlags; ++i) {
         j = tlags - i;
         gama_geven[0][0][i][k] = .5 * (gama_g[0][0][i][k] +
                                        gama_g[0][0][j][k]);
         gama_godd[0][0][i][k] = .5 * (gama_g[0][0][i][k] -
                                       gama_g[0][0][j][k]);
      }
   }
}

/* Use large lag gamma values to estimate sample variance.
if (spatial && temporal) {
   for (i = 0; i < parm_mvar; ++i) {
      varmod_smplvr[i] = .25 * (gama_g[kmax - 1][0][kmaxt][i] +
			        gama_g[kmax - 1][0][kmaxt - 1][i] +
			        gama_g[kmax - 2][0][kmaxt - 1][i] +
			        gama_g[kmax - 2][0][kmaxt][i]);
   }
} */

// Optionally, write means, variances and empirical covariograms.

if (mode == 1 || test) {
   fprintf_(1, "gama3: Sample size= " + nd);
   fprintf_(1, "gama3: Variable    Mean    Sample Variance");
   for (i = 0; i < parm_mvar; ++i) {
      fprintf_(1, "        " + (i + 1) + "      " +
         fdble_(varmod_mean[i], 9, 5) + "      " +
         fdble_(varmod_smplvr[i], 9, 5));
   }
   Covmodl.covprt_(0);
}

return 0;
}
}
