import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class GISwind extends Frame {

// Class for the main frame window.

/* These static integers are needed in the Dimension statements in
   the window's constructor. */

static final int TEXTROWS = 25, TEXTROWHGHT = 23;
static int mainwinhght = TEXTROWS * TEXTROWHGHT,
   mainwinwdth = 600; // was 480
final int NMTEXTROWS = TEXTROWS;
static final int MAXNMPTS = 500;
static final int MAXNMPXLS = 5000;
static final int MAXNMBANDS = 4;
static final int MAXNMOBJCTS = 20000;

boolean graphdrawn = false, readytoref = false, trnsfrmfound = false,
   digitizepath = false, digitizesurface = false;

static String pointfle;
static String animalfle[][] = new String[2][4];

String msg = " ", keymsg = "", mousemsg = "";

String textarray[] = new String[NMTEXTROWS];

int mouseX = 30, mouseY = 30, textlinenm = 1, nmpathpts, nmrows = 100,
   nmcols = 100;

static int nmrefpts = 0;
double xtrans, xscale, ytrans, yscale, xdum, ydum, surfval = 1.;

double vrhs[] = new double[4];
double strtmat[][] = new double[4][4];
double hjvar[] = new double[4];
double vsol[] = new double[4];

static double longref[] = new double[20];
static double latref[] = new double[20];
static double xref[] = new double[20];
static double yref[] = new double[20];

double pathlng[] = new double[MAXNMPTS];
double pathlat[] = new double[MAXNMPTS];

double collngval[] = new double[100];
double rowlatval[] = new double[100];
double level[][] = new double[100][100];

CheckboxMenuItem debug, test;

// ---------------------------------------------------------------------

public GISwind() {
int i;
addKeyListener(new MyKeyAdapter(this));
addMouseListener(new MyMouseAdapter(this));

// Create an object to handle window events.

MyWindowAdapter adapter = new MyWindowAdapter(this);

// Register it to receive those events.

addWindowListener(adapter);

// Create menu bar and add it to frame.

MenuBar mbar = new MenuBar();
setMenuBar(mbar);

// Create the menu items.

Menu fle = new Menu("File");
MenuItem item1, item2, item3, item4;
fle.add(item1 = new MenuItem("New..."));
fle.add(item2 = new MenuItem("Open an image file"));
fle.add(item3 = new MenuItem("-"));
fle.add(item4 = new MenuItem("Quit..."));
mbar.add(fle);

// GIS tools menu.

Menu tools = new Menu("Tools");

Menu digsub = new Menu("Perform on-screen digitizing");
MenuItem item5, item6, item7, item8, item9;
digsub.add(item5 = new MenuItem("Enter a new reference point set"));
digsub.add(item6 = new MenuItem("Digitize a single reference point"));
digsub.add(item7 = new MenuItem("Start digitizing a new path"));
digsub.add(item8 = new MenuItem("Start digitizing a new surface level"));
digsub.add(item9 = new MenuItem("Close a digitized path or surface"));
tools.add(digsub);

MenuItem item10;
tools.add(item10 = new MenuItem("Count animals in an image"));

mbar.add(tools);

// Option assessment menu selections.

Menu assess = new Menu("Assess");
MenuItem item11;
assess.add(item11 = new MenuItem("Compute impacts of options"));
mbar.add(assess);

// Help and About box.

Menu helpabout = new Menu("Help");
MenuItem item12, item13;
helpabout.add(item12 = new MenuItem("Help"));
helpabout.add(item13 = new MenuItem("About"));
mbar.add(helpabout);

// Create an object to handle action and item events.

MyMenuHandler handler = new MyMenuHandler(this);

// Register it to receive those events.

item1.addActionListener(handler);
item2.addActionListener(handler);
item3.addActionListener(handler);
item4.addActionListener(handler);
item5.addActionListener(handler);
item6.addActionListener(handler);
item7.addActionListener(handler);
item8.addActionListener(handler);
item9.addActionListener(handler);
item10.addActionListener(handler);
item11.addActionListener(handler);
item12.addActionListener(handler);
item13.addActionListener(handler);

// Set font, background and foreground colors.

Font f = new Font("SansSerif", Font.PLAIN, 14);
setFont(f);
setBackground(Color.white);
setForeground(Color.black);

// Initialize text array.

for (i = 0; i < NMTEXTROWS; ++i) {
   textarray[i] = " ";
}
}

// ----------------------------------------------------------------------

public void textline_(String line) {

// Load text array with the string "line."

int i;

if (textlinenm < NMTEXTROWS - 2) {
   ++textlinenm;
   textarray[textlinenm - 1] = line;

} else {

   // Ratchet lines in the text array.

   for (i = 0; i < NMTEXTROWS - 3; ++i) {
      textarray[i] = textarray[i + 1];
   }
   textarray[NMTEXTROWS - 3] = line;
}
}

// ----------------------------------------------------------------------

public void paint(Graphics g) {
int i, yinc = 20, ypos = 50;

// Write command message line.

g.drawString("Command message:", 5, mainwinhght - 2 * TEXTROWHGHT);
g.drawString(msg, 5, mainwinhght - TEXTROWHGHT);

// Write multi-line text output.

for (i = 0; i < NMTEXTROWS - 2; ++i){
   g.drawString(textarray[i], 6, ypos);
   ypos += yinc;
}
}

// -----------------------------------------------------------------------

public static void giswindow_() {

// Create an interactive GIS window.

GISwind appwin = new GISwind();

appwin.setSize(new Dimension(mainwinwdth, mainwinhght));
appwin.setTitle("GIS Tools");

if (GISutils.nmflesperimage > 0) {
   GISutils.abundest_(appwin, animalfle);

   return;
}

/* Make main window visible. NOTE: "setVisible" returns immediately.
   The only way to keep the window alive is to make sure there is
   no execution of the method "System.exit(0)" in wherever "giswindow"
   returns to -- all the way up the daisy chain of calling methods to
   the "main()" method. */

appwin.setVisible(true);

}

// -----------------------------------------------------------------------

public void updatepath_() {

// Add this point to the current path.

if (nmpathpts == MAXNMPTS) {
   Run_id.iderr_("updatepath: nmpathpts= " + nmpathpts);
}

if (!trnsfrmfound) {
   msg = "No transformation, point not digitized";
   repaint();
   return;
}

pathlng[nmpathpts] = xtrans + xscale * xdum;
pathlat[nmpathpts] = ytrans + yscale * ydum;

textline_("long= " + pathlng[nmpathpts]);
textline_("lat= " + pathlat[nmpathpts]);

++nmpathpts;
}

// -----------------------------------------------------------------------

public void updatesurface_() {

// Add this point to the current surface.

int i, j, row = -1, col = -1;

double lngval, latval, lngdiff, latdiff, dist, mindist;

/* Find the closest grid point and add it to the grid point list that
   defines this surface. */

lngval = xtrans + xscale * xdum;
latval = ytrans + yscale * ydum;
mindist = 1.e30;
for (i = 0; i < nmrows; ++i) {
   for (j = 0; j < nmcols; ++j) {
      lngdiff = collngval[j] - lngval;
      latdiff = rowlatval[i] - latval;
      dist = Math.sqrt(lngdiff * lngdiff + latdiff * latdiff);

      if (dist < mindist) {
	 row = i;
	 col = j;
	 mindist = dist;
      }
   }
}
level[row][col] = surfval;

}

// -----------------------------------------------------------------------

public void closepath_() {

/* Write the file of digitized points.  Future improvement: get the
   region name from the user and write that instead of "Region_name,"
   below.  With this improvement, a user would only have to "cat"
   together multiple files written by this routine and then optionally,
   use "vi" to remove the ^M values from each record. */

int i;

Run_id.fleopen_(6, "path.lgt", 'w');
Run_id.fprintf_(6, nmpathpts + " " + "Region_name");
for (i = 0; i < nmpathpts; ++i) {
   Run_id.fprintf_(6, pathlng[i] + " " + pathlat[i]);
}
Run_id.fclose_(6, 'w');

}

// -----------------------------------------------------------------------

public void closesurface_() {

// Finish digitizing a surface by writing a surface file.

int i, j;

Run_id.fleopen_(6, "surface.sgd", 'w');

// Write each grid point and its "level" value.

Run_id.fprintf_(6, "Discrete-valued Surface" + "\n " + nmrows + " " +
   nmcols);

for (i = 0; i < nmrows; ++i) {
   for (j = 0; j < nmcols; ++j) {
      Run_id.fprintf_(6, " " + i + " " + j + " " + collngval[j] + " " +
	 rowlatval[i] + "   " + level[i][j]);
   }
}

Run_id.fclose_(6, 'w');

}

// -----------------------------------------------------------------------

public void findtrnsfrm_() {

/* Finds the best translate-and-scale transformation given a set of
   reference points. */

int i;

if (nmrefpts < 2) {
   Run_id.iderr_("findtrnsfrm: nmrefpts= " + nmrefpts);
}

textline_(" findtrnsfrm output");
textline_("i longref    xref    latref   yref");
for (i = 0; i < nmrefpts; ++i) {
   textline_(i + " " + longref[i] + " " + xref[i] + " " +
      latref[i] + " " + yref[i]);
}

// Use the first two reference points to get starting values.

strtmat[0][0] = 1.;
strtmat[0][1] = xref[0];
strtmat[0][2] = 0.;
strtmat[0][3] = 0.;

strtmat[1][0] = 1.;
strtmat[1][1] = xref[1];
strtmat[1][2] = 0.;
strtmat[1][3] = 0.;

strtmat[2][0] = 0.;
strtmat[2][1] = 0.;
strtmat[2][2] = 1.;
strtmat[2][3] = yref[0];

strtmat[3][0] = 0.;
strtmat[3][1] = 0.;
strtmat[3][2] = 1.;
strtmat[3][3] = yref[1];

vrhs[0] = longref[0];
vrhs[1] = longref[1];
vrhs[2] = latref[0];
vrhs[3] = latref[1];

Matrix.slvl_(strtmat, vsol, vrhs, 4);

xtrans = vsol[0];
xscale = vsol[1];
ytrans = vsol[2];
yscale = vsol[3];

textline_("2-point: xtrans= " + xtrans + " ytrans= " + ytrans);
textline_("         xscale= " + xscale + " yscale= " + yscale);

if (nmrefpts == 2) {
   return;
}

/* Now use Hooke-Jeeves to refine this transformation to honor all
   reference points as closely as possible. */

hjvar[0] = xtrans;
hjvar[1] = xscale;
hjvar[2] = ytrans;
hjvar[3] = yscale;

Optimiz.fnm = 10;
Optimiz.n = 4;
Optimiz.ci = 0;
for (i = 0; i < Optimiz.n; ++i) {
   Pxp.vartype[i] = "Continuous";
   Optimiz.g[i] = -1.e6;
   Optimiz.h[i] = 1.e6;
}

textline_("findtrnsfrm: before hooke");

Hooke.hooke_(hjvar, vsol, Optimiz.rhohooke, Optimiz.epsilon,
   Optimiz.maxhookeiter, true);

xtrans = vsol[0];
xscale = vsol[1];
ytrans = vsol[2];
yscale = vsol[3];

textline_("final: xtrans= " + xtrans + " ytrans= " + ytrans);
textline_("       xscale= " + xscale + " yscale= " + yscale);

trnsfrmfound = true;
}

// ---------------------------------------------------------------------

static double totalerror_(int n, double x[]) {

/* Computes the sum of the location errors between the reference points
   and the transformed reference points.  Do this by transforming each
   (xref, yref) point into (longitude, latitude) and computing the
   error between the transformed (longitude, latitude) point and the
   reference longitude, latitude point, (longref, latref). */

int i;

double longtry, lattry, retval = 0.;

for (i = 0; i < nmrefpts; ++i) {
   longtry = x[0] + xref[i] * x[1];
   lattry = x[2] + yref[i] * x[3];
   retval += Math.abs(longref[i] - longtry) + Math.abs(latref[i] - lattry);
}

Run_id.printf_("totalerror: xt= " + x[0] + " xs= " + x[1] +
   "\n   yt= " + x[2] + " ys= " + x[3] + " error= " + retval);

return retval;
}
}

// ***********************************************************************

class MyKeyAdapter extends KeyAdapter {
GISwind appWindow;
public MyKeyAdapter(GISwind appWindow) {
this.appWindow = appWindow;
}

// -----------------------------------------------------------------------

public void keyTyped(KeyEvent ke) {
appWindow.keymsg += ke.getKeyChar();
appWindow.repaint();
};
}

// ***********************************************************************

class MyWindowAdapter extends WindowAdapter {
GISwind appWindow;
public MyWindowAdapter(GISwind appWindow) {
this.appWindow = appWindow;
}

// -----------------------------------------------------------------------

public void windowClosing(WindowEvent we) {
System.exit(0);
}
}

// **********************************************************************

class MyMouseAdapter extends MouseAdapter {
GISwind appWindow;
public MyMouseAdapter(GISwind appWindow) {
this.appWindow = appWindow;
}

// -----------------------------------------------------------------------

public void mousePressed(MouseEvent me) {
appWindow.mouseX = me.getX();
appWindow.mouseY = me.getY();
appWindow.mousemsg = "giswind: Mouse Down at " + appWindow.mouseX +
   ", " + appWindow.mouseY;
appWindow.repaint();
}
}

// *********************************************************************

class MyMenuHandler extends Dialog implements ActionListener,
   ItemListener {
GISwind giswind;
Plotimage plotimage;

int condnode = 0;

// ---------------------------------------------------------------------

public MyMenuHandler(GISwind giswind) {
super(giswind, "menu handler");
this.giswind = giswind;

// Create a Netcalcs object.
// Netcalcs netcalcs = new Netcalcs (decnet, "netcalcs");
}

// --------------------------------------------------------------------

public void actionPerformed (ActionEvent ae) {

// Handle action events.

String arg = (String) ae.getActionCommand();
String imageflename = "unknown", pointdir = "c:\\polbio\\";

int i, j, k, l, m, yinc = 20, ypos = 50;

double increment, minlng, maxlng, minlat, maxlat;

FileDialog fdpoint; // "fd" stands for "File Dialog."

Helpwindow helpwindow;

if (arg.equals("New...")) {

   giswind.msg = "You selected New.";

} else if (arg.equals("Open an image file")) {

   /* Future improvement: as long as the image loads in exactly the
      same place, you could save each image's transformation constants
      and load that transformation when you open the associated
      image.  This would make it easy to digitize a line across multiple
      images as you would need to do if you used a small scanner to scan
      a large map. */

   do {
      fdpoint = new FileDialog(giswind, "Open an Existing Image File",
         FileDialog.LOAD);
      fdpoint.setVisible(true);
      imageflename = fdpoint.getDirectory() + fdpoint.getFile();
   } while (imageflename == null);
   giswind.msg = "Opened the existing image file: " + imageflename;

   // Display image.

   plotimage = new Plotimage(giswind, imageflename,
      "Image to be digitized");
   plotimage.setSize(1200,900);

   // plotimage.setSize(new Dimension(mainwinwdth, mainwinhght));

   /*
   ScrollPane pane = new ScrollPane();
   pane.setSize(300, 300);
   pane.add(plotimage);
   */

   plotimage.setVisible(true);

   // Fix the directory within which the point file will be written.

   pointdir = fdpoint.getDirectory();
   GISwind.pointfle = fdpoint.getDirectory() + GISwind.pointfle;

} else if (arg.equals("Quit...")) {
   giswind.msg = "You selected Quit.";
   System.exit(0);

} else if (arg.equals("Enter a new reference point set")) {
   giswind.nmrefpts = 0;
   giswind.trnsfrmfound = false;

} else if (arg.equals("Digitize a single reference point")) {
   giswind.digitizepath = false;

   if (imageflename == null) {
      giswind.msg = "Please open an image file to be digitized";
   
   } else {
      if (giswind.readytoref) {

	 // Open a dialog box to receive coordinates of the entered point.

	 Enterrefwind enterrefwind = new Enterrefwind(giswind,
	    "Enter Coordinates of Digitized Point", giswind.xdum,
	    giswind.ydum);

	 enterrefwind.setVisible(true);
   
	 // Check for a correctly entered reference point.

	 if (giswind.longref[giswind.nmrefpts] < 360. &&
	     giswind.latref[giswind.nmrefpts] < 360.) {
	    ++giswind.nmrefpts;
	 }

         giswind.textline_("giswind: nmrefpts= " + giswind.nmrefpts);
         giswind.readytoref = false;
         giswind.repaint();

      } else {
	 giswind.msg = "First, mouse-digitize a reference point in the" +
	    " image window.";
         giswind.repaint();
      }
   }

} else if (arg.equals("Start digitizing a new path")) {
   if (giswind.nmrefpts == 0) {
      giswind.msg = "Please enter reference points first.";

   } else {
      if (!giswind.trnsfrmfound) {
         giswind.findtrnsfrm_();
      }
      giswind.msg = "Click on image to digitize a path point.";
      giswind.repaint();

      giswind.digitizesurface = false;
      giswind.digitizepath = true;
      giswind.nmpathpts = 0;
   }

} else if (arg.equals("Start digitizing a new surface level")) {
   if (giswind.nmrefpts == 0) {
      giswind.msg = "Please enter reference points first.";

   } else {
      if (!giswind.trnsfrmfound) {
         giswind.findtrnsfrm_();
      }
      giswind.msg = "Click on image grid points to digitize a surface.";
      giswind.repaint();

      giswind.digitizepath = false;
      giswind.digitizesurface = true;

      // Use a Dialog Box to get the surface value.

      Entersvalwind entersvalwind = new Entersvalwind(giswind,
         "Surface Value Entry");

      entersvalwind.setVisible(true);
   
      // Draw a longitude-latitude grid on the image.

      minlng = giswind.xtrans;
      maxlng = giswind.xtrans + plotimage.windsize * giswind.xscale;
      increment = (maxlng - minlng) / ((double) (giswind.nmrows - 1));
      for (i = 0; i < giswind.nmrows; ++i) {
	 giswind.collngval[i] = minlng + ((double) i) * increment;
      }

      minlat = giswind.ytrans;
      maxlat = giswind.ytrans + plotimage.windsize * giswind.yscale;
      increment = (maxlat - minlat) / ((double) (giswind.nmcols - 1));
      for (i = 0; i < giswind.nmcols; ++i) {
	 giswind.rowlatval[i] = minlat + ((double) i) * increment;
      }
      plotimage.repaint();
   }

} else if (arg.equals("Close a digitized path or surface")) {
   if (giswind.digitizepath) {
      giswind.closepath_();

   } else if (giswind.digitizesurface) {
      giswind.closesurface_();
   }

} else if (arg.equals("Count animals in an image")) {

   // Count animals in an image.

   do {
      fdpoint = new FileDialog(giswind, "Open an Animal Image File",
         FileDialog.LOAD);
      fdpoint.setVisible(true);
      imageflename = fdpoint.getDirectory() + fdpoint.getFile();
   } while (imageflename == null);
   giswind.msg = "Opened the animal image file: " + imageflename;

   GISwind.animalfle[0][0] = imageflename;
   GISutils.abundest_(giswind, GISwind.animalfle);

} else if (arg.equals("Help")) {
   helpwindow = new Helpwindow(this, "General GIS Tools Help Message");
   helpwindow.setVisible(true);

} else if (arg.equals("About")) {
   helpwindow = new Helpwindow(this, "About giswind");
   helpwindow.setVisible(true);
}
giswind.repaint();
}

// ------------------------------------------------------------------

public void itemStateChanged(ItemEvent ie) {

// Item event handler.

giswind.repaint();
}
}
