class Fitactions extends CA {

static boolean printpair = false;

static int nmoutcombs[] = new int[TNMVALS + 1];
static int bestnminoutpairs[] = new int[TNMVALS + 1];
static int nmobsoutcombs[] = new int[TNMVALS];
static int nmuniqueoutcombs[] = new int[TNMVALS];
static int wrongaction[] = new int[TNMVALS];

static double bestinoutpair[][][] =
   new double[TNMVALS][NMINOUTPAIRS][5];
static double incombfreq[][] = new double[TNMVALS][4];

// ----------------------------------------------------------------------

static void fitactions_() {

/* Runs the sequential action-matching algorithm defined as follows:
   1. At each time point, check the match between the observed
      out-combination and the one generated by the ID.  If they do
      not match, replace the model's out-combination with that observed.
   2. If this replacement causes the overall fraction of matches to
      go down, reject this replacement.
   3. Go to the next ID or time point.

   Note that "nmobsactns" is the number of observed actions in the
   actions history file whereas "nmoutcombs" is the number of these
   actions that contain both an action and a target.

   Possible modifications to this algorithm:
      1. Make a second pass over the time interval.
      2. Store the all-time best-matching solution instead of the
	 sequentially-best solution as is done in the current
	 algorithm.  But why are these different, i.e., why when
	 the solution does not improve and the replacement is rejected,
	 the previous number of matches is not achieved again?
      3. Make a pass over the time interval and then replace the
	 most-frequent mismatch.
*/

boolean retval, newoutcomb;

int i, j, k, l, tindex, nmt;

double bestmatchfrac;

/* Run model and acquire initial set of mismatches indexed by
   observation time. */

for (i = 0; i < nmids - 1; ++i) {
   Intridslve.nminoutpairs[i] = 0;
}

actnsagree_(true);

bestmatchfrac = matchfrac[0];

Displayactions.plottype = "model";

printf_("\nfitactions: gs_groups= " + gs_groups + " gs_eco= " + gs_eco +
   "\n   gh_groups= " + gh_groups + " gh_eco= " + gh_eco);

nmt = Intridslve.nmmdltimes;
TIMELOOP: for (tindex = 1; tindex <= nmt; ++tindex) {

   /* Adjust each group ID to correct the mismatch that occurred at
      time point "tindex."  Accept this adjustment only if it does
      not increase the total number of mismatches. */

   for (i = 0; i < nmids - 1; ++i) {

      /* Replace the model out-combination with the observed one in
	 each first mismatched in-out pair of each group ID. */

      thisidname = idname[i];
      idnmbrm1 = i;
      nmnds = Intridslve.nmndes[idnmbrm1];

      retval = Matchpair.matchpair_(tindex, "replace");

      /*
      printf_("fitactions: tindex= " + tindex + " i= " + i +
         " matchpair-replace retval= " + retval);
      */

      // No replacement occurred, go to the next ID or time point.

      if (!retval) {
         continue;
      }

      /* Recompute the action match fraction under this modified set of
	 in-out pairs. */

      actnsagree_(false);

      // Reload ID name.

      thisidname = idname[i];
      idnmbrm1 = i;
      nmnds = Intridslve.nmndes[idnmbrm1];

      if (bestmatchfrac < matchfrac[0]) {
         bestmatchfrac = matchfrac[0];
	      
	 // Improved. 
	 
         printf_("fitactions: tindex= " + tindex + " ID= " + thisidname +
            " improved, new bestmatchfrac= " + fdble_(bestmatchfrac, 5, 3));
      
         // Store this current-best in-out pattern collection.

         for (j = 0; j < nmids - 1; ++j) {
	    bestnminoutpairs[j] = Intridslve.nminoutpairs[j];
            for (k = 0; k < bestnminoutpairs[j]; ++k) {
               for (l = 0; l < 3; ++l) {
                  bestinoutpair[j][k][l] = Intridslve.incomb[j][k][l];
               }
               bestinoutpair[j][k][3] =
	          (double) Intridslve.outcomb[j][k][0];
               bestinoutpair[j][k][4] =
	          (double) Intridslve.outcomb[j][k][1];
	    }
	 }

         if (bestmatchfrac > 0.9) {
            break TIMELOOP;
         }

      } else {

         // Unimproved restore the in-out pair.
	 
         printf_("fitactions: tindex= " + tindex + " ID= " + thisidname +
            ", no improvement, restoring.");

	 Matchpair.matchpair_(tindex, "restore");
      }
   }
}

actnsagree_(true);
printf_("fitactions: just after actnsagree_: match fraction= " +
   matchfrac[0]);

/* Load and verify that the stored best collection returns the best match
   fraction. */

for (i = 0; i < nmids - 1; ++i) {
   Intridslve.nminoutpairs[i] = bestnminoutpairs[i];
   for (j = 0; j < Intridslve.nminoutpairs[i]; ++j) {
      for (k = 0; k < 3; ++k) {
         Intridslve.incomb[i][j][k] = bestinoutpair[i][j][k];
      }
      Intridslve.outcomb[i][j][0] = (int) bestinoutpair[i][j][3];
      Intridslve.outcomb[i][j][1] = (int) bestinoutpair[i][j][4];
   }
}

printf_("fitactions: final best match fraction= " + matchfrac[0]);

// Count the number of unique out-combinations for each group ID.

printf_("\nfitactions: ID  nmobsoutcombs  nmuniqueoutcombs");
for (i = 0; i < nmids - 1; ++i) {
   thisidname = idname[i];
   nmuniqueoutcombs[i] = 1;
   for (j = 1; j < Intridslve.nminoutpairs[i]; ++j) {
      newoutcomb = true;
      for (k = 0; k < j; ++k) {
	 if (Intridslve.outcomb[i][k][0] == Intridslve.outcomb[i][j][0]
	     &&
	     Intridslve.outcomb[i][k][1] == Intridslve.outcomb[i][j][1]
	    ) {
	    newoutcomb = false;
	    break;
	 }
      }
      if (newoutcomb) {
         ++nmuniqueoutcombs[i];
      }
   }
   printf_("     " + fstrng_(thisidname, 7) + "      " +
      fint_(nmobsoutcombs[i], 4) + "      " +
      fint_(nmuniqueoutcombs[i], 4));
}

// Write this new in-out pattern collection.

printf_("\nfitactions: writing bestpairsfle: " + bestpairsfle);

fleopen_(2, bestpairsfle, 'w');

printf_("\n In-Combination     Out-Combination" +
   "\ninactn inactr insubj   actn trgt");

for (i = 0; i < nmids - 1; ++i) {
   strng = idname[i] + " " + Intridslve.nminoutpairs[i];
   fprintf_(2, strng);
   printf_(strng);
   for (j = 0; j < Intridslve.nminoutpairs[i]; ++j) {
      strng = " " + fdble_(bestinoutpair[i][j][0], 5, 2) +
         " " + fdble_(bestinoutpair[i][j][1], 5, 2) + 
         " " + fdble_(bestinoutpair[i][j][2], 5, 2) +
         "   " + fdble_(bestinoutpair[i][j][3], 5, 2) +
         " " + fdble_(bestinoutpair[i][j][4], 5, 2);

      fprintf_(2, strng);
      printf_(strng);
   }
}
fclose_(2, 'w');
}

// ----------------------------------------------------------------------

static void actnsagree_(boolean pflag) {

/* Computes a measure of agreement between an observed actions history
   and the actions history generated by the set of interacting IDs.
   This measure assumes
      (a) utility is on the unit interval, and
      (b) the last ID is the ecosystem.
*/

boolean test = false, actionmatch = false, targetmatch = false,
   foundact = false, noobsactn = true, complementaction = false;

String obsstrng, mdlstrng, obstrgtlbl, opttrgtlbl;

int tindex, i, j, k, obsactnnm = 0, obstrgtnm = 0, optactnnm, opttrgtnm,
   trgtndenm, actnndenm, nmmatched, inactn, inactr, insubj, ctrgtnde,
   obsrawactnnm = 0, nmidacts, previndex = 0;

double maxutil, fact = 0., retval = 0.;

/* Print nminoutpairs.

for (i = 0; i < nmids - 1; ++i) {
   printf_("actnsagree: ID= " + idname[i] + " nminoutpairs= " + Intridslve.nminoutpairs[i]);
}
*/

// Solve the IntIDs model over the observed time interval.

Intridslve.intridslve_(false, false);

// Initialize arrays.

for (i = 0; i <= nmids; ++i) {
   nmoutcombs[i] = 0;
   nmmatch[i] = 0.;
   nmactmatch[i] = 0.;
   nmtrgtmatch[i] = 0.;
   wrongaction[i] = 0;
   incombfreq[i][0] = 0.;
   incombfreq[i][1] = 0.;
   incombfreq[i][2] = 0.;
   incombfreq[i][3] = 0.;
}

if (printpair) {
   printf_("\nactnsagree: nmmdltimes= " + Intridslve.nmmdltimes +
      "\nID tindex obstrgt opttrgt trgtmtch obsact optact actnmtch");
}

// Time loop.

for (tindex = 1; tindex <= Intridslve.nmmdltimes; ++tindex) {
   previndex = Math.max(tindex - 2, 0);

   // Loop over group IDs only.

   for (idnmbrm1 = 0; idnmbrm1 < nmids - 1; ++idnmbrm1) {
      thisidname = idname[idnmbrm1];

      /* See if there is an observed action by this ID within this
         time interval. */

      noobsactn = true;
      for (i = 0; i < nmobsactns; ++i) {
         if (!thisidname.equals(actnshstry_obsactor[i])) {
            continue;
	 }


         if (!findmpemp &&
             (Intridslve.tmept[previndex] <= actnshstry_obsactnnmtime[i] &&
              actnshstry_obsactnnmtime[i] < Intridslve.tmept[tindex - 1])) {
            obsactnnm = actnshstry_obsactnraw[i];
            obstrgtnm = actnshstry_obstrgtnm[i];

	    // Skip delete-d jackknifing deleted observations.

	    if (!jackknifedeleted[i]) {
	       noobsactn = false;
	       break;
	    }

	 } else if (findmpemp && tindex < 10) {
            obsactnnm = actnshstry_obsactnraw[i];
	    obstrgtnm = 1;
            noobsactn = false;
            break;
         }
      } // End of loop over observed actions.
      if (noobsactn) {
         continue;
      }

      // Count the number of observed out-combinations.

      if (obsactnnm > 0 && obstrgtnm > 0) {
         ++nmoutcombs[0];
         ++nmoutcombs[idnmbrm1 + 1];

      } else {
         for (j = 0; j < nmobsactns; ++j) {
            printf_("actnsagree: j= " + j + " obstrgtnm= " +
               actnshstry_obstrgtnm[j]);
         }
         iderr_("actnsagree: tmept= " + Intridslve.tmept[tindex - 1] +
            " obsactnnm= " + obsactnnm + " obstrgtnm= " + obstrgtnm);
      }

      /*
      printf_("actnsagree: nmobsactns= " + nmobsactns + " nmoutcombs= " +
         nmoutcombs[0]);
      */

      // Loop over multiple model out-combinations.

      actionmatch = false;
      targetmatch = false;
      nmidacts = actnshstry_mdlnmacts[idnmbrm1][tindex - 1];
      for (i = 0; i < nmidacts; ++i) {

         // Get the model-computed in-combination and out-combination.

         inactn = actnshstry_mdlinputval[idnmbrm1][tindex - 1][i][0];
         inactr = actnshstry_mdlinputval[idnmbrm1][tindex - 1][i][1];
         insubj = actnshstry_mdlinputval[idnmbrm1][tindex - 1][i][2];
         optactnnm = actnshstry_mdlactn[idnmbrm1][tindex - 1][i];
         opttrgtnm = actnshstry_mdltrgts[idnmbrm1][tindex - 1][i];

	 /*
         if (thisidname.equals("kenrr")) {
            printf_("actnsagree: tindex= " + tindex + " obsactnnm= " +
               obsactnnm + " optactnnm= " + optactnnm);
	 }
         */

         maxutil = CA.optutil[idnmbrm1][tindex - 1][i];

	 /* Keep track of the frequency of in-combinations that match
	    those used to set feasible values. */

 	 for (j = 0; j < bestnminoutpairs[idnmbrm1]; ++j) {
	    if (((int) bestinoutpair[idnmbrm1][j][0]) == inactn) {
               incombfreq[idnmbrm1][1] += 1.;
	    }
	    if (((int) bestinoutpair[idnmbrm1][j][1]) == inactr) {
               incombfreq[idnmbrm1][2] += 1.;
	    }
	    if (((int) bestinoutpair[idnmbrm1][j][2]) == insubj) {
               incombfreq[idnmbrm1][3] += 1.;
	    }
	    if (((int) bestinoutpair[idnmbrm1][j][0]) == inactn &&
		((int) bestinoutpair[idnmbrm1][j][1]) == inactr &&
		((int) bestinoutpair[idnmbrm1][j][2]) == insubj) {
	       incombfreq[idnmbrm1][0] += 1.;
	    }
	 }

         /* Skip ID-and-time point combinations if the associated ID
	    did not generate an action. */

         if (optactnnm == 0) {
            continue;
         }

         /* To determine if the observed and model-computed actions
            match, compare EMAT action labels.  Do this because each
            ID's output actions were replaced by EMAT codes when the
            "action_labels" array was created in "intridslve_."
            Also, count only 1 match event per model out-combination.
            Do this by only updating "nmactmatch" once per time and
            ID combination. */

         obsstrng = Intridslve.action_labels[idnmbrm1][obsactnnm - 1];
         mdlstrng = Intridslve.action_labels[idnmbrm1][optactnnm - 1];

         if (obsstrng.equals(mdlstrng)) {
            actionmatch = true;
            nmactmatch[0] += 1.;
            nmactmatch[idnmbrm1 + 1] += 1.;
         
	 } else if (thisidname.equals("poachers") &&
                    obsstrng.indexOf("rhino_horns") >= 0 &&
                    mdlstrng.indexOf("rhino_horns") >= 0) {
            actionmatch = true;
            nmactmatch[0] += 1.;
            nmactmatch[idnmbrm1 + 1] += 1.;

         } else {
            ++wrongaction[idnmbrm1];
         }

         // Check for target match.

         obstrgtlbl = Intridslve.target_labels[idnmbrm1][obstrgtnm - 1];
         opttrgtlbl = Intridslve.target_labels[idnmbrm1][opttrgtnm - 1];

         if (findmpemp ||
             (opttrgtlbl.indexOf(obstrgtlbl, 0) >= 0 ||
              obstrgtlbl.indexOf(opttrgtlbl, 0) >= 0)) {
            targetmatch = true;
            nmtrgtmatch[0] += 1.;
            nmtrgtmatch[idnmbrm1 + 1] += 1.;
         }

         if (printpair) {
            printf_(fstrng_(thisidname, 7) + " " +
               fdble_(Intridslve.tmept[tindex - 1], 7, 2) +
               " " + obstrgtnm + " " + opttrgtnm + " " +
	       fstrng_(Boolean.toString(targetmatch), 5) + "   " +
	       fint_(obsactnnm, 2) + " " + fint_(optactnnm, 2) + " " +
	       fstrng_(Boolean.toString(actionmatch), 5));
	 }
	 
         // Compute the match counter term of the objective function.

         if (actionmatch && targetmatch) {
            nmmatch[0] += 1.;
            nmmatch[idnmbrm1 + 1] += 1.;

            // Store this matched in-out pair.

            actnshstry_matchedactn[idnmbrm1][tindex - 1][i] = optactnnm;

	    /*
	    if (2006. <= Intridslve.tmept[tindex - 1] &&
		Intridslve.tmept[tindex - 1] < 2007.) {
	       printf_("actnsagree: match: ID= " + thisidname + " t= " +
	          Intridslve.tmept[tindex - 1] + " idactionnm= " + i);
            }
            printf_("actnsagree: t= " + Intridslve.tmept[tindex - 1] +
               " obsactn= " +
	       Intridslve.action_labels[idnmbrm1][obsactnnm - 1] +
	       " obstrgtlbl= " + obstrgtlbl);
            */

	    /* Break out of the "nmidacts" loop so that this observed
	       action is not matched twice. */

	    break;
	    
         } else {
            actnshstry_matchedactn[idnmbrm1][tindex - 1][i] = 0;
         }

	 // Compute complement action conditions set constraint.

	 if (dsensanalysis || findmpemp) {
            complementaction = false;
            for (j = 0; j < bestnminoutpairs[idnmbrm1]; ++j) {
	       if (((int) CAinitialize.complementact[idnmbrm1][j]) ==
                   optactnnm) {
                  complementaction = true;
		  break;
               }
            } // End of loop over best in-out pairs.
         }
      } // End of loop over multiple model out-combinations.
   } // End of ID loop.
} // End of time loop.

/* When fitting the model to an observed actions history, stop if the
   number of observed actions over this time frame is zero. */

if (cacalc && !dsensanalysis && nmoutcombs[0] == 0) {
   iderr_("actnsagree: nmoutcombs=0");
}

for (i = 0; i <= nmids; ++i) {
   if (nmoutcombs[i] > 0) {
      matchfrac[i] = nmmatch[i] / (double) nmoutcombs[i];
      actmatchfrac[i] = nmactmatch[i] / (double) nmoutcombs[i];
      trgtmatchfrac[i] = nmtrgtmatch[i] / (double) nmoutcombs[i];
   }
}

/*
printf_("actnsagree: matchfrac= " + matchfrac[0] + " nmoutcombs= " +
   nmoutcombs[0]);
*/

if (pflag) {
   fprintf_(1,"\nnmobsactns= " + nmobsactns + " nmoutcombs= " +
      nmoutcombs[0]);
   fprintf_(1, "   nmmatched= " + ((int) nmmatch[0]) + " matchfrac= " +
      fdble_(matchfrac[0], 4, 3) + "\n   actmatchfrac= " +
      fdble_(actmatchfrac[0], 4, 3) + " trgtmatchfrac= " +
      fdble_(trgtmatchfrac[0], 4, 3));

   fprintf_(1, "\n ID nmobsactns nmmatch mtchfrc nmactmtch actmtchfrc" +
      " nmtrgtmtch trgtmtchfrc");

   for (i = 0; i < nmids; ++i) {
      fprintf_(1, fstrng_(idname[i], 7) +
         "  " + fint_(nmoutcombs[i + 1], 4) +
         "  " + fint_(((int) nmmatch[i + 1]), 4) +
         "    " + fdble_(matchfrac[i + 1], 3, 3) +
         "  " + fint_(((int) nmactmatch[i + 1]), 4) +
         "    " + fdble_(actmatchfrac[i + 1], 3, 3) +
         "  " + fint_(((int) nmtrgtmatch[i + 1]), 4) +
         "    " + fdble_(trgtmatchfrac[i + 1], 3, 3));
   }
   for (i = 0; i < nmids; ++i) {
      fprintf_(1, fstrng_(idname[i], 7) + " wrongaction= " +
         wrongaction[i] + " incombfreq overall= " +
         fdble_(incombfreq[i][0], 4, 1));
   }

   fprintf_(1, "\nCA-Fitted Model Actions Error Rate:" +
      "\nnmmatched= " + nmmatch[0] + " nmoutcombs= " +
      nmoutcombs[0] + " match fraction= " +
      fdble_(matchfrac[0], 4, 3));
}

if (!complementaction) {
   gs_groups = matchfrac[0];

} else {
   gs_groups = -1.e2;
}

return;
}

// -----------------------------------------------------------------------

static void printinoutpair_(String mtdname, int tindex, int inactn,
   int inactr, int insubj, int obsactnnm, int obstrgtnm, int optactnnm,
   int opttrgtnm) {

// Prints the given in-out pair.

printf_("\n" + mtdname + ": In-Out Pair");
printf_("   tindex= " + tindex + " ID= " + thisidname + " " +
   "\n   " + fstrng_("in-action= ", 17) + inactn + " " +
   nodelbls[idnmbrm1][Intridslve.inactnnode[idnmbrm1] - 1][inactn] +
   "\n   " + fstrng_("in-actor= ", 17) + inactr + " " +
   nodelbls[idnmbrm1][Intridslve.inactrnode[idnmbrm1] - 1][inactr] +
   "\n   " + fstrng_("in-subject= ", 17) + insubj + " " +
   nodelbls[idnmbrm1][Intridslve.insubjnode[idnmbrm1] - 1][insubj]);

printf_("   " + fstrng_("obs out-action= ", 17) + obsactnnm + " " +
   nodelbls[idnmbrm1][Intridslve.decnode[idnmbrm1] - 1][obsactnnm] +
   "\n   " + fstrng_("obs target= ", 17) + obstrgtnm + " " +
   nodelbls[idnmbrm1][Intridslve.trgtsnode[idnmbrm1] - 1][obstrgtnm]);

printf_("   " + fstrng_("opt out-action= ", 17) + optactnnm + " " +
   nodelbls[idnmbrm1][Intridslve.decnode[idnmbrm1] - 1][optactnnm] +
   "\n   " + fstrng_("opt target= ", 17) + opttrgtnm + " " +
   nodelbls[idnmbrm1][Intridslve.trgtsnode[idnmbrm1] - 1][opttrgtnm]); 
}
}
