public class FibFactMaster extends GenericMaster {
    public void generateTasks() {
        for (int i = 0; i < 10; i++) {
            FactorialTask task = new FactorialTask(i);
            writeTask(task);
	}
        for (int i = 0; i < 10; i++) {
            FibonacciTask task = new FibonacciTask(i);
            writeTask(task);
        }
    }
        
    public void collectResults() {
        ResultEntry template = new ResultEntry();
        for (int i = 1; i < 20; i++) {
            ResultEntry result = takeResult(template);
                
            if (FactorialResult.class.isInstance(result)) {
                FactorialResult fact = (FactorialResult)result;
                System.out.println("Factorial of " + fact.n + 
                    " is " + fact.factorial);
            } else if (FibonacciResult.class.isInstance(result)) {
                FibonacciResult fib = (FibonacciResult)result;
                System.out.println("Fibonacci of " + 
                    fib.n + " is " + fib.fibonacci);
            } else {
                System.out.println("Result class not found");
            }
        }
    }     
}
