// package jsbook.chapter6.command;

public class FactorialTask extends TaskEntry {
    public Integer n;
    
    public FactorialTask() {
    }
    
    public FactorialTask(int n) {
        this.n = new Integer(n);
    }

    public ResultEntry execute() {
        System.out.println(
            "Computing Factorial of " + n);
        int nm = n.intValue();
        return new FactorialResult(nm, factorial(nm));
    }
    
    public int factorial(int i) {
        if (i == 0) {
            return 1;
        } else {
            return i * factorial(i - 1);
        }
    }
}
