public class Estimate extends Predict {
static boolean local, computehessian = false;

static int begincov, savenmcntr;

static double a[] = new double[OPTSIZE];
static double g[] = new double[OPTSIZE];
static double h[] = new double[OPTSIZE];
static double cpar[][] = new double[NMWRPAR][NMWRPAR];
static double glimit[][] = new double[NUMCNTR][OPTSIZE];
static double hlimit[][] = new double[NUMCNTR][OPTSIZE];
static double moments[] = new double[4];

// ----------------------------------------------------------------------

public static int estimate_(int option, double xcord, double ycord,
   double tmecord) {
 
// Estimates all parameters using sample in the array "vardat."
 
boolean test = true, plt = false;

int i, retval = 0;

// Specify a local or global model.

if (nmstmixcntr == 0) {
   local = true;

} else {
   local = false;
}

// Specify estimation method and initialize random number generator.

if (trnsfrm) {
   mdfit = true;
   trnsfrm_nmpars = 2 * parm_mvar;

} else {
   mdfit = false;
   trnsfrm_nmpars = 0;
}

if (itrend == 0) {

   /* Estimate the covariogram from the observations.  Use this covariogram
      to compute an ordinary kriging prediction at the center of the
      moving cylinder back in routine "krg_." */

   Vargrm.vargrm_(2, true, xcord, ycord, tmecord, a, g, h); 

} else if (4 <= itrend && itrend < 10) {

   /* Calculate variogram before detrending.
   Vargrm.vargrm_(2, true, xcord, ycord, tmecord, a, g, h); 
   iderr_("estimate: Terminating."); */

   /* Use either Two Stage Generalized Least Squares (2SGLS) or Minimum
      Distance (MD) to fit the trend parameters, transformation parameters,
      and covariogram parameters.

      Step 1: Perform first regression and estimate variogram from the
      residuals. */

   retval = Wlstrend.wlstrend_(1, cpar, mdfit);

   if (retval == 1) {
      iderr_("estimate: wlstrend=1, step 1");
   
   } else if (retval == 3) {
      return 3;
   }

   if (nmstmixcntr > 0) {

      /* Use the number of trend parameters computed in "wlstrend_" to
         inform the estimation of a GLOMAP model. */

      if (glomapest_(xcord, ycord, tmecord)) {
	 return 1;
      }

      if (!client) {
      
	 // Compute parameter estimate standard errors via Monte Carlo.

         Mcpstd.parstderr_(xcord, ycord, tmecord);
      }

      return 0;
   }

   // Fit covariogram matrix to these OLS residuals.

   Vargrm.vargrm_(2, true, xcord, ycord, tmecord, a, g, h);
   printf_("estimate: nmtrendpars= " + nmtrendpars + " ttlnmpars= " +
      ttlnmpars);

   if (parm_mvar > 1 && varmod_ifail == 4) {
      return 1;
   }

   if (varmod_ifail == 5) {

      // Zero variance was computed in vargrm.

      return 2;
   }

   // Step 2: Do either a second stage gls or a Minimum Distance fit.

   if (!mdfit) {

      // Perform second regression and load model if successful.

      retval = Wlstrend.wlstrend_(2, cpar, false);
      if (retval == 1) {
	 iderr_("estimate: wlstrend=1 (step 2)");
      }

      // Fit final variogram model.
      
      Vargrm.vargrm_(2, false, xcord, ycord, tmecord, a, g, h);

      if (varmod_ifail == 4) {
	 return 1;
      }

      if (varmod_ifail == 5) {
	 return 2;
      }

   } else {

      // Find the MD parameter estimates.

      if (mdest_(xcord, ycord, tmecord)) {
	 return 1;
      }
   }
      
} else if (itrend >= 10) {

   /* For itrend = 10 or 11, always use MD estimation as implemented
      for these particular models in the routine "mdtrend_()" (NOTE:
      need to convert mdtrend.c to java before this option can be activated).
   if (Mdtrend.mdtrend_(option, xcord, ycord, tmecord)) {
      iderr_("estimate: mdtrend failed");
   }
   */
}

/* Load transformation and local covariogram matrix parameters into global
   grid storage.  Note that even if "ifail" = 1, initial values have been
   loaded into varmod. */

Loadpar.loadpar_(4, 0, a, g, h);

// Optionally, create an aggregated time series plot.

if (temporal && plt) {
   Plot.plttmeag_(nd, vardat_t, vardat_vrble, vardat_obs, vardat_trend);
}

/* Compute the bias and standard error of the trend and covariance
   structure parameters.
lattint_(xcord, ycord, tmecord);
iderr_("estimate: after lattint");
*/

return 0;
}

// ---------------------------------------------------------------------

public static boolean mdest_(double xcord, double ycord, double tmecord) {

/* Uses Minimum Distance (MD) to estimate LOMAP's within-cylinder
   trend function parameters, transformation parameters (if trnsfrm = true),
   and the parameters of the residual's covariogram matrix.  These
   parameters are stored in a[] as follows.

   Parameter Type                   Components of x
   --------------                   ---------------
   trend function parameters        1 thru nmtrendpars

   transformation parameters        (nmtrendpars + 1) thru
                                    (nmtrendpars + trnsfrm_nmpars).

   covariogram matrix parameters    (nmtrendpars + trnsfrm_nmpars + 1) thru
                                    (nmtrendpars + trnsfrm_nmpars +
                                    varmod_nmpars).

   This ordering follows the sequence of transformations needed to reach
   the residuals:

   1. Subtract off the trend function using the fitted trend function
      parameters,
   2. Transform these residuals via the fitted transformation parameters,
   3. Form the covariance matrix of the residuals using the fitted
      covariogram matrix of these transformed residuals,
   4. Use this covariance matrix to compute the i.i.d. residuals.
*/

boolean test = false;

int i, j, k, nmimp = 0, vnmbr, seasnm = 0, meannm = 0;

double resid, sse, resmean;

fprintf_(1,"\n----------- mdest: LOMAP PARAMETER ESTIMATION ----------\n");
k = 0;
for (i = 0; i < parm_mvar; ++i) {
   for (j = 0; j < nmpars[i]; ++j) {

      /* Initial trend parameter values are from the step 1 OLS fit done in
         estimate_().
      a[k] = grdvar_rparm[i][j];
      */

      // Set constants to the local mean and all others to zero.

      if (j == 0) {
         a[k] = grdvar_vrblemns[i]; 

      } else {
         a[k] = .1; // was 0.
      }

      g[k] = 0.;
      h[k] = 100.;

      /* Kluge to set each initial seasonal parameter to the difference
         between the overall mean and the season mean. */

      if (seasclc && ((2 <= k && k <= 4) || (7 <= k && k <= 9))) {
         if (2 <= k && k <= 4) {
            seasnm = k - 1;
            meannm = 0;
         
         } else {
            seasnm = k - 6;
            meannm = nmpars[0];
         }
         a[k] = grdvar_seasmns[i][seasnm - 1] - a[meannm];
         g[k] = a[k] - .5 * Math.abs(a[k]);
         h[k] = a[k] + .5 * Math.abs(a[k]);
      }

      // Assure an interval of positive width.

      if (Math.abs(h[k] - g[k]) < 1.e-20) {
         g[k] = -10.;
         h[k] = 10.;
      }
      ++k;
   }
}

if (trnsfrm) {

   /* Load tau1 and tau2 transformation parameters. */

   for (j = 0; j < parm_mvar; ++j) {
      a[k] = trnsfrm_tau1[j];
      g[k] = .5;
      h[k] = 1.5;

      a[k + 1] = trnsfrm_tau2[j];
      g[k + 1] = .5;
      h[k + 1] = 1.5;
      k += 2;
   }
}

/* Initial covariogram matrix parameters and their bounds are already in
   a[], g[], and h[].  Set number of implicit constraints and their
   limits. */

if (parm_mvar > 1) {
   nmimp = 2;
   for (i = 0; i < nmimp; ++i) {
      Optimiz.gimplicit[i] = 0.;
      Optimiz.himplicit[i] = 1.e10;
   }
}

/* Reload covariogram matrix parameters into a. */

Loadpar.loadpar_(5, 0, a, g, h);

Optimiz.cnstrnt[1] = Optf.speccnstrnt_();
if (Optimiz.cnstrnt[1] < 0.) {
   for (i = parm_mvar; i < nmmdls; ++i) {
      varmod_sill[0][i] = 0.;
   }
   Loadpar.loadpar_(5, 0, a, g, h);
   Optimiz.cnstrnt[1] = Optf.speccnstrnt_();
   if (Optimiz.cnstrnt[1] < 0.) {
      iderr_("mdest: fix failed");
   }
}

// Now, fit all parameters with MD.

Optimiz.optimiz_(ttlnmpars, nmimp, a, g, h, 2);

/* Fix up covariogram matrix as necessary and then compute gaussian
   scale moments. */

if (parm_mvar > 1) {

   // Check and possibly correct nugget parameters.

   Optimiz.cnstrnt[0] = Optf.nuggcnstrnt_();
   if (Optimiz.cnstrnt[0] < 0.) {
      for (i = parm_mvar; i < nmmdls; ++i) {
	 varmod_nugget[0][i] = 0.;
      }
   }

   // Check and possibly correct continuous components.

   Optimiz.cnstrnt[1] = Optf.chkcovdat_(false, true, "mdest");

   // Perhaps residuals should be updated??
}

if (computehessian) {
   fprintf_(1, "Moments of standardized, gaussian residuals:");
   Summry.moments_(true, nd, vardat_stdres, moments);
}

// Residual analysis.

// Print trend, (optionally) transform, and covariogram matrix parameters.

for (i = 0; i < parm_mvar; ++i) {
   fprintf_(1, "mdest: Variable  Trend_Parameter  Value");
   for (j = 0; j < nmpars[i]; ++j) {
      fprintf_(1, "   " + nodelbls[idnmbrm1][lomapnms[i] - 1][0] +
         "     " + j + "     " + grdvar_rparm[i][j]);
   }

   if (trnsfrm) {
      fprintf_(1, nodelbls[idnmbrm1][lomapnms[i] - 1][0] + " tau1= " +
         trnsfrm_tau1[i] + " tau2= " + trnsfrm_tau2[i]);
      if (trnsfrm_tau2[i] == 0.) {
         iderr_("mdest: zero tau2 on variable " + lomapnms[i]);
      }
   }
}

if (test) {

   // Compute the sample variograms and sample cross-covariograms.

   Gama3.gama3_(ndi, alp, da, 2, tolt, test, true); 

   // Print the fitted covariogram matrix.
   
   fprintf_(1, "mdest: Covariogram after fitting model:");
   Covmodl.covprt_(1);

   /* Open residual plotting file and plot data, trend, residual,
      standardized, "whitened" residual. */

   fleopen_(7, "stdres.plt", 'w');
   for (i = 0; i < nd; ++i) {
      fprintf_(7, i + " " + vardat_vrble[i] + " " + vardat_obs[i] + " " +
         vardat_trend[i] + " " + vardat_dat[i] + " " + vardat_stdres[i]);
   }

   // Close the plotting file and then create the normal Q-Q plot.

   fclose_(7, 'w');

   fprintf_(1,"Q-Q plot of within-cylinder standard normal residuals.");
   Pltnrm.pltnrm_();
}
fprintf_(1,"-------------- End of LOMAP Estimation ------------------");
return false;
}

// -----------------------------------------------------------------------

public static boolean glomapest_(double xcord, double ycord, double tmecord) {

/* Estimate the parameters of a GLOMAP model.  **Note that if
   nmstmixcntr=1, the component gives equal weight to all locations
   so that ANY global trend function, e.g. a pollutant transport system
   of equations can be treated as a GLOMAP model. */

boolean test = true;

int i, i1, j, k, l, savecovnon, nmimp = 0, savestoption, localoffset,
   klocal = 0, iend, ibegin, savepredopt = 1;

double xcenter, ycenter, krnlsum;

fprintf_(1, "\n-------------------- GLOMAP ----------------------\n");

if (spatial && temporal) {
   savepredopt = spacetime_predoption;
   spacetime_predoption = 2;
}

if (icrval == 0 || (icrval == 1 && nmest == 0)) {

   /* Step 1: Find maximally-different seed locations.  Start these points
              at the region's center.  Also assign tcntr and krnlvar values.
   */

   xcenter = .5 * (spacetime_xmin + spacetime_xmax);
   ycenter = .5 * (spacetime_ymin + spacetime_ymax);
   fprintf_(1, "grand xcenter= " + xcenter + " grand ycenter= " + ycenter);

   // Initialize by finding starting locations for kernel centers.

   if (nmstmixcntr == 1) {
      stmix_xcntr[0] = xcenter;
      stmix_ycntr[0] = ycenter;
      stmix_tcntr[0] = tmecord;
      stmix_krnlvar[0] = 1.e6;
      fprintf_(1, "Component 1: " + " xcntr= " +
         fdble_(stmix_xcntr[0], 7, 3) + " ycntr= " +
         fdble_(stmix_ycntr[0], 7, 3) +
         " krnlvar= " + fdble_(stmix_krnlvar[0], 7, 3));

   } else {
      k = 0;
      if (spatial && !temporal) {
         for (i = 0; i < nmstmixcntr; ++i) {
            stmix_tcntr[i] = tmecord;
            stmix_krnlvar[i] =
               Math.pow(.2 * (spacetime_xmax - spacetime_xmin), 2.);
            a[k] = xcenter + .2 * (Rndm.rndm1_(0, 0) - .5) * xcenter;
            a[k + 1] = ycenter + .2 * (Rndm.rndm1_(0, 0) - .5) * ycenter;
            g[k] = spacetime_xmin;
            h[k] = spacetime_xmax;
            g[k + 1] = spacetime_ymin;
            h[k + 1] = spacetime_ymax;
            k += 2;
         }

	 /* Set implicit constraint to force points to stay within the
	    boundary and then call "optimiz_" to find the optimal
	    locations. */

	 g[k] = 0.;
	 h[k] = 1.;
         Optimiz.optimiz_(k, 1, a, g, h, 4);

         // Store these optimized locations.

         fprintf_(1, "Inter-distance maximized component locations:");
         k = 0;
         for (i = 0; i < nmstmixcntr; ++i) {
            stmix_xcntr[i] = a[k];
            stmix_ycntr[i] = a[k + 1];
            fprintf_(1, "Component= " + (i + 1) + " xcntr= " +
               fdble_(a[k], 6, 3) + " ycntr= " + fdble_(a[k + 1], 6, 3) +
               " krnlvar= " + fdble_(stmix_krnlvar[i], 6, 3));
            k += 2;
         }

      } else if (spatial && temporal) {
         for (i = 0; i < nmstmixcntr; ++i) {
            stmix_xcntr[i] = xcenter;
            stmix_ycntr[i] = ycenter;
            stmix_tcntr[i] = 82. + ((double) i);
            stmix_krnlvar[i] = 2.;
         }
      }
   }

   /* Step 2: Estimate LOMAP models at these seed locations.  Then, start
              the GLOMAP parameter estimation search with these fitted
              models by reading each of these model's parameters into the
              optimization vector. */

   savenmcntr = nmstmixcntr;
   savecovnon = covnonstatmdl;
   savestoption = spacetime_option;

   local = true;
   nmstmixcntr = 0;
   covnonstatmdl = 0;
   spacetime_option = 6;
   trnsfrm_nmpars = 0;

   if (trnsfrm) {

      /* Initialize transformation parameters to their optimal LOMAP global
         values.  Note that these parameters are not optimized in the
         following local model estimations.  It is assumed that these
         values have been found from a previous LOMAP global parameter
         fitting run (see estglbl_()). */

      for (i = 0; i < parm_mvar; ++i) {
	 if (realmmts[i][2] < 0.) {
            trnsfrm_tau1[i] = 1.5;
	 
	 } else {
	    trnsfrm_tau1[i] = .5;
         }
         trnsfrm_invtau1[i] = 1. / trnsfrm_tau1[i];

	 if (realmmts[i][3] < 0.) {
            trnsfrm_tau2[i] = 1.5;
	 
	 } else {
            trnsfrm_tau2[i] = .5;
	 }
         trnsfrm_invtau2[i] = 1. / trnsfrm_tau2[i];
      }
   }

   for (i = 0; i < savenmcntr; ++i) {

      /* For this GLOMAP component, load prediction location and compute
         LOMAP parameter estimates. */

      xcord = stmix_xcntr[i];
      ycord = stmix_ycntr[i];
      tmecord = stmix_tcntr[i];

      Mvsrch.mvsrch_(0, xcord, ycord, tmecord);
      Vargrm.vargrm_(2, true, xcord, ycord, tmecord, a, g, h);

      fprintf_(1, "\n-- LOMAP PARAMETER ESTIMATES OF GLOMAP COMPONENT " +
         (i + 1) + " --");

      if (mdest_(xcord, ycord, tmecord)) {
         iderr_("glomapest: mdest failure on component " + i);
      }
      Stwrite.stwrite_(grow, gcol, jtime, xcord, ycord, tmecord, 0, true);

      // Store LOMAP parameters in associated GLOMAP component.

      for (j = 0; j < parm_mvar; ++j) {
         for (i1 = 0; i1 < nmpars[j]; ++i1) {
            stmix_rparm[i][j][i1] = grdvar_rparm[j][i1];
         }
      }
      for (j = 0; j < nmmdls; ++j) {
         varmod_nugget[i + 1][j] = varmod_nugget[0][j];
         varmod_sill[i + 1][j] = varmod_sill[0][j];
         varmod_range[i + 1][0][j] = varmod_range[0][0][j];
         varmod_range[i + 1][1][j] = varmod_range[0][1][j];
         varmod_oddnug[i + 1][j] = varmod_oddnug[0][j];
         varmod_oddsill[i + 1][j] = varmod_oddsill[0][j];
         varmod_oddrnge[i + 1][j] = varmod_oddrnge[0][j];
      }

      // Store limits.

      for (j = 0; j < ttlnmpars; ++j) {
         glimit[i][j] = g[j];
         hlimit[i][j] = h[j];
      }
   }

   // ------- Begin simultaneous estimate of all GLOMAP parameters --------

   spacetime_option = savestoption;
   nmstmixcntr = savenmcntr;
   covnonstatmdl = 2; // Must be 2 for GLOMAP
   krnlstart = 1;
   krnlend = nmstmixcntr;
   if (trnsfrm) {
      trnsfrm_nmpars = 2 * parm_mvar;
   }

   /* Form optimization vector from the LOMAP parameters and set bounds.

      Format of optimization vector:
      ((kernel parameters) (trend parameters) (transformation parameters)
       (covariogram parameters)).  First, load kernel parameters. */

   l = 0;

   /* Fit kernel parameters only if there is more than 1 component and
      this is a spatial-only analysis. */

   if (nmstmixcntr > 1 && spatial && !temporal) {
      for (i = 0; i < nmstmixcntr; ++i) {
         a[l] = stmix_xcntr[i];
         g[l] = 1.0 * spacetime_xmin;
         h[l] = 1.0 * spacetime_xmax;
         if (a[l] < g[l]) a[l] = g[l];
         if (a[l] > h[l]) a[l] = h[l];

         a[l + 1] = stmix_ycntr[i];
         g[l + 1] = 1.0 * spacetime_ymin;
         h[l + 1] = 1.0 * spacetime_ymax;
         if (a[l + 1] < g[l + 1]) a[l + 1] = g[l + 1];
         if (a[l + 1] > h[l + 1]) a[l + 1] = h[l + 1];

         a[l + 2] = stmix_krnlvar[i];
         g[l + 2] = .01 * stmix_krnlvar[i];
         h[l + 2] = 10. * stmix_krnlvar[i];
         if (a[l + 2] < g[l + 2]) a[l + 2] = g[l + 2];
         if (a[l + 2] > h[l + 2]) a[l + 2] = h[l + 2];

         l += 3;
      }
   }

   // Load trend parameters and discern number of parameters.

   k = 0;
   for (i = 0; i < nmstmixcntr; ++i) {
      klocal = 0;
      for (j = 0; j < parm_mvar; ++j) {
         for (i1 = 0; i1 < nmpars[j]; ++i1) {

	    if (i1 > 0 && nmstmixcntr > 1) {

	       /* Initialize all trend parameters other than the overall
		  mean. */

	       stmix_rparm[i][j][i1] = 0.;
	       glimit[i][klocal] = -10.;
	       hlimit[i][klocal] = 10.;
	    }

	    // Load optimization vector.

            a[k + l] = stmix_rparm[i][j][i1];
            g[k + l] = glimit[i][klocal];
	    h[k + l] = hlimit[i][klocal];
	    ++k;
            ++klocal;
         }
      }
   }

   if (trnsfrm) {

      /* Load tau1 and tau2 transformation parameters.  Use
         LOMAP-estimated values because in LOMAP, transformation parameters
         are global. */

      for (j = 0; j < parm_mvar; ++j) {
         a[k + l] = trnsfrm_tau1[j];
	 if (trnsfrm_tau1[j] < 1.) {
	    g[k + l] = .2;
	    h[k + l] = 1.;

	 } else {
	    g[k + l] = 1.;
	    h[k + l] = 3.;
	 }

         a[k + l + 1] = trnsfrm_tau2[j];
	 if (trnsfrm_tau2[j] < 1.) {
	    g[k + l + 1] = .2;
	    h[k + l + 1] = 1.;

	 } else {
	    g[k + l + 1] = 1.;
	    h[k + l + 1] = 3.;
	 }
         k += 2;
      }
   }

   /* Store beginning of covariogram parameters and local offset (for use
      with glimit, hlimit, below). */

   begincov = k + l;
   localoffset = klocal;

   // Load covariogram matrix parameters.

   for (i = 1; i <= nmstmixcntr; ++i) {
      klocal = localoffset;
      for (j = 0; j < nmmdls; ++j) {
         a[k + l] = varmod_nugget[i][j];
         g[k + l] = glimit[i - 1][klocal];
         h[k + l] = hlimit[i - 1][klocal];
         ++k;
         ++klocal;

         if (varmod_model[j] != 0) {
            a[k + l] = varmod_sill[i][j];
            g[k + l] = glimit[i - 1][klocal];
            h[k + l] = hlimit[i - 1][klocal];
            ++k;
            ++klocal;

            if (spatial) {
               a[k + l] = varmod_range[i][0][j];
               g[k + l] = glimit[i - 1][klocal];
               h[k + l] = hlimit[i - 1][klocal];
               ++k;
               ++klocal;
            }

            if (temporal) {
               a[k + l] = varmod_range[i][1][j];
               g[k + l] = glimit[i - 1][klocal];
               h[k + l] = hlimit[i - 1][klocal];
               ++k;
               ++klocal;
            }
         }
         if (lngmem) {
            a[k + l] = varmod_lma[j];
            g[k + l] = glimit[i - 1][klocal];
            h[k + l] = hlimit[i - 1][klocal];

            a[k + l + 1] = varmod_lmb[j];
            g[k + l + 1] = glimit[i - 1][klocal + 1];
            h[k + l + 1] = hlimit[i - 1][klocal + 1];

            a[k + l + 2] = varmod_lmc[j];
            g[k + l + 2] = glimit[i - 1][klocal + 2];
            h[k + l + 2] = hlimit[i - 1][klocal + 2];
            k += 3;
            klocal += 3;
         }
      } // End of loop over models.

      if (varmod_model[nmmdls - 1] == 3) {
         a[k + l] = varmod_oddnug[i][nmmdls - 1];
         g[k + l] = glimit[i - 1][klocal];
         h[k + l] = hlimit[i - 1][klocal];
         ++k;
         ++klocal;
         a[k + l] = .8 * varmod_oddsill[i][nmmdls - 1];
         g[k + l] = glimit[i - 1][klocal];
         h[k + l] = hlimit[i - 1][klocal];
         ++k;
         ++klocal;
         a[k + l] = varmod_oddrnge[i][nmmdls - 1];
         g[k + l] = glimit[i - 1][klocal];
         h[k + l] = hlimit[i - 1][klocal];
         ++k;
         ++klocal;
      }
   } // End of loop over kernel centers.
   ttlnmpars = l + k;

   if (ttlnmpars > OPTSIZE) {
      iderr_("glomapest: ttlnmpars= " + ttlnmpars + " > OPTSIZE");
   }
   printf_("glomapest: begincov= " + begincov + " nmtrendpars= " +
      nmtrendpars + " varmod_nmpars= " + varmod_nmpars + " ttlnmpars= " +
      ttlnmpars);

   // Specify a global model and reload vardat structure.

   local = false;
   for (i = 0; i < parm_mvar; ++i) Surf.ndmin[i] = Surf.nmsites[i];
   Mvsrch.mvsrch_(0, xcord, ycord, tmecord);

   /* Step 3: Use box -> mdobjf to estimate all parameters.  First,
      set number of implicit constraints and call box to minimize the
      distance function. */

   if (parm_mvar > 1) {
      nmimp = 2;
      for (i = 0; i < nmimp; ++i) {
         Optimiz.gimplicit[i] = 0.;
         Optimiz.himplicit[i] = 1.e10;
      }
   }

} else if (icrval == 1 && nmest > 0) {

   /* During cross-validation, reload vardat structure with new missing
      value removed. */

   for (i = 0; i < parm_mvar; ++i) {
      Surf.ndmin[i] = Surf.nmsites[i];
   }
   Mvsrch.mvsrch_(0, xcord, ycord, tmecord);

   // For spatio-temporal one-time-step-ahead prediction, reset predoption.

   if (spatial && temporal) {
      spacetime_predoption = savepredopt;
   }
}

fprintf_(1, "\n\nSIMULTANEOUS MINIMUM DISTANCE ESTIMATES OF ALL GLOMAP" +
   " PARAMETERS\n");

// First, fit all GLOMAP parameters with MD.

Mdobjf.appchol = false;
Optimiz.optimiz_(ttlnmpars, nmimp, a, g, h, 2);

// Fix-up component covariogram matrix parameters as necessary.

if (parm_mvar > 1) {
   Optimiz.cnstrnt[0] = Optf.chkcovdat_(false, true, "glomapest");
}

fprintf_(1, "Moments of standardized residuals:");
Summry.moments_(true, nd, vardat_stdres, moments);

// Output fitted GLOMAP model.

fprintf_(1, "\n         Parameter Estimates\n");
for (i = 0; i < nmstmixcntr; ++i) {

   // Print kernel center and variance.

   fprintf_(1, "\n.......... Component  " + (i + 1) + " .........\n" +
      " x-center= " + fdble_(stmix_xcntr[i], 6, 3) +
      " y-center= " + fdble_(stmix_ycntr[i], 6, 3) +
      " t-center= " + fdble_(stmix_tcntr[i], 6, 3) +
      " krnlvar= " + fdble_(stmix_krnlvar[i], 6,3));

   if (trnsfrm) {
      for (j = 0; j < parm_mvar; ++j) {
         fprintf_(1, "Process= " + nodelbls[idnmbrm1][lomapnms[j] - 1][0] +
            " tau1= " + fdble_(trnsfrm_tau1[j], 7, 3) +
            " tau2= " + fdble_(trnsfrm_tau2[j], 7, 3));
      }
   }

   // Print trend parameter values for this component.

   fprintf_(1,"\nTrend Parameters");
   for (j = 0; j < parm_mvar; ++j) {
      fprintf_(1, "Process= " + nodelbls[idnmbrm1][lomapnms[j] - 1][0]);
      fprintf_(1, "Coefficient   Value");
      for (i1 = 0; i1 < nmpars[j]; ++i1) {
         fprintf_(1, "  " + i1 + "     " + stmix_rparm[i][j][i1]);
      }
   }

   // Print covariogram matrix parameter values for this component.

   Vargrm.prntcovmdl_(i + 1);
}

Resdiag.resdiag_("glomap", true);

fprintf_(1, "\n--- END OF GLOMAP MODEL PARAMETER ESTIMATION ---");
return false;
}
}
