class Estglbl extends Surf {
static double x[] = new double[OPTSIZE];
static double g[] = new double[OPTSIZE];
static double h[] = new double[OPTSIZE];

// ------------------------------------------------------------------------

static void estglbl_() {

// Estimates the global parameters of a LOMAP model.

int i = 0, k = 0, vnmbr;

// If not a LOMAP model, stop.

if (nmstmixcntr > 0) {
   iderr_("estglbl: not a LOMAP model");
}

// Set initial values and limits of alpha_S, alpha_T, tau1, tau2.

if (spatial) {

   // Alpha_S

   for (i = 0; i < parm_mvar; ++i) {
      x[k] = datfrac[i];
      g[k] = .1;
      h[k] = 1.;
      ++k;
   }
}

if (temporal) {

   // Alpha_T

   for (i = 0; i < parm_mvar; ++i) {
      x[k] = tlngth[i];
      g[k] = 3.;
      h[k] = 6.;
      ++k;
   }
}

if (trnsfrm) {

   /* Initialize transformation parameters and set their bounds. */

   trnsfrm_tau1[0] = 1.0;
   trnsfrm_tau2[0] = 1.0;
   trnsfrm_invtau1[0] = 1.;
   trnsfrm_invtau2[0] = 1.;

   trnsfrm_tau1[1] = 1.0;
   trnsfrm_tau2[1] = 1.0;
   trnsfrm_invtau1[1] = 1.;
   trnsfrm_invtau2[1] = 1.;
   for (i = 0; i < parm_mvar; ++i) {
      vnmbr = lomapnms[i];

      x[k] = trnsfrm_tau1[i];
      x[k + 1] = trnsfrm_tau2[i];

      // tau1 bounds.

      g[k] = .9 * trnsfrm_tau1[i];
      h[k] = 1.1 * trnsfrm_tau1[i];

      // tau2 bounds.

      g[k + 1] = .9 * trnsfrm_tau2[i];
      h[k + 1] = 1.1 * trnsfrm_tau2[i];

      k += 2;
   }
}

/* Optimize objective function.  **Broken until potential conflict of
   calling "optimiz_" hierarchically are resolved. */

iderr_("estglbl: potential hierarchical call to optimiz_ is broken");

Optimiz.optimiz_(k, 0, x, g, h, 2);
}

// ----------------------------------------------------------------------

static double glblobj_(int n, double x[]) {

/* Evaluates the objective function during the estimation of the global
   parameters (alpha_S, alpha_T, tau1, tau2) of a LOMAP model. */

int i, j = 0, nmskip = 1;
double val = 0.;

// Load values.

for (i = 0; i < parm_mvar; ++i) {
   if (spatial) {
      datfrac[i] = x[j];
      ndmin[i] = (int) (datfrac[i] * ((double) nmsites[i]));
      ++j;
   }
   if (temporal) {
      tlngth[i] = x[j];
      ++j;
   }
   printf_("glblobj: datfrac= " + datfrac[i]);
}

if (trnsfrm) {
   for (i = 0; i < parm_mvar; ++i) {
      trnsfrm_tau1[i] = x[j];
      trnsfrm_tau2[i] = x[j + 1];
      j += 2;
   }
}

// Open a new temporary file.

fleopen_(5, "kest.tmp", 'w');

// Run cross-validation routine, get statistics.

Surfcalcs.crossval_(true, 0, nmskip);

for (i = 0; i < parm_mvar; ++i) {
   val += 1.e-1 * Math.abs(Srfgrd.pbias[i]) +
          8.e-1 * Math.abs(Srfgrd.sebias[i]) +
          1.e-1 * Srfgrd.relrmse[i];
   printf_("glblobj: pbias= " + fdble_(Srfgrd.pbias[i], 8, 4) +
      " sebias= " + fdble_(Srfgrd.sebias[i], 8, 4) + " relrmse= " +
      fdble_(Srfgrd.relrmse[i], 8, 4));
}

printf_("glblobj: val= " + val);
for (i = 0; i < n; ++i) {
   printf_("glblobj: x(" + i + ")= " + fdble_(x[i], 8, 4));
}
iderr_("in glblobj");

return val;
}
}
