class Eqslv extends Krg {

// ---------------------------------------------------------------------

static int eqslvu_() {
 
/* Decomposes matrix stored in common block "form" and solves for xtemp
   using xmeas as the rhs vector(s). */
 
boolean chk = false;
int i, it, j, jt, k;
int ipvt[] = new int[parm_mtot];
double condmx = 1.e+25, error, bchk;
double work[] = new double[parm_mtot];
double b[] = new double[parm_mtot];

/* print A matrix
for (it=1; it <= parm_mtot; ++it) {
   for (jt=1; jt <= parm_mtot; ++jt) printf_(" %5.2lf",form_a[it-1][jt-1]);
   printf_("\n");
} */

// Save form_a in s for later error checking.

for (i = 0; i < parm_mtot; ++i) {
   for (j = 0; j < parm_mtot; ++j) s[i][j] = form_a[i][j];
}

// Decompose A matrix.

cond = decomp_(parm_mtot, form_a, ipvt, work);
if (cond > condmx) {
   printf_("cond= " + cond + " in eqslvu_");
   return 4;
}

// Find solution vector(s).  First, load dummy vector for solution.

for (j = 0; j < parm_mvar; ++j) {
   for (i = 0; i < parm_mtot; ++i) b[i] = form_xmeas[i][j];

   /* Back solve. */

   solve_(parm_mtot, form_a, b, ipvt); 

   for (i = 0; i < parm_mtot; ++i) xtemp[i][j] = b[i];

   /* Optionally, check the accuracy of the solution by computing the sum of
      the errors. */

   if (chk) {
      error = 0.;
      for (i = 0; i < parm_mtot; ++i) {
         bchk = 0.;
         for (k = 0; k < parm_mtot; ++k) bchk += s[i][k] * xtemp[k][j];
         error += Math.abs(form_xmeas[i][j] - bchk);
      }
      printf_("eqslvu: error= " + error);
      if (error > 1.e-6) {
	 iderr_("eqslvu: error too large, terminating.");
      }
   }
}

return 0;
}

// --------------------------------------------------------------------

static double decomp_(int n, double a[][], int ipvt[],
   double work[]) {
 
/* Matrix decomposition routine from G. E. Forsythe et. al.,
   Computer Methods for Mathematical Computations, 1977,
   Prentice-Hall. */
 
int nm1, i, j, k, kp1, kb, km1, m;
double ek, t, anorm, ynorm, znorm;

if (n == 1) iderr_("1x1 matrix in decomp_()");

ipvt[n-1]=1;
nm1=n-1;
 
// Compute 1-norm of a.
 
anorm=0.;
for (j=0; j < n; ++j) {
   t=0.;
   for (i = 0; i < n; ++i) t += Math.abs(a[i][j]);
   if (t > anorm) anorm=t;
}
 
// Gaussian elimination with partial pivoting.
 
for (k=1; k <= nm1; ++k) {
   kp1=k+1;

   // Find pivot.
 
   m=k;
   for (i=kp1; i <= n; ++i) {
      if (Math.abs(a[i-1][k-1]) > Math.abs(a[m-1][k-1])) m=i;
   }
   ipvt[k-1]=m;
   if (m != k) ipvt[n-1] = -ipvt[n-1];
   t=a[m-1][k-1];
   a[m-1][k-1]=a[k-1][k-1];
   a[k-1][k-1]=t;
 
   // Skip step if pivot is zero.
 
   if (t == 0.) continue;
 
   // Compute multipliers.
 
   for (i=kp1-1; i < n; ++i) a[i][k-1] /= -t;
 
   // Interchange and eliminate by columns.
 
   for (j=kp1; j <= n; ++j) {
      t=a[m-1][j-1];
      a[m-1][j-1]=a[k-1][j-1];
      a[k-1][j-1]=t;
      if (t == 0.) continue;
      for (i=kp1-1; i < n; ++i) a[i][j-1] += a[i][k-1]*t;
   }
}
 
// Solve (a-transpose)*y=e.
 
for (k=1; k <= n; ++k) {
   t=0.;
   if (k != 1) {
      km1=k-1;
      for (i = 0; i < km1; ++i) t += a[i][k-1]*work[i];
   }
   ek=1.;
   if (t < 0.) ek = -1.;
   if (a[k-1][k-1] == 0.) return 1.e30; // Exact singularity.
   work[k-1] = -(ek+t)/a[k-1][k-1];
}

for (kb=1; kb <= nm1; ++kb) {
   k=n-kb;
   t=0.;
   kp1=k+1;
   for (i=kp1-1; i < n; ++i) t += a[i][k-1]*work[k-1];
   work[k-1]=t;
   m=ipvt[k-1];
   if (m == k) continue;
   t=work[m-1];
   work[m-1]=work[k-1];
   work[k-1]=t;
}
ynorm=0.;
for (i = 0; i < n; ++i) ynorm += Math.abs(work[i]);
 
// Solve a*z=y.
 
solve_(n,a,work,ipvt);
znorm=0.;
for (i = 0; i < n; ++i) znorm += Math.abs(work[i]);
 
// Estimate condition.
 
if (ynorm == 0.) return 1.e30;
else if (anorm == 0. || znorm == 0.) return 1.;

cond = anorm*znorm/ynorm;
if (cond < 1.) cond=1.;

return cond;
}

// --------------------------------------------------------------------

static void solve_(int n, double a[][], double b[], int ipvt[]) {

/* Solves ax=b, G. E. Forsythe, Computer Methods for Mathematical
   Computations, 1977, Prentice-Hall. */
 
double t;
int kb, km1, nm1, kp1, i, k, m;

if (n == 1) iderr_("1x1 matrix in solve_()");

// Forward elimination.
 
nm1 = n-1;
for (k=1; k <= nm1; ++k) {
   kp1 = k+1;
   m = ipvt[k-1];
   t = b[m-1];
   b[m-1] = b[k-1];
   b[k-1] = t;
   for (i=kp1-1; i < n; ++i) b[i] += a[i][k-1]*t;
}
 
// Back substitution.
 
for (kb=1; kb <= nm1; ++kb) {
   km1 = n-kb;
   k = km1+1;
   b[k-1] /= a[k-1][k-1];
   t = -b[k-1];
   for (i=0; i < km1; ++i) b[i] += a[i][k-1]*t;
}
b[0] /= a[0][0];
}
}
