import java.io.*;

class Eosdata extends Surfcalcs {

// Processes Earth Observation System (EOS) data.

static String intrmdflenme = "eosdata.tmp", varname = "eosvar";

static short background;

static int nmrows, nmcols, minval, maxval;

static double longmin, longmax, latmin, latmax;

// --------------------------------------------------------------------

static void readeos_() {

/* Read an EOS binary data file.  Has been tested with Modis Terra
   Normalized Difference Vegetation Index (NDVI) data.  Note that
   long-lat min-max values are read in getmodl_() and that analysis
   long-lat min-max values, spacetime_lngmx, lngmn, latmx, latmn are
   read withing the "context" section of the .id file. */

short val;

int i, j, inflenm = 9, outflenm = 10;

double longstep, latstep, lng, lat, range, surfval;

// Open raw binary file.

fleopen_(inflenm, spacetime_infle[0], 'r');

// Compute (a) longitude and latitude step sizes, and (b) value range.

longstep = (longmax - longmin) / (double) (nmcols - 1);
latstep = (latmax - latmin) / (double) (nmrows - 1);
range = (double) (maxval - minval);

if (range < 1.e-6) {
   iderr_("readeos: range= " + range);
}

// Read binary file and write intermediate input file.

fleopen_(outflenm, intrmdflenme, 'w');
for (i = 0; i < nmrows; ++i) {
   for (j = 0; j < nmcols; ++j) {
      val = fgetbinint_(inflenm);

      // Check for a valid surface value.

      if (val != background && (val < minval || maxval < val)) {
	 iderr_("readeos: i= " + i + " j= " + j + " val= " + val);
      }

      // Compute longitude and latitude values for this observation.

      lng = longmin + longstep * (double) j;
      lat = latmax - latstep * (double) i;

      /* Write this normalized, nonnegative value to the intermediate
	 EOS data file. */

      if (val == background) surfval = -1.;
      else surfval = ((double) val) / range;

      fwbinflt_(outflenm, lng);
      fwbinflt_(outflenm, lat);
      fwbinflt_(outflenm, spacetime_endtime);
      fwbinflt_(outflenm, surfval);
   }
}
fclose_(inflenm, 'r');
fclose_(outflenm, 'w');
}
}
