import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;

public class Entersvalwind extends Dialog implements ActionListener {

// Creates a new window and receives the surface value to be digitized.

String action;

int i, j, nmpaintcalls = 0;

GISwind giswind;

TextField surfvalentry;

// ---------------------------------------------------------------------

public Entersvalwind (GISwind giswind, String title) {
super(giswind, title, true);
this.giswind = giswind;
setLayout(new FlowLayout(FlowLayout.RIGHT));
setSize(GISwind.mainwinwdth, GISwind.mainwinhght);

// Create an object to handle window events.

EntersvalwindAdapter entersvalwind = new EntersvalwindAdapter(this);

// Register it to receive those events.

addWindowListener(entersvalwind);

// Create buttons to echo input, get help, and to finish.

Button be, bh, bf;
add(be = new Button("Echo input"));
add(bh = new Button("Help"));
add(bf = new Button("Finish"));
be.addActionListener(this);
bh.addActionListener(this);
bf.addActionListener(this);

// Set font, background and foreground colors.

Font f = new Font("SansSerif", Font.PLAIN, 14);
setFont(f);
setBackground(Color.white);
setForeground(Color.black);

/* Display an edit control for the user to input the surface value to
   be digitized. */

surfvalentry = new TextField("0", 5);
add(surfvalentry);
surfvalentry.addActionListener(this);

nmpaintcalls = 0;
}

// ----------------------------------------------------------------------

public void actionPerformed(ActionEvent ae) {
String str;
Helpwindow helpwindow;

// Get action and process it.

str = ae.getActionCommand();
action = str;
if (str.equals("Echo input")) {
   repaint();

} else if (str.equals("Help")) {
   helpwindow = new Helpwindow(this, "Reference point assignment");
   helpwindow.setVisible(true);

} else if (str.equals("Finish")) {
   if (nmpaintcalls < 2) {
      giswind.msg = "Click [Echo input] at least once";
      giswind.repaint();

   } else {
      dispose();
   }
}

}

// ----------------------------------------------------------------------

public void itemStateChanged(ItemEvent ie) {
repaint();
}

// ----------------------------------------------------------------------

public void paint (Graphics g) {

String valstr;

Double tempval;

// Get surface value to be digitized.

valstr = surfvalentry.getText();

if (valstr == null) {
   valstr = "0";
}
tempval = Double.valueOf(valstr);
giswind.surfval = tempval.doubleValue();
giswind.textline_("Surface value to be digitized= " + giswind.surfval);

giswind.repaint();

++nmpaintcalls;
}

}

// ******************************************************************

class EntersvalwindAdapter extends WindowAdapter {
Entersvalwind entersvalwind;

// ------------------------------------------------------------------

public EntersvalwindAdapter (Entersvalwind entersvalwind) {
this.entersvalwind = entersvalwind;
}

// ------------------------------------------------------------------

public void windowClosing(WindowEvent we) {
entersvalwind.setVisible(false);
}

}
