public class Ecosysutils extends Displayactions {

// ----------------------------------------------------------------------

static void obsecoave_(int nmtimes, double timept[]) {

/* Average ecosystem observations within country and time.  Store these
   averages in "actnshstry_obsecoave."  Use these averages for computing
   the MPEMP and for plotting observed versus model output. */

boolean timematch = false;

int i, j, k, varnm = 0, countrynm = 0, ttlnmloaded = 0;

double obsecoval, mdlecoval;

// First, zero-out all arrays.

for (i = 0; i < nmcountries; ++i) {
   for (j = 0; j < nmtimes; ++j) {
      for (k = 0; k < Intridslve.nmecosysnds; ++k) {
         actnshstry_nmobscountry[i][j][k] = 0;
         actnshstry_obsecoave[i][j][k] = 0.;
         actnshstry_obsecotime[i][j][k] = 0.;
      }
   }
}

/* Detect each observation's node, time, and region value before using
   it in the sum. */

for (i = 0; i < nmecoobsttl; ++i) {

   /* Find ecosystem node number, output time index, and country number. */

   varnm = 0;
   for (j = 0; j < Intridslve.nmecosysnds; ++j) {
      if (Intridslve.ecosysnodes[j] == dat2_vrble[0][i]) {
	 varnm = j + 1;
         break;
      }
   }

   if (varnm == 0) {
      printf_("obsecoave: observation index, i= " + i +
         " node number= " + dat2_vrble[0][i] +
         " not a modeled ecosystem node.");
      continue;
   }

   /* Find the closest observed-action-time to this i^th observed-ecosystem
      time. */

   timematch = false;
   for (j = 0; j < nmtimes - 1; ++j) {
      if (timept[j] <= dat2_t[i] && dat2_t[i] <= timept[j + 1]) {
         
	 // Find which of these endpoints is closest.

         if ((dat2_t[i] - timept[j]) > (timept[j + 1] - dat2_t[i])) {
            ++j;
         }
	 timematch = true;
         break;
      }
   }

   printf_("obsecoave: i= " + i + " dat2_t= " + dat2_t[i] + " timept= " +
      timept[j] + " dat2_dat= " + dat2_dat[i] + " timematch= " + timematch);

   if (!timematch) {
      continue;
   }

   // Load this observation.  First, find country number.

   countrynm = Intridslve.regcountrynm[((int) dat2_x[i]) - 1];

   ++actnshstry_nmobscountry[countrynm - 1][j][varnm - 1];
   actnshstry_obsecoave[countrynm - 1][j][varnm - 1] += dat2_dat[i];
   actnshstry_obsecotime[countrynm - 1][j][varnm - 1] += dat2_t[i];
}

/* If a country has no observations, set its observed ecosystem
   variable averages to 0. */

for (i = 0; i < nmcountries; ++i) {
   for (j = 0; j < nmtimes; ++j) {
      ecoobstime[i][j] = false;
      ecomdltime[i][j] = true;
      for (k = 0; k < Intridslve.nmecosysnds; ++k) {
         if (actnshstry_nmobscountry[i][j][k] > 0) {
            ecoobstime[i][j] = true;
            actnshstry_obsecoave[i][j][k] /=
               (double) actnshstry_nmobscountry[i][j][k];
            actnshstry_obsecotime[i][j][k] /=
               (double) actnshstry_nmobscountry[i][j][k];
            ttlnmloaded += actnshstry_nmobscountry[i][j][k];

         } else {
	    actnshstry_obsecoave[i][j][k] = 0.;
	    actnshstry_obsecotime[i][j][k] = 0.;
	 }
      }
   }
}

if (ttlnmloaded == 0) {
   iderr_("obsecoave: ttlnmloaded=0");
}

/* Find the min, max of the observations on each ecosystem variable and
   compute the average of these observations across countries and at each
   time point.  Note that the model-based average has already been
   computed in "ecosysupdate_." */

for (i = 0; i < Intridslve.nmecosysnds; ++i) {
   ecomin[i] = 1.e6;
   ecomax[i] = 0.;
   for (j = 0; j < nmtimes; ++j) {
      obsecograndave[0][j][i] = 0.;
      for (k = 0; k < nmcountries; ++k) {
         obsecoval = actnshstry_obsecoave[k][j][i];
         if (ecomin[i] > obsecoval) {
            ecomin[i] = obsecoval;
         }

         if (ecomax[i] < obsecoval) {
            ecomax[i] = obsecoval;
         }
         obsecograndave[0][j][i] += obsecoval;
      }
   }
   for (j = 0; j < nmtimes; ++j) {
      obsecograndave[0][j][i] /= (double) nmcountries;
   }

   // Don't allow a negative lower limit.

   if (ecomin[i] < 0.) {
      ecomin[i] = 0.;
   }

   if (ecomax[i] - ecomin[i] < 1.e-8) {
   
      // ecomin = ecomax causes major bugs so is arbitrarily reset.
      
      printf_("obsecoave: econode= " + (i + 1) +
         " ecomin=ecomax, resetting to ecomax=ecomin+1");
      ecomax[i] = ecomin[i] + 1.;
   }

   // Enlarge the upper limit a little.

   ecomax[i] *= 1.5;
}

if (findmpemp) {

   return;
}

// Print the observed averages.

fprintf_(1, "\n   Observed Ecosystem Variables Averaged Over Countries"
   + "\n Time   Variable_1    Variable_2");

for (j = 0; j < nmtimes; ++j) {
   fprintf_(1, fdble_(actnshstry_obsactntime[j], 7, 2) + "    " +
      fdble_(obsecograndave[0][j][0], 7, 4) + "    " +
      fdble_(obsecograndave[0][j][1], 7, 4));
}
}

// ----------------------------------------------------------------------

static void obsecorgn_(int nmobsrgns, int nmtimes, double timept[]) {

/* Average ecosystem observations within region and time.  Store these
   averages in "actnshstry_obsecoave."  Use these averages for creating
   the raw observations plot in "Displayeco.ploteco_." */

String ndname = "none";

boolean timematch = false;

int i, j, k, varnm = 0, regionnm = 0;

double obsecoval, mdlecoval;

// First, zero-out all arrays.

for (i = 0; i < TNMVALS; ++i) {
   for (j = 0; j < MAXTIMES; ++j) {
      for (k = 0; k < MAXNMECO; ++k) {
         actnshstry_nmobscountry[i][j][k] = 0;
         actnshstry_obsecoave[i][j][k] = 0.;
         actnshstry_obsecotime[i][j][k] = 0.;
         ecomin[k] = 0.;
	 ecomax[k] = 0.;
      }
   }
}

/* Detect each observation's node, time, and region value before using
   it in the sum. */

for (i = 0; i < nmecoobsttl; ++i) {

   // Find ecosystem node number, output time index, and region number.

   varnm = 0;
   for (j = 0; j < nmobsnds; ++j) {
      if (obsndnm[j] == dat2_vrble[0][i]) {
	 varnm = j + 1;
         break;
      }
   }

   if (varnm == 0) {
      iderr_("obsecorgn: i= " + i + " varnm=0");
   }

   /* Find the closest observed-action-time to this i^th observed-ecosystem
      time.  "j" is used below. */

   timematch = false;
   for (j = 0; j < nmtimes - 1; ++j) {
      if (timept[j] <= dat2_t[i] && dat2_t[i] < timept[j + 1]) {
         
	 /* Find which of these endpoints is closest but reserve "j=0"
	    for below. */

         if (j == 0 || (dat2_t[i] - timept[j]) >
	               (timept[j + 1] - dat2_t[i])) {
            ++j;
         }
	 timematch = true;
         break;
      }
   }

   // Check for values earlier than "timept[0]." 

   if (starttime[0] <= dat2_t[i] && dat2_t[i] < timept[0]) {
      j = 0;
      timematch = true;
   }

   // Add time points as necessary to the end of the "timept" array.

   if (timept[nmtimes - 1] <= dat2_t[i]) {
      timept[nmtimes] = dat2_t[i];
      j = nmtimes;
      ++nmtimes;
      timematch = true;
   }

   if (!timematch) {
      continue;
   }

   // Find each variable's maximum.

   if (ecomax[varnm - 1] < dat2_dat[i]) {
      ecomax[varnm - 1] = dat2_dat[i];
   }

   // Load this observation.  First, get the region number.

   regionnm = (int) dat2_x[i];
   ++actnshstry_nmobscountry[regionnm - 1][j][varnm - 1];
   actnshstry_obsecoave[regionnm - 1][j][varnm - 1] += dat2_dat[i];
   actnshstry_obsecotime[regionnm - 1][j][varnm - 1] += dat2_t[i];
}

/* Update "nmactiontimes" in ploteco_() with this new "nmtimes" value.
   Note, this is one way to modify a scalar that was passed by value
   into this routine. */

nmactiontimes = nmtimes;

// If the end-time is zero, something is wrong.

if (endtime < 1.e-6) {
   iderr_("obsecorgn: endtime= " + endtime);
}

/* Divide the above sums by the number of observations.  If a region has
   no observations, set its observed ecosystem variable averages to 0.
   Optionally, normalize these averages by dividing them by the variable's
   maximum value. */

for (i = 0; i < Intridslve.nmregions; ++i) {
   for (j = 0; j < nmtimes; ++j) {
      ecoobstime[i][j] = false;
      ecomdltime[i][j] = true;
      for (k = 0; k < nmobsnds; ++k) {
         if (actnshstry_nmobscountry[i][j][k] > 0) {
            ecoobstime[i][j] = true;

            actnshstry_obsecoave[i][j][k] /=
               (double) actnshstry_nmobscountry[i][j][k];
            
	    // actnshstry_obsecoave[i][j][k] /= ecomax[k];

            actnshstry_obsecotime[i][j][k] /=
               (double) actnshstry_nmobscountry[i][j][k];

         } else {
	    actnshstry_obsecoave[i][j][k] = 0.;
	    actnshstry_obsecotime[i][j][k] = 0.;
	 }
      }
   }
}

for (i = 0; i < nmobsnds; ++i) {
   if (ecomax[i] - ecomin[i] < 1.e-8) {
   
      // ecomin = ecomax causes major bugs so is arbitrarily reset.
      
      printf_("obsecorgn: econode= " + i +
         " ecomin=ecomax, resetting to ecomax=ecomin+1");
      ecomax[i] = ecomin[i] + 1.;
   }

   ndname = nodelbls[nmids - 1][obsndnm[i] - 1][0];
 
   // Enlarge the upper limit a little.

   ecomax[i] *= 1.5;
}
}

// ----------------------------------------------------------------------

static void mdlecoPrint_(boolean herbivores, boolean countryaverages) {

/* Print the model-output averages -- note that model-based averages
   have already been computed in "ecosysupdate_."   Also, set each
   time's indicator of an ecosystem variable value to "true." */

String patchname;

int i, j, k, ttlnmpatches, regionnodenumber;

double meanabundance = 0.;

if (herbivores) {
   ttlnmpatches = HIBMcalcs.ttlnmpatches;

} else {
   ttlnmpatches = PIBMcalcs.ttlnmpatches;
}

regionnodenumber = Getmodlutils.getndnm_(regionnode);

if (!countryaverages) {
   fprintf_(1,
      "\n   Model-Generated Animal Abundance Per Patch (Region)" +
      "\n Region   Mean_Abundance_at_End-Time");

   if (ttlnmpatches != nodenghs[idnmbrm1][regionnodenumber - 1][0]) {
      iderr_("mdlecoPrint: ttlnmpatches= " + ttlnmpatches);
   }

   for (i = 1; i <= ttlnmpatches; ++i) {
      patchname = nodelbls[idnmbrm1][regionnodenumber - 1][i];

      if (herbivores) {
         meanabundance = HIBMcalcs.meanabundance[i - 1];
     
      } else {
         meanabundance = PIBMcalcs.meanabundance[i - 1];
      }

      fprintf_(1, " " + patchname + "   " + fdble_(meanabundance, 7, 4));
   }

return;
}

fprintf_(1,
   "\n   Model-Generated Ecosystem Variables Averaged Over Countries" +
   " in Countries" +
   "\n Country   Time   Variable_1    Variable_2");

for (i = 0; i < nmcountries; ++i) {
   for (j = 0; j < Intridslve.nmmdltimes; ++j) {
      fprintf_(1, "  " + countrymap[i] + "  " +
         fdble_(Intridslve.tmept[j], 7, 2) + "    " +
         fdble_(actnshstry_mdlecoave[i][j][0], 7, 4) + "    " +
         fdble_(actnshstry_mdlecoave[i][j][1], 7, 4));
      ecomdltime[i][j] = true;
   }
}

if (!cacalc) {

   // Find average model-output ecosystem variable min and max values.

   for (i = 0; i < Intridslve.nmecosysnds; ++i) {
      ecomin[i] = 1.e30;
      ecomax[i] = 0.;
      for (j = 0; j < nmcountries; ++j) {
         for (k = 0; k < Intridslve.nmmdltimes; ++k) {
            if (actnshstry_mdlecoave[j][k][i] < ecomin[i]) {
               ecomin[i] = actnshstry_mdlecoave[j][k][i];
            }
	    if (ecomax[i] < actnshstry_mdlecoave[j][k][i]) {
	       ecomax[i] = actnshstry_mdlecoave[j][k][i];
	    }
	 }
      }
  
      // ecomin = ecomax causes major bugs so is arbitrarily reset.

      if (ecomax[i] - ecomin[i] < 1.e-8) {
         printf_("mdleco: econode= " + i +
             " ecomin=ecomax, resetting to ecomax=ecomin+1");
         ecomax[i] = ecomin[i] + 1.;
      }
   }
}
}
}
