class Ecosyscalcs extends Update {

static boolean areacalcs = false, skipeco = false;

static boolean firsttimepoint[] = new boolean[NMTHRDS];
static boolean computeregion[] = new boolean[TNMVALS];

static String ecorlztnsfle = "none", riskfle = "none";

static String patchdefflename;

static int capntotal = 500, capn, nmobsrvd = 0, reportnode,
   ecorlztnsflenm = 9;

static int residregion[] = new int[DATSZE];
static int obsvar[][] = new int[DATSZE][MAXNMECO];
static int indx[] = new int[SIMSZE];

static double tbegin, capt, ibmdelta, maxdelta, delta, sqrtdelta, lastt;

static double pdfest[] = new double[SIMSZE];
static double xobs[][] = new double[SIMSZE][TNMNDS];
static double mean[][] = new double[TNMVALS][TNMNDS];
static double obsrvdval[][] = new double[DATSZE][TNMNDS];
static double modelval[][] = new double[DATSZE][TNMNDS];
static double resids[][] = new double[DATSZE][TNMNDS];
static double sensmean[][] = new double[DATSZE][TNMNDS];
static double residtime[] = new double[DATSZE];
static double wghtssum[] = new double[TNMVALS];
static double grandave[] = new double[MAXNMECO];

// --------------------------------------------------------------------

static void ecosysupdate_(int tindex, double t, boolean initialaction) {

/* Ecosystem ID.  At every time step, find the marginal distributions
   of the ecosystem ID over each region and post the weighted average
   of these to the bulletin board.

   ** Note that this averaging over regions is necessary because the
   group IDs are not region-specific. **
	    
   Assumes that all input action nodes were set in "readactions."
	    
   A time-stepping function's start time is always "Ecosyscalcs.tend"
   (which was set on the previous run of the ecosystem ID).  Start and
   stop times for a time-stepping function solution are set in
   "settime." */

boolean ecopflag, testflag = false;

int i, j, k, rgnareanode = 0, regioncountry = 0, inactorcountry = 0;

double mean = 0., stddev = 0., wght = 0.;

// Defensive programming!

idnmbrm1 = nmids - 1;

// Skip ecosystem computations for speed or debug reasons.

if (skipeco) {
   for (i = 0; i <= nmcountries; ++i) {
      for (j = 0; j < Intridslve.nmecosysnds; ++j) {
         Intridslve.wghtdave[i][j] = .1;
         Intridslve.wghtdstd[i][j] = .1;
         CA.actnshstry_mdlecoave[i][0][j] = .1;
      }
   }

   return;
}

/*
// -----------------------------------------------------------------
// For a book-exercise solution and rhino EMT debugging: 
for (i = 0; i <= nmcountries; ++i) {
   for (j = 0; j < Intridslve.nmecosysnds; ++j) {
      Intridslve.wghtdave[i][j] = .1;
      Intridslve.wghtdstd[i][j] = .1;
      CA.actnshstry_mdlecoave[i][0][j] = 2000. - 200. * (t - 2013.);
   }
}
if (Intridslve.ipflag) {
   printf_("ecosysupdate: t= " + fdble_(t, 4, 3) + " " + (1) + " " +
      (1) + " " + CA.actnshstry_mdlecoave[0][0][0] + " " + (1.0));
   fprintf_(2, "ecovals " + fdble_(t, 4, 3) + " " + (1) + " " +
      (1) + " " + CA.actnshstry_mdlecoave[0][0][0] + " " + (1.0));
}
if (true) return;
// -----------------------------------------------------------------
*/

// Load the ecosystem ID's conditioning node numbers.

nmcondnds = 3;
condnodes[idnmbrm1][0] = Intridslve.timenode[idnmbrm1];
condnodes[idnmbrm1][1] = Intridslve.ecoinactnnode;
condnodes[idnmbrm1][2] = Intridslve.ecorgnnode;

// Set the time value.

condvaltype[0] = "continuous";
condvals[0] = t;

// Set the input action's type. 

condvaltype[1] = "discrete";

// Get region area node number.

if (areacalcs) {
   rgnareanode = Getmodlutils.getndnm_("LArea");
}

// Zero ecosystem node weighted average arrays,

for (i = 0; i <= nmcountries; ++i) {
   wghtssum[i] = 0.;
   for (j = 0; j < Intridslve.nmecosysnds; ++j) {
      Intridslve.wghtdave[i][j] = 0.;
      Intridslve.wghtdstd[i][j] = 0.;
   }
}

// Set the number of nodes.

nmnds = Intridslve.nmndes[idnmbrm1];

// Compute the model over the desired regions.

for (i = 1; i <= Intridslve.nmregions; ++i) {
   if (!computeregion[i - 1]) {

      continue;
   }

   /* Set the region node.  It is assumed that this was the last
      conditioning node added to the "condvals" array. */

   condvals[nmcondnds - 1] = i;

   // Get the region's country, and the actor's country.

   regioncountry = Intridslve.regcountrynm[i - 1];
   inactorcountry = Displayutils.getcountrynm_(Intridutils.ecosysinactor);

   /*
   printf_("ecosysupdate: ecosysinactor= " + Intridutils.ecosysinactor);
   printf_("ecosysupdate: nmcountries= " + nmcountries + " regioncountry= "
      + regioncountry + " inactorcountry= " + inactorcountry);
   */

   // Get the input action to the ecosystem.
   
   /*
   printf_("ecosysupdate: nmregions= " + Intridslve.nmregions +
      " initialaction= " + initialaction);
   */

   if (initialaction) {
      condvals[1] = Getmodlutils.getndval_(Intridslve.ecoinactnnode,
         "beginning_state", false);

   } else if (nmcountries > 1 && regioncountry != inactorcountry) {
   
     /* Run the default in-action if the in-actor does not reside in the
        same country as this region. */

      condvals[1] = Intridutils.defaultecoactn;

   } else {

      // Use the eco-action read in readactions_().

      condvals[1] = Intridutils.ecoactn;

      if (nmids == 1) {

         /* This section is necessary because when there is only one ID,
	    readactions_() is not called so the assignment of a value to
            "ecoinput" that occurs there, does not happen. */

         if (dsensanalysis) {
	    Intridslve.actions_ecoinput[0] =
               Intridslve.actions_econoutput[0][0][0];

         } else if (t < 2008.) {
            Intridslve.actions_ecoinput[0] = 0;

         } else {
            Intridslve.actions_ecoinput[0] = 20;
         }
      }
   }

   // Check the input action node value.

   if (condvals[1] <= 0 ||
       condvals[1] > nodenghs[idnmbrm1][Intridslve.ecoinactnnode - 1][0]) {
      iderr_("ecosysupdate: ecosystem management option number= " +
         condvals[1]);
   }

   /* Run "beliefs" to compute all marginal distributions on ecosystem
      ID nodes.
      printf_("ecosysupdate: t= " + t + " condvals1= " + condvals[1] +
         " calling beliefs");
   */

   beliefs_(1, CA.ch);

   /* Note that there is no need to zero-out ecosystem input variables here
      because that is always performed at the beginning of a time step in
      intridslve_(). */
   
   // Check for a bad outflag value.
   /*
   if (tindex == 3) {
      iderr_("in ecosysupdate");
   }
   */


   if (nmids > 1 && !outflag[1]) {
      iderr_("ecosysupdate: IntIDs model, outflag[1]= false, region= " +
         i + " beltmept1= " + beltmept[1] + " outputtime0= " + outputtime[0] +
	 "\n   beltmept-outputtime0= " + (beltmept[1] - outputtime[0]) +
         " .5 * delta= " + (.5 * delta));
   }

   // Compute the hypothesis distribution agreement.

   if (cacalc) {
      ecosysgcalcs_(i, t, tindex);
   }

   /* Compute the by-country-and-time weighted average of each ecosystem
      output node.  Use region areas as weights.  Array dimensions of
      "mdlecoval" are region, time, variable.  Array dimensions of "mdecoave"
      are country, time, variable. */

   for (k = 0; k < nmcountries; ++k) {
      if (Intridslve.regcountrynm[i - 1] != (k + 1)) {
	 continue;
      }

      // Get weight value.
   
      if (areacalcs) {
         wght = condprb[idnmbrm1][rgnareanode - 1][0][i - 1]
	               [0][0][0][0][0][0];

      } else {
         wght = 1.;
      }

      for (j = 0; j < Intridslve.nmecosysnds; ++j) {
         reportnode = Intridslve.ecosysnodes[j];

         if (tindex == 2) {

	    // Initialize each region.

            CA.actnshstry_mdlecoval[i - 1][0][j] = 
	       initialvals[reportnode - 1];

	    // Initialize the weighted average.

            CA.actnshstry_mdlecoave[k][0][j] += wght *
	       initialvals[reportnode - 1];
         }

         if (!loadconsdst) {
            mean = beliefh[0][0][reportnode - 1][0];
	    stddev = beliefh[0][0][reportnode - 1][1];

         } else {
            mean = beliefc[0][0][reportnode - 1][0];
	    stddev = beliefc[0][0][reportnode - 1][1];
         }
        
	 // Reset Not-a-Number strings.

	 if (Double.isNaN(mean)) {
	    printf_("ecosyscalcs: tindex= " + tindex + " mean=NaN");
	    mean = -1.;
	 }
	 if (Double.isNaN(stddev)) {
	    printf_("ecosyscalcs: tindex= " + tindex + " stddev=NaN");
	    stddev = -1.;
	 }

         CA.actnshstry_mdlecoval[i - 1][tindex - 1][j] = mean;
         CA.actnshstry_mdlecoave[k][tindex - 1][j] += wght * mean;

         Intridslve.wghtdave[k + 1][j] += wght * mean;
         Intridslve.wghtdstd[k + 1][j] += wght * stddev;
      } // End of loop over ecosystem nodes (j loop).
      wghtssum[k] += wght;
   } // End of loop over countries (k loop).
}

/* Finish computing ecosystem node weighted averages and post these
   new ecosystem state node values to the bulletin board. */

for (k = 0; k < Intridslve.nmecosysnds; ++k) {
   grandave[k] = 0.;
}
for (i = 0; i < nmcountries; ++i) {
   if (wghtssum[i] < 1.e-6) {
      wghtssum[i] = 1.;
   }
   for (k = 0; k < Intridslve.nmecosysnds; ++k) {
      if (tindex == 2) {
         CA.actnshstry_mdlecoave[i][0][k] /= wghtssum[i];
      }
      CA.actnshstry_mdlecoave[i][tindex - 1][k] /= wghtssum[i];

      /*
      printf_("ecosysupdate: t= " + t + " mdlecoave= " +
         CA.actnshstry_mdlecoave[i][tindex - 1][k]);
      */

      Intridslve.wghtdave[i + 1][k] /= wghtssum[i];
      Intridslve.wghtdstd[i + 1][k] /= wghtssum[i];

      grandave[k] += Intridslve.wghtdave[i + 1][k];

      if (Intridslve.ipflag && !issms) {

	 /* Print country averages only if at least one region is
	    represented. */

         ecopflag = false;
         for (j = 0; j < Intridslve.nmregions; ++j) {
            if (computeregion[j] &&
                Intridslve.regcountrynm[j] == (i + 1)) {
	       ecopflag = true;
	       break;
	    }
         }
	 if (!ecopflag) {
            continue;
	 }

         // Write these values to the actions history file.

         fprintf_(2, "ecovals " + fdble_(t, 4, 3) + " " + (i + 1) + " " +
	    (k + 1) + " " + Intridslve.wghtdave[i + 1][k] + " " +
	       Intridslve.wghtdstd[i + 1][k]);
      }
   } // End of loop over ecosystem nodes (k loop).
} // End of loop over countries (i loop).

/* Compute the grand weighted average (aggregated across all countries)
   and store it in position "0." */

for (k = 0; k < Intridslve.nmecosysnds; ++k) {
   Intridslve.wghtdave[0][k] = grandave[k] / (double) nmcountries;
}
}

// ----------------------------------------------------------------------

static void ecosysgcalcs_(int region, double t, int tindex) {

/* Compute gh and gs for the ecosystem ID for this region and time
   combination.

   "simdata" dimensions are: realization#, node#, distribution.

   "margsimdat" dimensions are: observation#, node#. */

int i, j, k, econdnm = 0, nmvarsobs = 0, var;

double negmad, diff;

if (issms) {
   for (i = 0; i < SMScalcs.nmanimals; ++i) {
      pdfest[0] = Densest.densest5_(enmloops, SMScalcs.nmsteps, i,
		                    SMScalcs.path, SMScalcs.subsnmsteps[i],
		                    SMScalcs.subspath[i]);
   
      /* Let m = number of animals.  The variable "diff" is the negative
         of the Hellinger distance between a size-m sample and the model.
       	 The Hellinger distance is the sum of the absolute differences
	 between the square root of the model-based density at the
	 observed value -- and the square root of the proportion of the
	 sample that has this value.  Because only one path has been
	 observed for each animal, the proportion is always 1/m.  See
	 Lindsay (1994, p. 1082).
         
	 If however, there were replication, the Hellinger distance,
	 being an integral would need to be approximated.  One way is
	 to use Monte Carlo integration.  But note that a sample can be
	 viewed as a set of random points at which to evaluate an
	 integral.  The Monte Carlo approximation to an integral is
	 the sum of the integrand evaluated at these random points
	 multiplied by the range divided by the number of random points
	 which is the expected size of dx.  Therefore, the Hellinger
	 distance is approximated up to a scaling constant by this sum
	 divided by n.

      diff = -Math.abs(1. / ((double) SMScalcs.nmanimals) -
                       Math.sqrt(pdfest[0]));
	 */
      
      /* Simulated (log) likelihood: */

      diff = Math.log(pdfest[0]);

      CA.gs_eco += diff;
   }
   return;
}

/* -------------------- gh computation ----------------------------

   Build the sum of ecosystem ID "gh" values across all regions and at
   the last time point only by using the "gh" value for this region and
   time point that was computed in "beliefs." */

if (CA.ch > 0. && tindex == Intridslve.nmmdltimes) {
   CA.gh_eco += gh_measure;
   ++CA.nmgh_eco;

   //printf_("ecosysgcalcs: tindex= " + tindex + " gh_measure= " + gh_measure +
   //   " nmgh_eco= " + CA.nmgh_eco);
}

// -------------------- gs computation ----------------------------

for (i = 0; i < Intridslve.nmecosysnds; ++i) {
   xobs[0][i] = 0.;
}

/* If this region has been observed at this time, "t," load the single
   multivariate observation for this region (identified by (int) dat2_x)
   and at this time, "t."  Note that the following code loads up to
   "CA.nmobsnds" values into the array xobs[0]. */

for (i = 0; i < nmecoobsttl; ++i) {
      
   if (Math.abs(dat2_x[i] - (double) region) < 1.e-6 &&
       lastt < dat2_t[i] && dat2_t[i] <= t) {

      for (j = 0; j < CA.nmobsnds; ++j) {
	 if (dat2_vrble[0][i] == CA.obsndnm[j]) {
            obsvar[nmobsrvd][j] = CA.obsndnm[j];
	    xobs[0][j] = dat2_dat[i];
	    ++nmvarsobs;

	    // Always store region and time for each observation.
	 
            residregion[nmobsrvd] = (int) dat2_x[i];
            residtime[nmobsrvd] = dat2_t[i];

	    /* Now, break since for this i^th datum, there can be
	       only one observation. */

            break;
	 }
      }
   }
   if (nmvarsobs == CA.nmobsnds) {
      break;
   }
}

if (nmvarsobs == 0) {
   return;
}

/* If this region and time point has been observed, compute the
   negative Hellinger distance from the current ecosystem ID
   distribution to the data point that is within this region.  Find
   the sum of these values.  First, load simulated data. */

for (j = 0; j < Intridslve.nmecosysnds; ++j) {
   mean[region - 1][j] = 0.;
}
for (j = 0; j < enmloops; ++j) {
   for (k = 0; k < CA.nmobsnds; ++k) {
      if (obsvar[nmobsrvd][k] > 0) {
         CA.margsimdat[j][k] = simdata[0][j][obsvar[nmobsrvd][k] - 1][1];

         // Compute means of simulated values.
       
         //printf_("ecosysgcalcs: t= " + t + " j= " + j + " margsimdat= " +
         // CA.margsimdat[j][k]);

         mean[region - 1][k] += CA.margsimdat[j][k];
      }
   }
}
   
// Compute means or medians of simulated variables.

for (j = 0; j < CA.nmobsnds; ++j) {
   mean[region - 1][j] = 0.;
   if (obsvar[nmobsrvd][j] > 0) {
      for (i = 0; i < enmloops; ++i) {
         pdfest[i] = CA.margsimdat[i][j];
         indx[i] = i + 1;
         mean[region - 1][j] += pdfest[i];
      }
      Idsort.idsort_(pdfest, indx, 1, enmloops);
      //mean[region - 1][j] = pdfest[enmloops / 2];
      mean[region - 1][j] /= ((double) enmloops);
   }
}

// Define and compute residuals as Observed - Model-Computed_Mean.

diff = 0.;
negmad = 0.;
for (j = 0; j < CA.nmobsnds; ++j) {
   if (obsvar[nmobsrvd][j] > 0) {
      obsrvdval[nmobsrvd][j] = xobs[0][j];
      modelval[nmobsrvd][j] = mean[region - 1][j];
      resids[nmobsrvd][j] = xobs[0][j] - mean[region - 1][j];

      //printf_("ecosysgcalcs: t= " + t + " xobs= " + xobs[0][j] +
      //   " mean= " + mean[region - 1][j]);

   } else {
      continue;
   }

   /* The variable "negmad" is the negative sum of the absolute values
      of the standardized residuals (the negative of the so-called "MAD"
      statistic).  The negative sign is needed to make "gs_eco" an
      agreement measure. */

   if (Math.abs(xobs[0][j]) < 1.e-6) {
      negmad += -1. * Math.abs(resids[nmobsrvd][j]);

   } else {
      negmad += -1. * Math.abs(resids[nmobsrvd][j] / xobs[0][j]);
   }
}

++nmobsrvd;

// gs defined as the negative sum of median residuals.

CA.gs_eco += negmad;
}

//------------------------------------------------------------------

static void settime_(boolean isabm, boolean issms) {

/* Initialize "tbegin," "capt," and "capn" for the current segment of
   time over which the time-stepping function's solution is to be
   computed.  Note that for one ID, "tbegin" is read in "getmodl_." */

boolean writeflag = false;

int i;

double rcapn = 0.;

// Set the solution's capital "T" value.

capt = spacetime_tmax;

/* Compute delta and Capital N.  For an IntIDs run, the "capntotal" value
   determines "delta" for the entire solution history. */

if (initialIntridsTime) {

   if (!Intridslve.findtimesteps) {

      return;
   }

   if (issms) {
      capntotal = 1;

   } else if (idinfo_nmsdes[nmids - 1] > 0) {
      capntotal = 1000; // was 10000
   }

   if (idinfo_hashibm[nmids - 1] || idinfo_haspibm[nmids - 1]) {
	         
      /* Assuming time is measured in years, set an IBM's time step
         to 1 week. */

      ibmdelta = 1. / 52.;
   }

   /* "maxdelta" is the entire time interval divided by "capntotal."
      Intridslve.t0 is read in getmodl_() */

   maxdelta = (Intridslve.tfinal - Intridslve.t0) / (double) capntotal;
   delta = maxdelta;

   /* For an IntIDs run, set the initial interval to two "delta" steps
      back from "capt."  For an individual ID run, "tbegin" has been
      read in getmodl_(). */

   if (nmids > 1) {
      tbegin = capt - 2. * delta;
   }

   capn = (int) ((capt - tbegin) / delta);

   // Don't shutdown if capn < 1 because the IBM will not start if you do.
 
   if (capn < 1) {
      printf_("settime: capn= " + capn + " resetting to 1.");
      capn = 1;
   }
   
   printf_("\nsettime: tbegin= " + tbegin + " capt= " + capt +
      " capntotal= " + capntotal + " capn= " + capn +
      "\n   maxdelta= " + fdble_(maxdelta, 8, 5) +
      " delta= " + fdble_(delta, 8, 5) +
      " t0= " + fdble_(Intridslve.t0, 8, 3) +
      " tfinal= " + fdble_(Intridslve.tfinal, 8, 3));

   if (writeflag && Optimiz.funevals < 2) {
      fprintf_(1,
         "\n-----Initialization Time-Stepping Function Solution -----" +
         "\n   t0= " + Intridslve.t0 + " tbegin= " + fdble_(tbegin, 8, 3) +
	 " tfinal= " + Intridslve.tfinal + " delta= " +
	 fdble_(delta, 8, 3) +
	 "\n   capntotal= " + capntotal + "\n");
      writeflag = false;
   }

   if (delta < 1.e-6) {
      iderr_("   delta= " + delta);
   }

   Intridslve.findtimesteps = false;

} else {

   /* Compute a new "tbegin" value and then adjust "delta" as
      necessary so that the maximum delta is never exceeded. */

   tbegin = Intridslve.t - Intridslve.tstep; 
   rcapn = (capt - tbegin) / maxdelta;
   capn = (int) Math.round(rcapn);
   if (capn == 0) {
      capn = 1;
   }

   /* The following works because "nmtimepts" in Conddist.java
      is 1 + "capn" so if "capn" is 0, only one time point is
      evaluated.  If "capn" is >= 1, then "delta" correctly
      partions the interval, (Intridslve.t, capt). */

   delta = (capt - tbegin) / ((double) (capn + 1));

   /* Add "delta" to "tbegin" so that the SDE solver solves up to
      that value on its first call (see "beltmept" in Conddist.java
      and sdesol_(), above). */

   tbegin += delta;
}
sqrtdelta = Math.sqrt(delta);

// Check for feasible "tbegin," and "capt" values.

if (capt < tbegin || tbegin < 0. || capt < 0.) {
   iderr_("settime: tbegin= " + tbegin + " capt= " + capt +
      " tmin= " + spacetime_tmin +
      "\n   tmax= " + spacetime_tmax + " capn= " + capn + " delta= " +
      delta + " maxdelta= " + maxdelta);
}
}
}
