public class Econcalcs extends Beliefs {

static boolean pricecontrols = false, poachercapacity = false;

static boolean trader_illegal[] = new boolean[NMAGNTS];
static boolean consumer_purchaseevent[][][] =
   new boolean[NMTHRDS][ASIMSZE][NMAGNTS];

static String strategy = "none";

static int printcounter = 0, nmtraders, nmlegaltraders, actnval = 0;

static int maxnmcnsmrs[] = new int[NMTHRDS];
static int trader_nmsold[][][] = new int[NMTHRDS][ASIMSZE][NMAGNTS];

static double ra, reserveprice, pricelimit, poachprob = 0.,
   oneminusnmce = .9999, currentpop = 0.;

static double trader_unitprice[][][] = new double[NMTHRDS][ASIMSZE][NMAGNTS];
static double trader_priceq[][][] = new double[NMTHRDS][ASIMSZE][NMAGNTS];
static double trader_maxcap[] = new double[NMAGNTS];
static double trader_maxnetrev[] = new double[NMAGNTS];
static double trader_prodcap[][][] = new double[NMTHRDS][ASIMSZE][NMAGNTS];
static double trader_netrevold[][][] = new double[NMTHRDS][ASIMSZE][NMAGNTS];
static double trader_capq[][][] = new double[NMTHRDS][ASIMSZE][NMAGNTS];
static double trader_unitcost[] = new double[NMAGNTS];
static double trader_liquidityreserve[][][] =
   new double[NMTHRDS][ASIMSZE][NMAGNTS];
static double ordersize[] = new double[NMTHRDS];
static double nmlegalsold[] = new double[NMTHRDS];
static double nmillegalsold[] = new double[NMTHRDS];
static double legalprice[] = new double[NMTHRDS];
static double illegalprice[] = new double[NMTHRDS];
static double popt[] = new double[4];
static double pop[] = new double[4];

// -------------------------------------------------------------------

public static void step_(int thrd, double nodevals[][][],
   double yn[][], int dst) {

/* Steps an agent-based economics model of consumers and traders
   forward one time step.  This method is called at time intervals
   equal to the rhino IBM's step size which is one week.  All prices
   and costs herein are in U.S. dollars. */

int i, j, pth, nmsuccesses, besttrdr, nmcnsmrs = 0, dstm1 = dst - 1;

double unif, res, netrev, successprob, priceold, pricemin, prodcapkg = 0.,
   nmkgsold = 0., orderprob, popest = 0., ressave = 0.;

// Get sample path.

pth = idenom[thrd];

// At the first time point only, initialize the model.

if (Ecosyscalcs.firsttimepoint[thrd] && initialIntridsTime) {
   initializeagents_(thrd, pth, nodevals);
}

// Each trader decides on a selling price.

ordersize[thrd] = 0.;
nmlegalsold[thrd] = 0.;
nmillegalsold[thrd] = 0.;
for (i = 0; i < nmtraders; ++i) {

   /* First, compute the response value (Catullo, equation 10).  Convert
      production capacity units to kilograms by multiplying it by 5 kg. */

   priceold = trader_unitprice[thrd][pth][i];

   prodcapkg = 5. * trader_prodcap[thrd][pth][i];
   nmkgsold = (double) trader_nmsold[thrd][pth][i];
   if (!Ecosyscalcs.firsttimepoint[thrd] && prodcapkg >= 5. &&
       nmkgsold <= prodcapkg) {
      res = (prodcapkg - nmkgsold) / prodcapkg;

      /* If demand has exceeded capacity, see if consumers will bear a
         bit higher price. */
      
      if (nmkgsold >= .9 * prodcapkg) {
         res = -.01;
      }

   } else {
      res = 0.;
   }
   ressave = res;

   res = priceold * (1. - res);

   /* Next, compute q (Catullo, equation 8) and then sample once from
      a normal distribution with mean q and standard deviation of
      200 U.S. dollars to obtain a price. */

   trader_priceq[thrd][pth][i] =
      (1. - ra) * trader_priceq[thrd][pth][i] + ra * res;

   /*
   if (trader_illegal[i] && thrd == 1 && pth == 1) {
      printf_("step: time= " + fdble_(beltmept[thrd], 8, 3) +
         " ressave= " + fdble_(ressave, 5, 3) +
         " nmsold= " + trader_nmsold[thrd][pth][i] +
	 " prodcap= " + fdble_(trader_prodcap[thrd][pth][i], 8, 3) +
         " priceq= " + fdble_(trader_priceq[thrd][pth][i], 8, 3));
   }
   */

   trader_unitprice[thrd][pth][i] = trader_priceq[thrd][pth][i] +
         200. * Rndm.stdnrm_(thrd);

   // No-dumping condition.

   if (trader_unitprice[thrd][pth][i] < trader_unitcost[i]) {
      trader_unitprice[thrd][pth][i] = trader_unitcost[i];
   }

   // Price controls.
   
   if (!trader_illegal[i] && pricecontrols) {
      if (trader_unitprice[thrd][pth][i] > pricelimit) {
         trader_unitprice[thrd][pth][i] = pricelimit;
      }
   }

   // Store these prices.
   
   if (!trader_illegal[i]) {
      legalprice[thrd] = trader_unitprice[thrd][pth][i];
   
   } else {
      illegalprice[thrd] = trader_unitprice[thrd][pth][i];
   }

   /* Next, each trader decides on a possible one-unit increase or
      decrease in production capacity.  First, compute the difference
      in net revenue between the last two cycles.  Net revenue is
      profit at fixed prices without fixed costs, i.e., just variable
      costs:

      nr = price * nmsold - unitcost * nmsold (Catullo, note 6). */


   netrev = trader_nmsold[thrd][pth][i] * (priceold - trader_unitcost[i]);
   res = netrev - trader_netrevold[thrd][pth][i];
   trader_netrevold[thrd][pth][i] = netrev;

   /* Legal traders plow a percentage of this net revenue into reserve
      liquidity. */

   if (!trader_illegal[i]) {
      trader_liquidityreserve[thrd][pth][i] += .5 * netrev;
   }

   // Compute the production capacity q value.

   trader_capq[thrd][pth][i] = (1. - ra) *
      trader_capq[thrd][pth][i] + ra * res;

   /* Not implemented:
        [Although not included in Catullo, this model includes the cost
         of holding unsold inventory and the lost opportunity of having
         a production capacity that is lower than what is sold (this
         assumes some short-term inventory is always available).  Note
         that inventory is valued by the trader's unit cost -- not by
         what they might have earned had they been able to sell it.
         Penalizing for unsold inventory allows the model to represent
         the behavior of cutting back production as demand falls, and
         penalizing for inadequate production capacity allows the model
         to represent the behavior of increasing production as demand
         increases.

         This cost is discounted 50\% to represent the assumption that
         eventually this inventory will be sold (for unsold inventory)
         or the relative value of this lost opportunity (for insufficient
         production capacity).]
    
      Production capacity is in units of rhino horn sets while
      "nmsold" is in units of kilograms of rhino horn.
      1 horn set = 5 kilograms where a "horn set" consists of the large
      front horn plus the small rear horn. */

   trader_capq[thrd][pth][i] -= .5 * trader_unitcost[i] * 
      (5. * trader_prodcap[thrd][pth][i] - trader_nmsold[thrd][pth][i]);

   /* Select an option by sampling once from the binomial
      distribution with an "n" of 2 wherein the normalized q is
      the probability of success.
      0: reduce capacity by 1 unit.
      1: no change to capacity.
      2: increase capacity by 1 unit. */
   
   successprob = .001 * trader_capq[thrd][pth][i];
   successprob = 1. / (1. + Math.exp(-successprob));

   /*
   if (thrd == 1 && pth == 1 && trader_illegal[i]) {
      printf_("t= " + fdble_(beltmept[thrd], 8, 3) +
         " nmsold= " + trader_nmsold[thrd][pth][i] +
         " prodcap= " + fdble_(trader_prodcap[thrd][pth][i], 8, 3) +
         " capq= " + fdble_(trader_capq[thrd][pth][i], 8, 3) +
	 " p= " + successprob);
   }
   */

   nmsuccesses = 0;
   for (j = 0; j < 2; ++j) {
      unif = Rndm.rndm1_(thrd, 0);
      if (unif < successprob) {
         ++nmsuccesses;
      }
   }

   if (nmsuccesses == 0) {

      /* Reduce capacity by one unit under the assumed constraint that
         production capacity is always at least 2 horn sets. */

      if (trader_prodcap[thrd][pth][i] > 2.) {
         trader_prodcap[thrd][pth][i] -= 1.;
      }

   } else if (nmsuccesses == 2 && trader_prodcap[thrd][pth][i]  <
              trader_maxcap[i]) {

      /* Possibly increase capacity by one unit.  In particular, legal
         traders can only increase their production capacity if they have
         sufficient liquidity reserves. */

      if (!trader_illegal[i] && trader_liquidityreserve[thrd][pth][i] >
          trader_unitcost[i]) {
            trader_prodcap[thrd][pth][i] += 1.;
         trader_liquidityreserve[thrd][pth][i] -= trader_unitcost[i];

      } else if (trader_illegal[i]) {

         /* Illegal traders outsource their horn production to
            poachers.  Therefore, their capacity equals their ability to
            recruit poachers.  An indicator of this ability is the
            recent behavior of poachers.  If poaching has recently happened,
            the variable "poachercapacity" is set to the value "true." */

         trader_prodcap[thrd][pth][i] += 1.;

         /* And, because of this outsourcing, illegal traders do not use
            their liquidity reserve to pay for increased capacity as legal
            traders do.  Therefore, an illegal trader can allow their
            liquidity reserve to decline to non-positive values. */

         trader_liquidityreserve[thrd][pth][i] -=
            trader_unitcost[i] * (double) nmsuccesses;

      }
   }      

   if (trader_illegal[i]) {

      /* Traders do not shoot rhinos themselves, all they can do is
         to place an order with middlemen for rhino horn.  It is assumed
         in this economics model, however, that traders will receive a
         filled order from the middleman and any shortfall in actual rhino
         horn will be made up by buffalo horn or other substitutes.
         
         As coded in Idsolve.java, to do this, one first gets the
         trader-requested number of animals to poach ("ordersize," below)
         and places it in the order array, "actions_econinput."  The
         poachers submodel will read this value and, combined with
         the actions of the anti-poaching submodel, deliver a filled
         order of some number of poached rhinos.  They will write
         this number to the filled-orders array, "actions_econoutput."
         The rhino IBM will then read this number and kill that number
         of rhinos.
      
         The effect of anti-poaching measures on the reduction of
         the number of rhinos that are successfully poached is modeled in
         the poachers submodel.  Specifically, in that submodel, the
         number of rhinos to be poached is reduced depending on the in-actions
         of the anti-poaching group.

         There is random variation in the ability of traders to tell
         potential poachers how many rhino horns they want.  This
         randomness is also caused by the
         impact of disagreements between poachers and traders as to the
         price poachers are paid for the horns they poach.

         These two sources of randomness is modeled by having the actual
         number of horns ordered by the trader be a random function of
         their production capacity.  Specifically, ordersize is distributed
         as Binomial with success probablity, "orderprob" set to 0.8. */

      orderprob = .8;
      nmsuccesses = 0;
      for (j = 0; j < trader_prodcap[thrd][pth][i]; ++j) {
         unif = Rndm.rndm1_(thrd, 0);
         if (unif < orderprob) {
            ++nmsuccesses;
         }
      }
      ordersize[thrd] += nmsuccesses;
   }
}

/* Each consumer decides to purchase one kilogram of rhino horn or not.
   This is done by selecting the trader with the lowest selling price.
   If this price is below their reserve price, they purchase a kilogram
   of rhino horn.

   The central question in Butle and Damania is how much competition
   will emerge among illegal and legal traders.  These authors believe
   that unless legal traders are forced to keep their prices high
   through either a quota system or high taxes and licensing fees,
   illegal traders will decide to raise their production capacity in
   order to make a profit against legal traders who are selling rhino
   horn below black market prices.
  
   But competition in a real economy emerges because consumers are
   able to compare prices from different traders and select the trader
   with the lowest price.  So the real driver here is the decision making
   of the consumer.
  
   Legal trade advocates argue that lower rhino horn prices offered by
   legal traders will drive the illegal traders out of business.  But
   the Bertrand versus Cournot competition cusp may in fact cause the
   illegal traders to poach as much as possible if legal trade exists. */

for (j = 0; j < nmtraders; ++j) {
   trader_nmsold[thrd][pth][j] = 0;
}

/* Tie "maxnmcnsmrs" to Asian country population growth rate.  Do this
   by interpolating a population value for this time point and then
   scaling it to arrive at a "maxnmcnsmrs" value. */

popest = currentpop;
for (i = 0; i < 3; ++i) {
   if (popt[i] < beltmept[thrd] && beltmept[thrd] <= popt[i + 1]) {
      popest = pop[i] + (pop[i + 1] - pop[i]) *
                        (beltmept[thrd] - popt[i]) /
                        (popt[i + 1] - popt[i]);
      maxnmcnsmrs[thrd] = (int) (((double) maxnmcnsmrs[0]) *
		                     popest / currentpop);
      break;
   }
}

/* Horn-is-not-medicine media campaigns may affect a potential
   consumer's decision to purchase rhino horn.  The effectiveness
   of these campaigns is expressed here as NMCE = (1. - successprob)
   where NMCE stands for "Not-Medicine Campaign Effectiveness."
   successprob is the probability of success in a binomial distribution
   having "maxnmcnsmrs" potential consumers. */

nmcnsmrs = 0;
for (j = 0; j < maxnmcnsmrs[thrd]; ++j) {
   unif = Rndm.rndm1_(thrd, 0);
   if (unif < oneminusnmce) {
      ++nmcnsmrs;
   }
}

for (i = 0; i < nmcnsmrs; ++i) {
   consumer_purchaseevent[thrd][pth][i] = false;
   
   /* Each consumer tries to buy one kilogram of rhino horn at the
      cheapest price that is below their reserve price. */

   besttrdr = 0;
   pricemin = reserveprice;
   for (j = 0; j < nmtraders; ++j) {
      if (trader_prodcap[thrd][pth][j] < 1.) {
         //printf_("Econcalcs.step: trader= " + (j + 1) + " zero capacity");
         return;
         //iderr_("Econcalcs.step: trader= " + (j + 1) + " zero capacity");
      }

      if (trader_unitprice[thrd][pth][j] <= reserveprice &&
         trader_unitprice[thrd][pth][j] <= pricemin) {
         pricemin = trader_unitprice[thrd][pth][j];
	 besttrdr = j + 1;
      }
   }

   /*
   if (thrd == 1 && pth == 1) {
      printf_("step: time= " + beltmept[thrd] + " besttrdr= " +
         + besttrdr + " prodcap= " +
         trader_prodcap[thrd][pth][besttrdr - 1]);
   }
   */

   if (trader_prodcap[thrd][pth][0] > 0. &&
       (trader_unitprice[thrd][pth][0] ==
        trader_unitprice[thrd][pth][1])) {
      if (Rndm.rndm1_(thrd, 0) < .5) {
         besttrdr = 1;
	 
      } else {
         besttrdr = 2;
      }
   }

   if (besttrdr > 0) {
      consumer_purchaseevent[thrd][pth][i] = true;
      ++trader_nmsold[thrd][pth][besttrdr - 1];

      if (!trader_illegal[besttrdr - 1]) {
         nmlegalsold[thrd] += 1.;
      
      } else {
         nmillegalsold[thrd] += 1.;
      }
   }
}

/* Note that the order of these variables is assumed to be the same
   as in the .id file. */

/*
if (thrd == 1 && pth == 0) {
   printf_("Econcalcs.step: time= " + beltmept[thrd] + " illegalprice= " +
      illegalprice[thrd]);
}
if (ordersize[thrd] > 30) {
   printf_("step: thrd= " + thrd + " pth= " + pth +
      " ordersize= " + ordersize[thrd]);
}
*/

yn[thrd][0] = .2 * nmlegalsold[thrd]; // Back into "horns" units
yn[thrd][1] = ordersize[thrd]; // Already in "horns" units
// yn[thrd][1] = nmillegalsold[thrd];
yn[thrd][2] = legalprice[thrd];
yn[thrd][3] = illegalprice[thrd];
}

// -----------------------------------------------------------------

public static void initializeagents_(int thrd, int pth,
   double nodevals[][][]) {

/* Initialize economics model at the the beginning of every run over
   the time interval. */

int i, j;

/* Initialize trader unitprice, priceq, prodcap, capq, nmsold, and
   reserve liquidity.  Note that production capacity is in units of
   number of rhino horn sets. */

for (i = 0; i < nmtraders; ++i) {
   trader_unitprice[thrd][pth][i] = .8 * reserveprice;
   trader_priceq[thrd][pth][i] = trader_unitprice[thrd][pth][i];
   trader_prodcap[thrd][pth][i] = trader_maxcap[i];
   trader_capq[thrd][pth][i] = 0.;
   trader_nmsold[thrd][pth][i] = 0;
   trader_liquidityreserve[thrd][pth][i] = 100. *
      trader_unitprice[thrd][pth][i] * 5. * trader_prodcap[thrd][pth][i];
}

maxnmcnsmrs[thrd] = maxnmcnsmrs[0];
ordersize[thrd] = 0.;
nmlegalsold[thrd] = 0.;
nmillegalsold[thrd] = 0.;
}

// ------------------------------------------------------------------------

public static void abmsetup_(int dst) {

/* Specify constants and parameter values.  Runs once at the beginning
   of the simulation.
   The "strategy" variable takes on the following values:
   SQ    Status Quo
   PP    Pro-active protection
   DR    Demand reduction
   DDR   Disruptive demand reduction
   IDCN  Increased disruption of criminal networks
   LT    Legal trade alone
   DTS   Disruptive trade strategy
   IR    First integrated response
   EDTS  Enhanced disruptive trade strategy
*/

String inaction;

int i, k, dstm1 = dst - 1;

// Set some constants.

nmtraders = 2;
nmlegaltraders = 1;

// Read strategy or poaching rate.

inaction = Intridslve.management_policy;

// Set strategy and corresponding parameter values.

if (inaction.equals("status_quo")) {
   strategy = "SQ";
   pricecontrols = false;
   pricelimit = 1.e6;
   oneminusnmce = .9999;

} else if (inaction.equals("pro-active_protection")) {
   strategy = "PP";
   pricecontrols = false;
   pricelimit = 1.e6;
   oneminusnmce = .9999;

} else if (inaction.equals("intensive_disruption_of_criminal_networks")) {
   strategy = "IDCN";
   pricecontrols = false;
   pricelimit = 1.e6;
   oneminusnmce = .9999;

} else if (inaction.equals("demand_reduction")) {
   strategy = "DR";
   pricecontrols = false;
   pricelimit = 1.e6;
   oneminusnmce = .85; // was .7

} else if (inaction.equals("disruptive_demand_reduction")) {
   strategy = "DDR";
   pricecontrols = false;
   pricelimit = 1.e6;
   oneminusnmce = .85;

} else if (inaction.equals("legal_trade_alone")) {
   strategy = "LT";
   pricecontrols = true;
   pricelimit = 30000.;
   oneminusnmce = .9999;

} else if (inaction.equals("disruptive_trade_strategy")) {
   strategy = "DTS";
   pricecontrols = true;
   pricelimit = 30000.;
   oneminusnmce = .9999;

} else if (inaction.equals("enhanced_disruptive_trade_strategy")) {
   strategy = "EDTS";
   pricecontrols = true;
   pricelimit = 30000.;
   oneminusnmce = .85;

} else if (inaction.equals("integrated_response")) {
   strategy = "IR";
   pricecontrols = true;
   pricelimit = 30000.;
   oneminusnmce = .85;

} else if (inaction.equals("do_nothing") ||
           inaction.equals("take_legal_employment")) {
   poachercapacity = false;

} else if (inaction.equals("kill_few_rhinos") ||
           inaction.equals("kill_several_rhinos") ||
           inaction.equals("kill_many_rhinos")) {
   poachercapacity = true;
}

/* Read values of the learning parameter, consumer's reserve price,
   and the maximum possible production capacity. */
// ra = .2;
// reserveprice = 60000.;
// maxcap = 10.;

// Load legal trader's parameter values.

k = Getmodlutils.getndnm_("NmLegalSold");

ra = condprb[idnmbrm1][k - 1][0][0][0][0][0][0][0][dstm1];
reserveprice = condprb[idnmbrm1][k - 1][1][0][0][0][0][0][0][dstm1];
trader_maxcap[0] = condprb[idnmbrm1][k - 1][2][0][0][0][0][0][0][dstm1];

/* Load illegal trader's parameter values.
k = Getmodlutils.getndnm_("ORDERSIZE");
trader_maxcap[1] = condprb[idnmbrm1][k - 1][1][0][0][0][0][0][0][dstm1];
*/
trader_maxcap[1] = 10.;

// Reset parameter value during a sensitivity analysis run.

if (ssensanalysis) {
   Ssens.resetparm_();
}

/* Specify trader type, corresponding unit cost, and maximum net revenue
   Legal traders are in array positions 0,...,nmlegaltraders-1. */

for (i = 0; i < nmtraders; ++i) {
   if (i < nmlegaltraders) {

      // Legal traders.
      
      trader_illegal[i] = false;
      
      // Allow trading by setting unitcost below reserve price.

      if (strategy.equals("LT") || strategy.equals("DTS") ||
          strategy.equals("EDTS") || strategy.equals("IR")) {
         trader_unitcost[i] = 5000.;
   
	 /* Create an initial consumer population.  To represent the
	    assumption of insatiable demand at current (illegal)
	    production levels, create enough consumers to purchase
	    all rhino horn poached under the maximum poaching rate
	    of 30 rhinos per week across South Africa (20 in KNP, and
	    10 on the ranches).  Because each rhino horn set weighs on
	    average 5kg, multiply these numbers by 5.  Under legal
	    trade, assume this same production levels from stockpiles
	    and/or shaving of horn from live rhinos. */
   
         maxnmcnsmrs[0] = 60 * 5;

      } else {
         trader_unitcost[i] = reserveprice + 1.;
         maxnmcnsmrs[0] = 30 * 5;
      }
   } else {
      trader_illegal[i] = true;
      trader_unitcost[i] = 5000.;
   }
   
   /* Specify the maximum possible net revenue assuming a maximum
      markup of 200\%. */

   if (!trader_illegal[i]) {

      /* Legal traders plow 50\% of their net revenue back into their
         operation. */

      trader_maxnetrev[i] = .5 * ((double) maxnmcnsmrs[0]) *
         trader_unitcost[i] * (2. - 1.);

   } else {
      trader_maxnetrev[i] = 1. * ((double) maxnmcnsmrs[0]) *
         trader_unitcost[i] * (2. - 1.);
   }
}

/* Compute Asian population growth rates from population projections.
   From: United Nations, Dept. of Economic and Social Affairs, Population
   Division (2013), {\em World Population Prospects: The 2012
   Revision.projected populations based on the medium-fertility variant. */

popt[0] = 2010.;
pop[0] = 4165440162.;

popt[1] = 2020.;
pop[1] = 4581523062.;

popt[2] = 2030.; 
pop[2] = 4886846140.;

popt[3] = 2040.;
pop[3] = 5080418644.;

currentpop = pop[0] + (pop[1] - pop[0]) *
             (2014. - popt[0]) / (popt[1] - popt[0]);
}
}
