import java.util.*;
class Dsens extends CA {

static String dsensfle = "none";

// ------------------------------------------------------------------------

static void dsens_() {

/* Performs a deterministic sensitivity analysis.  To run, the algorithm
   needs a set of constraints, c_DSA ("c" for "conditions," and "DSA" for
   "deterministic sensitivity analysis") -- and a set of "response" values,
   r_DSA.  These two sets consist of deterministic values on simulator
   output nodes that are combinations of group actions and group and/or
   ecological responses that, when taken together, provide a counter-example
   to the types of simulator outputs the ecosystem manager is hoping to
   achieve.  Typically, a skeptic of the simulator would specify the
   pair of sets, c_DSA and r_DSA.

   Algorithm:

   Step 1: Update cbeta_H to the current value of cbeta_C.

   Step 2: Specify c_DSA and r_DSA.  Set the simulator's time interval
           accordingly.  When either c_DSA or r_DSA contain political
	   actions, initialize cbeta^(Grp) so that the associated
	   groups produce them.  And, if either set contains political
	   actions that are not to occur, initialize cbeta^(Grp) so that
	   these actions do not occur during a simulator run.

	   All actions either in c_DSA or r_DSA are contained in the
	   file "dsensfle."  All ecosystem response values are contained
	   in the ecosystem data file, "datafle."

   Step 3: Solve: cbeta_{DSA} = argmax_cbeta {g_H(cbeta)}

           under the constraints contained in c_DSA and r_DSA.  For actions,
	   the algorithm begins at a feasible point that satisfies these
	   actions.  For ecosystem responses, the algorithm searches for
	   ecosystem parameter values that maximize the agreement between
	   the "observed" values in "datafle" and those produced by the
	   ecosystem submodel.  To encourage this, "ch" is set to a small
	   value, say 0.1.

   Step 4: Print the hypothesis and DSA values. */

int i, j, k, nmloopssve;

double divisor, fracdiff, mdlval, dumval;

// Set up the optimization run.

dsenssetup_();
nmloopssve = Beliefs.nmloops;

/* Compute initial hypothesis agreement under the stochastic agreement
   definition of CA.  Do this by computing the agreement between "x_hyp"
   and "x_hyp."  Because of the objective function's stochasticity, this
   agreement value will be less than perfect agreement even though the
   two parameter vectors are identical. */

initialgh = CAutils.caf_(x_hyp, true);
initialgh = (initialgh < 1.e-4) ? 1.e-4 : initialgh;
initialgsgroups = gs_groups;
initialgs = gs;
ghdivisor = Math.abs(gh);
ghdivisor = (ghdivisor < 1.e-4) ? 1.e-4 : ghdivisor;

printf_("dsens: initialgsgroups= " + initialgsgroups);

// Perform the optimization to find cbeta_DSA.

Optimiz.optimiz_(n, m, x_ca, g, h, 3);

// If this is a client version of "id," return.

if (client) {

   return;
}

/* Print all group ID parameter that were changed to produce the DSA
   solution along with their percent change from their value in the
   hypothesis values parameter vector, vbeta_H. */

fprintf_(1, "\n-- Deterministic Sensitivity Analysis Solution --" +
   "\n Parameter ID   Node  Hypothesis_Value   DSA_Value");

for (i = 0; i < n; ++i) {

   // Compute a positive divisor.

   divisor = Math.abs(x_hyp[i]);
   if (divisor < 1.e-6) {
      divisor = 1.;
   }

   fracdiff = Math.abs(x_hyp[i] - x_ca[i]) / divisor;
   fprintf_(1, "  " + (i + 1) + "   " + idname[Pxp.idownerm1[i]] +
      "  " + Pxp.nodename[i] + "  " + fdble_(x_hyp[i], 6, 3) +
      "  " + fdble_(x_ca[i], 6, 3));
}

/* Print the ecosystem state variable expected values produced by the
   ecosystem ID under DSA solution parameter values.  (Currently, just
   for region 1). */

fprintf_(1, "   DSA Solution Ecosystem Variable Values:" +
   "\nCountry  Time  Ecosystem_Node  Value");

for (i = 0; i < nmcountries; ++i) {
   for (j = 0; j < Intridslve.nmmdltimes; ++j) {

      // If this is not a time at which the ecosystem was observed, skip.

      if (!Displayactions.ecoobstime[i][j]) {
         continue;
      }

      for (k = 0; k < Intridslve.nmecosysnds; ++k) {
         mdlval = actnshstry_mdlecoave[i][j][k];
         fprintf_(1, "    " + (i + 1) + "       " + (j + 1) +
            "       " + (k + 1) + "     " + fdble_(mdlval, 6, 4));
      }
   }
}
}

// -----------------------------------------------------------------------

static void dsenssetup_() {

// Set up a run to compute a DSA solution.

int i, j;

CAutils.caSetup_(true);

/* When nmids > 1, use a truth table to assign parameter values so
   that each group ID produces the in-out pairs contained in "dsensfle."
   This feasible solution is used as the starting solution in the
   optimization step. */
	 
CAinitialize.cainitialize_("dsens");

if (nmids > 1) {

   /* Reload the solution vector with the distribution found by
      cainitialize_(). */

   for (i = 0; i < nmids; ++i) {
      for (j = 0; j < Psens.nmsensids; ++j) {
         if (nmids > 1 && !idname[i].equals(Psens.id[j])) {
            continue;
         }
         thisidname = idname[i];
         idnmbrm1 = i;
         Pxp.pxp_(0, x_ca, g, h, 2, Psens.beginpar[j],
            Psens.begincnstrnt[j], false);
      }
   }

   // Compute match fractions.

   if (nmids > 1) {
      for (i = 0; i < nmids - 1; ++i) {
         Intridslve.nminoutpairs[i] = 0;
      }
      Fitactions.actnsagree_(true);
   }
}

/* Open the raw ecosystem data file and compute country-time averages
   and standard deviations. */

Ecosysutils.obsecoave_(nmobsactntimes, actnshstry_obsactntime);

/* In general, vc_DSA and/or vr_DSA may contain some mixture of actions and
   values on ecosystem variables.  To ensure a solution is found that
   results in a close match to all such ``observed'' group actions and/or
   ecosystem variables, set "ch" to the small value of (say) 0.1 so that the
   algorithm focuses on matching this ``data'' rather than staying true to
   the hypothesis distributions. */

ch = .0;

fprintf_(1,
   "\n--- Deterministic Sensitivity Analysis ---" +
   "\n   File of conditions and responses= " + dsensfle +
   "\n   File of observed ecosystem values= " + datafle +
   "\n   t0= " + Intridslve.t0 + " tfinal= " + Intridslve.tfinal +
   " nmmdltimes= " + Intridslve.nmmdltimes +
   "\n   Optimization Problem Degrees of Freedom (n)= " + n +
   "\n   Number of implicit constraints (m)= " + m);
}
}
