public class Distagree extends Conddist {

static boolean iddenspoints[] = new boolean[TNMIDS];

static int nmcondsets[] = new int[TNMIDS];
static int nmcontin[] = new int[TNMIDS];
static int nmdensnds[] = new int[TNMIDS];
static int smplsze[] = new int[TNMIDS];

// static int hypactdec[][][][] = new int[TNMIDS][TNMNDS][TNMNDS][TNMNDS];

static double oldcondval[][][] = new double[TNMIDS][1000][TNMNDS];
static double pfhyp[][] = new double[1000][DATSZE];
static double pfconsis[] = new double[DATSZE];
static double lower[] = new double[TNMNDS];
static double higher[] = new double[TNMNDS];
static double rangeh[] = new double[TNMNDS];
static double y[][][] = new double[TNMIDS][DATSZE][TNMNDS];
static double hypsimdata[][] = new double[SIMSZE][TNMNDS];
static double consissimdata[][] = new double[SIMSZE][TNMNDS];

// ---------------------------------------------------------------------

public static double hllngrdist_() {

/* Computes an approximation to the Hellinger distance between
   distributions 1 and 2.  Returns a metric bounded on the unit interval.
*/

boolean newcondset = false;

int i, j, k = 0, condsetnm = 0;

double hypval, consisval, diff = 0., retval = 0.;

// Check if the set of conditioning values has been seen before.

if (nmcondsets[idnmbrm1] == 0) {
   newcondset = true;

} else {
   for (i = 0; i < nmcondsets[idnmbrm1]; ++i) {
      newcondset = false;
      for (j = 0; j < nmcondnds; ++j) {
	 if (nodenghs[idnmbrm1][condnodes[idnmbrm1][j] - 1][0] == 1) {
            continue;
	 }
         if (Math.abs(condvals[j] - oldcondval[idnmbrm1][i][j]) > 1.e-6) {
	    newcondset = true;
            break;
         }
      }
      if (!newcondset) {
         condsetnm = i + 1;
	 break;
      }
   }
}

/*
if (thisidname.equals("poachers")) {
   printf_("hllngrdist: newcondset= " + newcondset);
}
*/

/* If this is a new conditioning set, add it.  Note that new
   in-combinations can appear at any time due to a parameter value
   change on some ID in the past. */

if (newcondset) {
   for (j = 1; j < nmcondnds; ++j) {
      if (nodenghs[idnmbrm1][condnodes[idnmbrm1][j] - 1][0] == 1) {
         continue;
      }
      oldcondval[idnmbrm1][nmcondsets[idnmbrm1]][j] = condvals[j];
   }
   ++nmcondsets[idnmbrm1];
   condsetnm = nmcondsets[idnmbrm1];
}

// Find values at which to estimate the density.

if (!iddenspoints[idnmbrm1]) {
   setup_();
   iddenspoints[idnmbrm1] = true;
}

/* Load the simulated data from the hypothesis and consistent
   distributions. */

for (i = 0; i < nmloops; ++i) {
   k = 0;
   for (j = 0; j < nmnds; ++j) {
      if (loadnode[idnmbrm1][j]) {
         hypsimdata[i][k] = simdata[0][i][j][0];
         consissimdata[i][k] = simdata[0][i][j][1];
     
	 /* 
	 printf_("hllngrdist: i= " + i + " hyp= " +
            hypsimdata[i][k] + " con= " + consissimdata[i][k]);
	 */

         ++k;
      }
   }
}

/* Find the hypothesis and consistent densities at each of these points.
   The density estimators work better if m >= .5n (see "densest2_"). */

if (nmcontin[idnmbrm1] > 0) {
   if (newcondset) {
      Densest.densest2_(nmloops, nmdensnds[idnmbrm1], hypsimdata,
         smplsze[idnmbrm1], y[idnmbrm1], pfhyp[condsetnm - 1]);
   }
   Densest.densest2_(nmloops, nmdensnds[idnmbrm1], consissimdata,
      smplsze[idnmbrm1], y[idnmbrm1], pfconsis);

} else {
   if (newcondset) {
      Densest.densest3_(nmloops, nmdensnds[idnmbrm1], hypsimdata,
         smplsze[idnmbrm1], y[idnmbrm1], pfhyp[condsetnm - 1]);

      /*
      if (condsetnm == 34) {
         printf_("hllngrdist: pfhyp0= " + pfhyp[condsetnm - 1][0]);
      }
      */
   }
   Densest.densest3_(nmloops, nmdensnds[idnmbrm1], consissimdata,
      smplsze[idnmbrm1], y[idnmbrm1], pfconsis);
}

// Compute the Hellinger distance measure.

for (i = 0; i < smplsze[idnmbrm1]; ++i) {
   hypval = pfhyp[condsetnm - 1][i];
   if (pfhyp[condsetnm - 1][i] > 0) {
      hypval = Math.sqrt(pfhyp[condsetnm - 1][i]);
   }
   consisval = pfconsis[i];
   if (pfconsis[i] > 0) {
      consisval = Math.sqrt(pfconsis[i]);
   }

   /*
   printf_("hllngrdist: ID= " + thisidname + " condsetnm= " + condsetnm +
      "\n  smpl= " + (i + 1) + " hypval= " + hypval + " consisval= " +
      consisval);
   */

   diff = hypval - consisval;
   retval += diff * diff;
}

if (retval > 0.) {
   retval = Math.sqrt(retval) / SQRTTWO;
}

/*
if (phenomenon_class[idnmbrm1].equals("ecosystem")) {
   printf_("hllngrdist: ID= " + thisidname + " t= " + Intridslve.t +
      " retval= " + retval);
}
printf_("hllngrdist: ID= " + thisidname + " t= " + Intridslve.t +
   " retval= " + retval);
*/

return retval;
}

// ----------------------------------------------------------------------

public static void setup_() {

// Finds a set of multivariate values at which to compute density estimates.

boolean same = false, psflag = false;

int i, j, k, l, m, n, nodenm = 0, continnm, desiredsize = 1005,
   nmtrys = 500;

double diff = 0., unif, low, high, incrmnt, nmvals, datminh,
   datmaxh, minrange = 1.e6, maxrange = -1.e6;

/* Compute the range for each node and use it to detect nodes that
   have low variance and are not having their parameters estimated.
   First, find the range of hypothesis distribution deviates for each
   node. */

for (i = 0; i < nmnds; ++i) {
   rangeh[i] = 0.;
   datminh = 1.e6;
   datmaxh = -1.e6;
   for (j = 0; j < nmloops; ++j) {
      if (simdata[0][j][i][0] < datminh) {
	 datminh = simdata[0][j][i][0];
      }

      if (simdata[0][j][i][0] > datmaxh) {
	 datmaxh = simdata[0][j][i][0];
      }
   }
   rangeh[i] = datmaxh - datminh;

   if (maxrange < rangeh[i]) {
      maxrange = rangeh[i];
   }
   if (rangeh[i] < minrange) {
      minrange = rangeh[i];
   }
}
if (maxrange - minrange < 1.e-6) {
   printf_("Distagree.setup: ID= " + thisidname + " maxrange-minrange=0");
}

// Create "loadnode" array.  Don't load conditioning nodes.

nmdensnds[idnmbrm1] = 0;
nmcontin[idnmbrm1] = 0;
for (i = 0; i < nmnds; ++i) {
   lower[i] = 1.e6;
   higher[i] = -1.e6;
   loadnode[idnmbrm1][i] = false;

   // Load required nodes.

   if (varinfo_eval[idnmbrm1][i] && varinfo_parest[idnmbrm1][i]) {
      loadnode[idnmbrm1][i] = true;
      ++nmdensnds[idnmbrm1];

      if (psflag) {
         printf_("Distagree.setup: ID= " + thisidname + " loadnode= " +
            nodelbls[idnmbrm1][i][0]);
      }

      if (nodenghs[idnmbrm1][i][0] == 1) {
	 ++nmcontin[idnmbrm1];
      }
   }
}

if (nmdensnds[idnmbrm1] == 0) {

   /* If the ecosystem ID is being fitted, use the ecosystem
      state nodes. */

   if (phenomenon_class[idnmbrm1].equals("ecosystem")) {
      nmdensnds[idnmbrm1] = Intridslve.nmecosysnds;
      for (i = 0; i < Intridslve.nmecosysnds; ++i) {
         loadnode[idnmbrm1][Intridslve.ecosysnodes[i] - 1] = true;
     
	 if (nodenghs[idnmbrm1][Intridslve.ecosysnodes[i] - 1][0] == 1) {
	    ++nmcontin[idnmbrm1];
         }
      }

   } else {

      //  Otherwise, report that there are no required nodes.

      if (psflag) {
         printf_("Distagree.setup: first nmdensnds= 0, ID= " + thisidname);
      }
   }
}

if (psflag) {
   printf_("Distagree.setup: ID= " + thisidname + " nmcontin= " +
      nmcontin[idnmbrm1]);
}

/* Load the hypothesis distribution's simulated data.  Find the min and
   max of continuous node hypothesis data. */

for (i = 0; i < nmloops; ++i) {
   k = 0;
   continnm = 0;
   for (j = 0; j < nmnds; ++j) {

      if (!loadnode[idnmbrm1][j]) {
	 continue;
      }

      hypsimdata[i][k] = simdata[0][i][j][0];

      if (nodenghs[idnmbrm1][j][0] == 1) {
	 if (hypsimdata[i][k] < lower[continnm]) {
	    lower[continnm] = hypsimdata[i][k];
	 }

         if (higher[continnm] < hypsimdata[i][k]) {
	    higher[continnm] = hypsimdata[i][k];
	 }
	 ++continnm;
      }
      ++k;
   }
}

/* Randomly select "smplsze" number of points in the space defined by
   the "nmdensnds" nodes.  The previously-simulated data set on the
   belief network will be used to approximate the density at these points.
   Note that this random selection algorithm, if used on strictly discrete
   nodes will, given enough trys, find all unique combinations of values
   across all "loadnode" nodes.  In this case, "smplsze" is simply this
   number of unique combinations so there is no point in enforcing an
   upper value of "smplsze." */

k = 0;
for (i = 0; i < nmtrys; ++i) {
   nodenm = 0;
   continnm = 0;
   for (j = 0; j < nmnds; ++j) {
      
      // Decide if this node is to be used.

      if (!loadnode[idnmbrm1][j]) {
         continue;
      }

      nmvals = nodenghs[idnmbrm1][j][0];
      if (nmvals == 1) {
         y[idnmbrm1][k][nodenm] = lower[continnm] +
	    (higher[continnm] - lower[continnm]) * Rndm.rndm1_(0, 0);
         ++continnm;

      } else {
         incrmnt = 1. / (double) nmvals;
         low = 0.;
         high = incrmnt;

         unif = Rndm.rndm1_(0, 0);
         for (l = 0; l < nmvals; ++l) {
            if (low < unif && unif <= high) {
               y[idnmbrm1][k][nodenm] = (double) (l + 1);
               break;
            }
            low += incrmnt;
            high += incrmnt;
         }

         if (psflag) {
	    printf_("setup: ID= " + thisidname + " k= " + k + " node= " +
               (j + 1) + " y= " + y[idnmbrm1][k][nodenm]);
         }

      }
      ++nodenm;
   }

   // Reject this k^th point if it is already in the set of points.

   if (k == 0) {
      ++k;
      continue;
   }
   for (m = 0; m < k; ++m) {
      same = true;
      for (n = 0; n < nodenm; ++n) {
	 if (Math.abs(y[idnmbrm1][k][n] - y[idnmbrm1][m][n]) > 1.e-6) {
	   same = false;
	    break;
         }
      }
      if (same) {
         break;
      }
   }

   if (!same) {
      ++k;
      if (k == DATSZE) {
         iderr_("Distagree.setup: k= " + k + " = DATSZE");

      } else if (continnm > 0 && k == desiredsize) {
         break;
      }
   }
}

smplsze[idnmbrm1] = k;

if (psflag) {
   printf_("Distagree.setup: ID= " + thisidname + " smplsze= " +
      smplsze[idnmbrm1]);
   for (i = 0; i < smplsze[idnmbrm1]; ++i) {
      for (j = 0; j < nodenm; ++j) {
         printf_("   smpl= " + i + " node= " + j + " nodevalue= " +
            y[idnmbrm1][i][j]);
      }
   }
}
}
}
