import java.util.*;
public class Displayutils extends Displayactions {

static boolean firstcall = true;

static char dumsym[] = new char[NMACTNS];

static String dumlbl[] = new String[NMACTNS];
static String dumlbl2[] = new String[NMACTNS];

static int nmthrdfixes[] = new int[NMACTNS];
static int index[] = new int[NMACTNS];

static float dumpt[][] = new float[NMACTTHRDS][NMTHRDPTS];
static float dumsingle[] = new float[NMACTNS];
static double dumcountry[] = new double[NMACTNS];

// ---------------------------------------------------------------------

public static int gettargets_(String trgtsstrng, String target[]) {

// Returns individual targets in the array "target."

String strng2;

int i, nmtrgts = 0;

StringTokenizer subjects = new StringTokenizer(trgtsstrng, ",");
strng2 = subjects.nextToken();

if (strng2.equals("one")) {
   nmtrgts = 1;

} else if (strng2.equals("two")) {
   nmtrgts = 2;

} else if (strng2.equals("three")) {
   nmtrgts = 3;

} else {
   printf_("gettargets: trgtsstrng= " + trgtsstrng);
   printf_("   unrecognized number of targets= " + strng2);
   nmtrgts = 0;
}
for (i = 0; i < nmtrgts; ++i) {
   target[i] = subjects.nextToken();
}

return nmtrgts;
}

// ---------------------------------------------------------------------

public static int getactornm_(String actor) {

// Returns the number of the actor.

int i;

for (i = 0; i < Storyparse.nmvernacgrps; ++i) {
   if (actor.equals(Storyparse.modelname[i])) {
      return (i + 1);
   }
}

return 0;
}

// ---------------------------------------------------------------------

public static int getcountrynm_(String actor) {

// Returns the number of the actor's country.

int i, idnumberm1 = -1, countrynm = 0;

for (i = 0; i < nmids; ++i) {
   if (actor.equals(idname[i])) {
      idnumberm1 = i;
      break;
   }
}

if (idnumberm1 == -1) {
   //printf_("getcountrynm: actor= " + actor + " ID not found.");
   return 0;
}

for (i = 0; i < nmcountries; ++i) {
   if (idcountry[idnumberm1].equals(countrymap[i])) {
      countrynm = i + 1;
      return countrynm;
   }
}

if (countrynm == 0 && nmids > 1) {
   printf_("getcountrynm: actor= " + actor + " country= " +
      idcountry[idnumberm1] + " not in countrymap, returning 0");
}

return 0;
}

// ---------------------------------------------------------------------

public static int getphenomenonnm_(String actor) {

// Returns the number of the actor's phenomenon class.

boolean phenomfound = false;

int i, idnumberm1 = -1;

for (i = 0; i < nmids; ++i) {
   if (actor.equals(idname[i])) {
      idnumberm1 = i;
      break;
   }
}

if (idnumberm1 == -1) {
   iderr_("getphenomenonnm: actor= " + actor + " not found.");
   return 0;
}

for (i = 1; i <= nmphenoms; ++i) {
   if (phenomenon_class[idnumberm1].equals(phenomenon[i - 1])) {
      phenomfound = true;
      break;
   }
}

if (!phenomfound) {
   iderr_("getphenomenon: no phenomenon for actor= " + actor);
}

return i;
}

// ---------------------------------------------------------------------

public static void reorderthrds_(int nmsingles, float singleton[][],
   int nmpentads, int nmthreads) {

/* Re-orders vertical axis values to minimize connecting line plotting
   length.  Another approach would be to re-order the action numbers so
   that patterns of action sequences become easy to see.  This is a
   combinatoric optimizations problem and could be solved with
   simanel_(). */

boolean improved = false;

String oldlab, newlab;

int i, j, k, nmtrys = 0, nmdiffs = 0, threadnm = 0, nmrndm = 1;

double oldpt1 = 0., oldpt2 = 0., newpt1 = 0., newpt2 = 0., diff = 0.,
   maxdiff = 0., minthres, sumlngth = 0., minlngth = 1.e30;

minthres = .9;   // was 1.1

do {
   improved = false;
   for (i = 1; i < nmthreads; ++i) {
      oldpt1 = 0.;
      oldpt2 = 0.;
      newpt2 = 0.;
      maxdiff = 0.;
      for (j = 0; j < nmpts[i] - 1; ++j) {
         diff = Math.abs(thread_pt[i][j + 1][1] - thread_pt[i][j][1]);
         if (diff > maxdiff) {
            oldpt1 = thread_pt[i][j][1];
            oldpt2 = thread_pt[i][j + 1][1];
            maxdiff = diff;
	    threadnm = i;
         }
      }

      if (minthres < maxdiff) {
         ++nmthrdfixes[threadnm];

         // Move second point closer to first point.

         if (oldpt1 < oldpt2) {
            newpt2 = oldpt2 - 1.;

         } else if (oldpt1 > oldpt2) {
            newpt2 = oldpt2 + 1.;
         }

         /* Switch "oldpt2" and "newpt2" over all threads and compute
            total line length. */

         sumlngth = switchpts_(nmsingles, singleton, nmthreads, oldpt2,
            newpt2);

         // Store the best solution.

         if (sumlngth < minlngth) {
            minlngth = sumlngth;
	    improved = true;
         
	 } else {
            sumlngth = switchpts_(nmsingles, singleton, nmthreads, newpt2,
            oldpt2);

         }
      }
   }
   ++nmtrys;
} while (nmtrys < 100);

printf_("reorderthrds: 1st nmtrys= " + nmtrys + " minlngth= " + minlngth);

/* Try switching each pair of pentads to see if any cause a smaller
   total line length. */

nmtrys = 0;
do {
   improved = false;
   for (i = 2; i <= nmpentads; ++i) {
      for (j = 1; j < i; ++j) {
         oldpt2 = (double) i;
         newpt2 = (double) j;
         sumlngth = switchpts_(nmsingles, singleton, nmthreads, oldpt2,
            newpt2);

         // Reject this switch if it doesn't help.

         if (sumlngth < minlngth) {
            minlngth = sumlngth;
            improved = true;

         } else {
            switchpts_(nmsingles, singleton, nmthreads, newpt2, oldpt2);
         }
      }
   }
   ++nmtrys;
} while (nmtrys < 1000);

printf_("reorderthrds: 2nd nmtrys= " + nmtrys + " minlngth= " + minlngth);

// Random search.

nmtrys = 0;
nmrndm = 1000;
do {
   for (k = 0; k < nmrndm; ++k) {
     
      // Pick point i randomly.

      i = Rndm.dscrtunif_(0, 1, nmpentads);
      if (i < 1 || i > nmpentads) {
         iderr_("reorderthrds: i= " + i);
      }

      // Pick point j randomly.

      j = Rndm.dscrtunif_(0, 1, nmpentads);
      if (j < 1 || j > nmpentads) {
         iderr_("reorderthrds: j= " + j);
      }
      if (i == j) {
	 continue;
      }
      oldpt2 = (double) i;
      newpt2 = (double) j;
      sumlngth = switchpts_(nmsingles, singleton, nmthreads, oldpt2, newpt2);

      // Reject this switch if it doesn't help.

      if (sumlngth < minlngth) {
         minlngth = sumlngth;

      } else {
         switchpts_(nmsingles, singleton, nmthreads, newpt2, oldpt2);
      }
   }
   ++nmtrys;
} while (nmtrys < 10);

printf_("reorderthrds: 3rd nmtrys= " + nmtrys + " minlngth= " + minlngth);
}

// -----------------------------------------------------------------

public static void sortpts_(int nmsingles, float singleton[][], int nmpentads,
   int nmthreads) {

// Sorts points by actor number.

int i, j, k;

float oldpt, newpt;

for (i = 0; i < nmpentads; ++i) {
   index[i] = i;
   dumlbl[i] = nomlab[i];
   dumlbl2[i] = nomlab2[i];
   dumsym[i] = pentadsymbol[i];
   dumcountry[i] = pentadcountry[i];
}

for (i = 0; i < nmsingles; ++i) {
   dumsingle[i] = singleton[i][1];
}

for (i = 0; i < nmthreads; ++i) {
   for (j = 0; j < nmpts[i]; ++j) {
      dumpt[i][j] = thread_pt[i][j][1];
   }
}

Idsort.idsort_(pentadactor, index, 1, nmpentads);

// Reload y-axis labels and singletons.

for (i = 0; i < nmpentads; ++i) {
   nomlab[i] = dumlbl[index[i]];
   nomlab2[i] = dumlbl2[index[i]];
   pentadsymbol[i] = dumsym[index[i]];
   pentadcountry[i] = dumcountry[index[i]];
   for (j = 0; j < nmsingles; ++j) {
      if (Math.abs(dumsingle[j] - (1. + (float) index[i])) < 1.e-6) {
         singleton[j][1] = (float) (i + 1);
      }
   }
}

/*
// Indicate which labels to display.

for (i = 0; i < nmpentads; ++i) {
   dumlbl[i] = nomlab[i];
   nomlab[i] = "noplot";
}

// Plot only initiating actor label.

for (i = 1; i < nmpentads; ++i) {
   if (pentadactor[i - 1] != pentadactor[i]) {
      nomlab[i - 1] = dumlbl[i - 1];
   }
}
for (i = 1; i < nmpentads - 1; i += 2) {
   if (!nomlab[i].equals("noplot") &&
       !nomlab[i + 1].equals("noplot")) {
      nomlab[i] = "noplot";
   }
}
for (i = 1; i < nmpentads - 2; i += 3) {
   if (!nomlab[i].equals("noplot") &&
       !nomlab[i + 2].equals("noplot")) {
      nomlab[i] = "noplot";
   }
}
nomlab[nmpentads - 1] = dumlbl[nmpentads - 1];
*/

// Reload "thread_pt."

for (i = 0; i < nmthreads; ++i) {
   for (j = 0; j < nmpts[i]; ++j) {
      oldpt = dumpt[i][j];

      // Find this old point in the "index" array.

      newpt = (float) 0.;
      for (k = 0; k < nmpentads; ++k) {
	 if (Math.abs(oldpt - (1. + (double) index[k])) < 1.e-6) {
	    newpt = (float) (1. + (double) k);
	    break;
	 }
      }
      thread_pt[i][j][1] = newpt;
   }
}
}

// -----------------------------------------------------------------

public static double switchpts_(int nmsingles, float singleton[][],
   int nmthreads, double oldpt2, double newpt2) {

// Switches points.

String oldlab, newlab, oldlab2, newlab2;

int k, j;

double sumlngth = 0.;

for (k = 0; k < nmthreads; ++k) {
   for (j = 0; j < nmpts[k]; ++j) {
      dumpt[k][j] = thread_pt[k][j][1];
   }
}

for (k = 0; k < nmthreads; ++k) {
   for (j = 0; j < nmpts[k]; ++j) {
      if (Math.abs((double) dumpt[k][j] - oldpt2) < 1.e-6) {
         thread_pt[k][j][1] = (float) newpt2;

      } else if (Math.abs((double) dumpt[k][j] - newpt2) < 1.e-6) {
         thread_pt[k][j][1] = (float) oldpt2;
      }
   }
}
         
// Switch y axis labels.
	 
oldlab = nomlab[((int) oldpt2) - 1];
newlab = nomlab[((int) newpt2) - 1];
nomlab[((int) oldpt2) - 1] = newlab;
nomlab[((int) newpt2) - 1] = oldlab;

oldlab2 = nomlab2[((int) oldpt2) - 1];
newlab2 = nomlab2[((int) newpt2) - 1];
nomlab2[((int) oldpt2) - 1] = newlab2;
nomlab2[((int) newpt2) - 1] = oldlab2;

// Switch singletons.

for (k = 0; k < nmsingles; ++k) {
   dumsingle[k] = singleton[k][1];
}

for (k = 0; k < nmsingles; ++k) {
   if (Math.abs(dumsingle[k] - oldpt2) < 1.e-6) {
      singleton[k][1] = (float) newpt2;
   }
   if (Math.abs(dumsingle[k] - newpt2) < 1.e-6) {
      singleton[k][1] = (float) oldpt2;
   }
}

// Compute new total length.

for (k = 0; k < nmthreads; ++k) {
   for (j = 0; j < nmpts[k] - 1; ++j) {
      sumlngth += Math.abs(thread_pt[k][j + 1][1] -
                           thread_pt[k][j][1]);
   }
}

if (firstcall) {
   printf_("switchpts: beginning length= " + sumlngth);
   firstcall = false;
}

return sumlngth;
}

// --------------------------------------------------------------------

static void fleformat_(String flename) {

// Re-formats an SQL query output file into the .ahs file format.

String ahsflename = "dum.ahs", action = "none", outstrng = "none";

double actiontime = 0.;

fleopen_(2, flename, 'r');
fleopen_(8, ahsflename, 'w');
do {
   actiontime = fgetdble_(2);
   action = fgetstrng_(2);

   // Write this observed action in .ahs form.

   outstrng = "action " + fdble_(actiontime, 7, 2) + " kenrr " + action +
      " ecosys";

   fprintf_(8, outstrng);
} while (!checkeof_(2));
fclose_(2, 'r');
fclose_(8, 'w');

actnshistfle = ahsflename;
}

// --------------------------------------------------------------------

static void ahsflesort_(String flename) {

/* Sorts an observed actions history file on time.  Broken because the .ahs
   file format has changed. */

int i, j, n = 0;

iderr_("ahsflesort: broken due to changed ahs file format.");

fleopen_(8, flename, 'r');
do {
   plttindex[n] = n;
   carryvar[n][0] = fgetstrng_(8);
   actiontime[n] = fgetdble_(8);
   for (j = 1; j <= 3; ++j) {
      carryvar[n][j] = fgetstrng_(8);
   }
   ++n;

   if (n ==  SORTSZE) {
      iderr_("ahsflesort: n= " + n + " >SORTSZE");
   }

} while (!checkeof_(8));
fclose_(8, 'r');

Idsort.idsort_(actiontime, plttindex, 1, n);

fleopen_(8, flename, 'w');

for (i = 0; i < n; ++i) {
   strng = carryvar[plttindex[i]][0] + " " + fdble_(actiontime[i], 7, 2);
   for (j = 1; j <= 3; ++j) {
      strng += " " + carryvar[plttindex[i]][j];
   }
   fprintf_(8, strng);
}
fclose_(8, 'w');
}

// ----------------------------------------------------------------------

static String getshort_(String actor) {

// Returns short actor name.

String shortname = "none";

int i;

for (i = 0; i < nmids; ++i) {
   if (idname[i].equals(actor)) {
      shortname = idsymb[i];
      break;
   }
}

if (shortname.equals("none")) {
   iderr_("getshort: short name not found for actor= " + actor);
}

return shortname;
}
}
