import java.util.*;
class Displayeco extends Displayactions {

/* Creates a display of either ecosystem observations or the output of
   the ecosystem model -- or both. */

static char plotsymbol[][] = new char[TNMNDS][26];

static String nomlab2[] = new String[2];

static int whichthread[][] = new int[TNMNDS][TNMVALS];
static int nmvarlocs[] = new int[TNMNDS];
static int varlocnm[][] = new int[TNMNDS][TNMVALS];
static int nmvarlocobs[][] = new int[TNMNDS][TNMVALS];

// ---------------------------------------------------------------------

static void ploteco_(double xscale, double yscale, double xshift,
   double yshift) {

// Create plot of ecosystem variables.

String filetype, rectype;

int i, j, k = 0, locationnm, varnm, nmsingles = 0, threadnm, nmthreads = 0,
   nmpltvars = 0, startdevs = 0, ttlpts = 0, nmlocations, vartoplot;

double time, val;

// Fill plotting symbol array.

for (i = 0; i < 26; ++i) {
   plotsymbol[0][i] = 'A';
   plotsymbol[1][i] = 'B';
   plotsymbol[2][i] = 'C';
   plotsymbol[3][i] = 'D';
   plotsymbol[4][i] = 'E';
   plotsymbol[5][i] = 'F';
   plotsymbol[6][i] = 'G';
   plotsymbol[7][i] = 'H';
   plotsymbol[8][i] = 'I';
   plotsymbol[9][i] = 'J';
   plotsymbol[10][i] = 'K';
}

// Initialize per-variable location numbers.

for (i = 0; i < TNMNDS; ++i) {
   for (j = 0; j < TNMVALS; ++j) {
      whichthread[i][j] = 0;
      varlocnm[i][j] = 0;
      nmvarlocobs[i][j] = 0;
   }
}

/* Use caSetup_() to open observed ecosystem data file and
   compute location-time averages. */

CAutils.caSetup_(false);
nmpltvars = nmobsnds;
nmlocations = CAutils.nmobsrgns;
Ecosysutils.obsecorgn_(nmlocations, nmactiontimes, Displayactions.time);

/* Write a temporary actions history file composed solely of "ecovals"
   record types. */

fleopen_(2, "tempobsecovals.ahs", 'w');
for (i = 0; i < nmactiontimes; ++i) {
   for (j = 0; j < Intridslve.nmregions; ++j) {
      for (k = 0; k < nmpltvars; ++k) {

         if (starttime[0] <= actnshstry_obsecotime[j][i][k] &&
             actnshstry_obsecotime[j][i][k] <= endtime) {

            fprintf_(2, "ecovals" + " " +
               actnshstry_obsecotime[j][i][k] + " " + (j + 1) + " " +
               (k + 1) + " " + actnshstry_obsecoave[j][i][k]);

            varlocnm[k][j] = 1;
            ++nmvarlocobs[k][j];
            ++ttlpts;

         } else {
            /*
	    printf_("ploteco: outside ecoval " + " " +
	       actnshstry_obsecotime[j][i][k] + " " + (j + 1) + " " +
	       (k + 1) + " " + actnshstry_obsecoave[j][i][k]);
            */
         }
      }
   }
}
fclose_(2, 'w');

if (ttlpts == 0) {
   printf_("ploteco: ttlpts in tempobsecovals.ahs=0");
}

// Map location numbers to per-variable location numbers.
 
for (i = 0; i < nmpltvars; ++i) {
   nmvarlocs[i] = 1;
   for (j = 0; j < nmlocations; ++j) {
      if (varlocnm[i][j] == 1) {
         varlocnm[i][j] = nmvarlocs[i];
         ++nmvarlocs[i];
      }
   }
}

// Figure out singletons and threads.

threadnm = 0;
for (i = 0; i < nmpltvars; ++i) {
   for (j = 0; j < nmlocations; ++j) {
      if (nmvarlocobs[i][j] > 1) {
         ++threadnm;
         nmpts[threadnm - 1] = 0;
         whichthread[i][j] = threadnm;
      }
   }
}
nmthreads = threadnm;

if (nmthreads > NMACTTHRDS) {
   iderr_("ploteco: nmthreads= " + nmthreads + " NMACTTHRDS= " + NMACTTHRDS);
}
printf_("ploteco: number of observed ecovals= " + ttlpts +
   " plottype= " + plottype);

// Finally, open this file for reading on file handle number 2.

fleopen_(2, "tempobsecovals.ahs", 'r');

if (plottype.equals("model")) {

   /* For model-generated ecosystem variable output, get the number of
      ecosystem variables, and figure out the number of threads.
      Each combination of variable and location gets its own standard
      deviation thread. */

   nmpltvars = Intridslve.nmecosysnds;
   nmlocations = nmcountries;
   startdevs = nmlocations * nmpltvars + 1;
   nmthreads = 2 * (startdevs - 1);

   if (nmthreads > NMACTTHRDS) {
      iderr_("ploteco: nmthreads= " + nmthreads + " NMACTTHRDS= " + NMACTTHRDS);
   }

   /* Zero-out the number-of-points-per-thread array and map location
      number-variable number combinations to thread numbers.  Standard
      deviations are plotted for model-generated values only. */

   threadnm = 0;
   for (i = 0; i < nmpltvars; ++i) {
      for (j = 0; j < nmlocations; ++j) {
         ++threadnm;
         nmpts[threadnm - 1] = 0;
         whichthread[i][j] = threadnm;
         nmpts[startdevs + threadnm - 2] = 0;
         varlocnm[i][j] = j + 1;
      }
   }

   /* Finally, open the model-generated actions history file so that the
      ecosystem variable values can be re-read. */

   printf_("ploteco: opening model actions history file " + actnshistfle);

   fleopen_(3, actnshistfle, 'r');
}

// Initialize the plotting symbol array.

for (i = 0; i < nmthreads; ++i) {
   for (j = 0; j < NMTHRDPTS; ++j) {
      symbol[i][j] = 'o';
   }
}

// Print legend information.

for (i = 0; i < nmpltvars; ++i) {
   for (j = 0; j < nmlocations; ++j) {
      if (varlocnm[i][j] > 0) {
         printf_("ploteco: variable= " + (i + 1) + " location= " +
            (j + 1) + " plot symbol= " +
            plotsymbol[i][varlocnm[i][j] - 1]);
      }
   }
}

/* Write the observed ecosystem values to plotting array.  Note that
   there must be some of these since the routine would have returned, above.
*/

printf_("ploteco: observed starttime0= " + starttime[0] + " endtime= " +
   endtime);

for (i = 0; i < ttlpts; ++i) {
   fgetstrng_(2);
   time = fgetdble_(2);
   if (time < starttime[0] || endtime < time) {
      fgetint_(2);
      fgetint_(2);
      fgetdble_(2);
      continue;
   }
   locationnm = fgetint_(2);
   varnm = fgetint_(2);
   singleton[nmsingles][0] = (float) time;
   val = fgetdble_(2);
   singleton[nmsingles][1] = (float) val;
   singsym[nmsingles] =  'o';

   /*
   printf_("ploteco: observed varnm= " + varnm + " time= " +
      singleton[nmsingles][0] + " observed ecoval= " + val + " sym= " +
      singsym[nmsingles]);
   */

   ++nmsingles;
}
fclose_(2, 'r');

// Announce what variable is being plotted.

vartoplot = 2;
printf_("ploteco: vartoplot= " + vartoplot);

// If ecosystem model output is to be plotted, fill threads with this output.

while (plottype.equals("model") && !checkeof_(3)) {

   // Get record type.  Read only ecosystem variable values.

   rectype = fgetstrng_(3);

   if (!rectype.equals("ecovals")) {
      fgetint_(3);
      fgetint_(3);
      fgetdble_(3);
      for (j = 0; j < 6; ++j) {
         fgetstrng_(3);
      }
      continue;
   }

   /* The first location's variables are in the first set of threads
      and so on.  All standard deviation variables follow these. */

   time = fgetdble_(3);
   if (time < starttime[0] || endtime < time) {
      fgetint_(3);
      fgetint_(3);
      fgetdble_(3);
      fgetdble_(3);
      continue;
   }
   locationnm = fgetint_(3);
   varnm = fgetint_(3);

   // Control how many variables are plotted.

   if (varnm != vartoplot) {
      fgetdble_(3);
      fgetdble_(3);
      continue;
   }

   threadnm = whichthread[varnm - 1][locationnm - 1];

   printf_("ploteco: model locationnm= " + locationnm + " varnm= " +
      varnm + " threadnm= " + threadnm);

   // Read-in the ecosystem variable's value.

   if (threadnm == 0) {
      singleton[nmsingles][0] = (float) time;
      val = fgetdble_(3);
      singleton[nmsingles][1] = (float) val;
      
      // printf_("ploteco: model time= " + time + " model singleton= " + val);

      // Load the appropriate plotting symbol.

      singsym[nmsingles] = plotsymbol[varnm - 1][varlocnm[varnm - 1]
	                             [locationnm - 1] - 1];
      ++nmsingles;

   } else {
      thread_pt[threadnm - 1][nmpts[threadnm - 1]][0] = (float) time;

      val = fgetdble_(3);
      thread_pt[threadnm - 1][nmpts[threadnm - 1]][1] = (float) val;

      printf_("ploteco: model threadnm= " + threadnm + " pt= " +
         nmpts[threadnm - 1] + " time= " + time + " curveval= " + val);

      symbol[threadnm - 1][nmpts[threadnm - 1]] =
         plotsymbol[varnm - 1][varlocnm[varnm - 1][locationnm - 1] - 1];
      ++nmpts[threadnm - 1];
   
      if (nmpts[threadnm - 1] >= NMTHRDPTS) {
         iderr_("ploteco: model nmpts= " + nmpts[threadnm - 1] +
                " NMTHRDPTS= " + NMTHRDPTS);
      }

      /* Read-in the standard deviation value.  These are plotted as
         different threads: one stddev thread for each combination of
         variable and location. */

      threadnm += startdevs - 1;

      thread_pt[threadnm - 1][nmpts[threadnm - 1]][0] = (float) time;

      val = fgetdble_(3);

      /*
      printf_("ploteco: model threadnm= " + threadnm + " pt= " +
         nmpts[threadnm - 1] + " time= " + time + " stdval= " + val);
      */

      thread_pt[threadnm - 1][nmpts[threadnm - 1]][1] = (float) val;
      symbol[threadnm - 1][nmpts[threadnm - 1]] = 'S';
      ++nmpts[threadnm - 1];
      linetype[threadnm - 1] = 1;
   }
}
fclose_(3, 'r');

// Print summary.

printf_("ploteco: nmsingles= " + nmsingles + " nmthreads= " + nmthreads);
for (i = 0; i < nmthreads; ++i) {
   printf_("ploteco: threadnm= " + (i + 1) + " nmpts= " + nmpts[i]);
}

// Plot all of these ecosystem variable threads.

plottitle[0] = "Ecological_actions_history";
plottitle[1] = null;
fleopen_(3, "out.dig", 'w');
Plotutils.pltscat_(3, nmsingles, singleton, singsym, nmthreads, nmpts,
   thread_pt, symbol, plottitle, linelbl, "Time", "Abundance", false, nomlab,
   1, nomlab2, xscale, yscale, xshift, yshift, 0, bar, linetype,
   starttime[0], endtime);
fclose_(3, 'w');
}
}
