public class Dfpmin extends ITDmodnn {

static final int ITMAX = 200;

static final double EPS = 1.e-9;
static final double CGOLD = 0.3819660;
static final double GOLD = 1.618034;
static final double GLIMIT = 100.;
static final double TINY = 1.e-20;
static final double TOL = 1.e-5;
static final double ZEPS = 1.e-9;

static int nmf = 0, fnum = 0, n;

static double wage = 0., fa, fb, fc, fret, xmin;

static double shiftarray[] = new double[6];
static double retarray[] = new double[6];
static double xi[] = new double[OPTSIZE];
static double g[] = new double[OPTSIZE];
static double dg[] = new double[OPTSIZE];
static double hdg[] = new double[OPTSIZE];
static double hessin[][] = new double[OPTSIZE][OPTSIZE];
static double x[] = new double[MAXP + 1];

// SIGN(a,b) ((b) > 0. ? fabs(a) : -fabs(a))

static int dfpmin_(double prds[][], int rspns[], int inn, double p[],
   int ifirst, int infnum) {

/* BFGS multivariable minimization from Numerical Recipes, p. 326.
   On entry, p contains the initial guess, on exit, the solution.
   n is the number of variables, ftol is the solution accuracy desired. 

   When used as a nonlinear regression routine, y is the data,
   s the covariance matrix (see routine func_()), and
   nd the number of observations (see routine func_()).

   n is always the number of parameters, and p is the
   parameter vector. */

boolean test = true;

int i, j, its;

double fp, fae, fad, fac, ftol = 1.e-7;

// Transfer input values to global locations.

fnum = infnum;
n = inn;

// Compute initial value of the objective function.

fp = func_(1, p, g, rspns, prds, ifirst);

if (test) {
   printf_("dfpmin: Initial BFGS f= " + fp);
}

for (i = 0; i < n; ++i) {
   for (j = 0; j < n; ++j) {
      hessin[i][j] = 0.;
   }
   hessin[i][i] = 1.;
   xi[i] = -g[i];
}

// BFGS iterations.

for (its = 1; its <= ITMAX; its++) {
   fret = linmin_(p, xi, rspns, prds, ifirst);

   if (test) {
      printf_("dfpmin: its= " + its + " fp= " + fp + " fret= " + fret);
   }

   // Convergence test.

   if (2. * Math.abs(fret - fp) <=
       ftol * (Math.abs(fret) + Math.abs(fp) + EPS)) {
      if (test) {
	 printf_("Converged, Final BFGS F= " + fp + " its= " + its +
            " nmf= " + nmf);
      }
      return 0;
   }

   // If solution is diverging, return.

   if (fret >= fp && its > 4) {
      if (test) {
	 printf_("Converged, Final BFGS F= " + fp + " its= " + its +
            " nmf= " + nmf);
      }
      printf_("BFGS is diverging, giving up.");

      return 1;
   }

   fp = fret;
   for (i = 0; i < n; ++i)  dg[i] = g[i];
   fret = func_(1, p, g, rspns, prds, ifirst);
   for (i = 0; i < n; ++i) dg[i] = g[i] - dg[i];
   for (i = 0; i < n; ++i) {
      hdg[i] = 0.;
      for (j = 0; j < n; ++j) hdg[i] += hessin[i][j] * dg[j];
   }
   fac = fae = 0.;
   for (i = 0; i < n; ++i) {
      fac += dg[i] * xi[i];
      fae += dg[i] * hdg[i];
   }
   fac = 1. / fac;
   fad = 1. / fae;
   for (i = 0; i < n; ++i) dg[i] = fac * xi[i] - fad * hdg[i];
   for (i = 0; i < n; ++i)
      for (j = 0; j < n; ++j) hessin[i][j] += fac * xi[i] * xi[j]
	 - fad * hdg[i] * hdg[j] + fae * dg[i] * dg[j];
   for (i = 0; i < n; ++i) {
      xi[i] = 0.;
      for (j = 0; j < n; ++j) xi[i] -= hessin[i][j] * g[j];
   }
}

if (test) {
   printf_("Converged, Final BFGS F= " + fp + " its= " + its +
      " nmf= " + nmf);
}
printf_("dfpmin: ITMAX exceeded");

return 1;
}

// ------------------------------------------------------------------

static double linmin_(double p[], double xi[], int rspns[], double prds[][],
   int ifirst) {

int j;

double xx = 0., fx = 0., fb = 0., fa = 0., bx = 0., ax = 0.;

double pcom[] = new double[NMPAR];
double xicom[] = new double[NMPAR];

for (j = 0; j < n; ++j) {
   pcom[j] = p[j];
   xicom[j] = xi[j];
}
ax = 0.;
xx = .001; // was 1.0

mnbrak_(ax, xx, bx, fa, fx, fb, pcom, xicom, rspns, prds, ifirst);
ax = retarray[0];
xx = retarray[1];
bx = retarray[2];
fa = retarray[3];
fx = retarray[4];
fb = retarray[5];

/*
printf_("linmin: ax= " + ax + " xx= " + xx + " bx= " + bx + " fa= " +
   fa + " fx= " + fx + " fb= " + fb);
*/

fret = brent_(ax, xx, bx, TOL, pcom, xicom, rspns, prds, ifirst);

for (j = 0; j < n; ++j) {
   xi[j] *= xmin;
   p[j] += xi[j];
}

return fret;
}

// -----------------------------------------------------------------------

static double f1dim_(double x, double pcom[], double xicom[],
   int rspns[], double prds[][], int ifirst) {

int j;

double f;

double xt[] = new double[NMPAR];
double g[] = new double[NMPAR];

for (j = 0; j < n; ++j) {
   xt[j] = pcom[j] + x * xicom[j];

   /*
   printf_("f1dim: x= " + x + " j= " + j + " xt= " + xt[j] + " xicom= " +
      xicom[j]);
   */
}

f = func_(0, xt, g, rspns, prds, ifirst);

return f;
}

// -----------------------------------------------------------------------

static double brent_(double ax, double bx, double cx, double tol,
   double pcom[], double xicom[], int rspns[], double prds[][],
   int ifirst) {

int iter;

double a, b, d = 0., etemp, fu, fv, fw, fx, p, q, r, tol1, tol2, u, v,
   w, x, xm, e;

e = 0.;
a = ((ax < cx) ? ax : cx);
b = ((ax > cx) ? ax : cx);
x = w = v = bx;
fw = fv = fx = f1dim_(x, pcom, xicom, rspns, prds, ifirst);
for (iter = 1; iter <= ITMAX; ++iter) {
   xm = .5 * (a + b);
   tol2 = 2. * (tol1 = tol * Math.abs(x) + ZEPS);
   if (Math.abs(x - xm) <= (tol2 - .5 * (b -a))) {
      xmin = x;

      return fx;
   }
   if (Math.abs(e) > tol1) {
      r = (x - w) * (fx - fv);
      q = (x - v) * (fx - fw);
      p = (x - v) * q - (x - w) * r;
      q = 2. * (q - r);
      if (q > 0.) p = -p;
      q = Math.abs(q);
      etemp = e;
      e = d;
      if (Math.abs(p) >= Math.abs(.5 * q * etemp) || p <= q * (a - x) ||
	 p >= q * (b - x)) {
	 d = CGOLD * (e = (x >= xm ? a - x : b - x));

      } else {
	 d = p / q;
	 u = x + d;
	 if (u - a < tol2 || b - u < tol2) d = sign_(tol1, xm - x);
      }

   } else {
      d = CGOLD * (e = (x >= xm ? a - x : b - x));
   }
   u = (Math.abs(d) >= tol1 ? x + d : x + sign_(tol1, d));

   fu = f1dim_(u, pcom, xicom, rspns, prds, ifirst);

   if (fu <= fx) {
      if (u >= x) a = x; else b = x;
      shft_(v, w, x, u);
      v = shiftarray[0];
      w = shiftarray[1];
      x = shiftarray[2];
      u = shiftarray[3];

      shft_(fv, fw, fx, fu);
      fv = shiftarray[0];
      fw = shiftarray[1];
      fx = shiftarray[2];
      fu = shiftarray[3];

   } else {
      if (u < x) a = u; else b = u;
      if (fu <= fw || w == x) {
         v = w;
         w = u;
         fv = fw;
         fw = fu;

      } else if (fu <= fv || v == x || v == w) {
         v = u;
         fv = fu;
      }
   }
}

printf_("brent: ITMAX exceeded.");

xmin = x;

return fx;
}

// -----------------------------------------------------------------------

static void mnbrak_(double ax, double bx, double cx, double fa, double fb,
   double fc, double pcom[], double xicom[], int rspns[],
   double prds[][], int ifirst) {

double ulim, u, r, q, fu, dum = 0.;

fa = f1dim_(ax, pcom, xicom, rspns, prds, ifirst);
fb = f1dim_(bx, pcom, xicom, rspns, prds, ifirst);

if (fb > fa) {
   shft_(dum, ax, bx, dum);
   dum = shiftarray[0];
   ax = shiftarray[1];
   bx = shiftarray[2];
   dum = shiftarray[3];

   shft_(dum, fb, fa, dum);
   dum = shiftarray[0];
   fb = shiftarray[1];
   fa = shiftarray[2];
   dum = shiftarray[3];
}

cx = (bx) + GOLD * (bx - ax);
fc = f1dim_(cx, pcom, xicom, rspns, prds, ifirst);

while(fb > fc) {
   r = (bx - ax) * (fb - fc);
   q = (bx - cx) * (fb - fa);

   u = (bx) - ((bx - cx) * q - (bx - ax) * r) /
       (2. * sign_(Math.max(Math.abs(q - r),TINY),q - r));

   ulim = (bx) + GLIMIT * (cx - bx);
   if ((bx - u) * (u - cx) > 0.) {
      fu = f1dim_(u, pcom, xicom, rspns, prds, ifirst);
      if (fu < fc) {
	 ax = (bx);
	 bx = u;
	 fa = (fb);
	 fb = fu;

         retarray[0] = ax;
         retarray[1] = bx;
         retarray[2] = cx;
         retarray[3] = fa;
         retarray[4] = fb;
         retarray[5] = fc;

	 return;

      }  else if (fu > fb) {
	 cx = u;
	 fc = fu;

         retarray[0] = ax;
         retarray[1] = bx;
         retarray[2] = cx;
         retarray[3] = fa;
         retarray[4] = fb;
         retarray[5] = fc;

	 return;
      }
      u = (cx) + GOLD * (cx - bx);
      fu = f1dim_(u, pcom, xicom, rspns, prds, ifirst);

   } else if ((cx - u) * (u - ulim) > 0.) {
      fu = f1dim_(u, pcom, xicom, rspns, prds, ifirst);
      if (fu < fc) {
	 shft_(bx, cx, u, cx + GOLD * (cx - bx));
         bx = shiftarray[0];
         cx = shiftarray[1];
         u = shiftarray[2];

	 shft_(fb, fc, fu,
	      f1dim_(u, pcom, xicom, rspns, prds, ifirst));
         fb = shiftarray[0];
         fc = shiftarray[1];
         fu = shiftarray[2];
      }

   } else if ((u - ulim) * (ulim - cx) >= 0.) {
      u = ulim;
      fu = f1dim_(u, pcom, xicom, rspns, prds, ifirst);

   } else {
      u = (cx) + GOLD * (cx - bx);
      fu = f1dim_(u, pcom, xicom, rspns, prds, ifirst);
   }
   shft_(ax, bx, cx, u);
   ax = shiftarray[0];
   bx = shiftarray[1];
   cx = shiftarray[2];
   u = shiftarray[3];

   shft_(fa, fb, fc, fu);
   fa = shiftarray[0];
   fb = shiftarray[1];
   fc = shiftarray[2];
   fu = shiftarray[3];

   retarray[0] = ax;
   retarray[1] = bx;
   retarray[2] = cx;
   retarray[3] = fa;
   retarray[4] = fb;
   retarray[5] = fc;

   /*
   printf_("mnbrak: ax= " + ax + " bx= " + bx + " cx= " + cx + " fa= " +
      " fb= " + fb + " fc= " + fc);
   */
}
}

// -------------------------------------------------------------------

static double func_(int option, double p[], double g[], int rspns[],
   double prds[][], int ifirst) {

/* Computes the objective function and gradients.
   option = 0: do not calculate gradient, g.
   option = 1: calculate gradient in addition to function value, fp. */

int i, j, retval;

double fp = 0., step = 1.e-5, psave;

/* Test function.
fp = getf_(p);
++nmf;
if (option == 1) {
   for (i = 0; i < n; ++i) {
      psave = p[i];
      p[i] += step;
      g[i] = getf_(p);
      ++nmf;
      g[i] = (g[i] - fp) / step;
      //printf_("func: i= " + i + " g= " + g[i]);
      p[i] = psave;
   }
}
if (true) {
   return fp;
}
*/

if (fnum == 1) {

   /* Load parameter values into appropriate locations. */

   xwghtx_(p, 1, false);

   /* Find objective function value: the sum of the individual error
      rates. */

   ITDmodnn.neterr_(rspns, prds, errs, rawerrs);
   fp = 0.;
   for (i = 0; i < k; ++i) {
      fp += errs[i];
   }

   // Update objective function evaluation counter.

   ++nmf;

   // Forward difference gradient approximation.

   if (option == 1) {
      for (i = 0; i < n; ++i) {
	 p[i] += step;
         xwghtx_(p, 1, false);
	 ITDmodnn.neterr_(rspns, prds, errs, rawerrs);
	 g[i] = 0.;
	 for (j = 0; j < k; ++j) g[i] += errs[j];
         ++nmf;

         // Compute gradient component.

         g[i] = (g[i] - fp) / step;

         // Restore parameter value.

	 p[i] -= step;
         xwghtx_(p, 1, false);
      }
   }
}

if (nmf > 10000) {
   iderr_("func: nmf= " + nmf + " exiting.");
}

return fp;
}

// ------------------------------------------------------------------------

static void shft_(double a, double b, double c , double d) {
// SHFT(a, b, c, d) (a) = (b) ; (b) = (c) ; (c) = (d);
shiftarray[0] = a;
shiftarray[1] = b;
shiftarray[2] = c;
shiftarray[3] = d;
shiftarray[0] = shiftarray[1];
shiftarray[1] = shiftarray[2];
shiftarray[2] = shiftarray[3];
}

// ---------------------------------------------------------------------

static double getf_(double p[]) {

/*
return (-3803.84 - 138.08 * p[0] - 232.9 * p[1] + 123.08 * p[0] * p[0]
      + 203.64 * p[1] * p[1] + 182.25 * p[0] * p[1]);
*/

return (p[0] * p[0] + p[1] * p[1]);
}
}
