import java.io.*;
public class Describe extends Id {
static double cntrd[] = new double[DATSZE];
static double rank[] = new double[DATSZE];

// -------------------------------------------------------------------------

public static void describe_() {

// Computes descriptive statistics of the data set.

boolean sameloc, tables = false;
String names[] = new String[TNMNDS];
int i, j, vrble, n, nmvars, nmboot = 500, nmbins, nfrac, start, loc3d, ndnm;
int index[] = new int[DATSZE];
int loc[] = new int[DATSZE];
double obssf, obsskew, obsdip, prob, val, q1, median, q3, iqr, rn, mean,
   smplvr, binwdth, cj, diff, diff2, diff4, m2, m4, kurtosis, logmean;
double x[] = new double[DATSZE];
double xsort[] = new double[DATSZE];
double boot[] = new double[DATSZE];
double skewstat[] = new double[nmboot];
double dipstat[] = new double[nmboot];
double b[] = new double[DATSZE / 10 + 1];
double freq[] = new double[DATSZE / 10];

fprintf_(1, "-------------- describe_data Command Output ------------\n"); 

// First, open a file for the frequency polygon plots.

fleopen_(2, "freqpoly.plt", 'w');
fprintf_(2, "varname bincenter relfreq");
fprintf_(1, "Frequency polygon plotting file is freqpoly.plt.");
fprintf_(1, "Format is: variable-name bin-center density.");

// Open time series plotting file.

fleopen_(3, "time.plt", 'w');
fprintf_(3, "varname x y locnm time value");
fprintf_(1, "\nTime series plotting file is time.plt.");
fprintf_(1, "Format is: variable-name x y location-number time value.");

// If tables have been requested, open table file.

if (tables) {
   fleopen_(4, "tables.dat", 'w');
   fprintf_(4, "varname loc class freq");
   fprintf_(1, "\nLocation by class table file is tables.dat.");
   fprintf_(1, "Format is: variable-name location class frequency.");
}

// Next, read data.

nmvars = Getdata.getdata_(datafle, names);

/* ------------------------------------------------------------------------
   For a spatial-only or temporal-only analysis, compute sample
   covariograms and sample cross-covariograms. */

if ((!spatial && temporal) || (spatial && !temporal)) {
   printf_("------ Creating plot file for empirical direct- and" +
      "\n cross-covariograms. ---------- ");
   Covmodl.cgramplt_(nmecoobsttl);
}

// Loop for calculating descriptive statistics on each observed variable.

start = 0;
for (vrble = 1; vrble <= nmvars; ++vrble) {
   ndnm = Getmodlutils.getndnm_(names[vrble - 1]);

   // Initialize things.

   dattmin = 1.e10;
   dattmax = -1.e10;
   datmin = 1.e10;
   datmax = -1.e10;
   loc3d = 1;
   n = nmobs[idnmbrm1][ndnm - 1];
   rn = (double) n;
   for (i = 0; i < n; ++i) {

      // Create data vectors needed for sorting.

      x[i] = dat2_dat[i + start];
      xsort[i] = x[i];
      index[i] = i + 1;

      // Detect and assign 3-dimensional space location (loc3d).

      if (i > 0) {
         sameloc = false;
         for (j = 0; j < i; ++j) {
            if (Math.abs(dat2_x[j + start] - dat2_x[i + start]) < 1.e-20 &&
                Math.abs(dat2_y[j + start] - dat2_y[i + start]) < 1.e-20 &&
                Math.abs(dat2_z[j + start] - dat2_z[i + start]) < 1.e-20) {
               sameloc = true;
               break;
            }
         }
         if (!sameloc) ++loc3d;
      }
      dat2_loc3d[i + start] = loc3d;
      loc[i] = loc3d;

      // Look for min, max of t and variable.

      if (dat2_t[i + start] < dattmin) dattmin = dat2_t[i + start];
      if (dattmax < dat2_t[i + start]) dattmax = dat2_t[i + start];

      if (x[i] < datmin) datmin = x[i];
      if (datmax < x[i]) datmax = x[i];
   }

   strng = "\n----- Description of Observations on " + names[vrble - 1] +
      " -----\n";
   fprintf_(1, strng);
   printf_(strng);

   /* --- Sample size, Mean, Standard Deviation, Extremes, Quantiles -----
      First, print number of observations on this variable. */

   fprintf_(1, "Count= " + n);

   // Print min, max.

   fprintf_(1, "dattmin= " + dattmin + " dattmax= " + dattmax);
   fprintf_(1, "datmin=  " + datmin + " datmax= " + datmax);

   // Compute and print quartiles.

   Idsort.idsort_(xsort, index, 1, n);
   q1 = xsort[((int) Math.round(.25 * rn)) - 1];
   median = xsort[((int) Math.round(.5 * rn)) - 1];
   q3 = xsort[((int) Math.round(.75 * rn)) - 1];
   iqr = q3 - q1;
   fprintf_(1, "Q1= " + q1);
   fprintf_(1, "Q2= " + median + " (median)");
   fprintf_(1, "Q3= " + q3);
   fprintf_(1, "IQR= " + iqr);

   // If requested, write a file of discretized variables by location.

   if (tables) tables_(4, names[vrble - 1], n, q1, q3,
                               x, loc3d, loc);

   // Compute and print mean and standard deviation.

   mean = 0.;
   smplvr = 0.;
   for (i = 0; i < n; ++i) {
      mean += x[i];
      smplvr += x[i] * x[i];
   }
   smplvr = (smplvr - ((mean * mean) / rn)) / (rn - 1.);
   mean /= rn;
   fprintf_(1, "Mean=               " + mean);
   fprintf_(1, "Standard Deviation= " + Math.sqrt(smplvr));

   // --------------------- Frequency Polygon -----------------------------
   // Create a plot file for the frequency polygon estimate of the density.
   // Bin width rule is from Simonoff (1996), p. 22.

   binwdth = 2.15 * Math.sqrt(smplvr) / Math.pow(rn, .2);
   nmbins = 0;
   b[0] = .9999999 * datmin;
   for (;;) {
      freq[nmbins] = 0.;
      ++nmbins;
      b[nmbins] = b[nmbins - 1] + binwdth;
      if (b[nmbins] > datmax) break;
   }
 
   // Construct histogram.

   for (i = 0; i < n; ++i) {
      for (j = 0; j < nmbins; ++j) {
         if (b[j] < x[i] && x[i] <= b[j + 1]) {
            freq[j] += 1.;
            break;
         }
      }
   }

   // Create frequency polygon plotting file.

   fprintf_(2, names[vrble - 1] + " " + (b[0] - .5 * binwdth) + " 0.");
   for (j = 0; j < nmbins; ++j) {
      cj = .5 * (b[j] + b[j + 1]);
      fprintf_(2, names[vrble - 1] + " " + cj + " " +
         (freq[j] / (rn * binwdth)));
   }
   fprintf_(2, names[vrble - 1] + " " + (b[nmbins] + .5 * binwdth) + " 0."); 
 
   // Test for serial correlation with the Runs Up-and-Down test.

   fprintf_(1, "Runs Up-and-Down test p-value= " +
      fdble_(runsupd_(n, x), 5, 3));

   // ---------------------- Time Series Plots ---------------------------

   if (dattmin < dattmax) {
      for (i = 0; i < n; ++i) {
         fprintf_(3, names[vrble - 1] + " " + dat2_x[i + start] + " " +
	    dat2_y[i + start] + " " + dat2_loc3d[i + start] +
            " " + dat2_t[i + start] + " " + dat2_dat[i + start]);
      }
   }

   // -------------------- Shapiro-Francia test of normality. ------------

   obssf = Pltnrm.shapfran_(n, x, mean);
   fprintf_(1, "\nShapiro-Francia normality test statistic= " + obssf);
   fprintf_(1, "p-value= " + Pltnrm.sfpvalue_(n, obssf));

   // ---------------- Shapiro-Francia test of lognormality. ------------

   logmean = 0.;
   for (i = 0; i < n; ++i) {
      if (x[i] < 1.e-2) boot[i] = Math.log(1.e-2);
      else boot[i] = Math.log(x[i]);
      logmean += boot[i];
   }
   logmean /= rn;
   obssf = Pltnrm.shapfran_(n, boot, logmean);
   fprintf_(1, "\nTest of Lognormality (on log(obs)):");
   fprintf_(1, "\n Shapiro-Francia normality test statistic= " + obssf);
   fprintf_(1, " p-value= " + Pltnrm.sfpvalue_(n, obssf));

   /* -------------------- Skew and Unimodality --------------------------
      First, compute the observed skew and unimodality statistics. */

   obsskew = gupskew_(n, median, x);
   obsdip = dipstat_(n, xsort);

   if (n < 6000) {
   
      /* If n is not too big, find a bootstrap C.I. for the skew and do a
         bootstrap test for unimodality. */

      for (i = 0; i < nmboot; ++i) {
         bootsmpl_(n, x, n, boot);
         Idsort.idsort_(boot, index, 1, n);
         median = boot[((int) Math.round(.5 * rn)) - 1];
         skewstat[i] = gupskew_(n, median, boot);
         dipstat[i] = dipstat_(n, boot);
      }

   } else {
      nmboot = 0;
   }

   // Confidence interval and test for zero skew.

   confint_("Skew", obsskew, .95, nmboot, skewstat);

   /* If bootstrapping, compute confidence interval and test for
      unimodality.  Under H_0, the dip statistic is 0.  This is why the
      test statistic under the null hypothesis is
      observed_dip - expected_dip = observed_dip - 0.
      The p-value of this test then, is the probability of seeing the
      observed statistic or greater from the Monte Carlo (bootstrapped)
      distribution of the unrestricted test statistic. */

   confint_("Unimodality", obsdip, .95, nmboot, dipstat);

   // Kurtosis.

   m2 = 0.;
   m4 = 0.;
   for (i = 0; i < n; ++i) {
      diff = x[i] - mean;
      diff2 = diff * diff;
      diff4 = diff2 * diff2;
      m2 += diff2;
      m4 += diff4;
   }
   kurtosis = (rn * m4 / (m2 * m2)) - 3.;
   fprintf_(1, "\nObserved Kurtosis= " + fdble_(kurtosis, 5, 3));

   // Increment starting point for reading data vector.

   start += nmobs[idnmbrm1][ndnm - 1];
}
fclose_(2, 'w');
fclose_(3, 'w');
if (tables) fclose_(4, 'w');
}

// -------------------------------------------------------------------------

public static void compare_() {

// Compares samples between pairs of nodes.

int ndnm1, ndnm2, i, j, k, n1, n2, nmin, nmboot = 500;
int indx1[] = new int[DATSZE];
int indx2[] = new int[DATSZE];

double med1, med2, diff, diff2, diff4, m2, m4, mean1, mean2, kurtosis1,
   kurtosis2, rnmin, obsmdiff, obsscdiff, obsskdiff, obskdiff, rn1, rn2;
double x1[] = new double[DATSZE];
double x2[] = new double[DATSZE];
double boot1[] = new double[DATSZE];
double boot2[] = new double[DATSZE];
double meddiff[] = new double[DATSZE];
double iqrdiff[] = new double[DATSZE];
double skewdiff[] = new double[DATSZE];
double kurtdiff[] = new double[DATSZE];

for (k = 0; k < Getmodl.nmpairs; ++k) {

   fprintf_(1,
      "\n------- Differences between node " + Getmodl.pairnames[k][0] +
      " and node " + Getmodl.pairnames[k][1] + " ---------");

   // Get node numbers and then load associated samples.

   ndnm1 = Getmodlutils.getndnm_(Getmodl.pairnames[k][0]);
   ndnm2 = Getmodlutils.getndnm_(Getmodl.pairnames[k][1]);

   n1 = 0;
   n2 = 0;
   for (i = 0; i < nmecoobsttl; ++i) {
      if (dat2_vrble[0][i] == ndnm1) {
         x1[n1] = dat2_dat[i];
         indx1[n1] = n1 + 1;
         ++n1;

      } else if (dat2_vrble[0][i] == ndnm2) {
         x2[n2] = dat2_dat[i];
         indx2[n2] = n2 + 1;
         ++n2;
      }
   }
   rn1 = (double) n1;
   rn2 = (double) n2;

   /* Compute observed values of median, IQR, skew, and kurtosis
      difference. */

   Idsort.idsort_(x1, indx1, 1, n1);
   Idsort.idsort_(x2, indx2, 1, n2);

   // Medians.

   med1 = x1[((int) Math.round(.5 * n1)) - 1]; 
   med2 = x2[((int) Math.round(.5 * n2)) - 1]; 
   obsmdiff = med1 - med2;

   // IQR's (scale).
   
   obsscdiff = (x1[((int) Math.round(.75 * rn1)) - 1] -
                x1[((int) Math.round(.25 * rn1)) - 1]) -
               (x2[((int) Math.round(.75 * rn2)) - 1] -
                x2[((int) Math.round(.25 * rn2)) - 1]);

   // Skews.

   obsskdiff = gupskew_(n1, med1, x1) - gupskew_(n2, med2, x2);
      
   // Kurtoses.  First, compute means.
   
   mean1 = 0.;
   mean2 = 0.;
   for (j = 0; j < n1; ++j) mean1 += x1[j];
   for (j = 0; j < n2; ++j) mean2 += x2[j];
   mean1 /= n1;
   mean2 /= n2;

   m2 = 0.;
   m4 = 0.;
   for (j = 0; j < n1; ++j) {
      diff = x1[j] - mean1;
      diff2 = diff * diff;
      diff4 = diff2 * diff2;
      m2 += diff2;
      m4 += diff4;
   }
   kurtosis1 = (rn1 * m4 / (m2 * m2)) - 3.;

   m2 = 0.;
   m4 = 0.;
   for (j = 0; j < n2; ++j) {
      diff = x2[j] - mean2;
      diff2 = diff * diff;
      diff4 = diff2 * diff2;
      m2 += diff2;
      m4 += diff4;
   }
   kurtosis2 = (rn2 * m4 / (m2 * m2)) - 3.;

   obskdiff = kurtosis1 - kurtosis2;

   /* Bootstrap samples are each of size min(n1,n2).  Then, compute
      medians, median difference, IQR difference, skew difference, and
      kurtosis difference. */

   nmin = Math.min(n1, n2);
   rnmin = (double) nmin;
   for (i = 0; i < nmboot; ++i) {
      bootsmpl_(n1, x1, nmin, boot1);
      bootsmpl_(n2, x2, nmin, boot2);
      Idsort.idsort_(boot1, indx1, 1, nmin);
      Idsort.idsort_(boot2, indx2, 1, nmin);

      // Medians.

      med1 = boot1[((int) Math.round(.5 * rnmin)) - 1]; 
      med2 = boot2[((int) Math.round(.5 * rnmin)) - 1]; 
      meddiff[i] = med1 - med2;

      // IQR's (scale).
   
      iqrdiff[i] = (boot1[((int) Math.round(.75 * rnmin)) - 1] -
                    boot1[((int) Math.round(.25 * rnmin)) - 1]) -
                   (boot2[((int) Math.round(.75 * rnmin)) - 1] -
                    boot2[((int) Math.round(.25 * rnmin)) - 1]);

      // Skews.

      skewdiff[i] = gupskew_(nmin, med1, boot1) -
                    gupskew_(nmin, med2, boot2);
      
      // Kurtoses.  First, compute means.
   
      mean1 = 0.;
      mean2 = 0.;
      for (j = 0; j < nmin; ++j) {
         mean1 += boot1[j];
         mean2 += boot2[j];
      }
      mean1 /= rnmin;
      mean2 /= rnmin;

      m2 = 0.;
      m4 = 0.;
      for (j = 0; j < nmin; ++j) {
         diff = boot1[j] - mean1;
         diff2 = diff * diff;
         diff4 = diff2 * diff2;
         m2 += diff2;
         m4 += diff4;
      }
      kurtosis1 = (rnmin * m4 / (m2 * m2)) - 3.;

      m2 = 0.;
      m4 = 0.;
      for (j = 0; j < nmin; ++j) {
         diff = boot2[j] - mean2;
         diff2 = diff * diff;
         diff4 = diff2 * diff2;
         m2 += diff2;
         m4 += diff4;
      }
      kurtosis2 = (rnmin * m4 / (m2 * m2)) - 3.;

      kurtdiff[i] = kurtosis1 - kurtosis2;
   }

   /* Report confidience intervals for difference in medians, IQR,
      skew, and kurtosis. */

   confint_("Median Difference", obsmdiff, .95, nmboot, meddiff);
   confint_("IQR Difference", obsscdiff, .95, nmboot, iqrdiff);
   confint_("Skew Difference", obsskdiff, .95, nmboot, skewdiff);
   confint_("Kurtosis Difference", obskdiff, .95, nmboot, kurtdiff);
}
}

// -------------------------------------------------------------------------

public static void confint_(String name, double obsstat, double cilevel,
   int n, double x[]) {

// Find minimum length C.I.

int i, nfrac;
int index[] = new int[DATSZE];
double cilength = 0., cilow = 0., cihigh = 0., minlength = 1.e20, prob = 0.;

fprintf_(1, "\nObserved " + name + "= " + fdble_(obsstat, 6, 3));
if (n == 0) return;

Idsort.idsort_(x, index, 1, n);
nfrac = (int) Math.round(cilevel * (double) n);
for (i = 0; i < n - nfrac; ++i) {
   cilength = x[i + nfrac] - x[i];
   if (cilength < minlength) {
      minlength = cilength;
      cilow = x[i];
      cihigh = x[i + nfrac];
   }
}
fprintf_(1, name + " " + fdble_(100. * cilevel, 5, 1) + "% C.I.= ("
   + fdble_(cilow, 5, 3) + ", " + fdble_(cihigh, 5, 3) + ")");

/* Now, perform the hypothesis test of H_0: E[Statistic] <= 0.  Do this
   by finding the fraction of bootstrap statistics computed under no
   hypothesis restrictions (x[i] - obsstat) that are greater than the
   the statistic computed from the data under null hypothesis restrictions:
   obsstat - 0.  This is: x[i] - obsstat > obsstat - 0 which is:
   x[i] > 2 * obsstat.  Note that the expected value of x[i] is
   approximately obsstat and hence the "2" is the result of removing the
   "centering" of the statistic (x[i] - obsstat).  Finding this fraction
   estimates the probabilty of seeing an unexpected event under the
   null hypothesis that E[Statistic] <= 0. */

prob = 0.;
for (i = 0; i < n; ++i) {
   if (x[i] > 2. * obsstat) prob += 1.;
}
prob /= (double) n;
fprintf_(1, "p-value of H_0: E[" + name + "] <= 0= " + fdble_(prob, 5, 3));
fprintf_(1, "p-value of H_0: E[" + name + "] >= 0: " +
   fdble_((1. - prob), 6, 3));
}

// ------------------------------------------------------------------------

public static double runsupd_(int n, double x[]) {

/* Performs the Runs Up-and-Down test and returns the large sample
   2-sided p-value.  See Madansky (1988, p. 113). */

int i, r = 0;
int v[] = new int[n - 1];
double rn = (double) n, z;

// First, compute the positive adjacent differences indicator vector.

for (i = 0; i < n - 1; ++i) {
   if (x[i + 1] > x[i]) v[i] = 1;
   else v[i] = 0;
}

// Count the runs in v.

for (i = 0; i < n - 2; ++i) {
   if (v[i + 1] != v[i]) ++r;
}

// Compute the test statistic

z = ((double) r) - (2 * rn - 1.) / 3.;
z /= Math.sqrt((16. * rn - 29.) / 90.);

// Return the 2-sided p-value.

if (z > 0.) return 2. * (1. - Pltnrm.cump_(z));
else return 2. * Pltnrm.cump_(z);
}

// -------------------------------------------------------------------------

public static double dipstat_(int n, double x[]) {

/* Computes the Dip statistic, a measure of how close the empirical CDF
   is to the closest unimodal CDF.  Hence, this statistic is used to test
   for unimodality.  See Hartigan (1985), Applied Statistics, Algorithm
   AS 217.  !!!Algorithm assumes that the data has been sorted. */

int i, ic, icva, icv, icx, icxa, igcm, igcm1, igcmx, ig, ih, ix, iv, j, jb,
   je, jr, jk, k, kb, ke, kr, lcmiv, lcmiv1, lcm1, low, high, mjk, mjmjk, mnj,
   mnmnj, na;
int gcm[] = new int[n];
int lcm[] = new int[n];
int mj[] = new int[n];
int mn[] = new int[n];
double a, b, cnstnt, d, dx, dip, dipnew, dl, du, fn, t, temp, xl, xu;

if (n <= 1) iderr_("n=1 in dipstat_()");

/* low contains the index of the current estimate of the lower end of the
   modal interval, high contains the index for the current upper end. */

fn = (double) n;
low = 1;
high = n;
dip = 1. / fn;
xl = x[low - 1];
xu = x[high - 1];

/* Establish the indices over which combination is necessary for the
   convex minorant fit. */

mn[0] = 1;
minor: for (j = 2; j <= n; ++j) {
   mn[j - 1] = j - 1;
   for (i = 1; i <= 2 * n; ++i) {
      mnj = mn[j - 1];
      mnmnj = mn[mnj - 1];
      a = (double) (mnj - mnmnj);
      b = (double) (j - mnj);
      if (mnj == 1 || (x[j - 1] - x[mnj - 1]) * a <
                      (x[mnj - 1] - x[mnmnj - 1]) * b) continue minor;
      mn[j - 1] = mnmnj;
   }
   if (i >= 2 * n) iderr_("error 1: i=2n in dipstat");
}

/* Establish the indices over which combination is necessary for the
   concave majorant fit. */

mj[n - 1] = n;
na = n - 1;
major: for (jk = 1; jk <= na; ++jk) {
   k = n - jk;
   mj[k - 1] = k + 1;
   for (i = 1; i <= 2 * n; ++i) {
      mjk = mj[k - 1];
      mjmjk = mj[mjk - 1];
      a = (double) (mjk - mjmjk);
      b = (double) (k - mjk);
      if (mjk == n || (x[k - 1] - x[mjk - 1]) * a <
                      (x[mjk - 1] - x[mjmjk - 1]) * b) continue major; 
      mj[k - 1] = mjmjk;
   }
   if (i >= 2 * n) iderr_("error 2: i=2n in dipstat");
}

/* Start the cycling.  Collect the change points for the gcm from high to
   low. */

for (i = 1; i <= 2 * n; ++i) {
   ic = 1;
   gcm[0] = high;
   for (;;) {
      igcm1 = gcm[ic - 1];
      ++ic;
      gcm[ic - 1] = mn[igcm1 - 1];
      if (gcm[ic - 1] <= low) break;
   }
   icx = ic;

   // Collect the change points for the lcm from low to high.

   ic = 1;
   lcm[0] = low;
   for (;;) {
      lcm1 = lcm[ic - 1];
      ++ic;
      lcm[ic - 1] = mj[lcm1 - 1];
      if (lcm[ic - 1] >= high) break;
   }
   icv = ic;

   /* icx, ix, ig are counters for the convex minorant.
      icv, iv, ih are conters for the concave majorant. */

   ig = icx;
   ih = icv;

   /* Find the largest distance greater than "dip" between the gcm and the
      lcm from low to high. */

   ix = icx - 1;
   iv = 2;
   d = 0.;
   if (icx != 2 || icv != 2) {
      for (;;) {
         igcmx = gcm[ix - 1];
         lcmiv = lcm[iv - 1];
         if (igcmx <= lcmiv) {
         
            /* If the next point of either the gcm or lcm is from the lcm then
               calculate distance here. */

            lcmiv1 = lcm[iv - 2];
            a = (double) (lcmiv - lcmiv1);
            b = (double) (igcmx - lcmiv1 - 1);
            dx = (x[igcmx - 1] - x[lcmiv1 - 1] * a) /
                 (fn * (x[lcmiv - 1] - x[lcmiv1 - 1])) - b / fn;
            --ix;
            if (dx >= d) {
               d = dx;
               ig = ix + 1;
               ih = iv;
            }

         } else {

            /* If the next point of either the gcm or lcm is from the gcm, then
               then calculate distance here. */

            lcmiv = lcm[iv - 1];
            igcm = gcm[ix - 1];
            igcm1 = gcm[ix];
            a = (double) (lcmiv - igcm1 + 1);
            b = (double) (igcm - igcm1);
            dx = a / fn - ((x[lcmiv - 1] - x[igcm1 - 1]) * b) /
                           (fn * (x[igcm - 1] - x[igcm1 - 1]));
            ++iv;
            if (dx >= d) {
               d = dx;
               ig = ix + 1;
               ih = iv - 1;
            }
         }

         if (ix < 1) ix = 1;
         if (iv > icv) iv = icv;
         if (gcm[ix - 1] == lcm[iv - 1]) break;
      }

   } else {
      d = 1. / fn;
   }

   if (d < dip) {
      dip *= .5;
      xl = x[low - 1];
      xu = x[high - 1];
      return dip;
   }

   /* Calculate the dips for the current low and high.
      First, the dip for the convex minorant. */

   dl = 0.;
   if (ig != icx) {
      icxa = icx - 1;
      for (j = ig; j <= icxa; ++j) {
         temp = 1. / fn;
         jb = gcm[j];
         je = gcm[j - 1];
         if (je - jb > 1 && x[je - 1] != x[jb - 1]) {
            a = (double) (je - jb);
            cnstnt = a / (fn * (x[je - 1] - x[jb - 1]));
            for (jr = jb; jr <= je; ++jr) {
               b = (double) (jr - jb + 1);
               t = b / fn - (x[jr - 1] - x[jb - 1]) * cnstnt;
               if (t > temp) temp = t;
            }
         }
         if (dl < temp) dl = temp;
      }
   }

   // The dip for the concave majorant.

   du = 0.;
   if (ih != icv) {
      icva = icv - 1;
      for (k = ih; k <= icva; ++k) {
         temp = 1. / fn;
         kb = lcm[k - 1];
         ke = lcm[k];
         if (ke - kb > 1 && x[ke - 1] != x[kb - 1]) {
            a = (double) (ke - kb);
            cnstnt = a / (fn * (x[ke - 1] - x[kb - 1]));
            for (kr = kb; kr <= ke; ++kr) {
               b = (double) (kr - kb - 1);
               t = (x[kr - 1] - x[kb - 1]) * cnstnt - b / fn;
               if (t > temp) temp = t;
            }
         }
         if (du < temp) du = temp;
      }
   }

   // Determine the current maximum.

   dipnew = dl;
   if (du > dl) dipnew = du;
   if (dip < dipnew) dip = dipnew;
   low = gcm[ig - 1];
   high = lcm[ih - 1];
}
if (i >= 2 * n) iderr_("error 3: i=2n in dipstat");

return 0.;
} 

// ----------------------------------------------------------------------

public static double gupskew_(int n, double median, double x[]) {

// Gupta's skew statistic.
/*
gskew <- function(datfull) {
   dat <- datfull[!is.na(datfull)]
   n <- length(dat)
   m <- median(dat)
   cntrd <- abs(dat - m)
   cntrd <- rank(cntrd) / (2 * (n + 1))
   r <- sapply(cntrd, min, .5)
   gstat <- sum(r * sign(dat - m)) / sqrt(n)
   return(gstat)
} 
*/

int i;
int index[] = new int[n];
double rn = (double) n, val = 0., cnstnt;

for (i = 0; i < n; ++i) {
   index[i] = i + 1;
   cntrd[i] = Math.abs(x[i] - median);
}

// Find ranks of cntrd.

Idsort.idsort_(cntrd, index, 1, n);
for (i = 1; i <= n; ++i) rank[index[i - 1] - 1] = (double) i;

// Compute skew statistic.

cnstnt = 2. * (rn + 1.);
for (i = 0; i < n; ++i) {
   val += Math.min(rank[i] / cnstnt, .5) * sign_(1., x[i] - median);
} 

return val / Math.sqrt(rn);

}

// ----------------------------------------------------------------------

public static void bootsmpl_(int n, double data[], int nmboot,
   double boot[]) {

// Draws a bootstrap sample of size nmboot from the n observations in dat.

int i, j;
double rn;

rn = (double) n;
for (i = 0; i < nmboot; ++i) {
   j = (int) Math.round(Rndm.rndm1_(0, 0) * rn);
   if (j < 1) j = 1;
   if (j > n) j = n;
   boot[i] = data[j - 1];
}
}

// -----------------------------------------------------------------------

public static void tables_(int tfle, String name, int n, double datmin,
   double datmax, double x[], int nmloc, int loc[]) {

// Discretizes x and writes a x-class by loc table.

int i, j, k, nmclass = 5, nloc;
String cat[] = new String[nmclass];
int freq[] = new int[nmclass];
double binwdth;
double low[] = new double[nmclass];
double high[] = new double[nmclass];
double xloc[] = new double[DATSZE];

// Compute bin boundaries and create bin labels.

low[0] = .999 * datmin;
high[nmclass - 1] = 1.001 * datmax;
binwdth = (high[nmclass - 1] - low[0]) / (double) nmclass;
high[0] = low[0] + binwdth;

for (j = 1; j < nmclass - 1; ++j) {
   low[j] = high[j - 1];
   high[j] = low[j] + binwdth;
}
low[nmclass - 1] = high[nmclass - 2];

// Create class labels.

for (j = 0; j < nmclass; ++j) {
   cat[j] = "c:" + fdble_(low[j],7,3).trim() + "-" +
      fdble_(high[j],7,3).trim();
}

// Find frequency distribution for each location.

for (k = 1; k <= nmloc; ++k) {
   nloc = 0;
   for (i = 0; i < n; ++i) {
      if (loc[i] == k) {
         xloc[nloc] = x[i];
         ++nloc;
      }
   }

   // Find bin counts for this location.

   for (j = 0; j < nmclass; ++j) freq[j] = 0;
   for (i = 0; i < nloc; ++i) {
      for (j = 0; j < nmclass; ++j) {
         if (low[j] < xloc[i] && xloc[i] <= high[j]) {
            ++freq[j];
            break;
         }
      }
   }
   for (i = 0; i < nmclass; ++i) {
      fprintf_(tfle, name + " " + k + " " + cat[i] + " " + freq[i]);
   }
}
}
}
