import java.util.*;
class Decsurf extends Intridslve {

// -----------------------------------------------------------------------

static void decsurf_() {

// Finds the optimal decision over a region of parameter combinations.

int i, j, k, nmpoints = 50, siiwpk, smmgk; // was 50

double maxutil, thisrisk, averisk, avegain, thisgain, decval = 0., inc,
   sellfew, sellseveral, sellmany, smallpay = 0., decentpay = 0.,
   bigpay = 0., wght1 = 0., wght2 = 0.;

inc = 1. / ((double) (nmpoints + 2));

siiwpk = Getmodlutils.getndnm_("SIIWP");
smmgk = Getmodlutils.getndnm_("SMMG");

// Find this model's perceived risk and gain from legal employment.

thisrisk = condprb[idnmbrm1][siiwpk - 1][0][1][0][0][0][0][0][0];
for (k = 0; k < 3; ++k) { // Loop over MMG values.
   smallpay += condprb[idnmbrm1][smmgk - 1][2][k][1][0][0][0][0][0];
}
thisgain = smallpay / 3.;
printf_("decsurf: legal thisrisk= " + thisrisk + " thisgain= " + thisgain);

// Find this model's perceived risk and gain from poaching.

sellfew = condprb[idnmbrm1][siiwpk - 1][0][2][0][0][0][0][0][0];
sellseveral = condprb[idnmbrm1][siiwpk - 1][0][3][0][0][0][0][0][0];
sellmany = condprb[idnmbrm1][siiwpk - 1][0][4][0][0][0][0][0][0];
thisrisk = (sellfew + sellseveral + sellmany) / 3.;

smallpay = 0.;
decentpay = 0.;
bigpay = 0.;
for (k = 0; k < 3; ++k) { // Loop over MMG values.
   smallpay += condprb[idnmbrm1][smmgk - 1][2][k][2][0][0][0][0][0];
   decentpay += condprb[idnmbrm1][smmgk - 1][2][k][3][0][0][0][0][0];
   bigpay += condprb[idnmbrm1][smmgk - 1][2][k][4][0][0][0][0][0];
}
smallpay /= 3.;
decentpay /= 3.;
bigpay /= 3.;
thisgain = (smallpay + decentpay + bigpay) / 3.;
printf_("decsurf: poaching thisrisk= " + thisrisk + " thisgain= " + thisgain);

// Compute average risk and average gain over a grid of points.

sellfew = .01;
sellseveral = .02;
sellmany = .03;
for (i = 0; i < nmpoints; ++i) {

   // Assign poaching risk values and compute their average.
 
   condprb[idnmbrm1][siiwpk - 1][0][2][0][0][0][0][0][0] = sellfew;
   condprb[idnmbrm1][siiwpk - 1][1][2][0][0][0][0][0][0] = 1. - sellfew;
   condprb[idnmbrm1][siiwpk - 1][0][3][0][0][0][0][0][0] = sellseveral;
   condprb[idnmbrm1][siiwpk - 1][1][3][0][0][0][0][0][0] = 1. - sellseveral;
   condprb[idnmbrm1][siiwpk - 1][0][4][0][0][0][0][0][0] = sellmany;
   condprb[idnmbrm1][siiwpk - 1][1][4][0][0][0][0][0][0] = 1. - sellmany;
   averisk = (sellfew + sellseveral + sellmany) / 3.;
   
   smallpay = .01;
   decentpay = .02;
   bigpay = .03;
   for (j = 0; j < nmpoints; ++j) {

      // Assign monetary gain goal values and compute their average.

      for (k = 0; k < 3; ++k) { // Loop over MMG values.
         wght1 = (smallpay < .5) ? .25 : .75;
         wght2 = 1. - wght1;
         condprb[idnmbrm1][smmgk - 1][2][k][2][0][0][0][0][0] = smallpay;
         condprb[idnmbrm1][smmgk - 1][1][k][2][0][0][0][0][0] =
            wght1 * (1. - sellfew);
         condprb[idnmbrm1][smmgk - 1][0][k][2][0][0][0][0][0] =
            wght2 * (1. - sellfew);

         wght1 = (decentpay < .5) ? .25 : .75;
         wght2 = 1. - wght1;
         condprb[idnmbrm1][smmgk - 1][2][k][3][0][0][0][0][0] = decentpay;
         condprb[idnmbrm1][smmgk - 1][1][k][3][0][0][0][0][0] =
            wght1 * (1. - sellseveral);
         condprb[idnmbrm1][smmgk - 1][0][k][3][0][0][0][0][0] =
            wght2 * (1. - sellseveral);

         wght1 = (bigpay < .5) ? .25 : .75;
         wght2 = 1. - wght1;
         condprb[idnmbrm1][smmgk - 1][2][k][4][0][0][0][0][0] = bigpay;
         condprb[idnmbrm1][smmgk - 1][1][k][4][0][0][0][0][0] =
            wght1 * (1. - sellmany);
         condprb[idnmbrm1][smmgk - 1][0][k][4][0][0][0][0][0] =
            wght2 * (1. - sellmany);
      }
      avegain = (smallpay + decentpay + bigpay) / 3.;

      // Find optimal decision and then set decision surface value.

      maxutil = Idsolve.idsolve_(1);

      if (nodelbls[idnmbrm1][decnode[0] - 1]
	          [optactn].equals("do_nothing") ||
          nodelbls[idnmbrm1][decnode[0] - 1]
	          [optactn].equals("take_legal_employment")) {
         decval = 0.;

      } else {
         decval = 1.;
      }

      fprintf_(1, fdble_(averisk, 6, 3) + " " + fdble_(avegain, 6, 3) +
         " " + decval);
      printf_(fdble_(averisk, 6, 3) + " " + fdble_(avegain, 6, 3) +
         " " + decval);

      smallpay += inc;
      decentpay += inc;
      bigpay += inc;
   }
   sellfew += inc;
   sellseveral += inc;
   sellmany += inc;
}
}
}
