public class Cptrules extends Readnet {
static int nmrules  = 0;

static int rulenmprtvals[][] = new int[TNMRULES][TNMPRTS];
static int ruleprtvals[][][] = new int[TNMRULES][TNMPRTS][TNMVALS];
static int prntvals[] = new int[TNMPRTS];

static double wght1 = 0., wght2 = 0.;

static double rulenodevals[][] = new double[TNMRULES][TNMVALS];

// ---------------------------------------------------------------------

static void cptrules_(int node) {

/* For nodes with at least one parent, this routine reads a node's
   rules for creating entries in the node's Conditional
   Probability Table (CPT).  Rules are listed in the .par file just before
   the node's CPT.  A rule's antecedent consists of a list of
   each parent's values.  Within a parent, values are of course related
   by the "or" logical operator.  Parents are related to each other
   by the "and" operator.  The keyword "any" indicates that all parental
   values are acceptable for that parent.  Note that all of the node's
   parents must be explicitly listed in the rule.  If a desired rule has
   "or" between a pair of parents, write separate rules for each set of
   "or"'d conditions.

   Let a node have m values.  The following rule format must be followed:

   Record 1: Number_of_rules: #_of_rules
   Record 2. Parent_name   Number_of_parent_values_in_rule
      parent_values_separated_by_spaces

   Record 3. Second_parent_name

   ...

   Last record: First_m-1_conditional_probabilities_or_constants

   Example:
   To express the rule:
   if ((INS == self || INS == kenrr) && INACTN == any) then val1 = 3.0

   enter the following into the .par file just before the CPT for the
   node ECONCHG:

   Number_of_rules: 1
   INS 2 self kenrr
   INACTN 1 any
   3.0
*/

String prtname, prtvalstrng, dumstrng;

int prtnm, i, j, k, rulenmvals = 0;

// Initialize the number of rules.

nmrules = 0;

// If this node has no parents, return.

if (nmnghs == 0) {
   return;
}

// Read the number of rules.

strng = fgetstrng_(parmfle);

if (!strng.equals("Number_of_rules:")) {
   streamTokenizer[parmfle - 1].pushBack();
   return;
}
nmrules = fgetint_(parmfle);

// Return if nmrules=0.

if (nmrules == 0) {
   return;

} else if (nmrules < 0) {
   iderr_("cptrules: nmrules= " + nmrules);
}

printf_("cptrules: !!! loading rules for node " + node);

// Loop thru the rules.

for (i = 0; i < nmrules; ++i) {
   
   // Read weights for a Determ_Contin function rule and return.

   if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Contin")) {
      wght1 = fgetdble_(parmfle);
      wght2 = fgetdble_(parmfle);
      return;
   }

   // Loop over the number of parents.

   for (j = 0; j < nmnghs; ++j) {
      
      // Read parent name and the number of parent values in this rule.

      prtname = fgetstrng_(parmfle);
      prtnm = Getmodlutils.getndnm_(prtname);
      rulenmprtvals[i][j] = fgetint_(parmfle);

      // Read these parent values.

      for (k = 0; k < rulenmprtvals[i][j]; ++k) {
	 prtvalstrng = fgetstrng_(parmfle);
	       
         // Trim front and back whitespace and convert to lowercase.

         dumstrng = prtvalstrng.toLowerCase();
         prtvalstrng = dumstrng.trim();

	 if (prtvalstrng.equals("any")) {
	    ruleprtvals[i][j][0] = -1;

	 } else {
	    ruleprtvals[i][j][k] =
	       Getmodlutils.getndval_(prtnm, prtvalstrng, true);
            if (ruleprtvals[i][j][k] <= 0) {
               iderr_("cptrules: parent values read failure");
	    }
	 }
      }
   }

   /* Read node's probabilities or values under the antecedents of this
      rule.  First, load the rule's number of values. */
   
   if (varinfo_dist[idnmbrm1][node - 1].equals("Discrete") ||
       varinfo_dist[idnmbrm1][node - 1].equals("Logit")) {
      rulenmvals = nmvals - 1;

   } else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Discrete")) {
      rulenmvals = 1;

   } else {
      iderr_("cptrules: unrecognized node type= " +
         varinfo_dist[idnmbrm1][node - 1]);
   }

   for (j = 0; j < rulenmvals; ++j) {
      rulenodevals[i][j] = fgetdble_(parmfle);
   }
}
}

// --------------------------------------------------------------------

static void applyrules_(int node, int j1, int j2, int j3, int j4, int j5,
   int j6, int j7, int nmvals, int nmnghs, int dst) {

// Applies rules to form node the CPT for node number "node".

boolean foundprtval, rulecondition, test = true;

int i, j, k, rulenmvals = 0, dstm1 = dst - 1;

double probsum = 0., continval = 0.;

// Return if there are no rules to apply.

if (nmrules == 0) {
   return;
}

// Load parent values array.

prntvals[0] = j1;
prntvals[1] = j2;
prntvals[2] = j3;
prntvals[3] = j4;
prntvals[4] = j5;
prntvals[5] = j6;
prntvals[6] = j7;

// Apply function to a Determ_Contin node.

if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Contin")) {
   continval = wght1 * ((double) j1) + wght2 * ((double) j2) +
               (1. - wght1 - wght2) * ((double) j3);
   continval /= 9.;

   printf_("applyrules: j1= " + j1 + " j2= " + j2 + " j3= " + j3 +
      " continval= " + continval);

   condprb[idnmbrm1][node - 1][0][j1 - 1][j2 - 1][j3 - 1][j4 - 1]
	  [j5 - 1][j6 - 1][dstm1] = continval;
   return;
}

/* For each rule, check for rule antecedent satisfaction.  If so,
   apply the rule. */

for (i = 0; i < nmrules; ++i) {
   rulecondition = true;
   for (j = 0; j < nmnghs; ++j) {

      if (ruleprtvals[i][j][0] == -1) {
      
	 // Process "any" case.

	 foundprtval = true;
	 continue;

      } else {

         // Explicitly listed values.

         foundprtval = false;
         for (k = 0; k < rulenmprtvals[i][j]; ++k) {
	    if (ruleprtvals[i][j][k] == prntvals[j]) {
	       foundprtval = true;
	       break;
	    }
         }
      }
      if (!foundprtval) {
         rulecondition = false;
         break;
      }
   }

   if (rulecondition) {

      // Load the rule's values.
   
      probsum = 0.;
      for (j = 1; j <= nmvals; ++j) {
         if (varinfo_dist[idnmbrm1][node - 1].equals("Discrete")) {
            if (j < nmvals) {
	       condprb[idnmbrm1][node - 1][j - 1][j1 - 1][j2 - 1]
		      [j3 - 1][j4 - 1] [j5 - 1][j6 - 1][dstm1] =
                  rulenodevals[i][j];
               probsum += rulenodevals[i][j];

	    } else {
	       condprb[idnmbrm1][node - 1][j - 1][j1 - 1][j2 - 1]
		      [j3 - 1][j4 - 1] [j5 - 1][j6 - 1][dstm1] = probsum;
	    }
	 
	 } else {
	    condprb[idnmbrm1][node - 1][j - 1][j1 - 1][j2 - 1][j3 - 1]
                   [j4 - 1][j5 - 1][j6 - 1][dstm1] = rulenodevals[i][j - 1];
	 }

         if (test) {
            printf_("applyrules: node= " + node + " i= " + i +
	       " j= " + j + " j1= " + j1 + " j2= " + j2 + " j3= " +
	       j3 + " j4= " + j4 + " j5= " + j5 + " j6= " + j6 + " val= " +
	    rulenodevals[i][j - 1]);
         }

         if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Discrete")) {
	    
	    // Nodes of this type only have one value to be read.

	    break;
	 }
      }
   }
}

}
}
