class Convrt extends Id {
static boolean iflag = false;

static boolean pointused[] = new boolean[MAXNMBPT];

static String recordorder = "none", analysisfle = "none";

static String head[] = new String[2];
static String bdryname[] = new String[300];
static String reportid[] = new String[300];

static int nmbdrys;

static int nmsegpts[] = new int[300];
static int timeofday[] = new int[300];
static int nmtracks[] = new int[300];
static int nmpoached[] = new int[300];

static double x, y, n, m1, a, b, eccen, radltf, radlgf, t1, capf, t0,
   rho0, radlat, radlng, t, rho, theta, radlf1, radlf2, dsin, capr,
   cnvrsn = .01, latrf1, latrf2, latref, lngref, xmax = 0., ymax = 0.,
   scale, globalxmin = 1.e20, globalxmax = -1.e20, globalymin = 1.e20,
   globalymax = -1.e20, globalestmin = 1.e20, globalestmax = -1.e20,
   mintime = 0., maxtime = 0.;

static double lngval[][] = new double[300][MAXNMBPT];
static double latval[][] = new double[300][MAXNMBPT];
static double timeval[] = new double[MAXNMBPT];
static double dist[] = new double[MAXNMBPT];
static double geotrans[][] = new double[3][4];

// -------------------------------------------------------------------------

static int convrt_(int option) {
 
/* Converts a longitude-latitude data or boundary file composed of one
   or more "boundaries" into Euclidean coordinates.  Use available
   software to do file rearrangement before running this program,
   e.g. Excell, SAS, SPSS, Splus.  Rearrangements that may be
   necessary include splitting a file into two files and stacking
   multivariate data into a univariate file.
 
   This method can:
     1) convert longitude and latitude to x,y coordinates using
        either Lambert's One Standard Parallel or Two Standard Parallel
        projections,
     2) perform conversion factor adjustment to x, y values,
     3) adjust reference points,
     4) perform 'Window' membership check.
 
   "option" variable settings:
      0: Converts a boundary file that contains 1 or more boundaries.

      1: Converts a SPATIO-TEMPORAL data file that has the format given
         by "frmt" as follows:
	 frmt=1: "lng lat predtime value."
	 frmt=2: "day month year string-value lat lng
         frmt=3: "id 4-strings lat lng 4-double

      2: Convert a longitude-latitude surface file (regular grid) to an
	 x, y surface file.

   Note: The transformation routines assume that locations south of the
         equator have negatively signed latitude values.  Locations
	 east of Greenwich, United Kingdom (East) have positively signed
	 longitude values. */

boolean test = false, thin = false, toggle;

String vname = "none", inputfle = "none", idval = "none", lastid = "none",
   dumstrng1 = "none", dumstrng2 = "none", dumstrng3 = "none",
   dumstrng4 = "none";

int i, j, k, l, prjtyp = 2, nmpts = 0, latd, latm, lats, longd, longm, longs,
   blank, drctn = 1, nmreadvar = 0, nmcols = 0, xorder = 0, yorder = 0,
   zorder = 0, torder = 0, frmt = 0, day = 0, month = 0, year = 0;

double predtime = 0., dxmin = 1.e30, dxmax = 0.0, dymin = 1.e30,
   dymax = 0.0, val = 0., varval = 0., lng, lat, area, latsign = 1.,
   lngsign = 1., latmin = 1.e20, latmax = -1.e20, lngmin = 1.e20,
   lngmax = -1.e20, xdist = 0., ydist = 0., diagdist = 0.,
   map_unit_per_meter, dumval1 = 0., dumval2 = 0.;

/* Define transformations to geo-coordinates to make multiple countries
   line up better. */

geotrans[0][0] = 0.; // x-translation
geotrans[0][1] = 1.; // x-scale
geotrans[0][2] = 0.; // y-translation
geotrans[0][3] = 1.; // y-scale

geotrans[1][0] = -.80; // x-translation
geotrans[1][1] = .98; // x-scale
geotrans[1][2] = -.20; // y-translation
geotrans[1][3] = .95; // y-scale

geotrans[2][0] = -.005; // x-translation
geotrans[2][1] = 1.001; // x-scale
geotrans[2][2] =  -.10; // y-translation
geotrans[2][3] = .97; // y-scale

if (Getmodl.eosdata) {

   // Read EOS binary data file and create intermediate input file.

   Eosdata.readeos_();
}

// Define 2 standard parallels.

latrf1 = spacetime_latmn + .33 * (spacetime_latmx - spacetime_latmn);
latrf2 = spacetime_latmn + .66 * (spacetime_latmx - spacetime_latmn);
printf_("convrt: lngmn= " + spacetime_lngmn + " lngmx= " + spacetime_lngmx +
        " latmn= " + spacetime_latmn + " latmx= " + spacetime_latmx +
	"\n   latrf1= " + latrf1 + " latrf2= " + latrf2);

/* Establish coordinate system center, maximum x, y distances, and
   scaling factor for the out.dig file. */
 
lngref = .5 * (spacetime_lngmx + spacetime_lngmn);
latref = .5 * (spacetime_latmx + spacetime_latmn);

// Verify a 0,0 origin.

lmbrt2_(1, lngref, latref);
printf_("convrt: lngref= " + fdble_(lngref, 7, 3) + " latref= " +
   fdble_(latref, 7, 3) + " x= " + fdble_(x, 4, 3) + " y= " +
   fdble_(y, 4, 3));

// Find xmax and ymax values by checking all three relevant corners.

lng = spacetime_lngmx;
lat = spacetime_latmn;
if (prjtyp == 1) {
   lambrt_(lng, lat);

} else {
   lmbrt2_(1, lng, lat);
}
printf_("convrt: lngmx, latmn x= " + x + " y= " + y);
xmax = x;

lng = spacetime_lngmx;
lat = spacetime_latmx;
if (prjtyp == 1) {
   lambrt_(lng, lat);

} else {
   lmbrt2_(1, lng, lat);
}
printf_("convrt: lngmx, latmx x= " + x + " y= " + y);
ymax = y;
if (x > xmax) {
   xmax = x;
}

lng = spacetime_lngmn;
lat = spacetime_latmx;
if (prjtyp == 1) {
   lambrt_(lng, lat);

} else {
   lmbrt2_(1, lng, lat);
}
printf_("convrt: lngmn, latmx x= " + x + " y= " + y);
if (y > ymax) {
   ymax = y;
}

// Set scale.

if (xmax > ymax) {
   scale = 1. / (2. * xmax);

} else {
   scale = 1. / (2. * ymax);
}
printf_("convrt: xmax= " + fdble_(xmax, 8, 3) + " ymax= " +
    fdble_(ymax, 8, 3) + " scale= " + fdble_(scale, 8, 3));

// Open output files.

fleopen_(4, spacetime_outfle, 'w');

if (drctn == 1) {
   fleopen_(5, "out.dig", 'w');
}

// Loop over input files.

for (i = 0; i < spacetime_nminfles; ++i) {
   if (Getmodl.eosdata) {
      inputfle = Eosdata.intrmdflenme;

   } else if (option == 0 || option == 1) {
      inputfle = spacetime_infle[i];

   } else if (option == 2) {
      inputfle = spacetime_surffle[i];
   }
   printf_("convrt: opening " + inputfle);
   fleopen_(3, inputfle, 'r');

   if (!Getmodl.eosdata) {

      // Read 2-line title information from input data file.

      for (j = 0; j < 2; ++j) {
         head[j] = fgetline_(3);
	 fprintf_(4, head[j]);
      }
      frmt = fgetint_(3);
      lngsign = fgetdble_(3);
      latsign = fgetdble_(3);
      recordorder = fgetstrng_(3);

      if (frmt == 2 || frmt == 3) {
         fleopen_(6, analysisfle, 'w');
   
	 // Read boundary file.
	
         fleopen_(7, "bdres.bln", 'r');
	 fgetline_(7);
	 fgetline_(7);
	 bdry_nmbdpts[0] = fgetint_(7);
         fgetstrng_(7);
         fgetint_(7);
         for (j = 0; j < bdry_nmbdpts[0]; ++j) {
            bdry_xbdry[0][j] = fgetdble_(7);
            bdry_ybdry[0][j] = fgetdble_(7);
         }
	 fclose_(7, 'r');

	 if (frmt == 2) {
            fleopen_(7, "carcassroutes.dat", 'w');
	 }
      }

   } else {
      fprintf_(1, "Reading EOS data file.");
   }

   // Convert an x,y file to longitude, latitude.

   if (drctn == -1) {
      while (checkeof_(3) != true) {
         x = fgetdble_(3);
         y = fgetdble_(3);

         // Translate back to the lng - lat coordinate system.

         x -= xmax;
         y -= ymax;
         lmbrt2_(drctn, lng, lat);
         fprintf_(4, lng + " " + lat);
         ++nmpts;
      }

      // Write number of points converted.
 
      fprintf_(1, "For input file " + spacetime_infle[i] +
	 " nmpts= " + nmpts);

      fclose_(3, 'r');
      fclose_(4, 'w');

      return 0;
   }

   // Convert a longitude-latitude file to x, y coordinates.

   if (option == 0) {

      // Loop for multiple boundaries in the boundary file.

      nmbdrys = 0;
      while (!checkeof_(3)) {

	 // Read route information.

	 if (frmt == 2) {
            reportid[nmbdrys] = fgetstrng_(3);
	    day = fgetint_(3);
	    month = fgetint_(3);
	    year = fgetint_(3);

            timeval[nmbdrys] = ((double) year) +
               Textutils.nmdays_(-99999, (year - 2000), month, day) / 365.;

	    timeofday[nmbdrys] = fgetint_(3);
            nmtracks[nmbdrys] = fgetint_(3);
	    nmpoached[nmbdrys] = fgetint_(3);
	 }

	 if (frmt == 1 || frmt == 2) {
         
            // Read number of segment points and segment descriptor.

            nmsegpts[nmbdrys] = fgetint_(3);
            bdryname[nmbdrys] = fgetstrng_(3);
            printf_("convrt: nmsegpts= " + nmsegpts[nmbdrys] +
               " bdryname= " + bdryname[nmbdrys]);
         }

	 j = 0;
	 lastid = fgetstrng_(3);
         streamTokenizer[2].pushBack();
	 do {
            if (frmt == 3) {
	       idval = fgetstrng_(3);
	       if (!idval.equals(lastid)) {
                  nmsegpts[nmbdrys] = j;
                  bdryname[nmbdrys] = lastid;
		  j = 0;
                  ++nmbdrys;
                  lastid = idval;
               }
	       for (k = 0; k < 12; ++k) {
	          dumval1 = fgetdble_(3);
	       }
	    }
            reportid[nmbdrys] = idval;

            if (recordorder.equals("lng-lat")) {
	       lngval[nmbdrys][j] = lngsign * fgetdble_(3);
	       lngval[nmbdrys][j] *= geotrans[i][1];
	       lngval[nmbdrys][j] += geotrans[i][0];

	       latval[nmbdrys][j] = latsign * fgetdble_(3);
	       latval[nmbdrys][j] *= geotrans[i][3];
	       latval[nmbdrys][j] += geotrans[i][2];

            } else if (recordorder.equals("lat-lng")) {
	       latval[nmbdrys][j] = latsign * fgetdble_(3);
	       latval[nmbdrys][j] *= geotrans[i][3];
	       latval[nmbdrys][j] += geotrans[i][2];

	       lngval[nmbdrys][j] = lngsign * fgetdble_(3);
	       lngval[nmbdrys][j] *= geotrans[i][1];
	       lngval[nmbdrys][j] += geotrans[i][0];
	    }
            if (frmt == 3) {
	       for (k = 0; k < 10; ++k) {
	          dumval2 = fgetdble_(3);
	       }
	    }
	    ++j;
         } while ((frmt != 3 && j < nmsegpts[nmbdrys]) ||
                  (!checkeof_(3)));
	 if (frmt == 3) {
            nmsegpts[nmbdrys] = j;
            bdryname[nmbdrys] = lastid;
	 }
         ++nmbdrys;
      }
      fclose_(3, 'r');
      bdry_nmbdrys += nmbdrys;

      if (frmt != 3) {
      
         // Check for boundary file data-entry errors.  Correct as necessary.

         bdryerrs_();
      }

      /* Find area enclosed by each boundary and convert each point in
	 each boundary. */

      fprintf_(1, "  Region       Area (assuming long-lat boundary" +
         " locations)");

      if (frmt == 2) {
         for (j = 0; j < 2; ++j) {
            fprintf_(6, head[j]);
         }
      }

      for (j = 0; j < nmbdrys; ++j) {
         area = Mcce.polyarea_(nmsegpts[j] - 1, lngval[j], latval[j]); 

         // Approximately transform to square kilometers.

         area = area * 111.325 * 111.325 *
            Math.cos(latval[j][0] * 3.14159265 / 180.);
         fprintf_(1, fstrng_(bdryname[j], 14) + " " + area);

	 /* Write number of boundary points, boundary name, and country
	    number. */

         if (!thin) {
	    nmpts = nmsegpts[j];
      
         } else {
	    nmpts = nmsegpts[j] / 2 + 1;
         }
         fprintf_(4, nmpts + " " + bdryname[j] + " " + (i + 1));

	 if (frmt == 2) {
	    fprintf_(6, reportid[j] + " " + timeval[j] + " " + nmtracks[j] +
               " " + nmpoached[j] + "\n" + nmpts + " " + bdryname[j] +
	       " " + (i + 1));

         } else if (frmt == 3) {

            // Future work: write time value.

            fprintf_(6, nmpts + " " + bdryname[j] + " " + (i + 1));
         }

         toggle = true;
         for (k = 0; k < nmsegpts[j]; ++k) {

            // Find x, y distances in new coordinate system.
 
            if (prjtyp == 1) {
	       lambrt_(lngval[j][k], latval[j][k]);
	 
	    } else if (prjtyp == 2) {
	       lmbrt2_(drctn, lngval[j][k], latval[j][k]);
	    }

            /* Write output file with the location shifted into a positive
               coordinate system.  If "thin" is on, write every other point.
	       Also, create a plot of these boundaries. */

	    x += xmax;
	    y += ymax;
            if (spacetime_lngmn < 0. && spacetime_lngmx < 0.) {
               x = xmax - x;
            }

	    // Write device-independent plotting file.

	    if (k == 0) {
	       fprintf_(5, "MOVETO " + fdble_(x * scale, 5, 3) +
	          " " + fdble_(y * scale, 5, 3));
	 
	    } else {
	       fprintf_(5, "LINETO " + fdble_(x * scale, 5, 3) + " " +
                  fdble_(y * scale, 5, 3));
            }

	    // Write x,y coordinates boundary file (typically a *.bln file).

            if (!thin) {
	       fprintf_(4," " + x + " " + y);
	       if (frmt == 2 || frmt == 3) {
	          fprintf_(6," " + x + " " + y);
               }

	    } else {
               if (toggle || k == nmsegpts[j] - 1) {
	          fprintf_(4," " + x + " " + y);
                  toggle = false;

               } else {
	          toggle = true;
	       }
            }

	    // Find overall lng, lat, x, and y minimums and maximums.

	    lngmin = (lngval[j][k] < lngmin) ? lngval[j][k] : lngmin;
	    lngmax = (lngval[j][k] > lngmax) ? lngval[j][k] : lngmax;

	    latmin = (latval[j][k] < latmin) ? latval[j][k] : latmin;
	    latmax = (latval[j][k] > latmax) ? latval[j][k] : latmax;

	    globalxmin = (x < globalxmin) ? x : globalxmin;
	    globalxmax = (x > globalxmax) ? x : globalxmax;

	    globalymin = (y < globalymin) ? y : globalymin;
	    globalymax = (y > globalymax) ? y : globalymax;
         }
      }

   } else if (option == 1 && frmt == 1) {

      /* Loops for reading, transforming and windowing latitude-longitude
         data file. */

      varloop: for (;;) {

         // Read variable names.

         if (!Getmodl.eosdata) {
            nmreadvar = 0;
            i = 0;
            for (;;) {
               strng = fgetstrng_(3);
               if (streamTokenizer[2].ttype != streamTokenizer[2].TT_WORD) {
                  streamTokenizer[2].pushBack();
                  break;
               }
               ++i;
               if (strng.equals("Xcoord") ||
                  strng.equals("Long")) {
                  xorder = i;

               } else if (strng.equals("Ycoord") ||
                  strng.equals("Lat")) {
                  yorder = i;
   
               } else if (strng.equals("Zcoord") ||
                  strng.equals("Hght")) {
                  zorder = i;
     
               } else if (strng.equals("Time")) {
                  torder = i;
      
               } else {
                  vname = strng;
                  ++nmreadvar;
                  if (nmreadvar > 1) {
		     iderr_("convrt: 1 variable per record.");
		  }
               }
            }
            nmcols = i;

         } else {
	    xorder = 1;
	    yorder = 2;
	    torder = 3;
	    zorder = -1;
	    nmreadvar = 1;
	    vname = Eosdata.varname;
	    nmcols = 4;
         }
         if (nmcols == 0) {
	    iderr_("convrt: no data columns");
         }

         // Write names of columns.

	 if (torder == 0) {
            fprintf_(4, "Xcoord Ycoord " + vname);

         } else {
            fprintf_(4, "Xcoord Ycoord Time " + vname);
         }

         // Now, loop through observations.

         readvar: for (;;) {
	    if (!Getmodl.eosdata) {

               // Check for end of file if so, break varloop.

               if (checkeof_(3)) {
	          break varloop;
               }

	       /* For non-EOS data, try to read a variable name.  If so,
		  push it back and break the readvar loop.  Either way,
		  push back whatever was read. */

               strng = fgetstrng_(3);
               if (streamTokenizer[2].ttype == streamTokenizer[2].TT_WORD) {
	          streamTokenizer[2].pushBack();
                  break;
               }
               streamTokenizer[2].pushBack();
            }

            for (i = 1; i <= nmcols; ++i) {

               if (!Getmodl.eosdata) {
	          val = fgetdble_(3);
	       
	       } else {
	          val = fgetbinflt_(3);
	          if (val == 1.e200) {
		     break varloop;
	          }
               }

               if (i == xorder) {
                  lng = val;
       
               } else if (i == yorder) {
                  lat = val;
         
               } else if (i == zorder) {
                  iderr_("currently, no z coordinate allowed in convrt");
                  // z = val;
         
               } else if (i == torder) {
                  predtime = val;

	       } else {
	          varval = val;
               }
            }

            /* Find x, y point in new coordinate system.  First fix the
	       sign of of longitude values east of Greenwich. */
 
            if (lng > 0. && spacetime_lngmn < 0. && spacetime_lngmx < 0.) {
               lng = -lng;
            }
            if (prjtyp == 1) {
	       lambrt_(lng, lat);
         
	    } else if (prjtyp == 2) {
	       lmbrt2_(drctn, lng, lat);
            }

            // Check for window membership.

            if (test) {
	       fprintf_(1, "lat= " + lat + " lng= " + lng + " x= " + x +
	          " xmax= " + xmax + " y= " + y + " ymax= " + ymax);
            }

            if (Math.abs(x) < xmax && Math.abs(y) < ymax) {

               /* Write output file(s) with the location shifted into a
		  positive coordinate system. */

	       x += xmax;
	       y += ymax;
               if (spacetime_lngmn < 0. && spacetime_lngmx < 0.) {
                  x = xmax - x;
               }
	       
	       if (torder == 0) {
                  fprintf_(4, fdble_(x, 9, 5) + " " +
	             fdble_(y, 9, 5) + " " + fdble_(varval, 9, 5));

	       } else {
                  fprintf_(4, fdble_(x, 9, 5) + " " +
	             fdble_(y, 9, 5) + " " + fdble_(predtime, 8, 3) +
		     " " + fdble_(varval, 9, 5));
               }

	       // Keep track of input file min max's.

	       if (x < dxmin) {
	          dxmin = x;
	       }
	       if (x > dxmax) {
	          dxmax = x;
	       }
	       if (y < dymin) {
	          dymin = y;
	       }
	       if (y > dymax) {
	          dymax = y;
	       }
            }
            ++nmpts;
         } // End of data read loop.
      } // End of variable read loop.
      fclose_(3, 'r');

   } else if (option == 1 && frmt == 2) {

      /* Read spatio-temporal sites file.  A "site" may be anything such
         as a rhino carcass. */

      nmpts = 0;
      while (checkeof_(3) != true) {
         if (recordorder.equals("long-lat")) {
            lngval[0][nmpts] = lngsign * fgetdble_(3);
            latval[0][nmpts] = latsign * fgetdble_(3);
	    ++nmpts;

         } else {
            day = fgetint_(3);
            month = fgetint_(3);
            year = fgetint_(3);
            timeval[nmpts] = ((double) year) +
               Textutils.nmdays_(-99999, (year - 2000), month, day) / 365.;

	    // Throw away moonphase.

	    printf_("convrt: moon= " + fgetstrng_(3));

            latval[0][nmpts] = latsign * fgetdble_(3);
            lngval[0][nmpts] = lngsign * fgetdble_(3);
	 
	    if (mintime < timeval[nmpts] && timeval[nmpts] < maxtime) {
	       ++nmpts;
            }
         }
      }
      fclose_(3, 'r');

      for (k = 0; k < 2; ++k) {
         fprintf_(4, head[k]);
         fprintf_(6, head[k]);
      }
      fprintf_(4, nmpts + " data 1");
      fprintf_(6, nmpts + " carcassloc");
      printf_("convrt: nmpts= " + nmpts);

      for (k = 0; k < nmpts; ++k) {

         // Find x, y distances in new coordinate system.
 
         if (prjtyp == 1) {
            lambrt_(lngval[0][k], latval[0][k]);
	 
         } else if (prjtyp == 2) {
            lmbrt2_(drctn, lngval[0][k], latval[0][k]);
         }

         /* Write output file with the location shifted into a positive
            coordinate system. */

         x += xmax;
         y += ymax;
         if (spacetime_lngmn < 0. && spacetime_lngmx < 0.) {
            x = xmax - x;
         }
         fprintf_(4, x + " " + y + " c");

	 // Write analysis file.

         fprintf_(6," " + timeval[k] + " " + x + " " + y);
	 
	 // Write file that creates attacker routes from carcass locations.

	 write_carcass_route_(7, x, y, timeval[k]);
      }
      fclose_(6, 'w');
      fclose_(7, 'w');

   } else if (option == 2) {

      /* Convert a longitude-latitude surface file to an x, y surface file.
         Note that the 2-line title has already been read, above.  Remaining
         records in this file consist of the number of rows and columns, and
         then records consisting of "row column longitude latitude value." */

      spacetime_nmrows = fgetint_(3);
      spacetime_nmcols = fgetint_(3);

      if (i == 0) {
         fprintf_(4, "1 " + (spacetime_nminfles * spacetime_nmrows) +
	    " " + spacetime_nmcols + " " + spacetime_xmin + " " +
	    spacetime_xmax + " " + spacetime_ymin + " " +
	    spacetime_ymax + " " + spacetime_estmin + " " +
	    spacetime_estmax);
      }

      for (j = 0; j < spacetime_nmrows; ++j) {
         for (k = 0; k < spacetime_nmcols; ++k) {

	    // Throw away row and column numbers. 

	    fgetint_(3);
	    fgetint_(3);
	    lng = fgetdble_(3);
	    lng = geotrans[i][0] + geotrans[i][1] * lng;
	    lat = fgetdble_(3);
	    lat = geotrans[i][2] + geotrans[i][3] * lat;
	    val = fgetdble_(3);

            if (lng > 0. && spacetime_lngmn < 0. && spacetime_lngmx < 0.) {
               lng = -lng;
            }
            if (prjtyp == 1) {
	       lambrt_(lng, lat);
         
	    } else if (prjtyp == 2) {
	       lmbrt2_(drctn, lng, lat);
            }
            x += xmax;
            y += ymax;

            /* Check for boundary membership, if any.  Set blank value
               accordingly.  Only compare country i points to country i
	       boundaries. */

            blank = 1;
            for (l = 0; l < bdry_nmbdrys; ++l) {
               if (Surf.bdry_(bdry_nmbdpts[l], bdry_xbdry[l], bdry_ybdry[l],
                   x, y) > 0. && (i + 1) == bdry_countrynm[l]) {
                  blank = 0;
	    
		  // Find overall value minimum and maximum.

	          if (val < globalestmin) {
	             globalestmin = val;
	          }
	          if (val > globalestmax) {
	             globalestmax = val;
	          }
                  break;
               }
            }
            fprintf_(4, x + " " + y + " " + val + " " + blank);
         }
      }
      fclose_(3, 'r');
   } // End of option == 2 condition.
} // End of loop over in-files.
fclose_(4, 'w');
fprintf_(1,"\n");

// Under option 0, overlay a lng-lat grid on the plot.

if (option == 0) {
   // lnglatgrd_(5);
}
fclose_(5, 'w');

// Create PostScript file.

fprintf_(1, "Writing plot of all boundaries to file lng-latgrd.eps");
Pltpost.pltpost_("lng-latgrd.eps", 1.);

// Write summary of conversion to the report file.
 
fprintf_(1, "\n---------------- MAP PROJECTION OUTPUT ---------------\n" +
   "\ncnvrsn= " + cnvrsn + " prjtyp= " + prjtyp +
   "\nmin longitude= " + spacetime_lngmn +
   "\nmax longitude= " + spacetime_lngmx +
   "\nmin latitude= " + spacetime_latmn +
   "\nmax latitude= " + spacetime_latmx);

if (prjtyp == 2) {
   fprintf_(1, "std. parallel 1= " + latrf1 + ", std. parallel 2= " +
      latrf2);
}

if (option == 0 || option == 1) {

   /* When converting a data file, write xmax, ymax; note xmin and ymin will
      both be zero after the shift. */
 
   fprintf_(1, "Lat-long determined (calculated) xmax= " +
      fdble_(2. * xmax, 8, 3) + " ymax= " + fdble_(2. * ymax, 8, 3) +
      "\nInput file: xmin= " + fdble_(dxmin, 8, 3) +
      " xmax= " + fdble_(dxmax, 8, 3) +
      "\nInput file: ymin= " + fdble_(dymin, 8, 3) +
      " ymax= " + fdble_(dymax, 8, 3));

   // Compute conversion factor between meters and map units.

   xdist = globalxmax - globalxmin;
   ydist = globalymax - globalymin;
   diagdist = Math.sqrt(xdist * xdist + ydist * ydist);
   printf_("convrt: diagdist= " + diagdist);

   map_unit_per_meter = 
               Routegen.great_circle_dist_(latmin, lngmin, latmax, lngmax);
   printf_("convrt: diagonal in meters= " + map_unit_per_meter);

   map_unit_per_meter = diagdist / map_unit_per_meter;

   printf_("convrt: latmin= " + latmin + " lngmin= " + lngmin +
      " latmax= " + latmax + " lngmax= " + lngmax +
      "\n   map_unit_per_meter= " + map_unit_per_meter);
}

// Write number of points within window and written to output file.
 
fprintf_(1, "nmpts= " + nmpts);

return 0;
}
 
// -----------------------------------------------------------------------

static void lambrt_(double lng, double lat) {
 
/* Reads a latitude, longitude value and converts to an x, y value
   using Lambert's One Standard Parallel Conical Projection,
   Ellipsoid Equations.  The standard parallel is taken to be latref
   which is also assumed to be the map's horizontal center. Lngref
   is taken to be the vertical center line.  This makes the point at
   (latref,lngref) the map center. The constants 'a' and 'b' appear on
   page 15 of the reference below and are from "GRS, 1980".
   The equations appear on page 107 of 'Map Projections Used by the U.S.
   Geological Survey', 1983. */
 
if (!iflag) {

   // Set initial constants.
 
   a=6378137.;
   b=6356752.;
   eccen= Math.sqrt(((a*a)-(b*b))/(a*a));
   radltf=(PI/180.)*latref;
   radlgf = -(PI/180.)*lngref;
   n= Math.sin(radltf);
   m1= Math.cos(radltf) / Math.sqrt(1.-(eccen*eccen)*(n*n));
   t1= Math.tan(PI/4.-radltf/2.)/
       Math.pow(((1.-eccen*n)/(1.+eccen*n)), (eccen/2.));
   capf=m1/(n* Math.pow(t1, n));
   t0=t1;
   rho0=a*capf* Math.pow(t0, n);
   iflag = true;
}
 
// Calculate x, y position in kilometers from latref,lngref.
 
radlat = (PI/180.)*lat;
radlng = - (PI/180.)*lng;
t= Math.tan(PI/4.-radlat/2.)/
   Math.pow(((1.-eccen* Math.sin(radlat)) / (1.+eccen* Math.sin(radlat))),
	    (eccen/2.));
rho=a*capf* Math.pow(t,n);
theta=n*(radlng-radlgf);
x=(cnvrsn*.001)*rho* Math.sin(theta);
y=(cnvrsn*.001)*(rho0-rho* Math.cos(theta));
}
 
// ------------------------------------------------------------------------

static void lmbrt2_(int drctn, double lng, double lat) {
 
/* Performs the Lambert Two Standard Parallel Projection using
   the Spherical Equations. */
 
if (!iflag) {
 
   // Set initial constants.
 
   a=6378137.;
   b=6356752.;
   radlf1=(PI/180.)*latrf1;
   radlf2=(PI/180.)*latrf2;
   radlgf = (PI/180.)*lngref;
   radltf=(PI/180.)*latref;
   eccen= Math.sqrt((a*a-b*b)/(a*a));
   dsin= Math.sin(radltf);
   capr=a*(1.-(eccen*eccen)) /
	(Math.pow((1.-(eccen*eccen)*(dsin*dsin)), 1.5 ));

   n=Math.log(Math.cos(radlf1)/Math.cos(radlf2)) /
	      (Math.log(Math.tan(PI/4.+radlf2/2.) /
	       Math.tan(PI/4.+radlf1/2.)));

   capf= Math.cos(radlf1)* Math.pow((Math.tan(PI/4.+radlf1/2.)),n )/n;

   rho0=capr*capf / Math.pow( (Math.tan(PI/4.+radltf/2.)),n );

   printf_("lmbrt2: n= " + n + " capr= " + capr + "\n    capf= " + capf);
   iflag = true;
}

if (drctn == 1) {
   radlat = (PI/180.) * lat;
   radlng = (PI/180.) * lng;
   theta=n*(radlng-radlgf);

   rho=capr*capf/ Math.pow((Math.tan(PI/4.+radlat/2.)), n);
   
   // Was .001.
   
   x=(cnvrsn*.005)*rho* Math.sin(theta);
   y=(cnvrsn*.005)*(rho0-rho* Math.cos(theta));

} else if (drctn == -1) {

   // Inverse transform.

   x =  x / (cnvrsn*.001);
   y = y / (cnvrsn*.001);
   rho = (x * x) + ((rho0 - y) * (rho0 - y));
   rho = Math.sqrt(rho);
   if (n < 0.) {
      rho = -rho;
      x = - x;
      rho0 = -rho0;
      y = - y;
   }
   theta = Math.atan(x / (rho0 - y));
   lat = Math.pow((capr*capf/rho),1./n);
   lat = 2. * Math.atan(lat) - PI/2.;
   lng = theta/n + radlgf;
   lat = (180./PI) * lat;
   lng = -(180./PI) * lng;
}
}

// -----------------------------------------------------------------------

static void lnglatgrd_(int flenm) {

// Creates a longitude -- latitude grid.

int i, j;

double lnginc, latinc, lng, lat;

// Set up text font for PostScript.

fprintf_(flenm, "SETCHARSIZE 10");

// Find lng, lat increments.

lnginc = (spacetime_lngmx - spacetime_lngmn) / (double) spacetime_nmcols;
latinc = (spacetime_latmx - spacetime_latmn) / (double) spacetime_nmrows;

lat = spacetime_latmn;
for (i = 0; i < spacetime_nmrows; ++i) {
   lng = spacetime_lngmn;
   for (j = 0; j < spacetime_nmcols; ++j) {

      // Move to begin point.

      lmbrt2_(1, lng, lat);
      x += xmax;
      y += ymax;
      if (j == 0) {
	 fprintf_(flenm, "GRTEXT " + fdble_(x * scale, 6, 4) + " " +
	    fdble_(y * scale, 6, 4) + " " + fdble_(lat, 5, 1));
      }
      if (i == 0) {
	 fprintf_(flenm, "GRTEXT " + fdble_(x * scale, 6, 4) + " " +
	    fdble_(y * scale - .02, 6, 4) + " " + fdble_(lng, 5, 1));
      }

      fprintf_(flenm, "MOVETO " + fdble_(x * scale, 6, 4) + " " +
	 fdble_(y * scale, 6, 4));

      // Lower line.

      lng += lnginc;
      lmbrt2_(1, lng, lat);
      x += xmax;
      y += ymax;
      fprintf_(flenm, "LINETO " + fdble_(x * scale, 6, 4) + " " +
	 fdble_(y * scale, 6, 4));

      // Right-side vertical line.

      lat += latinc;
      lmbrt2_(1, lng, lat);
      x += xmax;
      y += ymax;
      fprintf_(flenm, "LINETO " + fdble_(x * scale, 6, 4) + " " +
	 fdble_(y * scale, 6, 4));

      // Upper line.

      lng -= lnginc;
      lmbrt2_(1, lng, lat);
      x += xmax;
      y += ymax;
      fprintf_(flenm, "LINETO " + fdble_(x * scale, 6, 4) + " " +
	 fdble_(y * scale, 6, 4));

      // Left-side line.

      lat -= latinc;
      lmbrt2_(1, lng, lat);
      x += xmax;
      y += ymax;
      fprintf_(flenm, "LINETO " + fdble_(x * scale, 6, 4) + " " +
	 fdble_(y * scale, 6, 4));

      // Increment longitude to begin new begin point.

      lng += lnginc;
   }
   lat += latinc;
}
}

// ----------------------------------------------------------------------

static void bdryerrs_() {

/* Check for data-entry errors by checking for spikes.  Replace two
   points that are each in different boundaries but are closer than
   "largemileserr" miles
   ("smalldist" = "smallmileserr" * dist-in-degrees / 60)
   to each other with their average location. */

int i, j, k, l, m, n, bestl;

double lastlng = 0., lastlat = 0., lngdiff = 0., latdiff = 0., avelng = 0.,
   avelat = 0., smalldist, smallmileserr, largemileserr, errdist, mindist;

smallmileserr = .01;
smalldist = smallmileserr / 60.;
largemileserr = 10.; // was 15
errdist = largemileserr / 60.;

for (i = 0; i < nmbdrys; ++i) {
   for (k = 0; k < nmbdrys; ++k) {
      if (i == k ||
         (!bdryname[k].equals("Mara") &&
          !bdryname[k].equals("Singida") &&
          !bdryname[k].equals("Kagera") &&
          !bdryname[k].equals("Mbeya"))) {
         continue;
      }

      // Initialize the "pointused" array.

      for (l = 0; l < nmsegpts[k]; ++l) {
	 pointused[l] = false;
      }

      for (j = 0; j < nmsegpts[i]; ++j) {

         // Find the closest point to this j^th point.

         mindist = 1.e30;
         bestl = -1;
         for (l = 0; l < nmsegpts[k]; ++l) {
            lngdiff = lngval[i][j] - lngval[k][l];
            latdiff = latval[i][j] - latval[k][l];
            dist[0] = Math.sqrt(lngdiff * lngdiff + latdiff * latdiff);
            if (dist[0] < mindist) {
               mindist = dist[0];
	       bestl = l;
            }
         }

         if (!pointused[bestl] && smalldist < mindist &&
	     mindist < errdist) {
            lngval[i][j] = lngval[k][bestl];
            latval[i][j] = latval[k][bestl];
	    pointused[bestl] = true;
         }
      }
   }

   // Smooth spikes.
   
   for (j = 0; j < nmsegpts[i] - 2; ++j) {
      lngdiff = lngval[i][j] - lngval[i][j + 1];
      latdiff = latval[i][j] - latval[i][j + 1];
      dist[0] = Math.sqrt(lngdiff * lngdiff + latdiff * latdiff);
      if (dist[0] < 1.e-5) {
	 continue;
      }

      lngdiff = lngval[i][j + 1] - lngval[i][j + 2];
      latdiff = latval[i][j + 1] - latval[i][j + 2];
      dist[1] = Math.sqrt(lngdiff * lngdiff + latdiff * latdiff);
      if (dist[1] < 1.e-5) {
	 continue;
      }

      lngdiff = lngval[i][j] - lngval[i][j + 2];
      latdiff = latval[i][j] - latval[i][j + 2];
      dist[2] = Math.sqrt(lngdiff * lngdiff + latdiff * latdiff);
      if (dist[2] < 1.e-5) {
	 continue;
      }

      if (dist[0] > .2 * errdist || dist[1] > .2 * errdist ||
	  dist[2] > .2 * errdist) {
         continue;
      }

      if (3. * dist[2] < Math.min(dist[0], dist[1])) {
	 lngval[i][j + 1] = .5 * (lngval[i][j] + lngval[i][j + 2]);
	 latval[i][j + 1] = .5 * (latval[i][j] + latval[i][j + 2]);
	 printf_("bdryerr: spike at j= " + j + " region= " +
	    bdryname[i]);

      }
   }
}

// Write the modified boundary file.

fleopen_(3, "newreg.lgt", 'w');
for (i = 0; i < nmbdrys; ++i) {
   fprintf_(3, nmsegpts[i] + " " + bdryname[i]);
   for (j = 0; j < nmsegpts[i]; ++j) {
      fprintf_(3, lngval[i][j] + " " + latval[i][j]);
   }
}
fclose_(3, 'w');
}

// -------------------------------------------------------------------

static void write_carcass_route_(int flenm, double x, double y,
   double timeval) {

/* Creates an attacker route from the space-time coordinates of a poached
   rhino. */

int i;

double difx, dify, dist, xentry = 0., yentry = 0., distmin = 0.;

for (i = 0; i < bdry_nmbdpts[0] - 1; ++i) {
   difx = x - bdry_xbdry[0][i];
   dify = y - bdry_ybdry[0][i];
   dist = Math.sqrt(difx * difx + dify * dify);
   if (i == 0) {
      distmin = dist;
   }
   if (dist < distmin) {
      distmin = dist;
      xentry = bdry_xbdry[0][i];
      yentry = bdry_ybdry[0][i];
   }
}

fprintf_(7, "CARCASS " + timeval + " 3 1" +
   "\n3 a 1" +
   "\n" + xentry + " " + yentry +
   "\n" + x + " " + y +
   "\n" + xentry + " " + yentry);
}
}
