class Colors extends Pltsurf {

// -----------------------------------------------------------------------

static void colors_(double max, double min) {

// Assigns levels and colors to levels.

int i, izero = 0;

// If levels have already been assigned, just assign colors and return.

if (nmlevls == 0) {

   nmlevls = 5;

   // Assign levels and level labels.

   level[0] = min;
   for (i = 1; i <= nmlevls; ++i) {
      level[i] = level[i - 1] + Math.abs(max - min) / (double) nmlevls;
   }
}

// Find interval containing zero.

if (0. <= level[0]) {
   if (0. < level[0]) izero = 0;
   else izero = 1;

} else if (level[0] < 0. && level[nmlevls] > 0.) {
   izero = nmlevls;
   for (i = 1; i <= nmlevls; ++i) {
      if (level[i - 1] <= 0. &&  0. < level[i]) izero = i;
   }

} else if (level[nmlevls] <= 0.) {
   izero = nmlevls;
}

/* Assign colors to level intervals.  Increasingly negative intervals
   receive increasingly negative colors, increasingly positive intervals
   receive increasingly positive colors.  The interval that contains
   zero is colored 0.
   Also write level labels. */

for (i = 1; i <= nmlevls; ++i) {
   colors[i - 1] = i - izero;
   if (izero == 0) {
      --colors[i - 1];
   }
   if (lgndlbl[i - 1].equals("none")) {

      /* Print open ended lower interval if level[0] < 0.  Print
         open-ended upper level if level[nmlevls] != 1. */

      if (i == 1 && level[0] < 0.) {
         lgndlbl[i - 1] = " <_" + fdble_(level[i], 5, 3);
   
      } else if (i == nmlevls && Math.abs(level[nmlevls] - 1.) > 1.e-6) {
         lgndlbl[i - 1] = " >_" + fdble_(level[i - 1], 5, 3);
   
      } else {
         lgndlbl[i - 1] = " [" + fdble_(level[i - 1], 5, 3) +
            ",_" + fdble_(level[i], 5, 3) + "]";
      }
   }
}
}
}
