class Choles extends Surf {
static boolean chk = false;

// -------------------------------------------------------------------

/*
main() {
// Test the cholesky routine.
static double b[3][3]={8.,1.,3.,1.,6.,4.,3.,4.,4.};
double l[3][3];
int i;
choles_(b,l,1,3);
for (i=1; i <= 3; ++i) {
   printf_("%lf %lf %lf\n",l[i-1][0],l[i-1][1],l[i-1][2]);
}
}
*/

static double choles_(double b[][], double l[][], int rwstrt,
   int rwend, boolean pflag) {

/* Performs cholesky decomposition of b into l from Hornbeck, R. W. (1975),
   Numerical Methods, p. 231.  Terminates if the square root operation is
   invalid (see Hornbeck, p. 231).  Optionally, checks the accuracy of the
   decomposition.  If the Math.sqrt operation fails, l[0][0] contains the
   negative of the value at fault. */

int i, ii, j, k;
double sum, error, bchk;

if (b[rwstrt-1][rwstrt-1] <= 0.) {
   l[0][0] = -b[rwstrt-1][rwstrt-1];
   if (pflag) printf_("Error 1 in choles_()\n");
   return b[rwstrt - 1][rwstrt - 1];
}
l[rwstrt-1][rwstrt-1] = Math.sqrt(b[rwstrt-1][rwstrt-1]);

for (i=rwstrt+1; i <= rwend; ++i) {

   for (j=rwstrt; j <= i-1; ++j) {
      sum=0.;
      if (1 <= j-1) {
         for (k=0; k < j-1; ++k) sum += l[i-1][k] * l[j-1][k];
      }
      l[i-1][j-1] = (b[i-1][j-1] - sum) / l[j-1][j-1];

      /* Check for NaN.
      if (Double.isNaN(l[i-1][j-1])) {
         iderr_("NaN in choles_(), rwend= " + rwend + " i= " + i +
            " j= " + j);
      }
      */
   }

   sum = 0.;
   if (1 <= i-1) {
      for (k = rwstrt-1; k < i-1; ++k) sum += l[i-1][k] * l[i-1][k];
   }

   // Check for valid argument to the square root function.

   if (b[i-1][i-1] - sum < 0.) {
      l[0][0] = b[i-1][i-1] - sum;
      if (pflag) printf_("choles: Error 3, i= " + i +
         " following should be >=0: " + l[0][0]);
      return l[0][0];
   }
   l[i-1][i-1] = Math.sqrt(b[i-1][i-1] - sum);

   // As per Kourouklis (1977, p. 4), if l(i,i)=0, set l(*,i)=0.

   if (Math.abs(l[i-1][i-1]) < 1.e-10) {
      for (ii=rwstrt-1; ii < rwend; ++ii) l[ii][i-1]=0.;
   }

   // Fill in rest of row with zeros.

   for (j=i-1; j < rwend; ++j) l[(i-1)-1][j]=0.;
}

/* Optionally, check the accuracy of the decomposition by computing
   l*transpose(l). */

if (chk) {
   error = 0.;
   for (i=rwstrt-1; i < rwend; ++i) {
      for (j=rwstrt-1; j < rwend; ++j) {
         bchk = 0.;
         for (k=rwstrt-1; k < rwend; ++k) bchk += l[i][k] * l[j][k];
         error += Math.abs(b[i][j] - bchk);
      }
   }
   if (error > 1.e-6) {
      printf_("error= " + error);
      iderr_("in choles.");
   }
}

return 0.;
}
}
