class Checkdist extends Beliefs {
static double dist[][][] = new double[NMACTNS][TNMNDS][TNMVALS];

// ----------------------------------------------------------------------

static void checksitdist_(int invec) {

/* Compute and store Situation node distributions.  Check for input
   vectors that produce similar such joint distributions.  These input
   vectors will always cause the same output vector. */

int i, j, k, l;

double probdistance, maxdistance;

/* Add the first output action and target to the conditioning set just
   to allow the BBN solution to work.  Note that the input nodes were set
   in "actnsagree_()" -- the method that calls this method. */

nmcondnds += 2;
condnodes[idnmbrm1][nmcondnds - 2] = Intridslve.decnode[0];
condnodes[idnmbrm1][nmcondnds - 1] = Intridslve.trgtsnode[0];
condvals[nmcondnds - 2] = 1;
condvals[nmcondnds - 1] = 1;

// Compute marginal distributions.

iderr_("in checksitdist");
beliefs_(3, CA.ch);
nmcondnds -= 2;

// Store these distributions.

for (i = 0; i < nmnds; ++i) {
   for (j = 0; j < nodenghs[idnmbrm1][i][0]; ++j) {
      dist[invec][i][j] = belief[0][i][j];
   }
}
printf_("checksitdist: invec= " + invec);

/* Check for a similar set of Situation (subnetwork 1) marginal
   distributions. */

for (i = 0; i <= invec; ++i) {
   for (j = 0; j < i; ++j) {
      maxdistance = 0.;
      nodeloop: for (k = 0; k < nmnds; ++k) {

	 // Don't check conditioning nodes or Scenario nodes.

	 for (l = 0; l < nmcondnds; ++l) {
	    if (k + 1 == condnodes[idnmbrm1][l]) {
	       continue nodeloop;
	    }
	 }
         if (k + 1 > subnet_nmnodes[idnmbrm1][0]) {
	    continue;
	 }

	 /* Compute this node's average probability distance between
	    these two input vectors. */

	 probdistance = 0.;
         for (l = 0; l < nodenghs[idnmbrm1][k][0]; ++l) {
            probdistance += Math.abs(dist[i][k][l] - dist[j][k][l]);

            /*
            printf_("i= " + i + " j= " + j + " node= " + k + " l= " + l +
               " disti= " + dist[i][k][l] + " distj= " + dist[j][k][l]);
            */
	 }
	 probdistance /= (double) nodenghs[idnmbrm1][k][0];

	 /*
         printf_("checksitdist: i= " + i + " j= " + j + " probdistance= " +
            probdistance);
         */

	 // Keep track of the maximum average probability distance.

	 if (probdistance > maxdistance) {
	    maxdistance = probdistance;
	 }
      }

      /* Print a warning if "maxdistance" is small -- indicating a pair 
         of input vectors that are producing similar Situation joint
	 distributions. */

      if (maxdistance < 1.e-2) {
         printf_("checksitdists: i= " + i + " j= " + j + " similar dists");
      }
   }
}

/*
if (invec == CA.lastact - 1) {
   iderr_("in checksitdist");
}
*/

}
}
