import java.util.*;
public class CAutils extends CA {

// Utility functions for the Consistency Analysis (CA) class.

static int nmobsrgns = 1, rgnndnm;

static int prnt[] = new int[6];
static int nmvalngh[] = new int[6];

// ----------------------------------------------------------------------

public static void caSetup_(boolean initialize) {

// Sets up a CA.

boolean oldrgnnm = false;

int i, j, k, l = 0, retval = 0;

if (datafle == null) {
   iderr_("caSetup: ecosystem data file name not read.");
}

// Initialize some arrays.

for (i = 0; i < nmids; ++i) {
   Beliefs.compute_gh[i] = false;
   Distagree.iddenspoints[i] = false;
}

// Initialize array that indicates regions to run the ecosystem model in.

for (i = 0; i < TNMVALS; ++i) {
   if (Beliefs.issms) {
      Ecosyscalcs.computeregion[i] = true;

   } else {
      Ecosyscalcs.computeregion[i] = false;
   }
}

/* Read the ecosystem data file.  On the first line of "datafle"
   (after any comment lines) are the short node names as defined in the
   ID.  If this is an IntIDs model, load the ecosystem ID before reading
   the data file.  The following call to "getmodl_" assumes the ecosystem
   ID is the last ID read in an IntIDs model. */

if (nmids > 1) {
   printf_("caSetup: NOTE! set the desired .par files in the" +
      " individual .id files.");

   idnmbrm1 = nmids - 1;
   thisidname = idname[idnmbrm1];
   Getmodl.readoneid = true;
   Getmodl.getmodl_(6, idfle[nmids - 1]);

} else {
   idnmbrm1 = 0;
   thisidname = idname[idnmbrm1];
}

// Optionally read ecosystem data.

if (phenom_class.equals("ecosystem") || nmids > 1) {
   nmobsnds = Getdata.getdata_(datafle, obsnd);
   if (nmecoobsttl == 0) {
      iderr_("caSetup: ecosystem data file is empty.");
   }

   if (!Beliefs.issms) {
      for (i = 0; i < nmobsnds; ++i) {
         obsndnm[i] = Getmodlutils.getndnm_(obsnd[i]);
      }

      // Sort ecosystem data by time.

      for (i = 0; i < nmecoobsttl; ++i) {
         index[i] = i;
      }
      Idsort.idsort_(dat2_t, index, 1, nmecoobsttl);

      for (i = 0; i < nmecoobsttl; ++i) {
         dumvecx[i] = dat2_x[i];
         dumvecdat[i] = dat2_dat[i];
         idumvec[i] = dat2_vrble[0][i];
      }

      /* Reload the data array and identify regions in which the ecosystem
         model is to be run. */

      for (i = 0; i < nmecoobsttl; ++i) {
         dat2_x[i] = dumvecx[index[i]];
         dat2_dat[i] = dumvecdat[index[i]];
         dat2_vrble[0][i] = idumvec[index[i]];
         Ecosyscalcs.computeregion[((int) dat2_x[i]) - 1] = true;
      }

      // Count the number of observed regions.

      for (i = 1; i < nmecoobsttl; ++i) {
         oldrgnnm = false;
         for (j = 0; j < i; ++j) {
            if (((int) dat2_x[j]) == ((int) dat2_x[i])) {
               oldrgnnm = true;
               break;
            }
         }
         if (!oldrgnnm) {
            ++nmobsrgns;
         }
      }
      printf_("caSetup: idname= " + idname[idnmbrm1] + " nmecoobsttl= " +
         nmecoobsttl + " nmobsrgns= " + nmobsrgns);

      if (nmobsrgns > 1 &&
          (idinfo_hashibm[nmids - 1] || idinfo_haspibm[nmids - 1])) {
         iderr_("caSetup: nmobsrgns > 1 but has an IBM");
      }
   }
}

/* The following allows minimum distance fitting of a stand-alone
   ecosystem model. */

if (nmids == 1) {
   Intridsetup.intridsetup_(false, false);
   fitactions = false;

   if (phenom_class.equals("ecosystem")) {
      i = Getmodlutils.getndnm_("ManOp");
      for (j = 0; j < nmcondnds; ++j) {
         if (condnodes[idnmbrm1][j] == i) {
            Intridutils.ecoactn = (int) condvals[j];
            break;
         }
      }
   }

} else {
   fitactions = true;
}

// Map region numbers to country numbers.

if (phenom_class.equals("ecosystem") || nmids > 1) {
   rgnndnm = Getmodlutils.getndnm_(regionnode);
   for (i = 1; i <= nodenghs[nmids - 1][rgnndnm - 1][0]; ++i) {
      Intridslve.regcountrynm[i - 1] = 1; // All countries.
      if (nodelbls[nmids - 1][rgnndnm - 1][i].indexOf("k_") >= 0) {
         Intridslve.regcountrynm[i - 1] = 2; // Kenya.
   
      } else if (nodelbls[nmids - 1][rgnndnm - 1][i].indexOf("t_") >= 0) {
         Intridslve.regcountrynm[i - 1] = 3; // Tanzania.

      } else if (nodelbls[nmids - 1][rgnndnm - 1][i].indexOf("u_") >= 0) {
         Intridslve.regcountrynm[i - 1] = 4; // Uganda.
      }
   }
}

if (!initialize) {

   return;
}

if (fitactions) {

   /* Initialize ID solver routine.  The observed actions history file
      is read within this method. */

   Intridslve.intridslve_(true, false);
}

fprintf_(1, "\n-------- CA Initialization Parameter Values ----------" +
   "\n   t0= " + Intridslve.t0 + " tfinal= " + Intridslve.tfinal +
   " nmobsactntimes= " + nmobsactntimes + " loadconsdst= " +
      Beliefs.loadconsdst +
   "\n   fitactions= " + fitactions);

printf_("\n-------- CA Initialization Parameter Values ----------" +
   "\n   t0= " + Intridslve.t0 + " tfinal= " + Intridslve.tfinal +
   " nmobsactntimes= " + nmobsactntimes + " loadconsdst= " +
      Beliefs.loadconsdst +
   "\n   fitactions= " + fitactions);

/* Load the optimization vector with the initial guess.  Do this by
   placing the number of free parameters in "n," and number of implicit
   constraints in "m."  When "nmids" > 1, this will result in a parameter
   vector of all parameters of the IDs that constitute the IntIDs model. */

n = 0;
m = 0;
Pxp.xi = 0;
Pxp.ci = 0;
for (i = 0; i < nmids; ++i) {

   // Get ID number.

   for (j = 0; j < Psens.nmsensids; ++j) {
      if (nmids > 1 && !idname[i].equals(Psens.id[j])) {
         continue;
      }
      thisidname = idname[i];
      idnmbrm1 = i;

      /* Specify those IDs that are to have their hypothesis distribution
         agreement measure computed.  Note that due to the "continue"
	 statement above, if this ID is not being fitted, its gh value
	 will not be computed. */

      if (ch > 0. && !thisidname.equals("mntwrk")) {
         Beliefs.compute_gh[i] = true;
      }

      /* Read parameter files.  Note that for a single ID analysis, the
         parameters have already been read. */

      if (nmids > 1) {
         Getmodl.getmodl_(6, idfle[i]);
      }

      // Set to "on" parameters associated with the given nodes.

      for (k = 0; k < nmnds; ++k) {
         varinfo_parest[i][k] = false;
      }

      for (k = 0; k < Psens.nmndes[j]; ++k) {
         l = Getmodlutils.getndnm_(Psens.ndenames[j][k]);
         varinfo_parest[i][l - 1] = true;
      }

      /* Load these parameters into the hypothesis and the initial
         parameter vectors.  Assign constraint index values. */

      Psens.beginpar[j] = Pxp.xi;
      Psens.begincnstrnt[j] = Pxp.ci;

      Pxp.pxp_(0, x_hyp, Optimiz.g, Optimiz.h, 1, Psens.beginpar[j],
         Psens.begincnstrnt[j], false);

      Pxp.pxp_(0, x_ca, g, h, 2, Psens.beginpar[j],
         Psens.begincnstrnt[j], false);

      n += Pxp.xi - Psens.beginpar[j];
      m += Pxp.ci - Psens.begincnstrnt[j];
   }
}

printf_("caSetup: n= " + n + " m= " + m);
printf_("caSetup: If ecosys ID is not being estimated, its gh value will not be computed.");

/* Set the constraint that keeps the percent change between the
   solution's agreement with the data, and the initial agreement with the
   the data to be between -10\%, and 1000\%. */

if (fitactions) {
   Optimiz.gimplicit[m] = -.1;
   Optimiz.himplicit[m] = 10.;
   ++m;
}
}

// ----------------------------------------------------------------------

public static double caf_(double x[], boolean pflag) {

/* Evaluates the Consistency Analysis objective function:
   g_CA() = (1 - CH) * g_S + CH * g_H. */

boolean smplefcn = false;

int idnm, i, j, k, l;

double dens = 0., dist, testval = 1., val = 0., nmestimatedids = 0.;

if (caftest > 0) {
   return 0.;
}

/* ---- Step 1: load optimization vector into the ID parameter vector,
		"condprb." ----------------------------------------- */

for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
   thisidname = idname[idnmbrm1];
   nmnds = Intridslve.nmndes[idnmbrm1];
   Psens.getparms_(1, x, g, h, false);
}
idnmbrm1 = 0;

// ---- Step 2: g_S Computation. ---------------------------------------

gs_groups = 0.;
gs_eco = 0.;
Ecosyscalcs.nmobsrvd = 0;
if (!fitactions) {
   if (nmids == 1) {

      // Solve the IntIDs model over the observed time interval.

      Intridslve.intridslve_(false, false);

      gs = gs_eco;

   } else {

      /* The following code does not load the observed values correctly
         for "densest2." */

      /* Non-action data.  First, perform Gibbs sampling (logic sampling)
         to generate many realizations of the ID's joint distribution. */

      Beliefs.beliefs_(1, ch);

      /* Extract from "simdata" simulated realizations of the observed
         variables at the last time point and place into "margsimdat."
         Note that the "dat2" structure must be sorted by time and within
         time, by "variable" for this to work.  Also assumes that the
         output times in "beliefs_" are the same as "dattimes."  */

      for (i = 0; i < Beliefs.nmloops; ++i) {
         for (j = 0; j < nmecoobsttl; ++j) {
            margsimdat[i][j] = Beliefs.simdata[0][i]
		                              [dat2_vrble[0][j] - 1][1];
	    
	    // Check for a bad sort.

	    if (dat2_t[j + 1] < dat2_t[j] ||
	        dat2_vrble[0][j + 1] < dat2_vrble[0][j]) {
               iderr_("caf: bad sort in dat2");
	    }
         }
      }

      /* For non-action data, compute g_S as a function of the estimated
         density at the data. */

      if (Beliefs.ghtype.equals("hellinger")) {

         /* Call statement (for reference):
            static void densest2_(int n, int nmvar, double data[][],
	       int nmpts, double xobs[][], double pdfests[]) {
         */

         // Densest.densest2_(Beliefs.nmloops, nmecoobsttl, margsimdat,
         //   nmecoobsttl, dat2_dat, Ecosyscalcs.pdfest);

      } else if (Beliefs.ghtype.equals("means")) {
         Ecosyscalcs.pdfest[0] = -Mdobjf.eucdist_(Beliefs.nmloops,
            nmecoobsttl, margsimdat, dat2_dat);
      }

      /* For g_S(.) defined to be negative Hellinger distance:
         gs = -sum_{i=1}^{n} [sqrt(pf_emp(x_i)) - sqrt(pf_model(x_i))]^2.
         If the sample size = 1, this formula becomes
         -2(1-sqrt(pf_model(x_1)))^2.  Consequently, the maximum of
         Hellinger distance and the ML solution coincide.   This is why
         below, gs = pdfest.  The above sample-size-one formula is not
         used due to the result being very small and being undetectable
         by the algorithm due to round-off errors. */

      gs = Ecosyscalcs.pdfest[0];

      if (Double.isInfinite(gs) || Double.isNaN(gs)) {
         printf_("caf: gs= " + gs + ", setting to -1.");
         gs = -1.;
      }
   }

} else if (fitactions) {

   /* Action data on group IDs and observations on random variables for
      the ecosystem ID.  For either a single ID with action-reaction
      data or an actions history data set, compute distance from
      observed actions to model-generated actions.  The negative of this
      distance is the agreement between the observed actions and the
      model-generated actions.

      For an Ecosystem ID, "gs_eco" is computed as a side result of
      solving the IntIDs model within "intridslve_" -- which is called
      within the call to "actnsagree_," below.

      Determine which ID is affected by the move taken in "hooke_" and
      force it to be solved rather than use stored in-out pairs.
      Hooke.vrble = 0 means that the entire IntIDs model needs to have
      all of its IDs re-solved. */

   if (!space_in_use && Optimiz.optmethod.equals("Hooke")) {
      if (Hooke.vrble == 0) {

	 /* Force all IDs to re-solve.  Note that this can cause
	    the function to be different than the one computed during
	    the optimization steps because there, IDs whose parameters
	    are not being adjusted, are not re-solved. */

         for (i = 0; i < nmids; ++i) {
            Intridslve.nminoutpairs[i] = 0;
         }

      } else if (Hooke.vrble > 0) {
         Intridslve.nminoutpairs[Pxp.idownerm1[Hooke.vrble - 1]] = 0;
      }
   }

   /* Initialize random number generator so that function evaluations are
      smooth. */

   /*
   for (i = 0; i <= nmthreads; ++i) {
      Rndm.rndm1_(i, 1);
   }
   */

   // Only force those IDs to re-solve that contain optimization variables.

   if (!Optimiz.optmethod.equals("Hooke") && ch < 1.0) {
      for (i = 0; i < Optimiz.n; i++) {
         Intridslve.nminoutpairs[Pxp.idownerm1[i]] = 0;
      }
   }

   // Run the IntIDs model over the time interval.

   if (CA.computeactionsagreement) {
      Fitactions.actnsagree_(pflag);
   }

   // Compute the model's agreement with data.

   gs = (gs_groups + gs_eco) / 2.;
}

// ---- Step 3: g_H Computation. --------------------------------------

if (!fitactions) {
   gh = Beliefs.gh_measure;
   
} else {

   // Individual "gh_group" values were computed in "intridslve_." */

   gh_groups = 0.;
   dist = 0.;
   for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
      thisidname = idname[idnmbrm1];
      for (j = 0; j < Psens.nmsensids; ++j) {
         if (idname[idnmbrm1].equals(Psens.id[j]) &&
             Beliefs.compute_gh[idnmbrm1]) {
            if (idnmbrm1 == nmids - 1) {
                  gh_eco = 1. + (gh_eco / ((double) nmgh_eco));

            } else {
               for (k = 1; k <= Intridslve.nmndes[idnmbrm1]; ++k) {
                  if (varinfo_parest[idnmbrm1][k - 1]) {
                     dist += helldist_(k);
                  }
               }
 
	       if (idnmbrm1 < nmids - 1) {
	          gh_group[idnmbrm1] = -dist;
                  gh_groups += gh_group[idnmbrm1];

               } else {
                  gh_eco = -dist;
               }
	    }
	 }
      }

      /* "gh_measure" is negative Hellinger distance.  This value is
         always nonpositive.  It is important that this gh_groups indicate
	 perfect agreeement at its value of zero so that the measure of
	 political feasibility in Mpemp.java is correctly defined. */

      gh_groups = gh_groups / ((double) Psens.nmsensids);

      // Form the overall g_H value.
      
      gh = (gh_groups + gh_eco) / 2.;
   }

   /* In order for the weighted average of gh and gs to make sense,
      gh needs to be close to the unit interval.  To achieve this, gh is
      defined to be:
         
            -(Hellinger distance between U_beta and U_betah)
       -------------------------------------------------------
       |-(Hellinger distance between U_beta_initial and U_betah)|

      where U_beta_initial has been found by running CA's Initialize
      step. */

   if (ghdivisor > 1.e-6) {
      gh /= ghdivisor;
   }
}

// --- Step 4: Compute CA objective function. --------------------------

/* The objective function is the priority-weighted sum of standardized
   "gs" and "gh" where "ch" is the priority given to having the consistent
   distribution agree with the one specified by the hypothesis parameter
   values. */

gca = (1. - ch) * gs + ch * gh;

if (pflag) {
   printf_("caf: gs_groups= " + fdble_(gs_groups, 8, 5) + " gs_eco= " +
      fdble_(gs_eco, 8, 5) + " gs= " + fdble_(gs, 8, 5)  + " matchfrac= " +
      fdble_(matchfrac[0], 8, 5) +
      "\n    gh_groups= " + fdble_(gh_groups, 9, 6) + " gh_eco= " +
      fdble_(gh_eco, 8, 5) + " gh= " + fdble_(gh, 8, 5) + " gca= " +
      fdble_(gca, 9, 6));

   for (i = 0; i < nmids; ++i) {
      for (j = 0; j < Psens.nmsensids; ++j) {
         if (idname[i].equals(Psens.id[j])) {
            printf_("    Estimated ID= " + idname[i] +
               " nm_grp_condsets= " + nm_grp_condsets[i] +
	       " gh_group= " + fdble_(gh_group[i], 8, 5));
         }
      }
   }
}

/* Because the function representing the agreement with the actions
   history data is discontinuous, it is important to not accept any moves
   that reduces this value from the found initially.  This agreement is
   enforced by adding a major penalty to the objective function if the
   agreement with the actions history data is reduced.  Use of such a
   penalty function to, in-effect, represent an implicit constraint, works
   because the explosive first derivative caused by the abrupt assignment
   of a penalty value to the objective function does not mess up any
   Hessian calculation because the Hooke and Jeeves algorithm does not
   compute the Hessian. */
  
if (penaltythres < 1.e-6) {
   Optimiz.cnstrnt[0] = gs_groups;

} else {
   Optimiz.cnstrnt[0] = (gs_groups - penaltythres) / penaltythres;
}

if (Optimiz.cnstrnt[0] < Optimiz.gimplicit[0] ||
    Optimiz.himplicit[0] < Optimiz.cnstrnt[0]) {
   
   printf_("caf: cnstrnt= " + Optimiz.cnstrnt[0] + " gca=penalty value.");
   gca = Optimiz.penaltyval;
}

return gca;
}

// ------------------------------------------------------------------

public static void modecalcs_() {

int i, j, k, l, prntnm = 0, nmvals, nodenm, j1, j2, j3, j4, j5, j6,
   hmode, cmode, ndists = 0, nagree = 0;

double hmodeval, cmodeval, hprobval, cprobval, parspacedist = 0.;

/* Compute the fraction of distributions for which the mode is the same
   between the ID specified with hypothesis parameter values and the ID
   specified with consistent parameter values. */

for (nodenm = 1; nodenm <= nmnds; ++nodenm) {
   nmvals = nodenghs[idnmbrm1][nodenm - 1][0];

   if (!varinfo_dist[idnmbrm1][nodenm - 1].equals("Discrete")) {
      continue;
   }

   // Get parent information for this node.

   for (i = 0; i < 6; ++i) {
      prnt[i] = nodenghs[idnmbrm1][nodenm - 1][i + 2];
      if (prnt[i] > 0) {
         nmvalngh[i] = nodenghs[idnmbrm1][prnt[i] - 1][0];

      } else {
         nmvalngh[i] = 1;
      }
   }

   // Now, loop through all parent-value combinations.

   for (j1 = 0; j1 < nmvalngh[0]; ++j1) {
      for (j2 = 0; j2 < nmvalngh[1]; ++j2) {
         for (j3 = 0 ; j3 < nmvalngh[2]; ++j3) {
            for (j4 = 0; j4 < nmvalngh[3]; ++j4) {
               for (j5 = 0; j5 < nmvalngh[4]; ++j5) {
                  for (j6 = 0; j6 < nmvalngh[5]; ++j6) {

		     // Find modes of hypothesis and consistent IDs.

		     hmode = 0;
		     cmode = 0;
		     hmodeval = 0.;
		     cmodeval = 0.;
		     for (i = 0; i < nmvals; ++i) {

			// Hypothesis.

			hprobval = Readnet.condprb[idnmbrm1][nodenm - 1]
				     [i][j1][j2][j3][j4][j5][j6][0];
			if (hmodeval < hprobval) {
			   hmodeval = hprobval;
			   hmode = i + 1;
			}

			// Consistent.

			cprobval = Readnet.condprb[idnmbrm1][nodenm - 1]
				     [i][j1][j2][j3][j4][j5][j6][1];
			if (cmodeval < cprobval) {
			   cmodeval = cprobval;
			   cmode = i + 1;
			}
		     }

		     // Update counters.

		     ++ndists;
		     if (hmode == cmode) {
			++nagree;

                     } else {
                        printf_("modecalcs: ID= " + idname[idnmbrm1] +
                           " node= " + nodelbls[idnmbrm1][nodenm - 1][0] +
                           "\n   hmode= " + hmode + " cmode= " + cmode);
		     }
		  }
               }
            }
         }
      }
   }
}

if (ndists > 0) {
   fprintf_(1, "\n n_agree/n_dists= " + (((double) nagree) /
      ((double) ndists)));
}
}

// ------------------------------------------------------------------

public static double helldist_(int distnode) {

int i, j, k, l, prntnm = 0, nmvals, nmpars = 0, j1, j2, j3, j4, j5, j6;

double hprobval, cprobval, dumval, helldist = 0.;

/* Compute the Hellinger distance between the ID specified with
   hypothesis parameter values and the ID specified with consistent
   parameter values. */

nmvals = nodenghs[idnmbrm1][distnode - 1][0];
if (nmvals == 1) {
   nmpars = varinfo_nmparms[idnmbrm1][distnode - 1];

} else {
   nmpars = nmvals;
}

// Get parent information for this node.

for (i = 0; i < 6; ++i) {
   prnt[i] = nodenghs[idnmbrm1][distnode - 1][i + 2];
   if (prnt[i] > 0) {
      nmvalngh[i] = nodenghs[idnmbrm1][prnt[i] - 1][0];

   } else {
      nmvalngh[i] = 1;
   }
}

// Now, loop through all parent-value combinations.

for (j1 = 0; j1 < nmvalngh[0]; ++j1) {
   for (j2 = 0; j2 < nmvalngh[1]; ++j2) {
      for (j3 = 0; j3 < nmvalngh[2]; ++j3) {
         for (j4 = 0; j4 < nmvalngh[3]; ++j4) {
            for (j5 = 0; j5 < nmvalngh[4]; ++j5) {
               for (j6 = 0; j6 < nmvalngh[5]; ++j6) {
		  for (i = 0; i < nmpars; ++i) {

	             // Hypothesis.

	             hprobval = Readnet.condprb[idnmbrm1][distnode - 1]
				     [i][j1][j2][j3][j4][j5][j6][0];

		     // Consistent.

                     cprobval = Readnet.condprb[idnmbrm1][distnode - 1]
				     [i][j1][j2][j3][j4][j5][j6][1];

                     // Compute the discrete Hellinger distance.

                     dumval = Math.sqrt(hprobval) - Math.sqrt(cprobval);
		     dumval *= dumval;
                     helldist += dumval;
		  }
               }
            }
         }
      }
   }
}

return Math.sqrt(0.5 * helldist + 1.e-7);
}
}
