class CAinitialize extends Fitactions {

/* See the id Users Manual for details of the algorithms in this class.
 
Notes:

   1. Consider all in-combinations that map to the same out-combination
      as a group and set all their parameters to the same values.

   2. Only change conditional distributions conditioned on
      "bestinoutpair" combinations (not individual INACTN, INS etc. node 
      values.

   3. For a node with a nuisance 2nd parent, use the desired conditional
      distribution no matter what the value of this parent is.

   4. Always have INACTN or ACTN as the first parent.  That way,
      adding an in-action or out-action to an ID's .par file is
      easy to do in an editor.

   5. Set the conditional distributions on nodes that are in between
      nodes directly affected by INACTN or ACTN node -- and a Goal node
      so that the value of the direct-affect node is passed down the
      hierarchy with very little noise.

   6. The algorithm below cannot fit the same action directed against
      two or more different targets due to CTARGET being dependent on
      ACTN.

   7. Debug this code by turning on the print statement in Idsolve.java
      that prints the goal distributions and the expected utility.

   8. If a Scenario Goal has several audience nodes, set distributions
      so that if at least one audience is satisfied, then this
      "audience effect" is satisfied.
*/

static int outcombindx[][] = new int[TNMIDS][NMINOUTPAIRS];
static int prnt[] = new int[6];
static int nmvalngh[] = new int[6];
static int iprntval[] = new int[6];
static int sc_state_dist[][] = new int[NMINOUTPAIRS][2];
static int dumint1[] = new int[NMINOUTPAIRS];
static int dumint2[] = new int[NMINOUTPAIRS];
static int indx[] = new int[NMINOUTPAIRS];
static int obsingroup[] = new int[NMINOUTPAIRS];
static int outcombfreq[] = new int[NMINOUTPAIRS];
static int evaluation_dimension_mode[] = new int[2];
static int modes_to_group[][] = new int[3][3];

static double dscrtdst[] = new double[TNMVALS];
static double sortarray[] = new double[NMINOUTPAIRS];
static double margdist[][] = new double[TNMNDS][TNMVALS];
static double dumpair[][] = new double[NMINOUTPAIRS][6];
static double complementact[][] = new double[TNMIDS][NMINOUTPAIRS];

// ----------------------------------------------------------------------

static void cainitialize_(String applctn) {

boolean uniqueingroup = false, newoutcomb;

String nodename = "none";

int i, j, k, kk, l, ll, nmgenpairs, nminactors, nminactns, nminsubj,
   nmmatched, maxfreq, incombgroup, nmobsingroups = 0, outactcondnode,
   outtrgtcondnode;

double dumval, modeval = 0.;

// Map mode dimension patterns to in-combination groups.

k = 1;
for (i = 0; i < 3; ++i) {
   for (j = 0; j < 3; ++j) {
      modes_to_group[i][j] = k;
      ++k;
   }
}

/* Assign initial distribution values to combinations of in-combination
   group and evaluation dimension. */

sc_state_dist[0][0] = 2; sc_state_dist[0][1] = 1;
sc_state_dist[1][0] = 2; sc_state_dist[1][1] = 2;
sc_state_dist[2][0] = 2; sc_state_dist[2][1] = 3;
sc_state_dist[3][0] = 2; sc_state_dist[3][1] = 2;
sc_state_dist[4][0] = 3; sc_state_dist[4][1] = 2;
sc_state_dist[5][0] = 3; sc_state_dist[5][1] = 3;
sc_state_dist[6][0] = 3; sc_state_dist[6][1] = 2;
sc_state_dist[7][0] = 3; sc_state_dist[7][1] = 3;
sc_state_dist[8][0] = 3; sc_state_dist[8][1] = 3;

/* Read-in the set of in-out pairs that the IntIDs model is to be
   fitted to.  A negative value for an action indicates that action
   is to be avoided.  Because these are non-temporal actions, they do
   not load the array "obsactntime."

   For a deterministic sensitivity analysis ("dsens"), use the number
   of actions and number of targets for this ID to specify the desired
   action-target pairs.  Do this as follows.
   A mix of desired and complement actions: Enter the desired pairs
   as with a "ca" application, and modify the Scenario so that the
   complement actions cause a low value of OGA. */

if (applctn.equals("ca")) {
   fleopen_(2, bestpairsfle, 'r');

} else if (applctn.equals("dsens")) {
   fleopen_(2, Dsens.dsensfle, 'r');

} else if (applctn.equals("mpemp")) {
   fleopen_(2, Mpemp.mpempfle, 'r');
}

/* Read the CA, sensitivity analysis, or MPEMP constraints file.
   A record in this file is an in-out pair.  An in-out pair is five real numbers:
   input action, input actor, input subject, output action, output actor.
   The numbers index the values of the following nodes:
   Input Action, Input Actor, Input Subject, Action, Target. */

do {
   if (nmids > 1) {
      thisidname = fgetstrng_(2);
      idnmbrm1 = Getmodlutils.getidnmbrm1_(thisidname);
      bestnminoutpairs[idnmbrm1] = fgetint_(2);
      Intridslve.nminoutpairs[idnmbrm1] = bestnminoutpairs[idnmbrm1];
      for (j = 0; j < Intridslve.nminoutpairs[idnmbrm1]; ++j) {
         for (k = 0; k < 5; ++k) {
            bestinoutpair[idnmbrm1][j][k] = fgetdble_(2);
         }
      }

   } else {
      fgetstrng_(2);
      Intridslve.actions_econoutput[0][0][0] = fgetint_(2);
   }
} while (!checkeof_(2));
fclose_(2, 'r');

if (nmids == 1) {

   return;
}

// Set these desired and complement actions.

for (idnmbrm1 = 0; idnmbrm1 < nmids - 1; ++idnmbrm1) {
   if (!findmpemp) {
      nminactors = 1;
      nminactns = 1;
      nminsubj = 1;

   } else {
      nminactors = nodenghs[idnmbrm1][Intridslve.inactrnode[idnmbrm1] - 1][0];
      nminactns = nodenghs[idnmbrm1][Intridslve.inactnnode[idnmbrm1] - 1][0];
      nminsubj = nodenghs[idnmbrm1][Intridslve.insubjnode[idnmbrm1] - 1][0];
   }
   nmgenpairs = 0;
   for (j = 0; j < Intridslve.nminoutpairs[idnmbrm1]; ++j) {

      /*
      printf_("cainitialize: j= " + j + " mpempaction= " + 
         bestinoutpair[idnmbrm1][j][3] + " target= " +
         bestinoutpair[idnmbrm1][j][4]);
      */

      for (k = 0; k < nminactors; ++k) {
         for (l = 0; l < nminactns; ++l) {
            for (ll = 0; ll < nminsubj; ++ll) {
               if (bestinoutpair[idnmbrm1][j][3] < 0.) {
		       
                  // Store a complement action.

                  complementact[idnmbrm1][nmgenpairs] =
		          -bestinoutpair[idnmbrm1][j][3];

               } else {

		  // Store required action in observed action array.

                  actnshstry_obsactor[nmobsactns] = idname[idnmbrm1];
                  actnshstry_obsactnraw[nmobsactns] =
                     (int) bestinoutpair[idnmbrm1][j][3];
	          ++nmobsactns;
               }

               /* Store either a complement or required action in the
	          incomb-outcomb array. */

               for (kk = 0; kk < 3; ++kk) {
                  Intridslve.incomb[idnmbrm1][nmgenpairs][kk] =
		          bestinoutpair[idnmbrm1][j][kk];
               }
               Intridslve.outcomb[idnmbrm1][nmgenpairs][0] =
		       (int) bestinoutpair[idnmbrm1][j][3];
               Intridslve.outcomb[idnmbrm1][nmgenpairs][1] =
		       (int) bestinoutpair[idnmbrm1][j][4];
	       ++nmgenpairs;
            }
         }
      }
      if (bestinoutpair[idnmbrm1][j][3] < 0.) {
         bestinoutpair[idnmbrm1][j][3] *= -1.; 
      }
   }
   Intridslve.nminoutpairs[idnmbrm1] = nmgenpairs;
}

/* For each in-out pair, identify its unique out-combination by giving
   it a unique value in the array "outcombindx." */

printf_("\n-------- CA Initialize Substep 2 Output --------" +
   "\n ID   # of in-out pairs  # of unique out-combinations" +
   "\n   (from Substep 1)   (of these in-out pairs)");

for (idnmbrm1 = 0; idnmbrm1 < nmids - 1; ++idnmbrm1) {
   thisidname = idname[idnmbrm1];
   nmgenpairs = Intridslve.nminoutpairs[idnmbrm1];

   if (nmgenpairs == 0) {
      nmuniqueoutcombs[idnmbrm1] = 0;
      continue;
   }

   /* If there are any in-out pairs, there is at least one unique
      out-combination.  And, the first in-out pair is always the first
      unique out-combination. */

   nmuniqueoutcombs[idnmbrm1] = 1;
   outcombindx[idnmbrm1][0] = 1;

   for (j = 1; j < nmgenpairs; ++j) {
      newoutcomb = true;
      for (k = 0; k < j; ++k) {
	 if (Intridslve.outcomb[idnmbrm1][k][0] ==
	     Intridslve.outcomb[idnmbrm1][j][0]
	    &&
	     Intridslve.outcomb[idnmbrm1][k][1] ==
	     Intridslve.outcomb[idnmbrm1][j][1]) {
	    newoutcomb = false;
	    break;
	 }
      }
      if (newoutcomb) {
         ++nmuniqueoutcombs[idnmbrm1];
      }
      outcombindx[idnmbrm1][j] = nmuniqueoutcombs[idnmbrm1];
   }
   printf_(fstrng_(thisidname, 7) + "  " + nmgenpairs + "  " +
      nmuniqueoutcombs[idnmbrm1]);

   // Next, compute the frequency of each unique out-combination.

   for (j = 0; j < nmuniqueoutcombs[idnmbrm1]; ++j) {
      outcombfreq[j] = 0;
      indx[j] = j + 1;
   }
   for (j = 0; j < nmgenpairs; ++j) {
      ++outcombfreq[outcombindx[idnmbrm1][j] - 1];
      dumint2[j] = outcombindx[idnmbrm1][j];
   }

   /* Sort the unique out-combinations from most-frequent to
      least-frequent. */

   for (j = 0; j < nmuniqueoutcombs[idnmbrm1]; ++j) {
      dumint1[j] = outcombfreq[j];
      sortarray[j] = -1. * (double) outcombfreq[j];
   }
   Idsort.idsort_(sortarray, indx, 1, nmuniqueoutcombs[idnmbrm1]);
   for (j = 0; j < nmuniqueoutcombs[idnmbrm1]; ++j) {
      outcombfreq[j] = dumint1[indx[j] - 1];
   }
   for (j = 0; j < nmgenpairs; ++j) {
      for (k = 1; k <= nmuniqueoutcombs[idnmbrm1]; ++k) {
         if (dumint2[j] == indx[k - 1]) {
            outcombindx[idnmbrm1][j] = k;
	    break;
	 }
      }
   }

   // Sort the in-out pairs by their "outcombindx."

   for (j = 0; j < nmgenpairs; ++j) {
      for (k = 0; k < 3; ++k) {
         dumpair[j][k] = Intridslve.incomb[idnmbrm1][j][k];
      } 
      dumpair[j][3] = (double) Intridslve.outcomb[idnmbrm1][j][0];
      dumpair[j][4] = complementact[idnmbrm1][j];
      dumpair[j][5] = (double) Intridslve.outcomb[idnmbrm1][j][1];
      dumint2[j] = outcombindx[idnmbrm1][j];
      sortarray[j] = (double) outcombindx[idnmbrm1][j];
      indx[j] = j + 1;
   }
   Idsort.idsort_(sortarray, indx, 1, nmgenpairs);
   for (j = 0; j < nmgenpairs; ++j) {
      for (k = 0; k < 3; ++k) {
         Intridslve.incomb[idnmbrm1][j][k] = dumpair[indx[j] - 1][k];
      } 
      Intridslve.outcomb[idnmbrm1][j][0] = (int) dumpair[indx[j] - 1][3];
      complementact[idnmbrm1][j] = dumpair[indx[j] - 1][4];
      Intridslve.outcomb[idnmbrm1][j][1] = (int) dumpair[indx[j] - 1][5];
      outcombindx[idnmbrm1][j] = dumint2[indx[j] - 1];

      /*
      printf_("cainitialize: j= " + j + " outcomb= " +
         Intridslve.outcomb[idnmbrm1][j][0] + " complementact= " +
	 complementact[idnmbrm1][j] + " outtrgt= " +
	 Intridslve.outcomb[idnmbrm1][j][1] + " outcombindx= " +
	 outcombindx[idnmbrm1][j]);
      */
   }
}

// ******** Set unfavorable, and favorable distributions.***********

for (idnmbrm1 = 0; idnmbrm1 < nmids - 1; ++idnmbrm1) {

   /* Set all distributions on Scenario State nodes so that the first
      value ("negligible") has the highest probability.  Do this for all
      of the node's conditional distributions. */

   thisidname = idname[idnmbrm1];
   if (thisidname.equals("middlemen") || thisidname.equals("anti-poach")) {
      continue;
   }
   printf_("\ncainitialize: Beginning ID= " + thisidname);

   nmnds = Intridslve.nmndes[idnmbrm1];
   nmcondnds = Intridslve.nmcondndes[idnmbrm1];
   Intridslve.nminputnodes = nmcondnds - 2;

   condnodes[idnmbrm1][0] = Intridslve.timenode[idnmbrm1];
   condvaltype[0] = "continuous";
   condnodes[idnmbrm1][1] = Intridslve.inactnnode[idnmbrm1];
   condvaltype[1] = "discrete";
   condnodes[idnmbrm1][2] = Intridslve.inactrnode[idnmbrm1];
   condvaltype[2] = "discrete";
   condnodes[idnmbrm1][3] = Intridslve.insubjnode[idnmbrm1];
   condvaltype[3] = "discrete";
   i = 3;

   if (thisidname.indexOf("epa", 0) >= 0 ||
       thisidname.indexOf("ngo", 0) >= 0) {
      ++i;
      condnodes[idnmbrm1][i] = Intridslve.ecoinnodes[idnmbrm1][0];
      condvaltype[i] = "continuous";

      ++i;
      condnodes[idnmbrm1][i] = Intridslve.ecoinnodes[idnmbrm1][1];
      condvaltype[i] = "continuous";

   } else if (thisidname.indexOf("rr", 0) >= 0 ||
              thisidname.indexOf("pas", 0) >= 0) {
      ++i;
      condnodes[idnmbrm1][i] = Intridslve.ecoinnodes[idnmbrm1][0];
      condvaltype[i] = "continuous";

   } else if (thisidname.equals("middlemen")) {
      ++i;
      condnodes[idnmbrm1][i] = 5;
      condvaltype[i] = "continuous";

      ++i;
      condnodes[idnmbrm1][i] = 6;
      condvaltype[i] = "continuous";

   } else if (thisidname.equals("poachers")) {
      ++i;
      condnodes[idnmbrm1][i] = 5;
      condvaltype[i] = "continuous";

      ++i;
      condnodes[idnmbrm1][i] = 6;
      condvaltype[i] = "continuous";

      ++i;
      condnodes[idnmbrm1][i] = 7;
      condvaltype[i] = "continuous";
   }

   ++i;
   outactcondnode = i;
   outtrgtcondnode = i + 1;

   condnodes[idnmbrm1][outactcondnode] = Intridslve.decnode[idnmbrm1];
   condvaltype[outactcondnode] = "discrete";

   condnodes[idnmbrm1][outtrgtcondnode] = Intridslve.trgtsnode[idnmbrm1];
   condvaltype[outtrgtcondnode] = "discrete";

   for (i = 1; i <= nmnds; ++i) {
      nodename = nodelbls[idnmbrm1][i - 1][0];
      if (grph_label[idnmbrm1][i - 1].equals("SECON") ||
           grph_label[idnmbrm1][i - 1].equals("SCMPDON") ||
           grph_label[idnmbrm1][i - 1].equals("SDON") ||
           grph_label[idnmbrm1][i - 1].equals("SLVE") ||
           grph_label[idnmbrm1][i - 1].equals("SFAM") ||
           grph_label[idnmbrm1][i - 1].equals("SPRES") ||
           grph_label[idnmbrm1][i - 1].equals("SMILR") ||
           grph_label[idnmbrm1][i - 1].equals("SIIWP") ||
           grph_label[idnmbrm1][i - 1].equals("SRRPR") ||
           grph_label[idnmbrm1][i - 1].equals("SPASPR") ||
           grph_label[idnmbrm1][i - 1].equals("SWPREV")) {
         printf_("   forcing unfavorable on node= " + nodename);
         forceunfav_(i);
      }
   }

   /* *********** Turn on desired outcomes. **************

      Compute the marginal distributions of Scenario State nodes under
      each pair.  Do this with beliefs_() because there is no need to
      solve the influence diagram for each pair. */

   condvals[0] = 0.;
   spacetime_tmax = condvals[0];
   nmgenpairs = Intridslve.nminoutpairs[idnmbrm1];

   printf_("cainitialize: nmgenpairs= " + nmgenpairs);

   for (j = 0; j < nmgenpairs; ++j) {

      // Skip complement actions.

      if (complementact[idnmbrm1][j] > 0.) {
         continue;
      }

      // Set in-action, in-actor, and in-subject.

      for (i = 1; i <= 3; ++i) {
         condvals[i] = Intridslve.incomb[idnmbrm1][j][i - 1];
      }
      i = 3;

      // Set in-ecosystem node(s).

      if (thisidname.indexOf("epa", 0) >= 0 ||
          thisidname.indexOf("ngo", 0) >= 0) {
         ++i;
         condvals[i] = .3;
         ++i;
         condvals[i] = .3;
   
      } else if (thisidname.indexOf("rr", 0) >= 0 ||
              thisidname.indexOf("pas", 0) >= 0) {
         ++i;
         condvals[i] = .3;
      }
      
      // Set order size, in-bid price and in-wage node(s).

      if (thisidname.equals("poachers")) {
         ++i;
         condvals[i] = 25.;
         ++i;
         condvals[i] = 1000.;
         ++i;
         condvals[i] = 100.;
      }

      // Set action and target.

      condvals[outactcondnode] = Intridslve.outcomb[idnmbrm1][j][0];
      condvals[outtrgtcondnode] = Intridslve.outcomb[idnmbrm1][j][1];

      /* Compute the marginal beliefs distributions and store it in
         "beliefc." */

      Beliefs.beliefs_(1, 0.);

      // Find modal values.

      evaluation_dimension_mode[0] = 0;
      evaluation_dimension_mode[1] = 0;
      for (i = 0; i < nmnds; ++i) {
   
         /* Dimension 1 (economic) is either economic, donors, livestock,
            or family.
            Dimension 2 (militaristic) is either military,
            interaction with police, or presidential approval. */

         if (grph_label[idnmbrm1][i].equals("ECON") ||
             grph_label[idnmbrm1][i].equals("DON") ||
             grph_label[idnmbrm1][i].equals("LVE") ||
             grph_label[idnmbrm1][i].equals("FAM")) {
            l = 0;

         } else if (grph_label[idnmbrm1][i].equals("MILR") ||
            grph_label[idnmbrm1][i].equals("IIWP") ||
            //grph_label[idnmbrm1][i].equals("PCHACT") ||
            grph_label[idnmbrm1][i].equals("PRES")) {
            l = 1;

         } else {
            continue;
	 }

         // Find the mode of this Situation State node.

         modeval = 0.;
         evaluation_dimension_mode[l] = 1;
         for (k = 0; k < nodenghs[idnmbrm1][i][0]; ++k) {
            margdist[i][k] = Beliefs.beliefc[0][Beliefs.nmoutt - 1][i][k];
            if (margdist[i][k] > modeval) {
               modeval = margdist[i][k];
               evaluation_dimension_mode[l] = k + 1;
            }
         }
      }

      // Verify.

      if (evaluation_dimension_mode[0] < 1 ||
          evaluation_dimension_mode[1] < 1) {
         iderr_("cainitialize: evaluation_dimension_mode problem");
      }

      /* Place each in-combination in a group based on its pattern
         across the two dimensions. */

      incombgroup = modes_to_group[evaluation_dimension_mode[0] - 1]
                                  [evaluation_dimension_mode[1] - 1];
      
      /*
      printf_("   pair= " + (j + 1) + " incombgroup= " + incombgroup +
         " evaldim1= " + evaluation_dimension_mode[0] + " evaldim2= " +
                         evaluation_dimension_mode[1] +
         "\n    action= " + condvals[outactcondnode] + " target= " +
	 condvals[outtrgtcondnode] + " outcombindx= " +
	 outcombindx[idnmbrm1][j]);
      */

      // Count the number of unique in-combination groups.
      
      uniqueingroup = true;
      for (k = 0; k < nmobsingroups; ++k) {
         if (incombgroup == obsingroup[k]) {
            uniqueingroup = false;
	    break;
	 }
      }
      if (uniqueingroup) {
         obsingroup[nmobsingroups] = incombgroup;
         ++nmobsingroups;
      }

      /* Set those conditional distributions that are referenced by
         the in-combinations according to the entries in "sc_state_dist." */
     
      setdists_(incombgroup, outactcondnode);
   }
      
   printf_("cainitialize: desired actions nmobsingroups= " + nmobsingroups +
      " any action nmuniqueoutcombs= " + nmuniqueoutcombs[idnmbrm1]);

   // Compute the out-combination for each observed in-combination.
   
   nmmatched = 0;
   for (j = 1; j <= nmgenpairs; ++j) {
      nmmatched += checkmatch_(j);
   }

   printf_("cainitialize: ID= " + thisidname + " nmgenpairs= " + nmgenpairs +
      " desired actions nmmatched= " + nmmatched +
      "\n NOTE: all complement actions have been forced unfavorable");

   /*
   if (thisidname.equals("kenrr")) {
      iderr_("in cainitialize");
   }
   */

   /* Write this set of feasible parameter values to the "initial" file
      name. */

   if (!Report.confidenceintervals) {
      Writenet.writenet_(3, 2, true);
   }
} // End of loop over IDs.

return;
}

// ---------------------------------------------------------------------

static void forceunfav_(int nodenm) {

// Forces distributions to be unfavorable.

int i, j, k, j1, j2, j3, j4, j5, j6, nmvals, obsactnnm = 0,
   obstrgtnm = 0, pttrnnm = 0;

nmvals = nodenghs[idnmbrm1][nodenm - 1][0];

// Get parent values.

for (i = 0; i < 6; ++i) {
   prnt[i] = nodenghs[idnmbrm1][nodenm - 1][i + 2];
   if (prnt[i] > 0) {
      nmvalngh[i] = nodenghs[idnmbrm1][prnt[i] - 1][0];

   } else {
      nmvalngh[i] = 1;
   }
}

for (j1 = 1; j1 <= nmvalngh[0]; ++j1) {
   for (j2 = 1; j2 <= nmvalngh[1]; ++j2) {
      for (j3 = 1 ; j3 <= nmvalngh[2]; ++j3) {
         for (j4 = 1; j4 <= nmvalngh[3]; ++j4) {
            for (j5 = 1; j5 <= nmvalngh[4]; ++j5) {
               for (j6 = 1; j6 <= nmvalngh[5]; ++j6) {
                  iprntval[0] = j1;
                  iprntval[1] = j2;
                  iprntval[2] = j3;
                  iprntval[3] = j4;
                  iprntval[4] = j5;
                  iprntval[5] = j6;

                  /* Make a distribution not favorable.  Assumes that
		     ACTN is the first parent. */

                  if (varinfo_dist[idnmbrm1][nodenm - 1].equals(
                     "Discrete")) {
	             getdistpttrn_(nmvals, 1, dscrtdst);
	             for (j = 0; j < nmvals; ++j) {
	                Readnet.condprb[idnmbrm1][nodenm - 1][j]
	                   [iprntval[0] - 1][iprntval[1] - 1]
	                   [iprntval[2] - 1][iprntval[3] - 1]
	                   [iprntval[4] - 1][iprntval[5] - 1][1]
	                   = dscrtdst[j];
                     }

                  } else if (nmvals > 2) {

	             // Determ-Discrete node.

		     Readnet.condprb[idnmbrm1][nodenm - 1][0]
                        [iprntval[0] - 1][iprntval[1] - 1]
		        [iprntval[2] - 1][iprntval[3] - 1]
		        [iprntval[4] - 1][iprntval[5] - 1][1]
		        = getdetermval_(nmvals, 1);
		  }
               }
            }
         }
      }
   }
}
}

// ----------------------------------------------------------------------

static void setdists_(int incombgroup, int outactcondnode) {

boolean newact;

int i, j, k, l, prntnm = 0, obsactnnm, obstrgtnm, nmvals, nodenm, j1,
   j2, j3, j4, j5, j6;

// Find nodes and modify their conditional distributions.

for (nodenm = 1; nodenm <= nmnds; ++nodenm) {

   nmvals = nodenghs[idnmbrm1][nodenm - 1][0];
   if (nmvals == 1) {
      continue;
   }

   if (grph_label[idnmbrm1][nodenm - 1].equals("CTARGET")) {
   
      /* For the CTARGET node, place high probability on the observed
	 target (Discrete). */

      for (i = 0; i < Intridslve.nminoutpairs[idnmbrm1]; ++i) {
      
         // Skip complement actions.

         if (complementact[idnmbrm1][i] > 0.) {
            continue;
         }

         obsactnnm = Intridslve.outcomb[idnmbrm1][i][0];
         obstrgtnm = Intridslve.outcomb[idnmbrm1][i][1];
         if (obstrgtnm == 0) {
            printf_("setdists: ID= " + thisidname + " obstrgtnm=0");
	    continue;
	 }

	 /*
	 if (thisidname.equals("kenrr")) {
            printf_("setdists: obsactnnm= " + obsactnnm + " obstrgtnm= " +
               obstrgtnm);
         }
	 */

         if (varinfo_dist[idnmbrm1][nodenm - 1].equals("Discrete")) {
            for (j = 0; j < nmvals; ++j) {
               dscrtdst[j] = .3 / (double) (nmvals - 1);
            }
            dscrtdst[obstrgtnm - 1] = .7;

            for (j = 0; j < nmvals; ++j) {
               Readnet.condprb[idnmbrm1][nodenm - 1][j][obsactnnm - 1]
			      [0][0][0][0][0][1] = dscrtdst[j];
            }

	 } else {
	    for (j = 0; j < 2; ++j) {
	       for (k = 0; k < 2; ++k) {
		  for (l = 0; l < 2; ++l) {
                     Readnet.condprb[idnmbrm1][nodenm - 1][0]
				    [obsactnnm - 1][j][k][l][0][0][1]
				       = (double) obstrgtnm;
		  }
	       }
	    }
	 }
      }
      continue;
   }

   /* Modify Situation change and Scenario state nodes.  First, get node
      numbers of parents. */

   for (i = 0; i < 6; ++i) {
      prnt[i] = nodenghs[idnmbrm1][nodenm - 1][i + 2];
      if (prnt[i] > 0) {
         nmvalngh[i] = nodenghs[idnmbrm1][prnt[i] - 1][0];

      } else {
         nmvalngh[i] = 1;
      }
   }

   // Now, loop through all parent-value combinations.

   for (j1 = 1; j1 <= nmvalngh[0]; ++j1) {
      for (j2 = 1; j2 <= nmvalngh[1]; ++j2) {
         for (j3 = 1 ; j3 <= nmvalngh[2]; ++j3) {
            for (j4 = 1; j4 <= nmvalngh[3]; ++j4) {
               for (j5 = 1; j5 <= nmvalngh[4]; ++j5) {
                  for (j6 = 1; j6 <= nmvalngh[5]; ++j6) {
                     iprntval[0] = j1;
                     iprntval[1] = j2;
                     iprntval[2] = j3;
                     iprntval[3] = j4;
                     iprntval[4] = j5;
                     iprntval[5] = j6;
		     assigndist_(nodenm, nmvals, incombgroup,
                        outactcondnode);
		  }
               }
            }
         }
      }
   }
}
}

// ----------------------------------------------------------------------

static void assigndist_(int nodenm, int nmvals, int incombgroup,
   int outactcondnode) {

/* Assigns conditional distributions.
   Nodes that are influenced by in-action, in-actor, action, or chosen
   target nodes represent "evaluation dimensions": the main criteria
   along which a group evaluates an in-combination or an out-combination.

   Set CPTs of Situation nodes so that the first 9 different groups of
   observed in-combinations generate 9 different patterns of marginal
   distributions on Situation State nodes such as Economic State, and
   Military State.  Two patterns are different if their modal values are
   different.  Assign a Situation pattern to each such pattern of
   Situation State node pairs.  Use this number to assign corresponding
   CPTs to the Scenario nodes as in Table 2 of pemtc.tex.

Group           Dimension 1          Dimension 2
----------------------------------------------------------------------
president       Economic             Militaristic
----------------------------------------------------------------------
EPA             Economic             Poaching Action,
	        President            Rural Resident Poaching Rate,
				     Pastoralist Poaching Rate
----------------------------------------------------------------------
rural resident  Economic             Imminent Interaction With Police
----------------------------------------------------------------------
pastoralist     Territory Size,      Imminent Interaction With Police
	        Livestock       
----------------------------------------------------------------------
NGO             Presidents           Wildlife Prevalence
----------------------------------------------------------------------
*/

boolean desiredincomb, matchinactr = false, matchsubj = false,
   matchprnts = false, modifysit = false;

int i = 0, outcombpttrn = 0, val = 0, evaldim = 0, prntnm, initialdist = 0;

// Modify Situation nodes.

if (modifysit &&
    (grph_label[idnmbrm1][nodenm - 1].equals("MILR") ||
     grph_label[idnmbrm1][nodenm - 1].equals("PCHACT") ||
     grph_label[idnmbrm1][nodenm - 1].equals("IIWP") ||
     grph_label[idnmbrm1][nodenm - 1].equals("KENPRES") ||
     grph_label[idnmbrm1][nodenm - 1].equals("TANPRES") ||
     grph_label[idnmbrm1][nodenm - 1].equals("UGAPRES"))) {

   /* Set distributions on Situation subnetwork nodes that represent
      the group's evaluation dimensions.  Assumes INACTN is always the
      first parent.  If a node does not have Subject as a parent, do
      not match on Subject.  If you do, the "condprb" array will have
      distributions modified below that are never used in the ID's
      simulation. */

   matchsubj = false;
   for (i = 0; i < nodenghs[idnmbrm1][nodenm - 1][1]; ++i) {
      prntnm = nodenghs[idnmbrm1][nodenm - 1][i + 2];
      if (grph_label[idnmbrm1][prntnm - 1].equals("INS")) {
	 matchsubj = true;
	 break;
      }
   }
   matchinactr = false;
   for (i = 0; i < nodenghs[idnmbrm1][nodenm - 1][1]; ++i) {
      prntnm = nodenghs[idnmbrm1][nodenm - 1][i + 2];
      if (grph_label[idnmbrm1][prntnm - 1].equals("INACTR")) {
	 matchinactr = true;
	 break;
      }
   }
   
   /* Now, check if this combination of parent values is one of the
      desired in-combinations.  If so, use the associated "outcombpttrn"
      value to get the appropriate Determ-Discrete value. */

   desiredincomb = false;
   for (i = 0; i < Intridslve.nminoutpairs[idnmbrm1]; ++i) {
      matchprnts = true;

      // Check in-action match.

      if (iprntval[0] != (int) Intridslve.incomb[idnmbrm1][i][0]) {
         matchprnts = false;
      }

      // Check in-actor match.

      if (matchinactr &&
          iprntval[1] != (int) Intridslve.incomb[idnmbrm1][i][1]) {
         matchprnts = false;
      }

      // Check subject match.

      if (matchsubj &&
          iprntval[2] != (int) Intridslve.incomb[idnmbrm1][i][2]) {
         matchprnts = false;
      }

      if (matchprnts) {
         desiredincomb = true;
         outcombpttrn = outcombindx[idnmbrm1][i];
         break;
      }
   }
   if (!findmpemp && !desiredincomb) {
      return;
   }

   if (grph_label[idnmbrm1][nodenm - 1].equals("MILR") ||
       grph_label[idnmbrm1][nodenm - 1].equals("IIWP") ||
       grph_label[idnmbrm1][nodenm - 1].equals("PCHACT") ||
       grph_label[idnmbrm1][nodenm - 1].equals("PRES")) {
      evaldim = 2;

   } else {
      evaldim = 1;
   }
   
   /*
   if (0 < outcombpttrn && outcombpttrn <= 3) {
      val = distval[outcombpttrn - 1][modnode - 1];
   }
   */

// Modify Scenario nodes.

} else if (grph_label[idnmbrm1][nodenm - 1].equals("SECON") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SCMPDON") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SDON") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SLVE") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SFAM") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SPRES") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SMILR") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SIIWP") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SRRPR") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SPASPR") ||
           grph_label[idnmbrm1][nodenm - 1].equals("SWPREV")) {

   // Do not modify the distribution for complement actions.

   for (i = 0; i < Intridslve.nminoutpairs[idnmbrm1]; ++i) {
      if (Math.abs(((double) iprntval[0]) -
         complementact[idnmbrm1][i]) < 1.e-6) {
	 /*
         printf_("setdists: iprnt0= " + iprntval[0] +
                 " complmentact= " + complementact[idnmbrm1][i]);
	 */

         return;
      }
   }

   /* Return if the ACTN parent node's value for this node is not equal
      to the in-combination-group's output action. */

   if (Math.abs(condvals[outactcondnode] - iprntval[0]) > 1.e-6) {
      return;
   }

   /* Return if the in-combination-group's modal values do not equal the
      corresponding Situation State parent node's values. */

   if (!findmpemp &&
       (Math.abs(evaluation_dimension_mode[0] - iprntval[1]) > 1.e-6 ||
        Math.abs(evaluation_dimension_mode[1] - iprntval[2]) > 1.e-6)) {
      return;
   }

   // Lookup initial distribution value.

   if (grph_label[idnmbrm1][nodenm - 1].equals("SECON") ||
       grph_label[idnmbrm1][nodenm - 1].equals("SCMPDON") ||
       grph_label[idnmbrm1][nodenm - 1].equals("SDON") ||
       grph_label[idnmbrm1][nodenm - 1].equals("SLVE") ||
       grph_label[idnmbrm1][nodenm - 1].equals("SFAM")) {
      evaldim = 1;

   } else if (grph_label[idnmbrm1][nodenm - 1].equals("SPRES") ||
              grph_label[idnmbrm1][nodenm - 1].equals("SMILR") ||
              grph_label[idnmbrm1][nodenm - 1].equals("SIIWP") ||
              grph_label[idnmbrm1][nodenm - 1].equals("SRRPR") ||
              grph_label[idnmbrm1][nodenm - 1].equals("SPASPR") ||
              grph_label[idnmbrm1][nodenm - 1].equals("SWPREV")) {
      evaldim = 2;
   }

   if (!findmpemp) {
      initialdist = sc_state_dist[incombgroup - 1][evaldim - 1];

   } else {
      initialdist = 3;
   }
   
} else {
   return;
}

/* Now, get this distribution and place it in the conditional probability
   distribution array. */

if (varinfo_dist[idnmbrm1][nodenm - 1].equals("Discrete")) {
   getdistpttrn_(nmvals, initialdist, dscrtdst);

   for (i = 0; i < nmvals; ++i) {
      Readnet.condprb[idnmbrm1][nodenm - 1][i][iprntval[0] - 1]
	             [iprntval[1] - 1][iprntval[2] - 1]
		     [iprntval[3] - 1][iprntval[4] - 1]
		     [iprntval[5] - 1][1]
         = dscrtdst[i];
   }

} else {

   // Determ-Discrete node.

   Readnet.condprb[idnmbrm1][nodenm - 1][0][iprntval[0] - 1]
                  [iprntval[1] - 1][iprntval[2] - 1][iprntval[3] - 1]
                  [iprntval[4] - 1][iprntval[5] - 1][1]
      = getdetermval_(nmvals, initialdist);
}
}

// --------------------------------------------------------------------

static void getdistpttrn_(int nmvals, int pttrnnm, double pttrn[]) {

// Returns a discrete distribution of a node that has "nmvals" values.

if (nmvals > 3) {
   iderr_("distpttrn: nmvals= " + nmvals);
}

if (pttrnnm <= 0 || pttrnnm > 3) {
   iderr_("distpttrn: pttrnnm= " + pttrnnm);
}

// Load the different distributions.

if (nmvals == 2) {
   if (pttrnnm == 1) {
      pttrn[0] = .98;
      pttrn[1] = .02;

   } else if (pttrnnm == 2) {
      pttrn[0] = .5;
      pttrn[1] = .5;

   } else if (pttrnnm == 3) {
      pttrn[0] = .02;
      pttrn[1] = .98;
   }

} else if (nmvals == 3) {
   if (pttrnnm == 1) {
      pttrn[0] = .98;
      pttrn[1] = .01;
      pttrn[2] = .01;

   } else if (pttrnnm == 2) {
      pttrn[0] = .01;
      pttrn[1] = .98;
      pttrn[2] = .01;

   } else if (pttrnnm == 3) {
      pttrn[0] = .01;
      pttrn[1] = .01;
      pttrn[2] = .98;
   }
}
}

// -----------------------------------------------------------------------

static double getdetermval_(int nmdetermvals, int distpttrn) {

/* Returns a trial value of a "Determ_Discrete" node.  "nmdetermvals"
   is the number of possible values of the deterministic node. */

double retval = 0.;

if (distpttrn <= 0 || distpttrn > 3) {
   iderr_("getdetermval: distpttrn= " + distpttrn);
}

if (nmdetermvals == 3) {
   retval = (double) distpttrn;

} else if (nmdetermvals == 5) {
   if (distpttrn == 1) {
      retval = 1.;

   } else if (distpttrn == 2) {
      retval = 3.;

   } else if (distpttrn == 3) {
      retval = 5.;
   }
}

if (retval < 1.) {
   iderr_("getdetermval: nmdetermvals= " + nmdetermvals +
      " distpttrn= " + distpttrn + " retval= " + retval);
}
return retval;
}

// --------------------------------------------------------------------

static int checkmatch_(int obspairnm) {

/* Computes an out-combination and returns "1" if the  match-test is
   successsful. */

int i, retval = 0;

/* Assign the number of input nodes.  Recall that Time is always the first
   conditioning node.  First, load the conditioning node values array. */

nmnds = Intridslve.nmndes[idnmbrm1];
nmcondnds = Intridslve.nmcondndes[idnmbrm1];
Intridslve.nminputnodes = nmcondnds - 2;

for (i = 1; i < Intridslve.nminputnodes; ++i) {
   condvals[i] = Intridslve.incomb[idnmbrm1][obspairnm - 1][i - 1];
}

// Load ecosystem input node values.

Intridutils.loadeco_(0);

// Initialize random number generator

for (i = 0; i <= nmthreads; ++i) {
   Rndm.rndm1_(i, 1);
}

/* Solve the ID for its optimal out-combination under this
   in-combination. */

//Idsolve.idsolve_(1);

if (Math.abs(complementact[idnmbrm1][obspairnm - 1]) < 1.e-6) {

   // A desired action.

   Idsolve.idsolve_(1);

   /*
   printf_("checkmatch: obsact= " +
      Intridslve.outcomb[idnmbrm1][obspairnm - 1][0] + " optact= " +
      Intridslve.optactn + " obstrgt= " + 
      Intridslve.outcomb[idnmbrm1][obspairnm - 1][1] + " opttrgt= " +
      Intridslve.opttrgts);
   */

   if (Math.abs(Intridslve.outcomb[idnmbrm1][obspairnm - 1][0] -
       ((double) Intridslve.optactn)) < 1.e-6 &&
       Math.abs(Intridslve.outcomb[idnmbrm1][obspairnm - 1][1] -
       ((double) Intridslve.opttrgts)) < 1.e-6) {
      retval = 1;
   }

} else {

   // A complement action.

   if (Math.abs(Intridslve.outcomb[idnmbrm1][obspairnm - 1][0] -
       ((double) Intridslve.optactn)) < 1.e-6) {
      printf_("checkmatch: complementactnm= " +
         Intridslve.outcomb[idnmbrm1][obspairnm - 1][0] + " optact= " +
         Intridslve.optactn);
      iderr_("checkmatch: ID= " + thisidname + " obspairnm= " +
         obspairnm + " not good: complement act matched!");
   }
}

return retval;
}
}
