import java.util.*;
public class CAapps extends CA {

// Applications of Consistency Analysis (CA).

static boolean chkdobs[] = new boolean[DATSZE];

static int urn[] = new int[DATSZE];
static int index[] = new int[DATSZE];
static int datsve_vrble[][] = new int[2][DATSZE];
static int nmecoerrs[] = new int[MAXNMECO];

static double begintme = 0., cilevel = 0.;

static double ecoerr[][] = new double[MAXNMECO][MAXTIMES];
static double naive_err[][] = new double[MAXNMECO][MAXTIMES];
static double nmecoprds[][] = new double[MAXNMECO][MAXTIMES];
static double pobsmean[][] = new double[MAXNMECO][MAXTIMES];
static double actserr[] = new double[MAXTIMES];
static double nmacts[] = new double[MAXTIMES];
static double parmest[][] = new double[OPTSIZE][DATSZE];
static double tstat[] = new double[DATSZE];
static double datsve_x[] = new double[DATSZE];
static double datsve_t[] = new double[DATSZE];
static double datsve_dat[] = new double[DATSZE];

// ------------------------------------------------------------------------

public static void predskill_() {

/* Computes one-step-ahead prediction error rates.  For discretely
   valued nodes, the average match fraction is computed, and for
   continuously valued nodes, the root mean squared prediction error
   (RMSPE) is computed.  When "refitintrvl" time has passed, the
   consistent parameter vector is fitted to data up through "esttme"
   and then the model is run through "predtme" using this new
   consistent parameter vector.  The hypothesis parameter vector is
   not modified.

   The algorithm re-fits the simulator every "refitintrvl" time units.
   Typically, time is measured in years.  An ecosystem manager would
   be constrained by analyst time, computer availability, and data
   acquistion frequency.  Under these constraints, a typical re-fit
   time interval would be about every quarter (three months), i.e.,
   "refitintrvl" is set to (4 * 3) / 52.  Note that this value equals
   the default time interval used in Intridsetup.setup_(). */

boolean actionmatch, targetmatch, checkrun = false;

String obstrgtlbl, opttrgtlbl;

int i, j, k, l, istart = -1, iend = -1, obsactnnm, obstrgtnm, optactnnm,
   opttrgtnm, nmidacts, obsrawactnnm, mdltimessve, actntimessve,
   mdltimes = 0, nmca = 0, nmpreds = 0, nmacterrs = 0;

double esttme = 0., predtme, refitintrvl, lastrefit = 0., coefvar = 0.,
   zeta, epsilon, delta;

// Initialize the Consistency Analysis parameter estimation procedure.

actntimessve = nmobsactntimes;
mdltimessve = Intridslve.nmmdltimes;
refitintrvl = 12. / 52.; // was 12/52 (every 12 weeks).

// Specify those regions to run the ecosystem ID on.

for (i = 1; i <= Intridslve.nmregions; ++i) {
   Ecosyscalcs.computeregion[i - 1] = false;
   for (j = 0; j < nmcmprgns; ++j) {
      if (nodelbls[Intridslve.ecosysidnm - 1][Intridslve.ecorgnnode - 1]
                  [i].equals(regionname[j])) {
         Ecosyscalcs.computeregion[i - 1] = true;
      }
   }
}

/* Find the first and last time index values at which predictions are
   to be computed. */

//if (nmids == 1 && phenomenon_class[idnmbrm1].equals("ecosystem")) {
//   idnmbrm1 = 0;

if (nmobsactntimes > 0) {
   if (begintme <= actnshstry_obsactntime[0]) {
      istart = 1;
   }
   for (i = 0; i < nmobsactntimes - 1; ++i) {
      if (actnshstry_obsactntime[i] < begintme &&
          begintme <= actnshstry_obsactntime[i + 1]) {
         istart = i + 1;
         break;
      }
   }
   for (i = 1; i < nmobsactntimes - 1; ++i) {
      if (actnshstry_obsactntime[i] < Intridslve.tfinal &&
         Intridslve.tfinal <= actnshstry_obsactntime[i + 1]) {
         iend = i + 1;
         break;
      }
   }
   if (actnshstry_obsactntime[nmobsactntimes - 1] < Intridslve.tfinal) {
      iend = nmobsactntimes;
   }

} else {
   istart = 10;
   iend = nmecoobsttl;
}

if (istart == -1 || iend == -1) {
   iderr_("predskill: bad times");
}

// Initialize the "checked observation" array.
 
for (i = 0; i < nmecoobsttl; ++i) {
   chkdobs[i] = false;
}

fprintf_(1, "\n----------- Prediction Skill Output ------------");
fprintf_(1, " # compute regions= " + nmcmprgns + " istart= " + istart +
   " starttime= " + actnshstry_obsactntime[istart - 1] +
   "\n   iend= " + iend + " endtime= " + actnshstry_obsactntime[iend - 1] +
   " number of prediction time points= " + (iend - istart + 1) +
   "\n   nmobsactntimes= " + nmobsactntimes + " nmecoobsttl= " + nmecoobsttl);

/*
for (i = istart; i < iend; ++i) {
   printf_("i= " + i);
   for (idnmbrm1 = 0; idnmbrm1 < nmids - 1; ++idnmbrm1) {
      obsactnnm = actnshstry_obsactn[idnmbrm1][i - 1][0];
      obstrgtnm = actnshstry_obstrgts[idnmbrm1][i - 1][0];
      thisidname = idname[idnmbrm1];
      printf_("   ID= " + thisidname + " obsactnnm= " + obsactnnm +
         " obstrgtnm= " + obstrgtnm);
   }
}
printf_("predskill: region    time   eco-variable   eco-observation");
for (i = 0; i < nmecoobsttl; ++i) {
   printf_((i + 1) + "     " + dat2_x[i] + "     " + dat2_t[i] + "     " +
      dat2_vrble[0][i] + "     " + dat2_dat[i]);
}
*/

/* Loop over observation time points up through "iend" - 1.  "i" is a time
   index similar to "tindex" in "intridslve_." */

for (i = istart; i < iend; ++i) {

   /* Set end-time for parameter estimation to be this current time point,
      "i." */

   if (nmobsactntimes > 0) {
      esttme = actnshstry_obsactntime[i - 1];
      Intridslve.tfinal = esttme;
      nmobsactntimes = i;

   } else {
      esttme = dat2_t[i - 1]; // ??
      Intridslve.tfinal = esttme;
   }

   // Set the number of IntIDs time points.

   for (j = 1; j <= mdltimessve; ++j) {
      if (Intridslve.tmept[j - 1] <= esttme &&
         esttme < Intridslve.tmept[j]) {
         Intridslve.nmmdltimes = j;
	 break;
      }
   }
   
   if (nmids == 1) {
      for (j = 0; j < nmcondnds; ++j) {
         if (nodelbls[0][condnodes[0][j] - 1][0].equals("Time")) {
            condvals[j] = esttme;
	    break;
         }
      }
   }

   if ((esttme - lastrefit) > refitintrvl || i == istart) {
   
      /* Create an actions history data set using only data from the
         observed sample up through the time point, "esttme." */

      for (j = 0; j < nmobsactntimes; ++j) {
         jackknifedeleted[j] = false;
      }
      for (j = nmobsactntimes; j < actntimessve; ++j) {
         jackknifedeleted[j] = true;
      }

      /* Now, estimate parameters using this new data set.  Note that all
         three Consistency Analysis steps need to be run because this new
	 actions history data set has its own unique pattern of actions. */

      if (!checkrun) {
         ca_(true);
   
	 // If this is a client, return after first run of ca_().

         if (client) {
            return;
         }
      }
      ++nmca;
      initsubstep1 = false;
      initsubstep2 = false;
      lastrefit = esttme;
   }

   /* Now, set the prediction time to the very next time point and set
      the number of model times. */

   if (nmobsactntimes > 0) {
      predtme = actnshstry_obsactntime[i];

   } else {
      predtme = dat2_t[i];
   }
   Intridslve.tfinal = predtme;

   Intridslve.nmmdltimes = 0;
   for (j = 0; j < mdltimessve - 1; ++j) {
      if (Intridslve.tmept[j] <= predtme &&
         predtme < Intridslve.tmept[j + 1]) {
         Intridslve.nmmdltimes = j + 1;
         mdltimes = Intridslve.nmmdltimes;
	 break;
      }
   }
   if (mdltimes == 0) {
      iderr_("predskill: mdltimes=0");
   }

   printf_("\npredskill: i= " + i + " esttme= " + esttme +
      " predtme= " + predtme + " nmmdltimes= " + mdltimes +
      " calling intridslve_");

   /* Call "intridslve_" to solve the fitted IntIDs model over the
      interval (t_0, predtme).  The prediction is the model-computed
      values on group actions and ecosystem state nodes at the time point,
      "predtme." */

   if (!checkrun) {
      Intridslve.intridslve_(false, false);
   }

   if (nmobsactntimes > 0) {

      /* Compute the fraction of output action errors made by the model at
         this time point and add this value to the sum. */

      for (idnmbrm1 = 0; idnmbrm1 < nmids - 1; ++idnmbrm1) {
         thisidname = idname[idnmbrm1];
      
         // Get the observed action and target.

         obsactnnm = actnshstry_obsactn[idnmbrm1][i][0];
         obstrgtnm = actnshstry_obstrgts[idnmbrm1][i][0];

         if (obsactnnm < 1 || obstrgtnm < 1) {
	    continue;

         } else {
            printf_("predskill: i= " + i + " ID= " + thisidname +
               " obsactnnm= " + obsactnnm + " obstrgtnm= " + obstrgtnm);
         }

         obsrawactnnm = actnshstry_obsactnnmraw[idnmbrm1][i];
         nmidacts = actnshstry_mdlnmacts[idnmbrm1][mdltimes - 1];

         actionmatch = false;
         targetmatch = false;
         for (j = 0; j < nmidacts; ++j) {

            // Get the model-computed out-combination.

            optactnnm = actnshstry_mdlactn[idnmbrm1][mdltimes - 1][j];
            opttrgtnm = actnshstry_mdltrgts[idnmbrm1][mdltimes - 1][j];

            /* Skip ID-and-time point combinations in which this group either
               (a) was not observed to output an action, or
               (b) the associated ID did not generate an action. */

            if (!actnshstry_obsactor[obsrawactnnm - 1].equals(thisidname) ||
               optactnnm == 0) {
               printf_("predskill: i= " + i + " optactnnm= " + optactnnm +
                  ", skipping");
               continue;
            }

            nmacts[i - 1] += 1.0;
            printf_("predskill: i= " + i + " nmacts= " + nmacts[i - 1]);

            /* To determine if the observed and model-computed actions
               match, compare EMAT action labels.  Do this because each
               ID's output actions were replaced by EMAT codes when the
               "action_labels" array was created in "intridslve_."
               Also, count only 1 match event per model out-combination.
               Do this by only updating "nmactmatch" once per time and
               ID combination. */

            if (Intridslve.action_labels[idnmbrm1][obsactnnm - 1].equals(
               Intridslve.action_labels[idnmbrm1][optactnnm - 1])) {
               actionmatch = true;
            }

            // Check for target match.

            obstrgtlbl = Intridslve.target_labels[idnmbrm1][obstrgtnm - 1];
            opttrgtlbl = Intridslve.target_labels[idnmbrm1][opttrgtnm - 1];

            if ((obstrgtlbl.indexOf(opttrgtlbl, 0) >= 0 ||
               opttrgtlbl.indexOf(obstrgtlbl, 0) >= 0)) {
               targetmatch = true;
            }

            // Check for a match.

            if (actionmatch && targetmatch) {
               printf_("predskill: match: ID= " + thisidname + " t= " +
	          Intridslve.tmept[i] + " idactionnm= " + optactnnm);

            } else {
	       actserr[i - 1] += 1.0;
            }
	    ++nmacterrs;
         } // End of loop over multiple model out-combinations.
      } // End of loop over group IDs.
   } // End of loop over nmobsactntimes > 0 condition.
 
   ++nmpreds;

   /* Compute the squared error on the ecosystem nodes made by the model
      predictions on observations one time step ahead of the most recent
      observation used in the CA.  Add this squared error to the sum.
      First, find the single multivariate observation for this region
      (identified by (int) dat2_x) and at this time, "predtme." */

   for (j = 0; j < nmecoobsttl; ++j) {

      /* Skip if this observation has already been compared to at this
         time point.  This check is needed because a window is used to
	 decide if an observation is close enough in time to be checked.
      */

      if (chkdobs[j]) {
         continue;
      }

      /* Find region number and check if this observation belongs to
         that region.  If not, skip to the next observation. */

      for (l = 1; l <= nodenghs[idnmbrm1][Intridslve.ecorgnnode - 1][0];
         ++l) {
         if (Math.abs(dat2_x[j] - (double) l) < 1.e-6) {
	    break;
	 }
      }
      if (!Ecosyscalcs.computeregion[l - 1]) {
         printf_("predskill: no computeregion, skipping");
         continue;
      }
      
      // Skip if wrong time.

      if (nmobsactntimes > 0) {
 
         /* When group action are observed, their time points are
            used used to set "esttme" and "predtme." In this case,
            ecosystem observations may not coincide with these
            time points.  Therefore, use an observation if it is within 0.2
            years of "predtme."  This rule assumes that time is in units of
            years.  This rule is used to decide if this run should be
            compared to ecosystem observations. */

         if (dat2_t[j] <= predtme - .2 || predtme + .2 <= dat2_t[j]) {
            continue;
         }

      } else {
         if (Math.abs(dat2_t[j] - predtme) > 1.e-6) {
            continue;
         }
      }

      /* Find the ecosystem ID node number of the observed ecosystem
         variable. */

      for (k = 0; k < nmobsnds; ++k) {
         if (dat2_vrble[0][j] == obsndnm[k]) {
	    break;
	 }
      }

      // Compute the squared error of this eco-variable prediction.

      printf_("\npredskill: Region= " + l + " ecoobsj= " + j + " obst= " +
         dat2_t[j] + " obsnode= " + (k + 1) +
	 "\n   ecoobsval= " + dat2_dat[j] + " mdlmean= " +
	 Ecosyscalcs.mean[l - 1][k]);

      ecoerr[k][i - 1] = dat2_dat[j] - Ecosyscalcs.mean[l - 1][k];
      ecoerr[k][i - 1] *= ecoerr[k][i - 1];

      if (j > 0) {
         naive_err[k][i - 1] = dat2_dat[j] - dat2_dat[j - 1];
         naive_err[k][i - 1] *= naive_err[k][i - 1];

      } else {
         printf_("predskill: i= " + i + " j= " + j +
            "cannot compute naive_err");
      }

      pobsmean[k][i - 1] += dat2_dat[j];
      nmecoprds[k][i - 1] += 1.;
      ++nmecoerrs[k];

      chkdobs[j] = true;
   }

   // Compute the predicted actions error rate for this observed time point.

   if (nmacts[i - 1] > 0) {
      actserr[i - 1] /= nmacts[i - 1];
      fprintf_(1, "   time= " + esttme + " nmacts= " + nmacts[i - 1] +
         " actserr= " + actserr[i - 1]);

   } else {
      actserr[i - 1] = 0.;
      fprintf_(1, "   time= " + esttme + " nmacts= " + nmacts[i - 1]);
   }

   /* Find the coefficient of variation at this prediction time of the
      model's prediction errors for each ecosystem node. */

   for (j = 0; j < nmobsnds; ++j) {
      if (nmecoprds[j][i - 1] > 0.) {
         coefvar = Math.sqrt(ecoerr[j][i - 1] / nmecoprds[j][i - 1]);
         pobsmean[j][i - 1] /= nmecoprds[j][i - 1];

	 if (pobsmean[j][i - 1] > 0.) {
            coefvar /= pobsmean[j][i - 1];

	 } else {
            coefvar = 0.;
	 }

         fprintf_(1, "   time= " + i + " econode= " +
            nodelbls[nmids - 1][obsndnm[j] - 1][0] +
	    "\n   coefficient of variation= " + coefvar +
	    " # of ecosystem errors= " + nmecoprds[j][i - 1]);

      } else {
         ecoerr[j][i - 1] = 0.;
         pobsmean[j][i - 1] = 0.; 

         fprintf_(1, "-------- No ecosystem predictions! -----------");
      }
   }
   //iderr_("in predskill");
} // End of one-step-ahead predictions time loop.
printf_("predskill: nmca= " + nmca + " nmpreds= " + nmpreds);

if (nmobsactntimes > 0) {

   // Compute average predicted actions error rate.

   zeta = 0.;
   for (i = istart; i < iend; ++i) {
      zeta += actserr[i - 1];
   }
   zeta /= ((double) nmacterrs);
   fprintf_(1, "# of predictions= " + nmpreds + " # of action errors= " +
      nmacterrs +
      "\n   Average predicted action error rate, zeta= " + zeta);
}

/* Compute both the model's RMSPE and the naive forecast's RMSPE for
   each ecosystem node. */

for (j = 0; j < nmobsnds; ++j) {
   epsilon = 0.;
   delta = 0.;
   for (i = istart; i < iend; ++i) {
      epsilon += ecoerr[j][i - 1];
      delta += naive_err[j][i - 1];
   }
   if (nmecoerrs[j] > 0) {
      epsilon /= ((double) nmecoerrs[j]);
      epsilon = Math.sqrt(epsilon);
      
      delta /= ((double) nmecoerrs[j]);
      delta = Math.sqrt(delta);
   }

   fprintf_(1, "Ecosystem node= " + (j + 1) + " # of ecosystem errors= " +
      nmecoerrs[j] +
      "\nRMSPE (epsilon)= " + epsilon + " RMSPE (delta)= " + delta);
}
}

// --------------------------------------------------------------------

public static int mchyptst_() {

/* Performs a Monte Carlo hypothesis test.  Delete-d subsamples are
   drawn, and the test statistic for each of subsample is
   computed under the full model.  See Hall and Titterington (1989).
   
   The test statistic could be the agreement with the sample, g_S.  The
   reduced model is by definition different than the full model so
   there would be no point in including g_H in the test statistic's
   definition.  Specifically, the test statistic would be
   T = hat{delta} - delta where delta = g_S^(R) - g_S^{(F)},
   g_S = g_S^(Grp) + g_S^(Eco), (R) is the reduced model, and
   (F) is the full model.  This test statistic would be sensitive to
   changes in a group's behavior that in-turn, affect the
   behavior of other groups and/or the ecosystem's response.

   But for now, test statistics as described in Chapter 12 and
   Chapter 12's Exercise Solutions are used.  These are:

   For groups: errormeas = AER    which is invoked when "measnmbr"= 0 

   For the ecosystem: errormeas = RMSPE_i   which is invoked when
      "measnmbr" to i (the i^th output variable)
 
   Be careful to exclude from the "nodes_to_estimate" list any node
   whose parameters are fixed values under H_0.

   On first call to this routine, compute the test statistic over all
   "nmecoobsttl" observations and under the full model.  The full model
   is in the hypothesis parameter file, and the reduced is in the
   initial parameter file.  This method assumes that both the full and
   reduced models have been previously fitted to the
   political-ecological data set.  Therefore, "evaluate" runs are made
   to compute the error measure under each of the full and reduced
   models without any parameter fitting being done.

   An evaluation of the test statistic is accomplished in 4 steps:
   1. Evaluate the error measure on the observed sample using the
      previously fitted, full model.
   2. Evaluate the error measure on the observed sample using the
      previously fitted, reduced model.
   3. Compute the observed test statistic value,

           "tstatobs = errormeasreduc - errormeasfull"

   This test statistic is deltahat - delta where
   delta = errormeasreduc - errormeasfull.  Under H_0, delta = 0.
   Hall and Titterington (1989) recommend computing the test statistic
   under H_0 only once using the observed sample.  Following this
   advice then, the observed value of the test statistic is:

                    T = deltahat - 0

   Note that "tstatobs" is also an estimate of delta that uses the
   observed sample.
*/

int i, j, subsmpl = 0, njack = 0, node, rndint, measnmbr = 0, d = 0, r = 0;

double errormeasreduc = 0., ri, rn, pvalue, tstatobs = 0., tstmin, tstmax,
   errormeasfull = 0.;

fprintf_(1, "\n ********** Monte Carlo Hypothesis Test *********** \n");

/*
dat2_z[0] = 2;
dat2_z[1] = 4;
dat2_z[2] = 1;
dat2_z[3] = 3;
dat2_z[4] = 5;
dat2_z[5] = 4;
dat2_z[6] = 3;
dat2_z[7] = 2;
nmecoobsttl = 8;
for (i = 0; i < nmecoobsttl; ++i) {
   dat2_x[i] = dat2_z[i];
}
*/

/* Read the full model into the initial parameter values position
   in "condprb." */

for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
   nmnds = Intridslve.nmndes[idnmbrm1];
   Readnet.readnet_(dstfle[idnmbrm1][0], Writenet.flenm, nmnds, 2);
}

// Compute the error measure value.

if (nmids > 1) {
   Fitactions.actnsagree_(true);
}
errormeasfull = errorcalc_(nmecoobsttl, measnmbr);

fprintf_(1, "\n Full model error estimate, errormeasfull= " +
   errormeasfull);

/* Compute the test statistic over the observed sample under the
   reduced model defined by H_0.  Do this by first reading the full
   model into the initial parameter values position in "condprb." */

for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
   nmnds = Intridslve.nmndes[idnmbrm1];
   Readnet.readnet_(dstfle[idnmbrm1][1], Writenet.flenm, nmnds, 2);
}

// Compute the error measure value.

if (nmids > 1) {
   Fitactions.actnsagree_(true);
}
errormeasreduc = errorcalc_(nmecoobsttl, measnmbr);

fprintf_(1, "\n Reduced model error estimate, errormeasreduc= " +
   errormeasreduc);

tstatobs = errormeasreduc - errormeasfull;

// Set the delete-d subsample size "r."

if (nmecoobsttl > 10) {
   r = (int) Math.pow(((double) nmecoobsttl), .9);

} else {
   r = nmecoobsttl - 1;
}

if (r < 2) {
   iderr_("mchyptst: r= " + r);
}

// Compute the number of jackknife samples.

d = nmecoobsttl - r;
if (d == 1) {
   njack = nmecoobsttl;

} else {
   njack = 100;
}

fprintf_(1, "\n nmecoobsttl= " + nmecoobsttl + " r= " + r + " njack= " +
   njack);
printf_("mchyptst: nmecoobsttl= " + nmecoobsttl + " r= " + r + " njack= " +
   njack);

// Save the observed sample.

for (i = 0; i < nmecoobsttl; ++i) {
   datsve_x[i] = dat2_x[i];
   datsve_t[i] = dat2_t[i];
   datsve_vrble[0][i] = dat2_vrble[0][i];
   datsve_dat[i] = dat2_dat[i];
}

// Get the number of the node that is to be fitted.

node = Getmodlutils.getndnm_(Psens.ndenames[0][0]);

/* Now, draw a delete-d subsample of size "r" (random sampling
   without replacement).  Compute the test statistic of this delete-d
   subsample using the full model, and store its.  Repeat this
   procedure "njack" times. */

fprintf_(1, "\n*** Delete-d subsample test statistic Results ***" +
   "\n Subsample_Number  Error_Measure_Reduced  Error_Measure_Full  T\n");

for (subsmpl = 1; subsmpl <= njack; ++subsmpl) {
   
   // Draw a delete-d subsample.

   subsample_(nmecoobsttl, r, subsmpl);

   // Fit the model to this subsample.

   for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
      nmnds = Intridslve.nmndes[idnmbrm1];
      Readnet.readnet_(dstfle[idnmbrm1][0], Writenet.flenm, nmnds, 2);
   }

   ca_(true);

   /* Compute the full and reduced error measures using this delete-d
      subsample.  Do this by first re-fitting each model to this
      subsample, and then computing the error measure. */

   if (nmids > 1) {
      Fitactions.actnsagree_(true);
   }
   errormeasfull = errorcalc_(r, measnmbr);

   for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
      nmnds = Intridslve.nmndes[idnmbrm1];
      Readnet.readnet_(dstfle[idnmbrm1][1], Writenet.flenm, nmnds, 2);
   }

   ca_(false);
   
   if (nmids > 1) {
      Fitactions.actnsagree_(true);
   }
   errormeasreduc = errorcalc_(r, measnmbr);

   /* Compute the test statistic value without assuming that H_0 is
      true.  In this case, the test statistic is:

         "tstat = deltahat - delta"
    
      where "tstatobs" is used as an observed-sample-based estimate
      of the true value of delta as recommended by Hall and
      Titterington (1989). */

   tstat[subsmpl - 1] = (errormeasreduc - errormeasfull) - tstatobs;
   fprintf_(1, "         " + subsmpl + "              " +
      fdble_(errormeasreduc, 5, 3) + "                " +
      fdble_(errormeasfull, 5, 3) + "         " +
      fdble_(tstat[i], 5, 3));
}

/* If the reduced model is significantly different than the full
   model, then the test statistic under H_0 using the full sample
   will be in the upper tail of the test statistic's empirical
   distribution found from the histogram of these "m" delete-d
   subsamples.  Therefore, find the p-value of the test by finding
   the percentage of delete-d subsample test statistic values
   that are larger than the observed sample test statistic's value.
   Also compute some summary statistics. */

pvalue = 0.;
tstmin = tstat[0];
tstmax = tstmin;
for (i = 0; i < njack; ++i) {
   if (tstat[i] > tstatobs) {
      pvalue += 1.;
   }

   if (tstat[i] < tstmin) {
      tstmin = tstat[i];
   }

   if (tstmax < tstat[i]) {
      tstmax = tstat[i];
   }
}
fprintf_(1, "Monte Carlo Test Results\n\n" +
   "   tstmin= " + fdble_(tstmin, 5, 3) + " tstatobs= " +
   fdble_(tstatobs, 5, 3) + " tstmax= " + fdble_(tstmax, 5, 3) +
   " p-value= " + (pvalue / ((double) njack)));
return 0;
}

// ---------------------------------------------------------------------

static void jackknifecis_() {

// Compute delete-d jackknife-based parameter confidence intervals.

int i, j, subsmpl = 0, njack = 0, node, nfrac, r, d = 0, nmobsttl,
   actntimessve, mdltimessve;

double dumval, minlength, cilength, cilow = 0., cihigh = 0.;

// Initialize the Consistency Analysis parameter estimation procedure.

actntimessve = nmobsactntimes;
mdltimessve = Intridslve.nmmdltimes;

// Save the observed sample.

for (i = 0; i < nmecoobsttl; ++i) {
   datsve_x[i] = dat2_x[i];
   datsve_t[i] = dat2_t[i];
   datsve_vrble[0][i] = dat2_vrble[0][i];
   datsve_dat[i] = dat2_dat[i];
}

// Specify those regions to run the ecosystem ID on.

for (i = 1; i <= Intridslve.nmregions; ++i) {
   Ecosyscalcs.computeregion[i - 1] = false;
   for (j = 0; j < nmcmprgns; ++j) {
      if (nodelbls[Intridslve.ecosysidnm - 1][Intridslve.ecorgnnode - 1]
                  [i].equals(regionname[j])) {
         Ecosyscalcs.computeregion[i - 1] = true;
      }
   }
}

// If there are no observed actions, do not run CA steps 1 and 2.

if (nmobsactntimes == 0) {
   initsubstep1 = false;
   initsubstep2 = false;
}

// Initialize jackknife subsampling random number generator.

Rndm.rndm1_(nmthreads + 1, 2);

/* Get the number of the node holding those parameters for whom
   confidence intervals will be computed. */

node = Getmodlutils.getndnm_(Psens.ndenames[0][0]);

// Set the size of "d," and then the size of the delete-d subsample.
      
if (Beliefs.issms) {
   nmecoobsttl = SMScalcs.nmanimals;
   nmobsttl = nmecoobsttl;
   r = nmobsttl - 1;
   SMScalcs.nmanimals = r;

} else if (!fitactions) {
   nmobsttl = nmecoobsttl;
   r = nmobsttl - 1;

} else {
   nmobsttl = nmobsactns;
   r = (int) Math.pow(((double) nmobsttl), .97);
}
d = nmobsttl - r;

/* Compute the number of needed jackknife samples.  For "d" > 1, the
   heuristic is to have at least one estimated value on each end of the
   histogram that is just outside the desired confidence interval. */

if (d == 1) {
   njack = nmobsttl;

} else {
   njack = 1 + ((int) (2. / (1. - cilevel)));
}

printf_("jackknifecis: nmobsttl= " + nmobsttl + " r= " + r +
   " njack= " + njack);

// Subsampling loop.

for (subsmpl = 1; subsmpl <= njack; ++subsmpl) {
   
   fprintf_(1, "\n------------ Subsample " + subsmpl + " --------------");
   printf_("\njackknifecis: ------- Subsample " + subsmpl + " ---------");

   // Draw a delete-d subsample.

   subsample_(nmobsttl, r, subsmpl);

   /* Now, fit the model to this subsample.  Note that when actions have
      been observed, all three steps of Consistency Analysis need to be
      run because this subsample may lack some unique set of actions that
      are in the sample. */

   if (nmobsactntimes > 0) {
      initsubstep1 = true;
      initsubstep2 = true;
   }

   ca_(true);

   // If this is a client, return after first run of ca_().

   if (client) {
      return;
   }

   // Store the parameter estimate values computed on this subsample.

   storeparms_(subsmpl);
}

// Compute fraction of subsamples to use for finding confidence intervals.

nfrac = (int) Math.round(cilevel * ((double) njack));
if (nfrac <= 0 || nfrac >= njack) {
   iderr_("jackknifecis: nfrac= " + nfrac + " njack= " + njack);
}

fprintf_(1, "\n--- Delete-d Jackknife Parameter Confidence Intervals ---" +
   "\nParameter  Lower Boundary    Upper Boundary");
for (i = 0; i < n; ++i) {

   // First, sort these parameter estimate values.

   for (j = 0; j < njack; ++j) {
      index[j] = j;
   }
   Idsort.idsort_(parmest[i], index, 1, njack);

   // Find shortest interval.
   
   minlength = 1.e6;
   cilow = parmest[i][0];
   cihigh = parmest[i][njack - 1];
   for (j = 0; j < njack - nfrac; ++j) {
      cilength = parmest[i][j + nfrac] - parmest[i][j];
      if (cilength < minlength) {
         minlength = cilength;
         cilow = parmest[i][j];
         cihigh = parmest[i][j + nfrac];
      }
   }
   fprintf_(1, "   " + (i + 1) + "      " + fdble_(cilow, 5, 3) +
      "      " + fdble_(cihigh, 5, 3));
}
}

// ---------------------------------------------------------------------

static double errorcalc_(int n, int measnmbr) {

// Computes error measures for Monte Carlo hypothesis tests.

int i;

double error = 0.;

if (measnmbr == 0) {
   for (i = 0; i < n; ++i) {
      error += dat2_x[i];
   }
   error /= ((double) n);

} else {
   for (i = 0; i < Ecosyscalcs.nmobsrvd; ++i) {
      error += Ecosyscalcs.resids[i][measnmbr - 1];
   }
}
return error;
}

// ---------------------------------------------------------------------

public static void subsample_(int nmobs, int r, int subsmpl) {

/* Draws a delete-d subsample of size "r" from an observed sample of
   size "nmobs."  If "d" is 1 (leave-one-out), take all but the
   "subsmpl"^th observation. */

int i, j = 0, k, rndint, d;

double rj, rn, rndmval;

// Initialize the deletion size, and the jackknife deletion array.

d = nmobs - r;

// Initially, delete all observations from the subsample.

for (i = 0; i < nmobs; ++i) {
   jackknifedeleted[i] = true;
}

// First, fill the urn with the integers 1 to "nmobs."

for (i = 1; i <= nmobs; ++i) {
   urn[i - 1] = i;
}

for (i = 0; i < r; ++i) {
   if (d > 1) {

      /* rn = number of integers (between 1 and nmobs) that are left
         in the urn. */

      rn = (double) (nmobs - i);

      /* Get j, a randomly chosen integer between 1 and rn. */

      rndmval = Rndm.rndm1_(nmthreads + 1, 0);
      rj = rn * rndmval;
      j = ((int) rj);
      if (rj - ((double) j) > .5) {
         ++j;
      }
      if (j == 0) {
         j = 1;
      }
      if (j > nmobs - i) {
         iderr_("subsample: j= " + j + " but nmobs= " + nmobs);
      }

      // Draw the j^th integer from the urn.

      rndint = urn[j - 1];

   } else {

      /* Leave-one-out subsampling.  Do this by skipping over the
         "subsmpl"^th observation. */

      rndint = i + 1;
      if (rndint >= subsmpl) {
         ++rndint;
      }
   }

   // Extract the "rndint" observation from the observed sample.

   if (Beliefs.issms) {
      SMScalcs.subsnmsteps[i] = SMScalcs.nmobssteps[rndint - 1];
      for (j = 0; j < SMScalcs.subsnmsteps[i]; ++j) {
         SMScalcs.subspath[i][j][0] = SMScalcs.obspath[rndint - 1][j][0];
         SMScalcs.subspath[i][j][1] = SMScalcs.obspath[rndint - 1][j][1];
      }

   } else if (!fitactions) {
      dat2_x[i] = datsve_x[rndint - 1];
      dat2_t[i] = datsve_t[rndint - 1];
      dat2_dat[i] = datsve_dat[rndint - 1];
      dat2_vrble[0][i] = datsve_vrble[0][rndint - 1];

   } else {

      // Include this observation in the subsample.

      jackknifedeleted[rndint - 1] = false;
   }

   if (d > 1) {

      /* Rewrite the contents of the urn so that the j^th integer is
         removed. */

      for (k = j; k < nmobs - i; ++k) {
         urn[k - 1] = urn[k];
      }
   }
}
}

// --------------------------------------------------------------------

public static void storeparms_(int subsmpl) {

// Stores parameter estimate values computed from the "subsmpl" subsample.

int i, j;

for (i = 0; i < n; ++i) {
   parmest[i][subsmpl - 1] = x_ca[i];
}

// Print all estimates to the report file.

fprintf_(1, "\n Jackknife Parameter Estimates");
for (i = 0; i < n; ++i) {
   strng = " ";
   for (j = 0; j < subsmpl; ++j) {
      strng += " " + fdble_(parmest[i][j], 5, 3);
   }
   fprintf_(1, strng);
}
}
}
