import java.util.*;

// -----------------------------------------------------------------

public class CA extends Id {

static boolean fitactions = true, initsubstep1 = true, initsubstep2 = true,
   camax = true, computeactionsagreement = true;


static boolean jackknifedeleted[] = new boolean[NMACTNS];

static String bestpairsfle = "bestiopairs.tmp",
   actnshistfle = "dumactnshistfle.ahs", strng1, strng2, runtype = "fit_model";

static String obsnd[] = new String[MAXNMECO];

static int n, m, nmobsactns = 0, nmobsactntimes = 0, nmobsnds = 0,
   nmgh_eco = 0, caftest = 0;

static long cabegintime = 0, casoltime = 0;

static int obsval[] = new int[TNMNDS];
static int nmdat[] = new int[TNMNDS];
static int index[] = new int[DATSZE];
static int idumvec[] = new int[DATSZE];
static int obsndnm[] = new int[MAXNMECO];

static double ch = 0., gs = 0., gh = 0., gh_groups = 0., gs_groups = 0.,
   gs_eco = 0., gh_eco = 0., gca = 0., ghdivisor = 0., initialgs = 0.,
   initialgsgroups = 0., initialgh = 0., initialgca = 0., finalgca = 0.,
   relgs, relgh, penaltythres = 0., ematthrshld = 0.9;

static double trim[] = new double[TNMNDS];
static double mean[] = new double[TNMNDS];
static double stdvec[] = new double[TNMNDS];
static double maxvec[] = new double[TNMNDS];
static double quantcalc[] = new double[SIMSZE];
static double x_hyp[] = new double[OPTSIZE];
static double x_ca[] = new double[OPTSIZE];
static double g[] = new double[OPTSIZE];
static double h[] = new double[OPTSIZE];
static double margsimdat[][] = new double[SIMSZE][TNMNDS];
static double gcaval[][] = new double[SIMSZE][1];
static double gh_group[] = new double[TNMIDS];
static double nm_grp_condsets[] = new double[TNMIDS + 1];
static double nmmatch[] = new double[TNMIDS + 1];
static double nmactmatch[] = new double[TNMIDS + 1];
static double nmtrgtmatch[] = new double[TNMIDS + 1];
static double matchfrac[] = new double[TNMIDS + 1];
static double actmatchfrac[] = new double[TNMIDS + 1];
static double trgtmatchfrac[] = new double[TNMIDS + 1];
static double dumvecx[] = new double[DATSZE];
static double dumvecdat[] = new double[DATSZE];

/* Structure to hold the observed actions history data.  Dimensions of
   "obsactn," "obsnmtrgts," and "obstrgts" are:
   action-author's_ID_number, time.

   Dimensions of "obsecoave," and "nmobscountry" are:
   country, time, variable. */

static String actnshstry_obsactor[] = new String[NMACTNS];
static String actnshstry_obsactnstrng[] = new String[NMACTNS];
static String actnshstry_obstrgtsstrng[] = new String[NMACTNS];

static String actnshstry_obsactloc[][][] =
   new String[TNMIDS][MAXTIMES][NMPOSTACTS];
static String actnshstry_obsactntext[][][] =
   new String[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_obsactnnmraw[][] = new int[TNMIDS][MAXTIMES];
static int actnshstry_obsactn[][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_obsactornm[] = new int[MAXTIMES];

static boolean actnshstry_matchedoutcomb[][][] =
   new boolean[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_matchedactn[][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_obsnmtrgts[][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_obstrgts[][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_nmobscountry[][][] =
   new int[TNMVALS][MAXTIMES][TNMNDS];

static int actnshstry_nmobsactlocs[][] =
   new int[TNMIDS][MAXTIMES];

static int actnshstry_obsactnraw[] = new int[NMACTNS];
static int actnshstry_obstrgtnm[] = new int[NMACTNS];

static double actnshstry_obsactntime[] = new double[MAXTIMES];
static double actnshstry_obsactnnmtime[] = new double[NMACTNS];
static double actnshstry_obsecotime[][][] = 
   new double[TNMVALS][MAXTIMES][MAXNMECO];

static double actnshstry_obsecoave[][][] =
   new double[TNMVALS][MAXTIMES][MAXNMECO];

/* Structure to hold the model-computed actions history data.
   Dimensions of "mdlecoval" are region, time, variable.
   Dimensions of "mdlecoave" is the same as "obsecoave." */

static int actnshstry_mdlnmacts[][] = new int[TNMIDS][MAXTIMES];

static String actnshstry_mdlinactn[][] =
   new String[TNMIDS][NMPOSTACTS];
static String actnshstry_mdlinactr[][] =
   new String[TNMIDS][NMPOSTACTS];

static int actnshstry_mdlactn[][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_mdltrgts[][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_mdlnmtrgts[][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS];

static int actnshstry_mdlinputval[][][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS][3];

static double optutil[][][] = new double[TNMIDS][MAXTIMES][NMPOSTACTS];
static double actnshstry_mdlecoval[][][] =
   new double[TNMVALS][MAXTIMES][MAXNMECO];

static double actnshstry_mdlecoave[][][] =
   new double[TNMVALS][MAXTIMES][MAXNMECO];

// Target number array for "pltacts_."

static int plttrgts[][][][] =
   new int[TNMIDS][MAXTIMES][NMPOSTACTS][MAXNMSUBJ];

// -------------------------------------------------------------------------

public static void ca_(boolean wflag) {

/* Performs Consistency Analysis.  This routine assumes the CA setup
   routine, "caSetup" has been executed.
   
   "gs" measures the agreement between the empirical distribution and
   the consistent distribution.

   "gh" measures the agreement between the hypothesis distribution and
   the consistent distribution.  Increasing values of gs, gh indicate
   increasing agreement.
*/

int i, j, k, l, tindex = 0, retval;

double relchnges, relchngeh, action_time, diff = 0., lngth = 0., reldif,
   divisor, fracdiff, dumval;

fprintf_(1, "\n   Optimization Problem Degrees of Freedom (n)= " + n +
   "\n      Number of implicit constraints= " + m);


/* Pre-processing steps to maximize the number of matches to to
   observed actions.  Can these two steps be iterated to improve the
   match rate? */

if (initsubstep1) {
   if (fitactions) {

      /* For an actions history data set, run a pre-processor that matches
         as many actions as possible. */

      Ecosyscalcs.skipeco = true;
      Intridslve.ignorecontinvars = true;
      Fitactions.fitactions_();
   }
   printf_("ca: Initialize Substep 1 completed");
}
   
if (initsubstep2) {
   if (fitactions) {

      /* Use a truth table to assign parameter values so that each ID
         produces the in-out pairs contained in "bestiopairs.tmp" or
         "rmspeiopairs.tmp."  This feasible solution is used as the
         starting solution in the optimization step of CA, below. */
	 
      CAinitialize.cainitialize_("ca");

      /* Reload the solution vector with the distribution found by
         cainitialize_(). */

      for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
         for (j = 0; j < Psens.nmsensids; ++j) {
            if (nmids > 1 && !idname[idnmbrm1].equals(Psens.id[j])) {
               continue;
            }
            thisidname = idname[idnmbrm1];
            nmnds = Intridslve.nmndes[idnmbrm1];
            Pxp.pxp_(0, x_ca, g, h, 2, Psens.beginpar[j],
               Psens.begincnstrnt[j], false);
         }
      }

      // Compute match fractions.

      for (i = 0; i < nmids - 1; ++i) {
        Intridslve.nminoutpairs[i] = 0;
      }
      fprintf_(1,"\n Model-Generated Actions History Match Fraction");
      Fitactions.actnsagree_(true);
   }
   printf_("ca: Initialize Substep 2 completed");
} // End of "initsubstep2."

if (!camax) {
   printf_("ca: camax is false, returning");

   return;
}
// Compute match fractions with ecosystem calculations turned on.

for (i = 0; i < nmids - 1; ++i) {
  Intridslve.nminoutpairs[i] = 0;
}
Ecosyscalcs.skipeco = false;

printf_("\n Model-Generated Actions History Match Fraction, Ecosystem is On");

if (caftest == 0) {
   Fitactions.actnsagree_(true);
}

if (nmids == 1 && !cacalc) {
   Beliefs.belpflag = true;
}

// Compute initial solution.

for (i = 0; i < nmids - 1; ++i) {
  Intridslve.nminoutpairs[i] = 0;
}

cabegintime = System.currentTimeMillis();
initialgca = CAutils.caf_(x_ca, true);
casoltime = System.currentTimeMillis();
casoltime = (casoltime - cabegintime) / 1000;

printf_("ca: with ecosystem turned on, casoltime= " + casoltime + " seconds.");

initialgh = gh;
initialgs = gs;
initialgsgroups = gs_groups;
printf_("ca: initialgsgroups= " + initialgsgroups);

ghdivisor = Math.abs(gh);
if (ghdivisor < 1.e-6) {
   ghdivisor = 1.;
}

/* For the Ecological Modelling article, set the initial value of the
   intercalving interval to 2.5 years.
x_ca[0] = 2.5; */

// Turn off ecosystem calculations and then find the new evaluation time.

Ecosyscalcs.skipeco = true;
cabegintime = System.currentTimeMillis();
initialgca = CAutils.caf_(x_ca, true);
casoltime = System.currentTimeMillis();
casoltime = (casoltime - cabegintime) / 1000;
printf_("ca: with ecosystem turned off, casoltime= " + casoltime + " seconds.");

fprintf_(1, "\n-------- Initial Agreement Function Values --------");

if (nmids > 1) {
   fprintf_(1, "   gs_groups= " + gs_groups + " gs_eco= " + gs_eco +
      "\n   gh_groups= " + gh_groups + " gh_eco= " + gh_eco +
      "\n   ch= " + ch + " initial match fraction= " +
      fdble_(matchfrac[0], 4, 3));
}
fprintf_(1, "   initialgs= " + initialgs + " gh= " + gh + " gca= " +
   initialgca +
   "\n   ghdivisor= " + ghdivisor);

if (Ecosyscalcs.nmobsrvd > 0 && !Beliefs.issms) {
   fprintf_(1, "\n----- Initial Residuals of Ecosystem Variables -----" +
      "\nRegion Time Var.   Obsrvd   Model   resid");
   for (i = 0; i < Ecosyscalcs.nmobsrvd; ++i) {
      for (j = 0; j < nmobsnds; ++j) {
         if (Ecosyscalcs.obsvar[i][j] > 0) {
            fprintf_(1, Ecosyscalcs.residregion[i] + "    " +
               Ecosyscalcs.residtime[i] + "  " +
	       Ecosyscalcs.obsvar[i][j] + "  " +
               Ecosyscalcs.obsrvdval[i][j] + "  " +
               Ecosyscalcs.modelval[i][j] + "  " +
	       Ecosyscalcs.resids[i][j]);
         }
      }
   }
}

if (runtype.equals("plots_only")) {

   /* Print all parameters and indicate those that have changed from their
      hypothesis to initial value by more than 1%. */

   fprintf_(1, "Note: * indicates the parameter has changed by more than 1%" +
   "\nParameter#  ID          Node          Hypothesis_Value   Initial_Value");

   for (i = 0; i < n; ++i) {

      // Compute a positive divisor.

      divisor = Math.abs(x_hyp[i]);
      if (divisor < 1.e-6) {
         divisor = 1.;
      }

      fracdiff = Math.abs(x_hyp[i] - x_ca[i]) / divisor;
      if (fracdiff > 1.e-2) {
         strng = "*";

      } else {
         strng = " ";
      }
      fprintf_(1, "  " + (i + 1) + "     " + idname[Pxp.idownerm1[i]] +
         "  " + Pxp.nodename[i] + "  " + fdble_(x_hyp[i], 6, 3) +
         "  " + fdble_(x_ca[i], 6, 3) + " " + strng);
   }
   printf_("ca: end of plots_only run");

   return;
}

// Now perform the CA optimization.

fprintf_(1, "\n ----------- Beginning CA Optimization ----------\n");
printf_("\n ----------- Beginning CA Optimization ----------");

// Initialization for CA test functions.

if (caftest == 1) {

   /* The test function is f = \prod_0^(n-1) x(i)**2.  See
      Optimiz.objf_(). */

   n = 27;
   m = 0;
   for (i = 0; i < n; ++i) {
      //x_ca[i] =  ((double) i) + 1.;
      x_ca[i] =  .9;
      g[i] = .0001;
      h[i] = .9999;
   }

} else if (caftest == 2) {
   
   /* The test function is Bukin's F4 benchmark function.  See
      Optimiz.objf_().  Hooke is successful when started at (-6, 2). */

   n = 2;
   m = 0;
   g[0] = -15.;
   h[0] = -5.;
   g[1] = -3.;
   h[1] = 3.;
   x_ca[0] = -6.;
   x_ca[1] = 2.;

} else if (caftest == 3) {
   
   /* The test function is Bukin's F6 benchmark function.  See
      Optimiz.objf_().  Starting at (-9, 1.5) allows Hooke to be
      successful, but starting at (-6, 2) yields a poor solution. */

   n = 2;
   m = 0;
   g[0] = -15.;
   h[0] = -5.;
   g[1] = -3.;
   h[1] = 3.;
   x_ca[0] = -6.;
   x_ca[1] = 2.0;
}

/* It is tempting to skip a parameter whose hypothesis and initial values are
   the same -- since, if the initial value is already at its hypothesis value, what
   improvement can be made?  But this reasoning ignores the need to fit a model to
   observations that, in the course of doing so, may move the parameter away from a
   non-reality hypothesis value. */

computeactionsagreement = true;
printf_("ca: beginning optimization: computeactionsagreement= " +
   computeactionsagreement + " skipeco= " + Ecosyscalcs.skipeco );

Optimiz.optimiz_(n, m, x_ca, g, h, 3);
computeactionsagreement = true;

// If this is a client version of "id," return.

if (client) {
   printf_("ca: client initialization completed");

   return;
}

// CA test function completion.

if (caftest > 0) {
   iderr_("ca: caftest complete");
}

/* Notes:
   Compute the objective function under the negative Hellinger distance definition of gh.
   Because the objective function's evaluation time under the Hellinger definition of gh
   can be five times longer than under the Euclidean distance definition, is is left to
   future work to take the converged solution under negative Euclideant distance and use
   it as the starting solution in a second CA that uses the negative Hellinger distance
   definition of gh.

   Also, through separate runs, increase nmloops until an ID stops changing its
   out-actions.  At this value, there is no practical reason to increase it
   more when computing the Hellinger gh value since the simulated stochasticity
   is high enough to produce the only thing the ID is needed for -- decisions.  */

// Compute the objective function one more time and print all measures.

for (i = 0; i < nmids - 1; ++i) {
  Intridslve.nminoutpairs[i] = 0;
}
printf_("\nca: skipeco= " + Ecosyscalcs.skipeco + ":");
finalgca = CAutils.caf_(x_ca, true);
printf_("ca: fbest= " + fdble_(Optimiz.fbest, 6, 3) +
   " finalgca= " + fdble_(finalgca, 6, 3));

// Turn on ecosystem computations and recompute all measures.

Ecosyscalcs.skipeco = false;
for (i = 0; i < nmids - 1; ++i) {
  Intridslve.nminoutpairs[i] = 0;
}
printf_("\nca: skipeco= " + Ecosyscalcs.skipeco + ":");
finalgca = CAutils.caf_(x_ca, true);
printf_("ca: fbest= " + fdble_(Optimiz.fbest, 6, 3) +
   " finalgca= " + fdble_(finalgca, 6, 3));

// Compute relative change in g_S and g_H from their initial values.

relgs = (initialgs - gs) / Math.abs(initialgs);
relgh = (initialgh - gh) / Math.abs(initialgh);

fprintf_(1, "\n-------- Final Agreement Function Values --------" +
            "\n   gs= " + gs + " gh= " + gh + " gca= " + finalgca +
            "\n   (gsintl-gs)/|gsintl|= " + relgs +
            "\n   (ghintl-gh)/|ghintl|= " + relgh);

if (nmids > 1) {
   fprintf_(1, "\n   gs_groups= " + gs_groups + " gs_eco= " + gs_eco +
               "\n   gh_groups= " + gh_groups + " gh_eco= " + gh_eco);
}

/* Reload the solution vector with the distribution found by
   optimization.  This is necessary because of the
   normalization that occurs in pxp_(). */

for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
   for (i = 0; i < Psens.nmsensids; ++i) {
      if (nmids > 1 && !idname[idnmbrm1].equals(Psens.id[i])) {
         continue;
      }
      thisidname = idname[idnmbrm1];
      nmnds = Intridslve.nmndes[idnmbrm1];
      printf_("ca: calling pxp for ID= " + thisidname + " beginpar= " + Psens.beginpar[i]);
      Pxp.pxp_(0, x_ca, g, h, 2, Psens.beginpar[i],
         Psens.begincnstrnt[i], false);
   }
}

/* Print all parameters and indicate those that have changed from their
   consistent value by more than 1%. */

fprintf_(1, "Note: * indicates the parameter has changed by more than 10%" +
   "\nParameter#  ID          Node      Hypothesis_Value  Consistent_Value");

for (i = 0; i < n; ++i) {

   // Compute a positive divisor.

   divisor = Math.abs(x_hyp[i]);
   if (divisor < 1.e-6) {
      divisor = 1.;
   }

   fracdiff = Math.abs(x_hyp[i] - x_ca[i]) / divisor;
   if (fracdiff > 0.1) {
      strng = "*";

   } else {
      strng = " ";
   }
   fprintf_(1, "  " + (i + 1) + "     " + idname[Pxp.idownerm1[i]] +
      "  " + Pxp.nodename[i] + "  " + fdble_(x_hyp[i], 6, 3) +
      "  " + fdble_(x_ca[i], 6, 3) + " " + strng);
}

/* Print mean of last simulated ecosystem variable marginals and
   data.  Note that "nmobsrvd" as found in "ecosysgcalcs_" is used
   instead of "nmecoobsttl" because the former allows for user-specified
   clipping of the temporal interval as specified in the
   "starttime" and "endtime" settings of the "estimate" relation. */
   
if (Ecosyscalcs.nmobsrvd > 0) {
   fprintf_(1, "\n----- Final Residuals of Ecosystem Variables -----" +
      "\nRegion Time Var. Obsrvd   Model   resid");
   for (i = 0; i < Ecosyscalcs.nmobsrvd; ++i) {
      for (j = 0; j < nmobsnds; ++j) {
         if (Ecosyscalcs.obsvar[i][j] > 0) {
            fprintf_(1, Ecosyscalcs.residregion[i] + "    " +
               Ecosyscalcs.residtime[i] + "  " +
	       Ecosyscalcs.obsvar[i][j] + "  " +
               Ecosyscalcs.obsrvdval[i][j] + "  " +
               Ecosyscalcs.modelval[i][j] + "  " +
	       Ecosyscalcs.resids[i][j]);
         }
      }
   }
}

if (wflag) {

   // Write the consistent distribution file(s).

   fprintf_(1, "----- Writing Consistent Distribution -----");
   Writenet.wrtedsts_();
}
}
}
