public class Busagent extends Mfgnetwork {

// -------------------------------------------------------------------

public static void business_(int thrd, int pth, int busnm) {

/* NOTE: dst in this class is plus 1 "dst" used in HIBMcalcs.java.

   A business agent has customers, a workforce, and an inventory that it
   replenishes from suppliers.  Special cases include the bungalows
   business and entertainment operators.  These businesses have small
   inventories that do not require replenishment.  Another special case is
   a supplier who has no suppliers such as a farmer or an artisan.

   There are three types of business agents: retailers that carry an
   inventory, retailers with no inventory, and suppliers who always carry
   an inventory.  A retailer with or without an inventory, faces buyers
   and charges them what they will bear.  An entertainment operator is a
   retailer with no inventory.

   Decision making of business type "supplier":
 
   1. Check for order
   2. Send counter-offer with higher price.
   3. Receive response
   4. Ship order.

   Decision making of business type "retailerwinv":

   1. Determine order size, $O = c d_t$ where $c$ is food consumption per
   customer, and $d_t$ is the forecasted number of customers.
   2. Send order to suppliers.
   3. Select cheapest offer and receive shipment.
   4. If quality and/or delivery time is unacceptable, blacklist that supplier.
   5. Update inventory and workforce.

   Decision making of business type "retailer":

   1. Check for customer.
   2. Serve customer.
   3. Update workforce.
   
   The econprovider, econinput, and econoutput arrays work as follows.
   i=0 is always the poaching syndicate agent.
   When actions_econprovider[i][j] = true, the ith buyer or business has
   placed an order with business j to the tune of actions_econinput[i]
   Business j fills an order to the tune of actions_econoutput[j].
   Buyers will never be econproviders and hence the last dimension of
   "econproviders" ranges from 1 to "nmbusinesses." */

boolean supplier = false, retailerwinv = false, retailer = false,
   order = false;

int i, iorg, j, nmsuccesses, bestsupplier, nmunitssold, ordersize = 0,
   orderer = 0, inventorysize;

int[] shufflvec = new int[NMAGNTS];

double unif, pres = 0., cres = 0., smoothcres = 0., netrev, successprob,
   priceold, pricemin = 0., q, liquidreserve, maxcapacity, costoneunit,
   priceoneunit, bigq, prodcapacity, revenue = 0., costs = 0., netrevold,
   currprofit, prevsold = 0.;

// Get constants for this business and initialize things.

if (busnm == 0) {
   iderr_("business: busnm=0");
}

if (bustype[busnm - 1] == "supplier") {
   supplier = true;

} else if (bustype[busnm - 1] == "retailerwinv") {
   retailerwinv =  true;

} else {
   retailer = true;
}

costoneunit = unitcost[busnm - 1];
maxcapacity = maxcap[busnm - 1];

// Get current values.

q = priceq[thrd][pth][busnm - 1];
priceoneunit = unitprice[thrd][pth][busnm - 1];
priceold = priceoneunit;
nmunitssold = nmsold[thrd][pth][busnm - 1];
liquidreserve = liquidityreserve[thrd][pth][busnm - 1];
bigq = capq[thrd][pth][busnm - 1];
prodcapacity = prodcap[thrd][pth][busnm - 1];
netrevold = oldnetrev[thrd][pth][busnm - 1];
inventorysize = inventory[thrd][pth][busnm - 1];

if (prodcapacity < 1.) {
   iderr_("busnm= " + busnm + " inventorysize= " + inventorysize +
      " prodcapacity= " + prodcapacity);
}

/* ---------------------- Order processing. --------------------------
 
   Check for orders and fill those that are waiting up to current
   production capacity.  Orders are pre-paid.
   Orders are cancelled by the order-consumer only. */

nmunitssold = 0;
if (supplier) {
   for (i = 1; i <= nmbusinesses; ++i) {
      orderer = i + nmbuyers;
      if (Intridslve.actions_econprovider[thrd][pth][orderer][busnm]) {
         ordersize = Intridslve.actions_econinput[thrd][pth][orderer];

         if (ordersize > inventorysize) {
            iderr_("supplier " + busnm + " ordersize= " + ordersize +
               " inventorysize= " + inventorysize);
         }

         Intridslve.actions_econoutput[thrd][pth][busnm] = (double) ordersize;
         nmunitssold += ordersize;
         revenue += ordersize * priceold;

         // Current version of model does not track supplier's inventory.
         // inventorysize -= ordersize;
      }
   }

} else {

   // Check and fill buyer orders.  A buyer consumes one unit of inventory.

   for (i = 1; i <= nmbuyers; ++i) {
      if (Intridslve.actions_econprovider[thrd][pth][i][busnm]) {
         ordersize = Intridslve.actions_econinput[thrd][pth][i];

         if (ordersize > inventorysize) {
            //iderr_("ordersize = 0");
            ordersize = 0;
         }

         nmunitssold += ordersize;
         revenue += priceold * ordersize;

         if (retailerwinv) {
            inventorysize -= ordersize;
         }
      }
   }
}

/* ------------------------ Pricing. -----------------------------

   Compute the response value (Catullo, equation 10). */

if (!Ecosyscalcs.firsttimepoint[thrd]) {
   pres = (prodcapacity - ((double) nmunitssold)) / prodcapacity;
}

if (supplier) {
   prevsold = avesold_(thrd, pth, busnm, 4, nmunitssold);

} else {
   prevsold = avesold_(thrd, pth, busnm, 2, nmunitssold);
}

if (nmunitssold > 0) {
   
   /* "pres" needs to be this extreme or asking price will not rise
       to the bid price (reserve price). */

   pres = -1.; // 1 for profit, 2 for bio!?
}

/* Next, compute q (Catullo, equation 8) and then sample once from
   a normal distribution with mean q and standard deviation of
   ?? U.S. dollars to obtain a price. */

q = (1. - ra) * q + ra * (priceold * (1. - pres));

priceoneunit = q + 0.001 * Rndm.stdnrm_(thrd);

// Keep the best price at which product sold.

if (nmunitssold > 0) {
   oldbest[thrd][pth][busnm - 1] = priceold;
}

if (prevsold > 0 && bestprice[thrd][pth][busnm - 1] < priceold) {
   bestprice[thrd][pth][busnm - 1] = priceold;
}

if (prevsold < .1) {
   bestprice[thrd][pth][busnm - 1] = oldbest[thrd][pth][busnm - 1];
   //priceoneunit = bestprice[thrd][pth][busnm - 1];
}

if (bestprice[thrd][pth][busnm - 1] < costoneunit) {
   bestprice[thrd][pth][busnm - 1] = costoneunit;
}

if (priceoneunit < bestprice[thrd][pth][busnm - 1]) {
   priceoneunit = bestprice[thrd][pth][busnm - 1];
}
if (supplier) {
   //priceoneunit = .999 * reserveprice;
}

/* ----------------------- Production capacity. --------------------
 
   Decide on a possible one-unit increase or decrease in production
   capacity.  First, compute the difference in net revenue between the
   last two cycles.  Net revenue is profit at fixed prices without fixed
   costs, i.e., just variable costs:

   nr = price * nmsold - unitcost * nmsold (Catullo, note 6). */

netrev = nmunitssold * (priceold - costoneunit);
cres = netrev - netrevold;
netrevold = netrev;

// Plow a percentage of this net revenue into reserve liquidity.

liquidreserve += .5 * netrev;

// Compute the production capacity q value.

smoothcres = aveprofit_(thrd, pth, busnm, 3, cres);
bigq = (1. - ra) * bigq + ra * smoothcres;

/* Select an option by sampling once from the binomial
   distribution with an "n" of 2 wherein the normalized q is
   the probability of success.
   0: reduce capacity.
   1: no change to capacity.
   2: increase capacity. */
   
successprob = 0.1 * bigq; // was .1
successprob = 1. / (1. + Math.exp(-successprob));

nmsuccesses = 0;
for (j = 0; j < 2; ++j) {
   unif = Rndm.rndm1_(thrd, 0);
   if (unif < successprob) {
      ++nmsuccesses;
   }
}

if (nmunitssold == 0) {
   nmsuccesses = 1;
}

if (nmsuccesses == 0) {

   /* Assumption: production capacity is always at least 10\% of
      maximum production capacity. */

   prodcapacity -= 20;
   if (prodcapacity < 10) {
      prodcapacity = 10;
   }

} else if (nmsuccesses == 2) {
   /*
   if (liquidreserve > costoneunit) {
      liquidreserve -= costoneunit;
      if (prodcapacity  < maxcapacity) {
         prodcapacity += prevsold;
      }
   }
   */
   if (prodcapacity  < maxcapacity) {
      prodcapacity += 20;
   }      
}      

// Keep the best productivity.

if (nmunitssold > 0 && prodcapacity > 0.) {
   oldbestprod[thrd][pth][busnm - 1] = prodcapacity;
}
if (oldbestprod[thrd][pth][busnm - 1] > 0.) {
   bestprod[thrd][pth][busnm - 1] = oldbestprod[thrd][pth][busnm - 1];
   prodcapacity = bestprod[thrd][pth][busnm - 1];
}

/*
if (prevsold > 0 && bestprice[thrd][pth][busnm - 1] < priceold) {
   bestprice[thrd][pth][busnm - 1] = priceold;
}
*/

if (prodcapacity < bestprod[thrd][pth][busnm - 1]) {
   prodcapacity = bestprod[thrd][pth][busnm - 1];
}

pricemin = reserveprice;
if (retailerwinv) {
   
   /* A retailer with inventory receives and consumes any orders that
      have been filled by its suppliers. */

   orderer = busnm + nmbuyers;
   for (i = 1; i <= nmbusinesses; ++i) {
      if (Intridslve.actions_econprovider[thrd][pth][orderer][i]) {
         ordersize = (int) Intridslve.actions_econoutput[thrd][pth][i];
         inventorysize += ordersize;
         Intridslve.actions_econprovider[thrd][pth][orderer][i] =
            false;
      }
   } 
      
   /* This retailer checks if inventory needs to be replenished.  If
      so, the retailer tries to buy one production unit from one of its
      suppliers at the cheapest price that is below the retailer's
      reserve price. */

   if (inventorysize < invthreshold || nmunitssold > 0) {
      bestsupplier = 0;
      shufflvec = Rndm.shuffle_(1, nmbusinesses, 0);
      for (iorg = 0; iorg < nmbusinesses; ++iorg) {
         j = shufflvec[iorg];
         if (desigsupplier[busnm - 1][j - 1] &&
             unitprice[thrd][pth][j - 1] <= reserveprice &&
             unitprice[thrd][pth][j - 1] <= pricemin) {
            pricemin = unitprice[thrd][pth][j - 1];

            if (pricemin < 1.) {
               iderr_("thrd= " + thrd + " pth= " + pth +" busnm= " + j +
                  " pricemin= " + pricemin);
            }

            bestsupplier = j;
         }
      }
         
      // Place a pre-paid order.

      if (bestsupplier > 0) {
         ordersize = Math.max((invthreshold - inventorysize), nmunitssold);
         orderer = busnm + nmbuyers;
         Intridslve.actions_econinput[thrd][pth][orderer] = ordersize;
         Intridslve.actions_econprovider[thrd][pth][orderer]
                                        [bestsupplier] = true;
         costs = ((double) ordersize) * pricemin;
      }
   }
}

/* --------------------------- Wages. --------------------------------

   In a pure profit strategy, a business pays workers the least that they
   can get away with.  This is the average wage paid to workers across
   other firms who belong to this business's sector.
   If the business is, instead, part of an operation tied to a
   biodiversity project, then this business uses a state-computed poverty
   line value as their minimum wage.  And, this business adjusts its
   wage towards what middlemen are paying poachers for rhino horn.  This
   adjustment is to pay a wage that is always one-tenth the middleman's
   current bid price.  Hence, the formula for a biodiversity-related
   business is to pay:

      wage = max(poverty line wage, 0.1 * middleman's bid price). */

if (nmids > 1 && operationbus[busnm - 1]) {
   //wage[busnm - 1] = Math.max(povertywage,
   //   0.2 * Intridslve.currbidprice[Intridslve.middleidnm - 1]);

   /*
   printf_("business: busnm= " + busnm + " povertywage= " + povertywage +
      " wage= " + wage[busnm - 1]);
   */

} else {
   wage[busnm - 1] = sectorwage;
}

/* --------------------- Employment and profit. ----------------------
 
   All business types update their workforce.  A business's production
   capacity is proportional to its number of employees (called here, the
   business's "number of employees."  The conversion factor from
   production capacity to number of employees is 0.1. */

nmemployees[thrd][pth][busnm - 1] = (int) (.1 * prodcapacity);

// Compute this business's current profit.

costs += nmemployees[thrd][pth][busnm - 1] * wage[busnm - 1];
currprofit = revenue - costs;

/*
if (thrd == 1 && pth == 1) {
   printf_("Busagent: busnm= " + busnm + " time= " +
      fdble_(beltmept[thrd], 8, 3) + " revenue= " + revenue + " costs= " +
      costs);
}
*/

profit[thrd][pth][busnm - 1] = currprofit;

/* ---------------------- Return processing. -------------------------- */

unitprice[thrd][pth][busnm - 1] = priceoneunit;
priceq[thrd][pth][busnm - 1] = q;
liquidityreserve[thrd][pth][busnm - 1] = liquidreserve;
capq[thrd][pth][busnm - 1] = bigq;
prodcap[thrd][pth][busnm - 1] = prodcapacity;
oldnetrev[thrd][pth][busnm - 1] = netrevold;
nmsold[thrd][pth][busnm - 1] = nmunitssold;
inventory[thrd][pth][busnm - 1] = inventorysize;

// ----------------------- Diagnostic output. ---------------------------   

/*
if (thrd == 1 && pth == 0) {
   if (busnm == 1 && Ecosyscalcs.firsttimepoint[thrd]) {
      printf_("stepnm busnm  priceoneunit pres nmunitssold  inventory" +
         " prodcap " + "  profit");

   } else if (busnm == 4 && Ecosyscalcs.firsttimepoint[thrd]) {
      printf_("stepnm busnm  priceoneunit  pres nmunitssold  successprob" +
         "  prodcap " + "  profit");
   }

   if (busnm == 1 || busnm == 2) {
      printf_(stepnm + "  " + busnm + "     " +
         fdble_(priceold, 5, 2) +
         //fdble_(bestprice[thrd][pth][busnm - 1], 5, 2) +
         "     " + fdble_(pres, 5, 3) + "     " + nmunitssold + "     " +
         //fdble_(successprob, 5, 3) + "  " + nmsuccesses +
         inventorysize +
         //"     " + fdble_(prodcapacity, 5, 3) + "     " +
         //fdble_(currprofit, 5, 3));
         "    " + fdble_(revenue, 5, 3) + "    " + fdble_(costs, 5, 3));

   } else if (busnm == -4 || busnm == -5) {
      printf_(stepnm + "  " + busnm + "     " +
         //fdble_(bestprice[thrd][pth][busnm - 1], 5, 2) +
         fdble_(priceold, 5, 2) +
         "     " + fdble_(pres, 5, 2) + "     " + nmunitssold +
         "     " + fdble_(successprob, 5, 3) + "       " +
         fdble_(prodcapacity, 5, 2) + "     " + fdble_(currprofit, 5, 3));
   }
}
*/
}

// -----------------------------------------------------------------------

static double avesold_(int thrd, int pth, int busnm, int n, int nmunitssold) {

// Computes the running average of the previous "n" periods.

int i;

double retval = 0., max = 0.;

for (i = 0; i < n - 1; ++i) {
   lastsold[thrd][pth][busnm - 1][i] = lastsold[thrd][pth][busnm - 1][i + 1];
}
lastsold[thrd][pth][busnm - 1][n - 1] = nmunitssold;

for (i = 0; i < n; ++i) {
   retval += lastsold[thrd][pth][busnm - 1][i];
   if (lastsold[thrd][pth][busnm - 1][i] > max) {
      max = lastsold[thrd][pth][busnm - 1][i];
   }
}
retval /= ((double) n);
return retval;
}

// -----------------------------------------------------------------------

static double aveprofit_(int thrd, int pth, int busnm, int n, double cres) {

// Computes the running average of the previous "n" periods.

int i;

double retval = 0., max = 0.;

for (i = 0; i < n - 1; ++i) {
   lastcres[thrd][pth][busnm - 1][i] = lastcres[thrd][pth][busnm - 1][i + 1];
}
lastcres[thrd][pth][busnm - 1][n - 1] = cres;

for (i = 0; i < n; ++i) {
   retval += lastcres[thrd][pth][busnm - 1][i];
   if (lastcres[thrd][pth][busnm - 1][i] > max) {
      max = lastcres[thrd][pth][busnm - 1][i];
   }
}
retval /= ((double) n);
return retval;
}
}
