public class Beliefs extends Readnet {

static boolean loadconsdst = false, belpflag = false,
   initialIntridsTime = true, issms, isabm = false, isbusinessabm = false,
   headerwritten = false, testflag = false;

static boolean initializetmefcns[] = new boolean[TNMIDS];
static boolean tmefcnstep[] = new boolean[NMTHRDS];
static boolean outflag[] = new boolean[NMTHRDS];
static boolean compute_gh[] = new boolean[TNMIDS];
static boolean fixedvars[][] = new boolean[TNMIDS][MAXNMSDE];
static boolean loadnode[][] = new boolean[TNMIDS][TNMNDS];

/* Set the distance measure between the hypothesis and consistent
   distributions.  Options are "kullbacklieblerdiv" or "hellinger." */

static String ghtype = "hellinger";

static int nmloops = 0, enmloops = 0, anmloops = 0, nmoutt = 0,
   nmtimepts = 0, printinterval = 0, xyptsflenm = 5;

/* "tmefcncounter" is global because it is modified in "update" which
   is not "conddist_," the method that initializes it. */
   
static int tmefcncounter[][] = new int[NMTHRDS][2];
static int nmtmefcns[] = new int[TNMIDS];
static int tmefcnnm[][] = new int[TNMIDS][MAXNMSDE];
static int idenom[] = new int[NMTHRDS];
static int rgnval[] = new int[NMTHRDS];

static double gh_measure, kli1, kli2, rnmloops, dif = 0., ch, aveprofit = 0.;

// "beltmept" is global because it is used in several places. */

static double beltmept[] = new double[NMTHRDS];
static double denom[] = new double[NMTHRDS];
static double outputtime[] = new double[MAXTIMES];
static double beliefh[][][][] =
   new double[NMTHRDS][10][TNMNDS][TNMVALS];
static double beliefc[][][][] =
   new double[NMTHRDS][10][TNMNDS][TNMVALS];
static double initialvals[] = new double[TNMNDS];
static double nodevalsh[][][] = new double[NMTHRDS][2][TNMNDS];
static double nodevalsc[][][] = new double[NMTHRDS][2][TNMNDS];
static double memorydst[][][] = new double[TNMIDS][TNMNDS][TNMVALS];
static double simdata[][][][] = new double[NMTHRDS][SIMSZE][TNMNDS][2];

// ------------------------------------------------------------------------

public static void beliefs_(int outflenm, double givench) {

/* Finds the ID's "beliefs."  These are defined to be each node's
   conditional distribution in the network conditional on given values
   for a set of conditioning nodes.  Also finds the conditional joint
   distribution of a requested set of nodes.

   arrays:
     belief . . . final conditional distributions (beliefs) for
                  each free node
     condnodes . . . conditioning node numbers
     condvals  . . . values of the conditioning nodes
    
   Limit:  1) up to 6 conditioning nodes 

   cacalc = false: compute beliefs for an ID evaluation.
   cacalc = true: compute beliefs to support a CA function evaluation.
                  An actions history data set is used to define start,
		  end, and all intervening time points.

   Note on setting "nmloops": because 2 IDs (the hypothesis and
      consistent distributions) are simulated each function evaluation
      in a CA, in order to have approximate agreement between
      CA-computed beliefs and "evaluate"-computed beliefs, "nmloops"
      needs to be at least 1500 based on experience with the ID
      defined in "ugapas.id." */

boolean flag, performghcalc = true;

String value, pltstrng;

int i, j, k, nmvals, nmloopssve = 0, profitnm = 0;

double condval, val = 0., emprate = 0., bidprice = 1., wage = 0.;

// Initialize CA weight.

ch = givench;

/*
if (thisidname.equals("poachers")) {
   printf_("\nbeliefs: ID= " + thisidname);
   for (i = 0; i < nmcondnds; ++i) {
      printf_("beliefs: condnode= " +
         nodelbls[idnmbrm1][condnodes[idnmbrm1][i] - 1][0] +
         " val= " + condvals[i]);
   }
   //iderr_("in beliefs");
}
*/

// Set number of output times, and those times.

if (nmids == 1) {
   if(!optimal_decision) {
      if (!temporal) {
         nmoutt = 1;
         outputtime[0] = 0.;
 
      } else {
         nmoutt = Math.min(nmloops, 10);
         if (testflag) {
            printf_("beliefs: tmin= " + spacetime_tmin + " tmax= " +
               spacetime_tmax + " nmoutt= " + nmoutt);
         }
         for (i = 0; i < nmoutt - 1; ++i) {
            outputtime[i] = spacetime_tmin + ((double) i) *
	       (spacetime_tmax - spacetime_tmin) / (double) (nmoutt - 1);
         }
         outputtime[nmoutt - 1] = spacetime_tmax;
         if (testflag) {
            printf_("beliefs: outputtime(" + nmoutt + ")= " +
               outputtime[nmoutt - 1]);
         }
      }

   } else {
      nmoutt = 1;
      outputtime[0] = spacetime_tmax;
      if (testflag) {
            printf_("beliefs: outputtime(" + nmoutt + ")= " +
               outputtime[nmoutt - 1]);
      }
   }

} else if (nmids > 1) {

   /* In an IntIDs model, set the single output time to be the end-time. */

   nmoutt = 1;
   outputtime[0] = 0.;
   if (Intridslve.timenode[idnmbrm1] > 0) {
      outputtime[0] = condvals[Intridslve.timenode[idnmbrm1] - 1];
	 
      /* Check that this is a valid conditioning time that was set in
         "intridslve_". */

      if (Math.abs(outputtime[0] - spacetime_tmax) > 1.e-6) {
         iderr_("beliefs: outputtime(0)= " + outputtime[0] +
            " but tmax= " + spacetime_tmax + " Time node nmbr= " +
	    Intridslve.timenode[idnmbrm1]);
      }
   }
}

// Set printing flag.

if (nmids == 1 && !client && !cacalc) {
   belpflag = true;
}

// Set "varinfo_eval" to false for a conditioning node.

for (i = 1; i <= nmnds; ++i) {
   for (j = 0; j < nmcondnds; ++j) {
      if (i == condnodes[idnmbrm1][j]) {
	 varinfo_eval[idnmbrm1][i - 1] = false;
      }
   }
}

// Initialize nodes of any time-stepping functions that are in this ID.

if (initializetmefcns[idnmbrm1]) {

   /* First, discover the number of time-stepping function nodes in
      either a system of SDEs, an HIBM, a PIBM, an SMS, and/or an ABM
      ("nmtmefcns") -- and relate these associated node numbers to the
      time-stepping function array.  Also, verify that all decision nodes
      have been set to a value. */

   nmtmefcns[idnmbrm1] = 0;
   if (Idsolve.parameterlearning && thisidname.equals("poachers") &&
       cacalc) {
	 
      // Load the consistent distribution with the hypothesis distribution.

      Parlearn.initialize_();
   }

   for (i = 1; i <= nmnds; ++i) {
      if (varinfo_dist[idnmbrm1][i - 1].equals("SDE") ||
          varinfo_dist[idnmbrm1][i - 1].equals("HIBM") ||
          varinfo_dist[idnmbrm1][i - 1].equals("PIBM") ||
          varinfo_dist[idnmbrm1][i - 1].equals("SMS") ||
          varinfo_dist[idnmbrm1][i - 1].equals("R_Horn_ABM") ||
          varinfo_dist[idnmbrm1][i - 1].equals("M_Network_ABM")) {
         tmefcnnm[idnmbrm1][nmtmefcns[idnmbrm1]] = i;
         fixedvars[idnmbrm1][nmtmefcns[idnmbrm1]] = false;
         ++nmtmefcns[idnmbrm1];

         if (varinfo_dist[idnmbrm1][i - 1].equals("HIBM")) {
	 
            // Read-in the IBM/ABM's files and parameters.

            HIBMcalcs.ibmsetup_(1);
	    if (cacalc) {
               HIBMcalcs.ibmsetup_(2);
	    }

         } else if (varinfo_dist[idnmbrm1][i - 1].equals("PIBM")) {
	 
            // Read-in the IBM/ABM's files and parameters.

            PIBMcalcs.ibmsetup_(1);
	    if (cacalc) {
               PIBMcalcs.ibmsetup_(2);
	    }

	 } else if (varinfo_dist[idnmbrm1][i - 1].equals("SMS")) {
	 
            // Set the SMS flag and read-in its files and parameters.

            issms = true;
            SMScalcs.smssetup_(1);
	    if (cacalc) {
               SMScalcs.smssetup_(2);
	    }

         } else if (varinfo_dist[idnmbrm1][i - 1].equals("R_Horn_ABM")) {
	 
            // Set the ABM flag and read-in parameters of the traders ABM.

            isabm = true;
	    Econcalcs.abmsetup_(1);
	    if (cacalc) {
	       Econcalcs.abmsetup_(2);
	    }
         
         } else if (varinfo_dist[idnmbrm1][i - 1].equals("M_Network_ABM")) {
	 
            /* Set the ABM flag and read-in parameters of the manufacturing
               network ABM. */

            isabm = true;
	    Mfgnetwork.abmsetup_(1);
	    if (cacalc) {
	       Mfgnetwork.abmsetup_(2);
	    }
         }
      }

      if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Root") ||
          varinfo_dist[idnmbrm1][i - 1].equals("Determ_Decision")) {
         flag = false;
         for (k = 0; k < nmcondnds; ++k) {
	    if (condnodes[idnmbrm1][k] == i) {
	       flag = true;
	       break;
	    }
         }

	 /* If a Determ_Root or Determ_Decision node is not set to a
	    value, terminate. */
	 
         if (!flag) {
	    if (nmids > 1) {
	       printf_("beliefs: idnmbrm1= " + idnmbrm1 + " ID= " +
	          thisidname);
	    }
	    printf_("beliefs: nmcondnds= " + nmcondnds);
            for (k = 0; k < nmcondnds; ++k) {
	       if (condnodes[idnmbrm1][k] < 1) {
                  printf_("   missing condnode's " + (k + 1) +
                     " node number has been set to " + condnodes[idnmbrm1][k]);

	       } else {
                  printf_("   condnodenm= " + condnodes[idnmbrm1][k] +
                     " label= " +
	             nodelbls[idnmbrm1][condnodes[idnmbrm1][k] - 1][0] +
	             " val= " + condvals[k]);
	       }
            }
	    iderr_("   deterministic root node " +
	       nodelbls[idnmbrm1][i - 1][0] + " not set to a value.");
         }
      }
   } // End of loop over nodes.
   initializetmefcns[idnmbrm1] = false;
}

if (nmtmefcns[idnmbrm1] > 0) {

   /* Initialize the begin-time, end-time, and time step for the solution
      to the set of time-stepping functions. */

   Ecosyscalcs.settime_(isabm, issms);
   if (Ecosyscalcs.delta < 1.e-6) {
      iderr_("beliefs: delta= " + Ecosyscalcs.delta);
   }
   nmtimepts = Ecosyscalcs.capn + 1;

   if (testflag) {
      printf_("beliefs: capn= " + Ecosyscalcs.capn + " nmtimepts= " +
         nmtimepts);
   }

} else {
   nmtimepts = 1;
}

// Set "nmloops" depending on model type.

nmloopssve = nmloops;
if (idinfo_nmsdes[idnmbrm1] > 0) {
   nmloops = enmloops;

} else if (idinfo_hashibm[idnmbrm1] || idinfo_haspibm[idnmbrm1]) {
   nmloops = enmloops;

} else if (idinfo_hasabm[idnmbrm1]) {
   nmloops = anmloops;
}

/* Check lower bound on "nmloops" and set simulation progress output
   interval. */

if (nmloops < 2) {
   iderr_("beliefs: nmloops= " + nmloops);
}

if (nmloops >= 20) {
   printinterval = nmloops / 10;

} else {
   printinterval = 2;
}

if (printinterval < 1) {
   iderr_("beliefs: printinterval= " + printinterval);
}
rnmloops = (double) nmloops;

/* Update all nodes by sampling from each node's conditional distribution. 
   Perform this simulation on this ID with dist=1 and (optionally) dst=2.
*/

//if (testflag && nmids == 1) {
//if (testflag && thisidname.equals("tigereco")) {
if (testflag) {
   printf_("beliefs: nmthreads= " + nmthreads +
      " Number of conditioning nodes= " + nmcondnds);
   for (k = 0; k < nmcondnds; ++k) {
      if (condnodes[idnmbrm1][k] == 0) {
         iderr_("beliefs: ID= " + thisidname + "condnodes(" + (k + 1) + ")=0");
      }
      if (nodenghs[idnmbrm1][condnodes[idnmbrm1][k] - 1][0] > 1) {
         printf_("   " +
            nodelbls[idnmbrm1][condnodes[idnmbrm1][k] - 1][0] + "= " +
            nodelbls[idnmbrm1][condnodes[idnmbrm1][k] - 1]
                 [((int) condvals[k])]);

      } else {
         printf_("   " +
            nodelbls[idnmbrm1][condnodes[idnmbrm1][k] - 1][0] + "= " +
            condvals[k]);
      }
   }
}

Conddist.conddist_(outflenm);

/* Decide if the inter-distribution agreement measure is to be computed.
   As a special case, the ecosystem's gh value is computed only at the
   end time. */

if (!compute_gh[idnmbrm1] ||
    (phenomenon_class[idnmbrm1].equals("ecosystem") &&
     Intridslve.tindex != Intridslve.nmmdltimes)) {
   performghcalc = false;

} else {
   performghcalc = true;
}

gh_measure = 0.;
if (loadconsdst && performghcalc && idnmbrm1 == nmids - 1) {

   /* Compute components of the g_H() function.  Broken for group IDs!!: The
      input conditions that Idsolve sees when computing Expected
      Goal Attainment over all possible out-combinations may be different from
      when an optimization search begins and when it converges.  When this
      happens, the g_H measure at the beginning of an optimization is the sum
      of different sets of conditioning values on the ID's conditioning nodes
      than the set used when the objective function is evaluated when the
      optimization has converged.  What is needed is a new algorithm that
      computes the Hellinger distance between the hypothesis and consistent
      distributions only on those nodes that are defined by parameters that are
      variables in the optimization problem.  Currently, the Hellinger distance
      for group IDs is computed in CAutils.caf_().  Note that the ecosystem ID's
      Hellinger distance continues to be computed here. */

   if (ghtype.equals("kullbacklieblerdiv")) {

      /* For CA, find the KL divergence between distribution 1 and
	 distribution 2. */

      gh_measure = (kli1 + kli2) / (double) nmloops;
      if (gh_measure < 0.) {
	 gh_measure = 0.;
      }

      /* Load marginal probability array with the simulated beliefs or
         moments and then compute constraint values.
      for (i = 0; i < m; ++i) {
         marg_consis[i] = beliefc[0][marg_ndnm[i] - 1][marg_valnm[i] - 1];
         Optimiz.cnstrnt[i] = marg_consis[i] - marg_obsvd[i];
      }
      */

   } else if (ghtype.equals("hellinger")) {
      
      /* Compute the negative Hellinger distance between distributions
	 1 and 2. */

      gh_measure = -Distagree.hllngrdist_();

      if (gh_measure > 0.) {
         iderr_("beliefs: Hellinger gh_measure= " + gh_measure + " > 0??");
      } 
   }
}

// For an IntIDs run, write all distributions to the memory array.

if (nmids > 1) {
   for (i = 0; i < nmnds; ++i) {
      for (k = 0; k < nodenghs[idnmbrm1][i][0]; ++k) {
         memorydst[idnmbrm1][i][k] = beliefh[0][nmoutt - 1][i][k];
      }
   }
}

// In an IntIDs run, write selected node values at this time point.

if (nmids > 1 && !cacalc && !dsensanalysis && !findmpemp) {
   intridnodeplot_();
}

nmloops = nmloopssve;

if (!belpflag) {

   return;
}

/* Write distributions to an output file that was opened in "idsolve_."
   First, write header information. */

if (nmcondnds == 0) {
   fprintf_(outflenm,
	 "\n---------------------Unconditional Beliefs--------------------");

} else {
   fprintf_(outflenm,
      "\n--------------------------------------------------------------" +
	 "\n  Conditioning Node                   Value");

   for (i = 0; i < nmcondnds; ++i) {
      j = condnodes[idnmbrm1][i];

      if (nodenghs[idnmbrm1][j - 1][0] > 1) {
         value = fstrng_(nodelbls[idnmbrm1][j - 1][(int) condvals[i]], 15);
        
      } else {
         value = fdble_(condvals[i], 15, 5);
      }
      fprintf_(outflenm, "  " +
         fstrng_(nodelbls[idnmbrm1][j - 1][0], 20) + "       " + value);
   }
}

// Write beliefs of requested nodes.

fprintf_(outflenm,
   "\n Output Time      Node          Mean    Standard Deviation" +
   "\n-----------------------------------------------------------");

for (k = 0; k < nmoutt; ++k) {
   pltstrng = fdble_(outputtime[k], 10, 3); 
   for (i = 0; i < nmnds; ++i){

      // Skip conditioning nodes and nodes that have not been requested.

      if (!varinfo_eval[idnmbrm1][i]) {
	 continue;
      }

      if (nodenghs[idnmbrm1][i][0] > 1) {

         // If discrete, write empirical probability mass function.

         fprintf_(outflenm, "\nPMF of node " + nodelbls[idnmbrm1][i][0] +
	    ": ");

         for (j = 0; j < nodenghs[idnmbrm1][i][0]; ++j) {
	    if (!loadconsdst) {
               fprintf_(outflenm, nodelbls[idnmbrm1][i][j + 1] + " " +
                  fdble_(beliefh[0][k][i][j], 6, 4));

	    } else {
               fprintf_(outflenm, nodelbls[idnmbrm1][i][j + 1] + " " +
                  fdble_(beliefc[0][k][i][j], 6, 4));
	    }
         }
 
      } else {

         /* For a continuous variable, only write first 2 moments.  Note
            that this includes any deterministic, linear function of
            other variables, e.g. a linear utility node. */

         if (!loadconsdst) {
            fprintf_(outflenm," " + fdble_(outputtime[k], 7, 2) + "  " +
               fstrng_(nodelbls[idnmbrm1][i][0], 20) + " " +
               fdble_(beliefh[0][k][i][0], 10, 4) + "  " +
               fdble_(beliefh[0][k][i][1], 10, 4));

	 } else {
            fprintf_(outflenm, " " + fdble_(outputtime[k], 7, 2) + "  " +
               fstrng_(nodelbls[idnmbrm1][i][0], 20) + " " +
               fdble_(beliefc[0][k][i][0], 10, 4) + "  " +
               fdble_(beliefc[0][k][i][1], 10, 4));
	 }
      }
   } // End of loop over nodes.
   fprintf_(outflenm, " ");
} // End of loop over output times.

// Optionally, write plotting file of continuously-valued nodes.

if (nmids == 1 && spacetime_xyptsfle != null && !issms) {
   continnodeplot_();
}
}

//-------------------------------------------------------------------

public static void continnodeplot_() {

/* For a single ID run, write a plotting file of the continuously-valued
   nodes. */

int i, j;

double val;

fleopen_(xyptsflenm, spacetime_xyptsfle, 'w');

for (i = 0; i < nmnds; ++i){
   if (!varinfo_eval[idnmbrm1][i] ||
       nodenghs[idnmbrm1][i][0] > 1) {
      continue;
   }

   // Write the node's name, its mean, and its standard deviation.

   strng = "Time " + grph_label[idnmbrm1][i] + " STDDEV";
   fprintf_(xyptsflenm, strng + "\nbegin");
   for (j = 0; j < nmoutt; ++j) {
      if (Double.isNaN(beliefh[0][j][i][1])) {
         val = 0.;
      
      } else {
         val = beliefh[0][j][i][1];
      }
      strng = fdble_(outputtime[j], 10, 3) + " " +
              fdble_(beliefh[0][j][i][0], 14, 6) + " " +
              fdble_(val, 14, 6);
      fprintf_(xyptsflenm, strng);
   }
   fprintf_(xyptsflenm, "end");
}
fclose_(xyptsflenm, 'w');
}

//-------------------------------------------------------------------

public static void intridnodeplot_() {

/* Write node plotting file.  NOTE: do not use this routine with
   IDs-only belief networks because only the marginal distributions from
   the last set of conditioning values is written by this routine -- not
   necessarily those under the optimal decision. */

String strng1 = "none";

int i, j;

double std;

// Plot only poachers, traders and rhinoeco IDs.

/*
if (!thisidname.equals("poachers") && !thisidname.equals("traders")
    && !thisidname.equals("rhinoeco")) {
*/

if (!thisidname.equals("traders") && !thisidname.equals("rhinoeco")) {
   return;
}

// Write header information.

if (!headerwritten) {
   strng = "traders: Time NmLegalSold STD LegalPrice STD IllegalPrice STD";
   fprintf_(xyptsflenm, strng);

   strng = "mntwrk: Time NMEMPLOYEES STD ICOPROFIT STD AVEWAGE STD";
   fprintf_(xyptsflenm, strng);

   strng = "poachers: Time l NMPOACHED STD";
   fprintf_(xyptsflenm, strng);

   strng = "rhinoeco: Time RhinoIBM STD";
   fprintf_(xyptsflenm, strng);
   headerwritten = true;
}

for (i = 0; i < nmoutt; ++i) {
   strng1 = thisidname + " " + fdble_(outputtime[i], 8, 3);
   if (thisidname.equals("poachers")) {
   strng1 += " " + fdble_(Parlearn.l, 5, 3);
   strng1 += " " + Intridslve.actions_econoutput[0][0][0] + " 0.0";
   
   } else if (thisidname.equals("traders")) {
      for (j = 0; j < nmnds; ++j){
         if (grph_label[idnmbrm1][j].equals("NmLegalSold") ||
             grph_label[idnmbrm1][j].equals("LegalPrice") ||
             grph_label[idnmbrm1][j].equals("IllegalPrice")) {
            if (Double.isNaN(beliefh[0][i][j][1])) {
               std = 0.;
      
            } else {
               std = beliefh[0][i][j][1];
            }
            strng1 += " " + fdble_(beliefh[0][i][j][0], 10, 3) + " " +
                         fdble_(std, 10, 3);
         }
      }
   
   } else if (thisidname.equals("mntwrk")) {
      for (j = 0; j < nmnds; ++j){
         if (grph_label[idnmbrm1][j].equals("NMEMPLOYEES") ||
             grph_label[idnmbrm1][j].equals("ICOPROFIT") ||
             grph_label[idnmbrm1][j].equals("AVEWAGE")) {
            if (Double.isNaN(beliefh[0][i][j][1])) {
               std = 0.;
      
            } else {
               std = beliefh[0][i][j][1];
            }
            strng1 += " " + fdble_(beliefh[0][i][j][0], 10, 3) + " " +
                         fdble_(std, 10, 3);
         }
      }

   } else if (thisidname.equals("rhinoeco")) {
      for (j = 0; j < nmnds; ++j){
         if (grph_label[idnmbrm1][j].equals("RhinoIBM")) {
            if (Double.isNaN(beliefh[0][i][j][1])) {
               std = 0.;
      
            } else {
               std = beliefh[0][i][j][1];
            }
            strng1 += " " + fdble_(beliefh[0][i][j][0], 10, 3) + " " +
                         fdble_(std, 10, 3);
         }
      }

   } else if (thisidname.equals("cheetaheco")) {
      for (j = 0; j < nmnds; ++j){
         if (grph_label[idnmbrm1][j].equals("CheetahIBM")) {
            if (Double.isNaN(beliefh[0][i][j][1])) {
               std = 0.;
      
            } else {
               std = beliefh[0][i][j][1];
            }
            strng1 += " " + fdble_(beliefh[0][i][j][0], 10, 3) + " " +
                         fdble_(std, 10, 3);
         }
      }
   }
   fprintf_(xyptsflenm, strng1);
}
}

// ----------------------------------------------------------------------

public static void checknmloops_() {

/* Determines through an approximate test if the "nmloops" ("m," below)
   parameter (number of Monte Carlo loops) is large enough.

   Exact test:
      1. Find the least-likely joint state of the ID.
      2. m > 1 / P(least-likely state).

   Approximate check:
      1. Discover nmh, the number of node hierarchy levels in the ID.
      2. Discover the smallest CPT entry, p_smallest.
      3. m > 1 / (p_smallest)^nmh

      For example, if nmh = 4 and p_smallest = 0.1,
      m > 1 /  (0.1)^4 = 10,000

   Verification Algorithm:
      1. Approximate all ID node beliefs using m loops.  Call these
	 beliefs p_i^(m), i = 1,...nmnodes.
      2. m_new *= m.
      1. Approximate all ID node beliefs using m_new loops.  Call these
	 beliefs p_i^(m_new), i = 1,...nmnodes.
      3. Compute a normalized maximum difference:
	    maxdif = max_i{ |p_i^(m) - p_i^(m_new)| / p_i^(m_new)}
      4. If maxdif < .1, quit.  Otherwise:
      5. m = m_new
	 p_i^(m) = p_i^(m_new)
      6. Go to Step 2. */

iderr_("checknmloops: not implemented yet");
}
}
