class Actnseqfreqs extends Displayactions {

static boolean freqplots = false;

static String sequencetype[][] = new String[TNMIDS][NMACTNS];
static String actorlbl[] = new String[TNMIDS];
static String sequencelbl[][] = new String[TNMIDS][NMACTNS];
static String incombtype[][] = new String[TNMIDS][NMACTNS];
static String outcombtype[][] = new String[TNMIDS][NMACTNS];
static String actn[][] = new String[TNMIDS][NMACTNS];
static String trgt[][] = new String[TNMIDS][NMACTNS];
static String inaction[] = new String[NMACTNS];
static String actnstrng[] = new String[NMACTNS];

static double empprob[] = new double[NMACTNS];

// ----------------------------------------------------------------------

static void actnseqfreqs_(int nmactions) {

/* Finds and displays the frequencies of action-target sequences that
   are one, two, and three actions long. */

boolean actionsonly = true, actionfound, typefound = false,
   actorfound = false, sizethree = false;

String sequence, seqlbl, incombstrng, outcombstrng, trgtsstrng, rectype,
   matchstrng, inputaction, inputactor;

int i, j, k, sublngth = 28, nmactors = 0, selfidnm = 0, totaln, maxmatch,
   maxfreq, incombnm = 0, outcombnm = 0, ovrlfrq = 0, ovrltotaln = 0,
   mostfreqout = 0, minmatch = 0, nmlookahead, ipnmlook, nmtrgts;

/* For reference, the declarations in CA.java are:

** String actnshstry_obsactor[] = new String[NMACTNS];
** String actnshstry_obsactnstrng[] = new String[NMACTNS];
** String actnshstry_obstrgtsstrng[] = new String[NMACTNS];

** int actnshstry_obsactn[][][] = new int[TNMIDS][MAXTIMES][2];
** int actnshstry_matchedactn[][][] = new int[TNMIDS][MAXTIMES][2];
** int actnshstry_obsnmtrgts[][][] = new int[TNMIDS][MAXTIMES][2];
** int actnshstry_obstrgts[][][] = new int[TNMIDS][MAXTIMES][2];

** double actnshstry_obsactntime[] = new double[MAXTIMES];

The declarations for model values (actnshstry_mdl.) are the same. */

double freqsum, entvar, mindiff = 1. / 365., timediff; // Time is in years.

// Open actions file.

fleopen_(2, actnshistfle, 'r');

// Print header and initialize variables.

if (plottype.equals("observations")) {
   fprintf_(1, "\n------- Observed Action Sequence Frequencies -------");

} else {
   fprintf_(1, "\n------- Model Action Sequence Frequencies -------");
}

for (i = 0; i < TNMIDS; ++i) {
   nmsequence[i] = 0;
   nmoutcombs[i] = 0;
   actorlbl[i] = "none";
   for (j = 0; j < NMACTNS; ++j) {
      nmsequencetype[i][j] = 0;
      nmoutcombtype[i][j] = 0;
      outfreq[i][j] = 0;
   }
}

// Find single actor-action sequences.

i = 0;
DOLOOP: do {

   // Read action values depending on source.

   if (plottype.equals("observations")) {
      /*
      time[0] = actnshstry_obsactntime[i];
      actnstrng[0] = actnshstry_obsactnstrng[i];
      actionactor[0] = actnshstry_obsactor[i];
      actiontrgt[0] = actnshstry_obstrgtsstrng[i];
      */
      rectype = fgetstrng_(2);
      time[0] = fgetdble_(2);
      actionactor[0] = fgetstrng_(2);
      actnstrng[0] = fgetstrng_(2);
      actiontrgt[0] = fgetstrng_(2);

   } else {
      for (;;) {
	 if (checkeof_(2)) {
	    break DOLOOP;
	 }
         rectype = fgetstrng_(2);
	 if (rectype.equals("ecovals")) {
            fgetdble_(2);
            fgetint_(2);
            fgetint_(2);
            fgetdble_(2);
            fgetdble_(2);
	 
	 } else {
	    break;
	 }
      }

      actionid[0] = fgetint_(2);
      inactid[0] = fgetint_(2);

      time[0] = fgetdble_(2);

      // No need to store in-action and in-actor.

      inputaction = fgetstrng_(2);
      inputactor = fgetstrng_(2);

      actionactor[0] = fgetstrng_(2);
      actnstrng[0] = fgetstrng_(2);
      actiontrgt[0] = fgetstrng_(2);
      matchstrng = fgetstrng_(2);
   }

   actorfound = false;
   for (j = 1; j <= nmactors; ++j) {
      if (actionactor[0].equals(actorlbl[j - 1])) {
	 selfidnm = j;
	 actorfound = true;
	 break;
      }
   }
   if (!actorfound) {
      actorlbl[nmactors] = actionactor[0];

      if (nmactors == nmids) {
	 printf_("actnseqfreqs: new actor= " + actionactor[0] +
	    " but nmactors= " + nmactors +
	    "\n   breaking out of action loop");
	 break;
      }
      ++nmactors;
      selfidnm = nmactors;
   }
   sequence = actionactor[0] + "-" + actnstrng[0];
   
   actionfound = false;
   for (j = 0; j < nmsequence[selfidnm - 1]; ++j) {
      if (sequence.equals(sequencetype[selfidnm - 1][j])) {
	 ++nmsequencetype[selfidnm - 1][j];
	 actionfound = true;
	 break;
      }
   }

   if (!actionfound) {
      sequencetype[selfidnm - 1][nmsequence[selfidnm - 1]] = sequence;
      sequencelbl[selfidnm - 1][nmsequence[selfidnm - 1]] = actnstrng[0];
      ++nmsequencetype[selfidnm - 1][nmsequence[selfidnm - 1]];
      ++nmsequence[selfidnm - 1];
   }

   // Find or create out-combination.

   outcombstrng = actnstrng[0] + "-" + actiontrgt[0];
   typefound = false;
   for (j = 0; j < nmoutcombs[selfidnm - 1]; ++j) {
      if (outcombstrng.equals(outcombtype[selfidnm - 1][j])) {
          nmoutcombtype[selfidnm - 1][j] += 1.;
          typefound = true;
          outcombnm = j + 1;
          break;
      }
   }

   if (!typefound) {
      outcombtype[selfidnm - 1][nmoutcombs[selfidnm - 1]] =
         outcombstrng;
      ++nmoutcombtype[selfidnm - 1][nmoutcombs[selfidnm - 1]];
      ++nmoutcombs[selfidnm - 1];
      outcombnm = nmoutcombs[selfidnm - 1];

      // Store this out-combination.

      actn[selfidnm - 1][outcombnm - 1] = actnstrng[0];
      trgt[selfidnm - 1][outcombnm - 1] = actiontrgt[0];
   }

   // Increment 1-way table frequency counter.

   ++outfreq[selfidnm - 1][outcombnm - 1];

   ++i;
} while ((plottype.equals("observations") && i < nmactions) ||
	 (plottype.equals("model") && !checkeof_(2)));
fclose_(2, 'r');

// --------- Now, find frequencies of one-action sequences. ----------

if (plottype.equals("model")) {
   nmactions = i;
}
printf_("actnseqfreqs: nmactions= " + nmactions);

fprintf_(1, "\nNote: MMFOC stands for Model Most Frequent Out-Combination" +
   "\nOMFOC stands for Observed Most Frequent Out-Combination");

for (i = 0; i < nmactors; ++i) {
   if (nmsequence[i] > 0) {

      fprintf_(1, "\nActor= " + actorlbl[i] + " nmsequence= " +
         nmsequence[i] +
	 "\n                                   Action      Frequency");
   
      for (j = 0; j < nmsequence[i]; ++j) {
         fprintf_(1, " " + fstrng_(sequencelbl[i][j], 50) + "  " +
	    nmsequencetype[i][j]);
      }

      /* Plot the frequency distribution of single actor-action sequence
	 types. */

      if (freqplots) {
	 fleopen_(4, "out.dig", 'w');
         Plotutils.pltbar_(4, nmsequence[i], sequencelbl[i],
	    nmsequencetype[i], "Single_Action",
	    "Sequence_Frequencies", "Frequency", .9, .9, .1, .1);
         fclose_(4, 'w');
         flename = "seqfreq1" + actorlbl[i] + ".eps";
         Pltpost.pltpost_(flename, 1.0); 

         fprintf_(1,"\nSingle Action Frequencies of this solution" +
            "\n   for actor " + actorlbl[i] + " are at:\n" +
            " <A HREF=\"" + flename + "\">" + flename + "</A>");
      }

   } else {
      fprintf_(1, "No single-action sequences.");
   }

   // Find the modal out-combination for this actor.

   maxfreq = 0;
   mostfreqout = 0;
   freqsum = 0.;
   for (j = 0; j < nmoutcombs[i]; ++j) {
      if (maxfreq < outfreq[i][j]) {
	 maxfreq = outfreq[i][j];
         mostfreqout = j + 1;
      }
      fprintf_(1,"   outcombtype= " + outcombtype[i][j] + " freq= " +
         outfreq[i][j]);
      freqsum += ((double) outfreq[i][j]);
   }
   minmatch += maxfreq;

   /* Find the entropy-based measure of variability for this actor's
      out-combination distribution. */

   for (j = 0; j < nmoutcombs[i]; ++j) {
      empprob[j] = ((double) outfreq[i][j]) / freqsum;
   }
   entvar = Summry.entvar_(nmoutcombs[i], empprob);
   fprintf_(1, "\n   maxfreq= " + maxfreq +
      " Entropy-based variance= " + entvar);

   if (mostfreqout == 0) {
      printf_("actnseqfreqs: plottype= " + plottype + " ID= " +
	 actorlbl[i] + " no out-combs");
      continue;
   }

   if (plottype.equals("observations")) {
      fprintf_(1, "\n   OMFOC= " +
         actn[i][mostfreqout - 1] + "   " + trgt[i][mostfreqout - 1]);

   } else {
      fprintf_(1, "\n   MMFOC= " + 
         actn[i][mostfreqout - 1] + "   " + trgt[i][mostfreqout - 1]);
   }
}

fprintf_(1,"\nThe worst match fraction that this model could achieve" +
   "\nagainst ANY actions history data set is " +
   fdble_((((double) minmatch) / ((double) nmactions)), 6, 2));

/* ----------------- Find size-2 sequences, i.e., ------------------
  actor-action--and--actor-reaction sequences.  First, read-in an initial
  chunk of the actions history. */
   
fleopen_(2, actnshistfle, 'r');

nmlookahead = Math.min(nmactions - 3, NMACTNS - 1);

FRSTLOOP: for (i = 1; i <= nmlookahead; ++i) {
   if (plottype.equals("observations")) {
      time[i] = actnshstry_obsactntime[i];
      actnstrng[i] = actnshstry_obsactnstrng[i];
      actionactor[i] = actnshstry_obsactor[i];
      actiontrgt[i] = actnshstry_obstrgtsstrng[i];
   
   } else {
      for (;;) {
	 if (checkeof_(2)) {
	    break FRSTLOOP;
	 }
         rectype = fgetstrng_(2);
	 if (rectype.equals("ecovals")) {
            fgetdble_(2);
            fgetint_(2);
            fgetint_(2);
            fgetdble_(2);
            fgetdble_(2);
	 
	 } else {
	    break;
	 }
      }

      actionid[i] = fgetint_(2);
      inactid[i] = fgetint_(2);

      time[i] = fgetdble_(2);
      inaction[i] = fgetstrng_(2);

      // Skip in-actor

      fgetstrng_(2);

      actionactor[i] = fgetstrng_(2);
      actnstrng[i] = fgetstrng_(2);
      actiontrgt[i] = fgetstrng_(2);
      matchstrng = fgetstrng_(2);

      // Keep track of unique action-reaction pairs.

      sequence = inaction[i] + "-" + actionactor[i] + "-" +
		 actnstrng[i] + "-" + actiontrgt[i];
      typefound = false;
      for (j = 0; j < nmtetrads; ++j) {
         if (sequence.equals(tetrad[j])) {
            typefound = true;
            break;
         }
      }
      if (!typefound) {
         tetrad[nmtetrads] = sequence;
         ++nmtetrads;
      }
   }
}

for (i = 0; i < TNMIDS; ++i) {
   nmincombs[i] = 0;
   nmoutcombs[i] = 0;
   nmsequence[i] = 0;
   for (j = 0; j < TNMVALS; ++j) {
      nmincombtype[i][j] = 0;
      nmoutcombtype[i][j] = 0;
      nmsequencetype[i][j] = 0;
      outfreq[i][j] = 0;
      for (k = 0; k < TNMVALS; ++k) {
	 inoutfreq[i][j][k] = 0;
      }
   }
}

/* Continue reading actions either from "actnshstry" arrays or from
   the previously-opened file #2. */

SCNDLOOP: for (i = 0; i < nmactions - 1; ++i) {

   // Ratchet the actions array and then read another action.

   for (j = 0; j < nmlookahead; ++j) {
      actionid[j] = actionid[j + 1];
      inactid[j] = inactid[j + 1];

      time[j] = time[j + 1];
      actionactor[j] = actionactor[j + 1];
      actnstrng[j] = actnstrng[j + 1];
      actiontrgt[j] = actiontrgt[j + 1];
   }

   ipnmlook = i + nmlookahead;
   if (ipnmlook < nmactions) {
      if (plottype.equals("observations")) {
         time[nmlookahead] = actnshstry_obsactntime[ipnmlook];
         actnstrng[nmlookahead] = actnshstry_obsactnstrng[ipnmlook];
         actionactor[nmlookahead] = actnshstry_obsactor[ipnmlook];
         actiontrgt[nmlookahead] = actnshstry_obstrgtsstrng[ipnmlook];
   
      } else {
	 if (checkeof_(2)) {
	    break SCNDLOOP;
	 }
         for (;;) {
            rectype = fgetstrng_(2);
	    if (rectype.equals("ecovals")) {
               fgetdble_(2);
               fgetint_(2);
               fgetint_(2);
               fgetdble_(2);
               fgetdble_(2);
	 
	    } else {
	       break;
	    }
         }

	 actionid[nmlookahead] = fgetint_(2);
	 inactid[nmlookahead] = fgetint_(2);

         time[nmlookahead] = fgetdble_(2);
         inaction[nmlookahead] = fgetstrng_(2);

         // Skip in-actor

         fgetstrng_(2);

         actionactor[nmlookahead] = fgetstrng_(2);
         actnstrng[nmlookahead] = fgetstrng_(2);
         actiontrgt[nmlookahead] = fgetstrng_(2);
         matchstrng = fgetstrng_(2);
      
	 // Keep track of unique action-reaction pairs.

         sequence = inaction[nmlookahead] + "-" + actionactor[nmlookahead] +
		 "-" + actnstrng[nmlookahead] + "-" +
		 actiontrgt[nmlookahead];
         typefound = false;
         for (j = 0; j < nmtetrads; ++j) {
            if (sequence.equals(tetrad[j])) {
               typefound = true;
               break;
            }
         }
         if (!typefound) {
            tetrad[nmtetrads] = sequence;
            ++nmtetrads;
         }
      } 
   }

   if (actiontrgt[0] == null) {
      continue;
   }

   /* Loop over all future actions to search for the target of this
      i^th actor-action. */

   for (j = 1; j <= nmlookahead; ++j) {
      if (j + i > nmactions - 1) {
	 break;
      }

      timediff = time[j] - time[0];

      // Verify that actions are sorted by time.

      if (timediff < 0.) {
	 iderr_("actnseqfreqs: time(" + j + ")= " + time[j] + " time0= " +
	    time[0] + ", actions not sorted by time.");
      }

      /* Continue if this action targets an ID that is outside of the
	 valid future time window. */

      if (timediff < mindiff || timediff > Intridslve.maxmemory ||
	  actiontrgt[0].indexOf(actionactor[j], 0) < 0) {
	 continue;
      }

      /* Store these two out-combinations.  "actionactor[j]" is the target
	 of "actionactor[0]'s" action.  The target of "actionactor[j]"'s
	 action is stored in "trgt," below. */

       incombstrng = actionactor[0] + "-" + actnstrng[0];
       outcombstrng = actionactor[j] + "-" + actnstrng[j];

       sequence = incombstrng + outcombstrng;

       // Find this target's ("actionactor[j]") label.

      for (k = 1; k <= nmactors; ++k) {
         if (actionactor[j].equals(actorlbl[k - 1])) {
            selfidnm = k;
            break;
         }
      }

      // Keep track of unique in-out pairs for plotting purposes.

      typefound = false;
      for (k = 0; k < nmsequence[selfidnm - 1]; ++k) {
         if (sequence.equals(sequencetype[selfidnm - 1][k])) {
            ++nmsequencetype[selfidnm - 1][k];
            typefound = true;
            break;
         }
      }

      if (!typefound) {
         sequencetype[selfidnm - 1][nmsequence[selfidnm - 1]] =
            sequence;
         ++nmsequencetype[selfidnm - 1][nmsequence[selfidnm - 1]];
         ++nmsequence[selfidnm - 1];
      }

      // Find or create in-combination.

      typefound = false;
      for (k = 0; k < nmincombs[selfidnm - 1]; ++k) {
         if (incombstrng.equals(incombtype[selfidnm - 1][k])) {
            nmincombtype[selfidnm - 1][k] += 1.;
            typefound = true;
            incombnm = k + 1;
            break;
         }
      }

      if (!typefound) {
         incombtype[selfidnm - 1][nmincombs[selfidnm - 1]] = incombstrng;
         ++nmincombtype[selfidnm - 1][nmincombs[selfidnm - 1]];
         ++nmincombs[selfidnm - 1];
	 incombnm = nmincombs[selfidnm - 1];
      }

      // Find or create out-combination.

      typefound = false;
      for (k = 0; k < nmoutcombs[selfidnm - 1]; ++k) {
         if (outcombstrng.equals(outcombtype[selfidnm - 1][k])) {
            nmoutcombtype[selfidnm - 1][k] += 1.;
            typefound = true;
            outcombnm = k + 1;
            break;
         }
      }

      if (!typefound) {
         outcombtype[selfidnm - 1][nmoutcombs[selfidnm - 1]] =
            outcombstrng;
         ++nmoutcombtype[selfidnm - 1][nmoutcombs[selfidnm - 1]];
         ++nmoutcombs[selfidnm - 1];
         outcombnm = nmoutcombs[selfidnm - 1];

         /* Store the out-combination which is the reaction of
            "actionactor[j]" to "actionactor[i]" action. */

         actn[selfidnm - 1][outcombnm - 1] = actnstrng[j];
         trgt[selfidnm - 1][outcombnm - 1] = actiontrgt[j];
      }

      // Increment 2-way table frequency counter.

      ++inoutfreq[selfidnm - 1][incombnm - 1][outcombnm - 1];
   }
}

if (plottype.equals("model")) {
   fclose_(2, 'r');
}

// Plot the size-2 sequences.

for (i = 0; i < nmactors; ++i) {
   if (nmsequence[i] > 0) {
      fprintf_(1, "\nSelf-ID= " + actorlbl[i] +
         "\n          In-Out Pair                           Frequency");
      for (j = 0; j < nmsequence[i]; ++j) {
         fprintf_(1, " " + fstrng_(sequencetype[i][j], 60) + "  " +
            nmsequencetype[i][j]);
      }

      // Plot the frequency distribution of these size-2 sequence types.

      if (freqplots) {
         fleopen_(4, "out.dig", 'w');
         Plotutils.pltbar_(4, nmsequence[i], sequencelbl[i],
	    nmsequencetype[i], "Action-Reaction",
	    "Sequence_Frequencies", "Frequency", .9, .9, .1, .1);
         fclose_(4, 'w');

         flename = "seqfreq2" + actorlbl[i] + ".eps";
         Pltpost.pltpost_(flename, 1.0); 

         fprintf_(1, "\nAction-Reaction Frequencies of this solution" +
            "\n   for selfID " + actorlbl[i] + " are at:\n" +
            " <A HREF=\"" + flename + "\">" + flename + "</A>");
      } 

   } else {
      fprintf_(1, "\nSelf-ID= " + actorlbl[i] + " plottype= " +
	 plottype + " actreactseq= 0");
      printf_("actnseqfreqs: ID= " + actorlbl[i] + " plottype= " +
	 plottype + " actreactseq= 0");
   }
}

/* Print 2-way table of in-combinations by out-combinations and compute
   the maximum possible match fraction that a function-based model (IntIDs
   or otherwise) can achieve.  Recall that a function-based model implies
   that 1 input can produce only 1 output. */

fprintf_(1, "\nActor         Maximum Possible Match Fraction");
for (i = 0; i < nmactors; ++i) {
   totaln = 0;
   maxmatch = 0;
   for (j = 0; j < nmincombs[i]; ++j) {
      maxfreq = 0;
      for (k = 0; k < nmoutcombs[i]; ++k) {
	 if (maxfreq < inoutfreq[i][j][k]) {
	    maxfreq = inoutfreq[i][j][k];
	    outcombnm = k + 1;
	 }

	 // Store total number of in-out pairs over all actors.

	 totaln += inoutfreq[i][j][k];
      }
      maxmatch += maxfreq;
      ovrlfrq += maxfreq;
	 
      /* Store the frequency of the most-frequent out-combination
         that is a reaction to this j+1^th in-combination. */

      maxinoutfreq[i][j] = maxfreq;
   } // End of loop over in-combinations.

   if (totaln > 0) {
      fprintf_(1, actorlbl[i] + "         " +
         fdble_((((double) maxmatch) / ((double) totaln)), 6, 3));
   }

   ovrltotaln += totaln;

   /* Now that the single best out-combination has been found for each
      unique in-combination, fit this ID so that it produces these.
      ?? (not completed yet) */

} // End of loop over actors.

if (ovrltotaln > 0) {
   fprintf_(1, "\nOverall Maximum Possible Match Fraction= " +
      fdble_((((double) ovrlfrq) / ((double) ovrltotaln)), 6, 3));

} else {
   fprintf_(1, "ovrltotaln= 0");
}

if (!sizethree) {
   fprintf_(1, "\nseqfreqs: size-3 sequences are currently not computed");
   return;
}

/* ------------------ Find size-3 sequences, i.e., --------------------
   actor-action--and--actor-reaction--and--actor-re-reaction sequences. */

nmsequence[0] = 0;
for (i = 0; i < nmactions - 2; ++i) {
   if (actionsonly) {
      sequence = actnstrng[i] + "-and-" + actnstrng[i + 1] + "-and-" +
         actnstrng[i + 2];

   } else {
      sequence = actionactor[i] + ":_" + actnstrng[i] + "-and-" +
         actionactor[i + 1] + ":_" + actnstrng[i + 1] + "-and-" +
         actionactor[i + 2] + ":_" + actnstrng[i + 2];
   }

   if (actionsonly) {
      seqlbl = actnstrng[i] + "--" + actnstrng[i + 1] +
	 "--" + actnstrng[i + 1];

   } else {
      seqlbl = actionactor[i] + "-" + actnstrng[i] + "--" +
	 actionactor[i + 1] + "-" + actnstrng[i + 1] + "--" +
	 actionactor[i + 2] + "-" + actnstrng[i + 2];
   }

   typefound = false;
   for (j = 0; j < nmsequence[0]; ++j) {
      if (sequence.equals(sequencetype[0][j])) {
	 ++nmsequencetype[0][j];
	 typefound = true;
	 break;
      }
   }

   if (!typefound) {
      sequencetype[0][nmsequence[0]] = sequence;
      sequencelbl[0][nmsequence[0]] = seqlbl;
      ++nmsequencetype[0][nmsequence[0]];
      ++nmsequence[0];
   }
}

if (nmsequence[0] > 0) {

   // Plot the frequency distribution of these size-3 sequence types.

   if (freqplots) {
      fleopen_(4, "out.dig", 'w');
      Plotutils.pltbar_(4, nmsequence[0], sequencelbl[0],
         nmsequencetype[0], "Action-Reaction-Re-reaction",
         "Sequence_Frequencies", "Frequency", .9, .9, .1, .1);
      fclose_(4, 'w');
      flename = "seqfreq3.eps";
      Pltpost.pltpost_(flename, 1.0); 

      fprintf_(1, "\nAction-Reaction-Re-reaction Frequencies of this" +
         " solution are at:\n" +
         " <A HREF=\"" + flename + "\">" + flename + "</A>");
   }

} else {
   fprintf_(1, "No action--reaction--re-reaction sequences.");
}
}
}
